% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{prod_entries}
\alias{prod_entries}
\alias{prod}
\alias{prod.Expression}
\title{Product of Entries}
\usage{
prod_entries(..., axis = NA_real_, keepdims = FALSE)

\method{prod}{Expression}(..., na.rm = FALSE)
}
\arguments{
\item{...}{Numeric scalar, vector, matrix, or \linkS4class{Expression} objects.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{keepdims}{(Optional) Should dimensions be maintained when applying the atom along an axis? If \code{FALSE}, result will be collapsed into an \eqn{n x 1} column vector. The default is \code{FALSE}.}

\item{na.rm}{(Unimplemented) A logical value indicating whether missing values should be removed.}
}
\value{
An \linkS4class{Expression} representing the product of the entries of the input.
}
\description{
The product of entries in a vector or matrix.
}
\details{
This atom is log-log affine, but it is neither convex nor concave.
}
\examples{

n <- 2
X <- Variable(n, n, pos=TRUE)
obj <- sum(X)
constraints <- list(prod_entries(X) == 4)
prob <- Problem(Minimize(obj), constraints)
result <- solve(prob, gp=TRUE)
result$value
result$getValue(X)

n <- 2
X <- Variable(n, n, pos=TRUE)
obj <- sum(X)
constraints <- list(prod(X) == 4)
prob <- Problem(Minimize(obj), constraints)
result <- solve(prob, gp=TRUE)
result$value
}
