% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{SOC-class}
\alias{SOC-class}
\alias{.SOC}
\alias{SOC}
\alias{as.character,SOC-method}
\alias{residual,SOC-method}
\alias{get_data,SOC-method}
\alias{format_constr,SOC-method}
\alias{num_cones,SOC-method}
\alias{size,SOC-method}
\alias{cone_sizes,SOC-method}
\alias{is_dcp,SOC-method}
\alias{is_dgp,SOC-method}
\alias{canonicalize,SOC-method}
\title{The SOC class.}
\usage{
SOC(t, X, axis = 2, id = NA_integer_)

\S4method{as.character}{SOC}(x)

\S4method{residual}{SOC}(object)

\S4method{get_data}{SOC}(object)

\S4method{format_constr}{SOC}(object, eq_constr, leq_constr, dims, solver)

\S4method{num_cones}{SOC}(object)

\S4method{size}{SOC}(object)

\S4method{cone_sizes}{SOC}(object)

\S4method{is_dcp}{SOC}(object)

\S4method{is_dgp}{SOC}(object)

\S4method{canonicalize}{SOC}(object)
}
\arguments{
\item{t}{The scalar part of the second-order constraint.}

\item{X}{A matrix whose rows/columns are each a cone.}

\item{axis}{The dimension along which to slice: \code{1} indicates rows, and \code{2} indicates columns. The default is \code{2}.}

\item{id}{(Optional) A numeric value representing the constraint ID.}

\item{x, object}{A \linkS4class{SOC} object.}

\item{eq_constr}{A list of the equality constraints in the canonical problem.}

\item{leq_constr}{A list of the inequality constraints in the canonical problem.}

\item{dims}{A list with the dimensions of the conic constraints.}

\item{solver}{A string representing the solver to be called.}
}
\description{
This class represents a second-order cone constraint, i.e. \eqn{\|x\|_2 \leq t}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{residual(SOC)}: The residual of the second-order constraint.

\item \code{get_data(SOC)}: Information needed to reconstruct the object aside from the args.

\item \code{format_constr(SOC)}: Format SOC constraints as inequalities for the solver.

\item \code{num_cones(SOC)}: The number of elementwise cones.

\item \code{size(SOC)}: The number of entries in the combined cones.

\item \code{cone_sizes(SOC)}: The dimensions of the second-order cones.

\item \code{is_dcp(SOC)}: An SOC constraint is DCP if each of its arguments is affine.

\item \code{is_dgp(SOC)}: Is the constraint DGP?

\item \code{canonicalize(SOC)}: The canonicalization of the constraint.

}}
\section{Slots}{

\describe{
\item{\code{t}}{The scalar part of the second-order constraint.}

\item{\code{X}}{A matrix whose rows/columns are each a cone.}

\item{\code{axis}}{The dimension along which to slice: \code{1} indicates rows, and \code{2} indicates columns. The default is \code{2}.}
}}

