library(CARMS)

SaDiode2<-carms.make(title="Assembly        Diode Config 2", diagram_grid=c(11,12) )
SaDiode2<-carms.state(SaDiode2, prob=1, name="All good",size=8, h2w=16/31,  position=c(2,5))
SaDiode2<-carms.state(SaDiode2, prob=0, name="1 of 4 opened",size=8,  h2w=16/31, position=c(4,2))
SaDiode2<-carms.state(SaDiode2, prob=0, name="1 of 4 shorted",size=8,  h2w=16/31, position=c(4,8))
SaDiode2<-carms.state(SaDiode2, prob=0, name="1 diode left",size=8,  h2w=16/31, position=c(7,4))
SaDiode2<-carms.state(SaDiode2, prob=0, name="2 diodes left",size=8,  h2w=16/31, position=c(8,10))
SaDiode2<-carms.state(SaDiode2, prob=0, name="failed state",size=8,  h2w=16/31, position=c(10,6))


SaDiode2<-carms.base(SaDiode2, 1e-6, time_units= "thousand Hours",base_label="Open",description="Open failure rate")
SaDiode2<-carms.base(SaDiode2, 5e-7, base_label="Short", description="Short failure rate")

# carms.arrow<-(x, from, to, rate, arc=0.35, arrow.position=0.5, label="")
SaDiode2<-carms.arrow(SaDiode2, 1, 2, rate="4*Open", label="4*Open", arc=.2)
SaDiode2<-carms.arrow(SaDiode2, 2, 4, rate= "2*Open", label="2*Open", arc= .2)
SaDiode2<-carms.arrow(SaDiode2, 2, 6, rate="Open", label="Open", arc=.45)
SaDiode2<-carms.arrow(SaDiode2, 1, 3, rate="4*Short", label="4*Short", arc=- .2)
SaDiode2<-carms.arrow(SaDiode2, 3, 5, rate="2*Open", label="2*Open", arc=-.3)
SaDiode2<-carms.arrow(SaDiode2, 5, 6, rate="Short+Open", label="Short+Open", arc= -.2)
SaDiode2<-carms.arrow(SaDiode2, 4, 6, rate="2*Open", label="2*Open", arc=.2)
SaDiode2<-carms.arrow(SaDiode2, 3, 6, rate="2*Short", label="2*Short", arc= -.1)
SaDiode2<-carms.arrow(SaDiode2, 2, 3, rate="Short", label="Short", arc=-.1)
SaDiode2<-carms.arrow(SaDiode2, 2, 5, rate="2*Short", label="2*Short", arc=0)
SaDiode2<-carms.arrow(SaDiode2, 4, 5, rate="2*Short", label="2*Short", arrow.position=0.4, arc= .05)
	dev.new(width=12, height=8, unit="in")
	diagram(SaDiode2)
# usage: simulate.carms(x, solution, mission_time, intervals=50, cycles=2000)
SaDiode2<-simulate.carms(SaDiode2, "bd", 2*10e5, 50)
plot.carms(SaDiode2)
