% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculate_forward_probability}
\alias{calculate_forward_probability}
\title{Calculate Forward Probability}
\usage{
calculate_forward_probability(
  item_ordering,
  partial_ranking,
  remaining_set,
  rho,
  alpha,
  n_items,
  metric = "footrule"
)
}
\arguments{
\item{item_ordering}{A vector of integer values to represent the specified
queue of which unranked item to assign a rank for the proposed augmented
ranking}

\item{partial_ranking}{An incomplete rank sequence vector of the original
observed incomplete ranking which contains NAs}

\item{remaining_set}{A vector of integer values to represent the elements
(ranks) missing from original observed ranking}

\item{rho}{Numeric vector specifying the consensus ranking}

\item{alpha}{Numeric value of the scale parameter}

\item{n_items}{Integer is the number of items in a ranking}

\item{metric}{A character string specifying the distance metric to use in
the Bayesian Mallows Model. Available options are \code{"footrule"},
\code{"spearman"}, \code{"cayley"}, \code{"hamming"}, \code{"kendall"},
and \code{"ulam"}.}
}
\value{
List containing aug_ranking, a ranking sequence vector of the
  proposed augmented ranking and forward_prob a numerical value of the
  probability of creating the augmented ranking using the pseudolikelihood
  augmentation.
}
\description{
Function to calculate probability of assigning a set of
  specific ranks to an specific item
given its rank in the consensus ranking
}
\keyword{internal}
