% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_partition_function}
\alias{get_partition_function}
\title{Compute the logarithm of the partition function for a Mallows rank model}
\usage{
get_partition_function(
  n_items,
  alpha,
  cardinalities = NULL,
  logz_estimate = NULL,
  metric = "footrule"
)
}
\arguments{
\item{n_items}{Number of items.}

\item{alpha}{The value of the alpha parameter.}

\item{cardinalities}{Number of occurrences for each unique distance.
Applicable for Footrule and Spearman distance. Defaults to \code{R_NilValue}.}

\item{logz_estimate}{Precomputed importance sampling fit.}

\item{metric}{A string. Available options are \code{"footrule"},
\code{"kendall"}, \code{"spearman"}, \code{"cayley"}, \code{"hamming"}, and \code{"ulam"}.
Defaults to \code{"footrule"}.}
}
\value{
A scalar, the logarithm of the partition function.
}
\description{
Compute the logarithm of the partition function for a Mallows rank model
}
\references{
\insertAllCited{}
}
\keyword{internal}
