% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{murakami_stat}
\alias{murakami_stat}
\alias{murakami_stat_perms}
\title{Compute Murakami's test statistic.}
\usage{
murakami_stat(x, y, flavor = 0L)

murakami_stat_perms(nx, ny, flavor = 0L)
}
\arguments{
\item{x}{a vector of the first sample.}

\item{y}{a vector of the second sample.}

\item{flavor}{which \sQuote{flavor} of test statistic.}

\item{nx}{the length of \code{x}, the first sample.}

\item{ny}{the length of \code{y}, the second sample.}
}
\value{
The BWS test statistic, \eqn{B_j}. For \code{murakami_stat_perms}, a vector of
the test statistics for \emph{all} permutations of the input.
}
\description{
Compute one of the modified Baumgartner-Weiss-Schindler test statistics proposed
by Murakami, or Neuhauser.
}
\details{
Given vectors \eqn{X} and \eqn{Y}, computes \eqn{B_{jX}} and \eqn{B_{jY}} 
for some \eqn{j} as described by Murakami and by Neuhauser, returning either their 
their average or their average distance.
The test statistics approximate the weighted square norm of the
difference in CDFs of the two distributions. 

The test statistic is based only on the ranks of the input. If the same
monotonic transform is applied to both vectors, the result should be unchanged.

The various \sQuote{flavor}s of test statistic are:
\describe{
\item{0}{The statistic of Baumgartner-Weiss-Schindler.}
\item{1}{Murakami's \eqn{B_1} statistic, from his 2006 paper.}
\item{2}{Neuhauser's difference statistic, denoted by Murakami as \eqn{B_2} in his 
2012 paper.}
\item{3}{Murakami's \eqn{B_3} statistic, from his 2012 paper.}
\item{4}{Murakami's \eqn{B_4} statistic, from his 2012 paper.}
\item{5}{Murakami's \eqn{B_5} statistic, from his 2012 paper, with a log weighting.}
}
}
\note{
\code{NA} and \code{NaN} are not yet dealt with!
}
\examples{

set.seed(1234)
x <- runif(1000)
y <- runif(100)
bval <- murakami_stat(x,y,1)

\donttest{
nx <- 6
ny <- 5
# monte carlo
set.seed(1234)
repli <- replicate(3000,murakami_stat(rnorm(nx),rnorm(ny),0L))
# under the null, perform the permutation test:
allem <- murakami_stat_perms(nx,ny,0L)
plot(ecdf(allem)) 
lines(ecdf(repli),col='red') 
}

}
\references{
W. Baumgartner, P. Weiss, H. Schindler, 'A nonparametric test for the general two-sample problem', 
Biometrics 54, no. 3 (Sep., 1998): pp. 1129-1135. 
\doi{10.2307/2533862}

M. Neuhauser, 'Exact tests based on the Baumgartner-Weiss-Schindler Statistic--a survey', 
Statistical Papers 46, no. 1 (2005): pp. 1-30.
\doi{10.1007/BF02762032}

M. Neuhauser, 'One-sided two-sample and trend tests based on a modified 
Baumgartner-Weiss-Schindler statistic', J. Nonparametric Statistics 13, no.
5 (2001): pp 729-739.
\doi{10.1080/10485250108832874}

H. Murakami, 'K-sample rank test based on modified Baumgartner statistic and
its power comparison', J. Jpn. Comp. Statist. 19, no. 1 (2006): pp. 1-13.
\doi{10.5183/jjscs1988.19.1}

H. Murakami, 'Modified Baumgartner Statistics for the two-sample and
multisample problems: a numerical comparison', J. Stat. Comp. and Sim.
82, no. 5 (2012): pp. 711-728.
\doi{10.1080/00949655.2010.551516}

H. Murakami, 'Lepage type statistic based on the modified Baumgartner statistic',
Comp. Stat. & Data Analysis 51 (2007): pp 5061-5067. 
\doi{10.1016/j.csda.2006.04.026}
}
\seealso{
\code{\link{bws_stat}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
