% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/81_parallel.R
\name{par_bvar}
\alias{par_bvar}
\title{Parallel hierarchical Bayesian vector autoregression}
\usage{
par_bvar(
  cl,
  n_runs = length(cl),
  data,
  lags,
  n_draw = 10000L,
  n_burn = 5000L,
  n_thin = 1L,
  priors = bv_priors(),
  mh = bv_mh(),
  fcast = NULL,
  irf = NULL
)
}
\arguments{
\item{cl}{A \code{cluster} object obtained from
\code{\link[parallel]{makeCluster}}.}

\item{n_runs}{The number of parallel runs to calculate. Defaults to the
length of \emph{cl}, i.e. the number of registered nodes.}

\item{data}{Numeric matrix or dataframe. Note that observations are expected
to be ordered from earliest to latest, and variables in the columns.}

\item{lags}{Integer scalar. Lag order of the model.}

\item{n_draw, n_burn}{Integer scalar. The number of iterations to (a) cycle
through and (b) burn at the start.}

\item{n_thin}{Integer scalar. Every \emph{n_thin}'th iteration is stored.
For a given memory requirement thinning reduces autocorrelation, while
increasing effective sample size.}

\item{priors}{Object from \code{\link{bv_priors}} with prior settings.
Used to adjust the Minnesota prior, add custom dummy priors, and choose
hyperparameters for hierarchical estimation.}

\item{mh}{Object from \code{\link{bv_mh}} with settings for the
Metropolis-Hastings step. Used to tune automatic adjustment of the
acceptance rate within the burn-in period, or manually adjust the proposal
variance.}

\item{fcast}{Object from \code{\link{bv_fcast}} with forecast settings.
Options include the horizon and settings for conditional forecasts i.e.
scenario analysis.
May also be calculated ex-post using \code{\link{predict.bvar}}.}

\item{irf}{Object from \code{\link{bv_irf}} with settings for the calculation
of impulse responses and forecast error variance decompositions. Options
include the horizon and different identification schemes.
May also be calculated ex-post using \code{\link{irf.bvar}}.}
}
\value{
Returns a list of class \code{bvar_chain} with \code{bvar} objects.
}
\description{
Wrapper for \code{\link{bvar}} to simplify parallel computation via
\code{\link[parallel]{parLapply}}. Make sure to properly start and stop the
provided cluster.
}
\examples{
\donttest{
library("parallel")

cl <- makeCluster(2L)

# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# A singular run using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Two parallel runs
y <- par_bvar(cl, n_runs = 2,
  data = data, lags = 1, n_draw = 1000L, n_burn = 200L)

stopCluster(cl)
}
# Plot lambda for all of the runs
\dontrun{
plot(x, type = "full", vars = "lambda", chains = y)

# Convert the hyperparameter lambda to a coda mcmc.list object
coda::as.mcmc(y, vars = "lambda")
}
}
\seealso{
\code{\link{bvar}}; \code{\link[parallel]{parLapply}}
}
\keyword{BVAR}
\keyword{MCMC}
\keyword{Metropolis-Hastings}
\keyword{hierarchical}
\keyword{priors}
