% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMT.Phi.R
\name{BMT.Phi}
\alias{BMT.Phi}
\alias{dBMT.Phi}
\alias{pBMT.Phi}
\alias{qBMT.Phi}
\alias{rBMT.Phi}
\title{The BMT-Phi Distribution.}
\usage{
dBMT.Phi(x, mean = 0, sd = 1, log = FALSE)

pBMT.Phi(q, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

qBMT.Phi(p, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

rBMT.Phi(n, mean = 0, sd = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le 
x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the lenght is taken
to be the number required}
}
\value{
\code{dBMT.Phi} gives the density, \code{pBMT.Phi} the distribution 
  function, \code{qBMT.Phi} the quantile function, and \code{rBMT.Phi} 
  generates random deviates.
  
  The length of the result is determined by \code{n} for \code{rBMT.Phi}, and
  is the maximum of the lengths of the numerical arguments for the other 
  functions.
  
  The numerical arguments other than \code{n} are recycled to the length of 
  the result. Only the first elements of the logical arguments are used.
  
  \code{sd <= 0} is an error and returns \code{NaN}.
}
\description{
Density, distribution function, quantile function, random number
  generation for the BMT-Phi distribution with mean equal to \code{mean} and 
  standard deviation equal to \code{sd}.
}
\details{
If \code{mean} or \code{sd} are not specified they assume the 
  default values of 0 and 1, respectively.
  
  The BMT-Phi distribution is the BMT distribution with \eqn{\kappa_l = 
  \kappa_r = 0.58029164978583758}. The BMT-Phi cumulative distribution
  function (cdf) is the closest BMT cdf to the normal cdf with the same mean and standard deviation.
}
\examples{

layout(matrix(1:4,2,2))

curve(pnorm(x), -4, 4, col = "red", lty = 2, ylab = "cdf")
curve(pBMT.Phi(x), add = TRUE, col = "blue", lty = 3)
legend("topleft", legend = c("norm(0,1)","BMT-Phi(0,1)"), 
       bty = "n", col = c("red","blue"), lty = 2:3)

curve(pnorm(x)-pBMT.Phi(x), -4, 4)

curve(qnorm(x), col = "red", lty = 2, xlab = "p", ylab = "qf")
curve(qBMT.Phi(x), add = TRUE, col = "blue", lty = 3)

hist(rBMT.Phi(10000), freq = FALSE, breaks = seq(-4,4,0.25), border = "blue")
curve(dnorm(x), add = TRUE, col = "red", lty = 2)
curve(dBMT.Phi(x), add = TRUE, col = "blue", lty = 3)
}
\references{
Torres-Jimenez, C. J. (2018), \emph{The BMT Item Response Theory model: A 
  new skewed distribution family with bounded domain and an IRT model based 
  on it}, PhD thesis, Doctorado en ciencias - Estadistica, Universidad 
  Nacional de Colombia, Sede Bogota.
}
\seealso{
\link{Distributions} for other standard distributions.
  \code{\link{pBMT}} for the BMT distribution and \code{\link{pBMT.Psi}} for 
  the BMT-Psi distribution.
}
\author{
Camilo Jose Torres-Jimenez [aut,cre] \email{cjtorresj@unal.edu.co}
}
