% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blsm.R
\name{proc_crr}
\alias{proc_crr}
\title{Procrustean corresponding positions}
\usage{
proc_crr(Z, Z0)
}
\arguments{
\item{Z}{set of initial coordinates to be transformed}

\item{Z0}{set of reference coordinates centered at the origin}
}
\value{
Set of coordinates minimizing the distance between the initial configuration and the reference one
}
\description{
Given a set of starting coordinates, the function returns the Procrustean Transform of the initial points that minimizes 
the sum of squared positional difference from a set of reference coordinates. The (Euclidean) distances between a candidate 
configuration and the reference are evaluated by considering the couples of corresponding points. 

The reference configuration must be centered at the origin.
}
\examples{
# Create configuration and center it at the origin
pos_ref = matrix(runif(20), ncol=2)
pos_ref = t(t(pos_ref)-colMeans(pos_ref))

# Create a new configuration by adding a perturbation to the previous one
pos = pos_ref + matrix(rnorm(20, mean=1, sd=0.1), ncol=2)

# Compute the Procrustean Transform and inspect the results
proc_pos = proc_crr(pos, pos_ref)
plot(pos_ref, col="blue", pch=20, xlim=c(-1,3), ylim=c(-1,3))
points(pos, col="red", pch=20)
points(proc_pos, col="purple", pch=20)
}
