% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.ggm_compare_bf.R
\name{select.ggm_compare_explore}
\alias{select.ggm_compare_explore}
\title{Graph selection for \code{ggm_compare_explore} Objects}
\usage{
\method{select}{ggm_compare_explore}(object, BF_cut = 3, ...)
}
\arguments{
\item{object}{An object of class \code{ggm_compare_explore}.}

\item{BF_cut}{Numeric. Threshold for including an edge (defaults to 3).}

\item{...}{Currently ignored.}
}
\value{
The returned object of class \code{select.ggm_compare_explore} contains
a lot of information that is used for printing and plotting the results.
For users of \strong{BGGM}, the following are the useful objects:


\itemize{

\item \code{adj_10} Adjacency matrix for which there was evidence for a difference.

\item \code{adj_10} Adjacency matrix for which there was evidence for a null relation

\item \code{pcor_mat_10} Selected partial correlation matrix (weighted adjacency; only for two groups).

}
}
\description{
Provides the selected graph (of differences) based on the Bayes factor
\insertCite{williams2020comparing}{BGGM}.
}
\examples{
\donttest{

##################
### example 1: ###
##################
# data
Y <- bfi

# males and females
Ymale <- subset(Y, gender == 1,
                   select = -c(gender,
                               education))[,1:10]

Yfemale <- subset(Y, gender == 2,
                     select = -c(gender,
                                 education))[,1:10]

# fit model
fit <- ggm_compare_explore(Ymale, Yfemale,
                           iter = 250,
                           type = "continuous",
                           progress = FALSE)


E <- select(fit, post_prob = 0.50)

}

}
\seealso{
\code{\link{explore}} and \code{\link{ggm_compare_explore}} for several examples.
}
