# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Function to calculate the similarity matrix based on the
#' cluster membership indicator of each iteration.
#' @param mat A matrix of cluster membership indicators.
#' @return returns a similarity matrix.
#' @export
#' @examples
#' n = 90 ## number of subjects
#' iters = 200 ## number of iterations
#' ## matrix of cluster membership indicators
#' ## perfect clustering with three clusters
#' mat = matrix(rep(1:3,each=n/3),nrow=n,ncol=iters)
#' sim = calSim(t(mat))
#' ## plot similarity matrix
#' x <- rep(1:n,times=n)
#' y <- rep(1:n,each=n)
#' z <- as.vector(sim)
#' levelplot(z~x*y,col.regions=rev(gray.colors(n^2)), xlab = "Subject ID",ylab = "Subject ID")
calSim <- function(mat) {
    .Call('BCSub_calSim', PACKAGE = 'BCSub', mat)
}

#' Internal function to sample from multivariate normal distribution.
#' @keywords internal
mvrnormArma <- function(n, mu, sigma) {
    .Call('BCSub_mvrnormArma', PACKAGE = 'BCSub', n, mu, sigma)
}

#' Internal function to sample Lambda
#' @keywords internal
samLamV3Cpp <- function(A, eta, sig, sigl, lam) {
    .Call('BCSub_samLamV3Cpp', PACKAGE = 'BCSub', A, eta, sig, sigl, lam)
}

#' Internal function to calculate the density of multivariate normal distribution.
#' @keywords internal
dmvnrm_arma <- function(x, mean, sigma, logd = FALSE) {
    .Call('BCSub_dmvnrm_arma', PACKAGE = 'BCSub', x, mean, sigma, logd)
}

#' Internal function to find matched index.
#' @keywords internal
myfind <- function(evec, e) {
    .Call('BCSub_myfind', PACKAGE = 'BCSub', evec, e)
}

#' Internal function to sample cluster membership indicator
#' @keywords internal
polyurncpp <- function(e, muA0, sigma0, A, sigma, sigmaInv, sigma0Inv, c) {
    .Call('BCSub_polyurncpp', PACKAGE = 'BCSub', e, muA0, sigma0, A, sigma, sigmaInv, sigma0Inv, c)
}

