/*
 * file:       LocaleData.java
 * author:     Jon Iles
 * copyright:  (c) Packwood Software 2003
 * date:       05/11/2003
 */

/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

package net.sf.mpxj;

import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 * Locale data for MPXJ.
 */
public final class LocaleData extends ListResourceBundle
{
   /**
    * {@inheritDoc}
    */
   @Override public Object[][] getContents()
   {
      return (RESOURCES);
   }

   /**
    * Convenience method for retrieving a String[] resource.
    *
    * @param locale locale identifier
    * @param key resource key
    * @return resource value
    */
   public static final String[] getStringArray(Locale locale, String key)
   {
      ResourceBundle bundle = ResourceBundle.getBundle(LocaleData.class.getName(), locale);
      return (bundle.getStringArray(key));
   }

   public static final String TASK_COLUMNS = "TASK_COLUMNS";
   public static final String RESOURCE_COLUMNS = "RESOURCE_COLUMNS";
   public static final String ASSIGNMENT_COLUMNS = "ASSIGNMENT_COLUMNS";
   public static final String CONSTRAINT_COLUMNS = "CONSTRAINT_COLUMNS";
   public static final String PROJECT_COLUMNS = "PROJECT_COLUMNS";

   private static final String[] RESOURCE_COLUMNS_ARRAY = new String[ResourceField.MAX_VALUE];
   private static final String[] TASK_COLUMNS_ARRAY = new String[TaskField.MAX_VALUE];
   private static final String[] ASSIGNMENT_COLUMNS_ARRAY = new String[AssignmentField.MAX_VALUE];
   private static final String[] CONSTRAINT_COLUMNS_ARRAY = new String[ConstraintField.MAX_VALUE];
   private static final String[] PROJECT_COLUMNS_ARRAY = new String[ProjectField.MAX_VALUE];

   static
   {
      TASK_COLUMNS_ARRAY[TaskField.WORK.getValue()] = "Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_WORK.getValue()] = "Baseline Work";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_WORK.getValue()] = "Actual Work";
      TASK_COLUMNS_ARRAY[TaskField.WORK_VARIANCE.getValue()] = "Work Variance";
      TASK_COLUMNS_ARRAY[TaskField.REMAINING_WORK.getValue()] = "Remaining Work";
      TASK_COLUMNS_ARRAY[TaskField.COST.getValue()] = "Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_COST.getValue()] = "Baseline Cost";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_COST.getValue()] = "Actual Cost";
      TASK_COLUMNS_ARRAY[TaskField.FIXED_COST.getValue()] = "Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.COST_VARIANCE.getValue()] = "Cost Variance";
      TASK_COLUMNS_ARRAY[TaskField.REMAINING_COST.getValue()] = "Remaining Cost";
      TASK_COLUMNS_ARRAY[TaskField.BCWP.getValue()] = "BCWP";
      TASK_COLUMNS_ARRAY[TaskField.BCWS.getValue()] = "BCWS";
      TASK_COLUMNS_ARRAY[TaskField.SV.getValue()] = "SV";
      TASK_COLUMNS_ARRAY[TaskField.NAME.getValue()] = "Task Name";
      TASK_COLUMNS_ARRAY[TaskField.WBS.getValue()] = "WBS";
      TASK_COLUMNS_ARRAY[TaskField.CONSTRAINT_TYPE.getValue()] = "Constraint Type";
      TASK_COLUMNS_ARRAY[TaskField.CONSTRAINT_DATE.getValue()] = "Constraint Date";
      TASK_COLUMNS_ARRAY[TaskField.CRITICAL.getValue()] = "Critical";
      TASK_COLUMNS_ARRAY[TaskField.LEVELING_DELAY.getValue()] = "Leveling Delay";
      TASK_COLUMNS_ARRAY[TaskField.FREE_SLACK.getValue()] = "Free Slack";
      TASK_COLUMNS_ARRAY[TaskField.TOTAL_SLACK.getValue()] = "Total Slack";
      TASK_COLUMNS_ARRAY[TaskField.ID.getValue()] = "ID";
      TASK_COLUMNS_ARRAY[TaskField.MILESTONE.getValue()] = "Milestone";
      TASK_COLUMNS_ARRAY[TaskField.PRIORITY.getValue()] = "Priority";
      TASK_COLUMNS_ARRAY[TaskField.SUBPROJECT_FILE.getValue()] = "Subproject File";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_DURATION.getValue()] = "Baseline Duration";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_DURATION.getValue()] = "Actual Duration";
      TASK_COLUMNS_ARRAY[TaskField.DURATION.getValue()] = "Duration";
      TASK_COLUMNS_ARRAY[TaskField.DURATION_VARIANCE.getValue()] = "Duration Variance";
      TASK_COLUMNS_ARRAY[TaskField.REMAINING_DURATION.getValue()] = "Remaining Duration";
      TASK_COLUMNS_ARRAY[TaskField.PERCENT_COMPLETE.getValue()] = "% Complete";
      TASK_COLUMNS_ARRAY[TaskField.PERCENT_WORK_COMPLETE.getValue()] = "% Work Complete";
      TASK_COLUMNS_ARRAY[TaskField.START.getValue()] = "Start";
      TASK_COLUMNS_ARRAY[TaskField.FINISH.getValue()] = "Finish";
      TASK_COLUMNS_ARRAY[TaskField.EARLY_START.getValue()] = "Early Start";
      TASK_COLUMNS_ARRAY[TaskField.EARLY_FINISH.getValue()] = "Early Finish";
      TASK_COLUMNS_ARRAY[TaskField.LATE_START.getValue()] = "Late Start";
      TASK_COLUMNS_ARRAY[TaskField.LATE_FINISH.getValue()] = "Late Finish";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_START.getValue()] = "Actual Start";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_FINISH.getValue()] = "Actual Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_START.getValue()] = "Baseline Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_FINISH.getValue()] = "Baseline Finish";
      TASK_COLUMNS_ARRAY[TaskField.START_VARIANCE.getValue()] = "Start Variance";
      TASK_COLUMNS_ARRAY[TaskField.FINISH_VARIANCE.getValue()] = "Finish Variance";
      TASK_COLUMNS_ARRAY[TaskField.PREDECESSORS.getValue()] = "Predecessors";
      TASK_COLUMNS_ARRAY[TaskField.SUCCESSORS.getValue()] = "Successors";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_NAMES.getValue()] = "Resource Names";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_INITIALS.getValue()] = "Resource Initials";
      TASK_COLUMNS_ARRAY[TaskField.TEXT1.getValue()] = "Text1";
      TASK_COLUMNS_ARRAY[TaskField.START1.getValue()] = "Start1";
      TASK_COLUMNS_ARRAY[TaskField.FINISH1.getValue()] = "Finish1";
      TASK_COLUMNS_ARRAY[TaskField.TEXT2.getValue()] = "Text2";
      TASK_COLUMNS_ARRAY[TaskField.START2.getValue()] = "Start2";
      TASK_COLUMNS_ARRAY[TaskField.FINISH2.getValue()] = "Finish2";
      TASK_COLUMNS_ARRAY[TaskField.TEXT3.getValue()] = "Text3";
      TASK_COLUMNS_ARRAY[TaskField.START3.getValue()] = "Start3";
      TASK_COLUMNS_ARRAY[TaskField.FINISH3.getValue()] = "Finish3";
      TASK_COLUMNS_ARRAY[TaskField.TEXT4.getValue()] = "Text4";
      TASK_COLUMNS_ARRAY[TaskField.START4.getValue()] = "Start4";
      TASK_COLUMNS_ARRAY[TaskField.FINISH4.getValue()] = "Finish4";
      TASK_COLUMNS_ARRAY[TaskField.TEXT5.getValue()] = "Text5";
      TASK_COLUMNS_ARRAY[TaskField.START5.getValue()] = "Start5";
      TASK_COLUMNS_ARRAY[TaskField.FINISH5.getValue()] = "Finish5";
      TASK_COLUMNS_ARRAY[TaskField.TEXT6.getValue()] = "Text6";
      TASK_COLUMNS_ARRAY[TaskField.TEXT7.getValue()] = "Text7";
      TASK_COLUMNS_ARRAY[TaskField.TEXT8.getValue()] = "Text8";
      TASK_COLUMNS_ARRAY[TaskField.TEXT9.getValue()] = "Text9";
      TASK_COLUMNS_ARRAY[TaskField.TEXT10.getValue()] = "Text10";
      TASK_COLUMNS_ARRAY[TaskField.MARKED.getValue()] = "Marked";
      TASK_COLUMNS_ARRAY[TaskField.FLAG1.getValue()] = "Flag1";
      TASK_COLUMNS_ARRAY[TaskField.FLAG2.getValue()] = "Flag2";
      TASK_COLUMNS_ARRAY[TaskField.FLAG3.getValue()] = "Flag3";
      TASK_COLUMNS_ARRAY[TaskField.FLAG4.getValue()] = "Flag4";
      TASK_COLUMNS_ARRAY[TaskField.FLAG5.getValue()] = "Flag5";
      TASK_COLUMNS_ARRAY[TaskField.FLAG6.getValue()] = "Flag6";
      TASK_COLUMNS_ARRAY[TaskField.FLAG7.getValue()] = "Flag7";
      TASK_COLUMNS_ARRAY[TaskField.FLAG8.getValue()] = "Flag8";
      TASK_COLUMNS_ARRAY[TaskField.FLAG9.getValue()] = "Flag9";
      TASK_COLUMNS_ARRAY[TaskField.FLAG10.getValue()] = "Flag10";
      TASK_COLUMNS_ARRAY[TaskField.ROLLUP.getValue()] = "Rollup";
      TASK_COLUMNS_ARRAY[TaskField.CV.getValue()] = "CV";
      TASK_COLUMNS_ARRAY[TaskField.PROJECT.getValue()] = "Project";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_LEVEL.getValue()] = "Outline Level";
      TASK_COLUMNS_ARRAY[TaskField.UNIQUE_ID.getValue()] = "Unique ID";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER1.getValue()] = "Number1";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER2.getValue()] = "Number2";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER3.getValue()] = "Number3";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER4.getValue()] = "Number4";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER5.getValue()] = "Number5";
      TASK_COLUMNS_ARRAY[TaskField.SUMMARY.getValue()] = "Summary";
      TASK_COLUMNS_ARRAY[TaskField.CREATED.getValue()] = "Created";
      TASK_COLUMNS_ARRAY[TaskField.NOTES.getValue()] = "Notes";
      TASK_COLUMNS_ARRAY[TaskField.UNIQUE_ID_PREDECESSORS.getValue()] = "Unique ID Predecessors";
      TASK_COLUMNS_ARRAY[TaskField.UNIQUE_ID_SUCCESSORS.getValue()] = "Unique ID Successors";
      TASK_COLUMNS_ARRAY[TaskField.OBJECTS.getValue()] = "Objects";
      TASK_COLUMNS_ARRAY[TaskField.LINKED_FIELDS.getValue()] = "Linked Fields";
      TASK_COLUMNS_ARRAY[TaskField.RESUME.getValue()] = "Resume";
      TASK_COLUMNS_ARRAY[TaskField.STOP.getValue()] = "Stop";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_NUMBER.getValue()] = "Outline Number";
      TASK_COLUMNS_ARRAY[TaskField.DURATION1.getValue()] = "Duration1";
      TASK_COLUMNS_ARRAY[TaskField.DURATION2.getValue()] = "Duration2";
      TASK_COLUMNS_ARRAY[TaskField.DURATION3.getValue()] = "Duration3";
      TASK_COLUMNS_ARRAY[TaskField.COST1.getValue()] = "Cost1";
      TASK_COLUMNS_ARRAY[TaskField.COST2.getValue()] = "Cost2";
      TASK_COLUMNS_ARRAY[TaskField.COST3.getValue()] = "Cost3";
      TASK_COLUMNS_ARRAY[TaskField.HIDE_BAR.getValue()] = "Hide Bar";
      TASK_COLUMNS_ARRAY[TaskField.CONFIRMED.getValue()] = "Confirmed";
      TASK_COLUMNS_ARRAY[TaskField.UPDATE_NEEDED.getValue()] = "Update Needed";
      TASK_COLUMNS_ARRAY[TaskField.CONTACT.getValue()] = "Contact";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_GROUP.getValue()] = "Resource Group";
      TASK_COLUMNS_ARRAY[TaskField.ACWP.getValue()] = "ACWP";
      TASK_COLUMNS_ARRAY[TaskField.TYPE.getValue()] = "Type";
      TASK_COLUMNS_ARRAY[TaskField.RECURRING.getValue()] = "Recurring";
      TASK_COLUMNS_ARRAY[TaskField.EFFORT_DRIVEN.getValue()] = "Effort Driven";
      TASK_COLUMNS_ARRAY[TaskField.OVERTIME_WORK.getValue()] = "Overtime Work";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_OVERTIME_WORK.getValue()] = "Actual Overtime Work";
      TASK_COLUMNS_ARRAY[TaskField.REMAINING_OVERTIME_WORK.getValue()] = "Remaining Overtime Work";
      TASK_COLUMNS_ARRAY[TaskField.REGULAR_WORK.getValue()] = "Regular Work";
      TASK_COLUMNS_ARRAY[TaskField.OVERTIME_COST.getValue()] = "Overtime Cost";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_OVERTIME_COST.getValue()] = "Actual Overtime Cost";
      TASK_COLUMNS_ARRAY[TaskField.REMAINING_OVERTIME_COST.getValue()] = "Remaining Overtime Cost";
      TASK_COLUMNS_ARRAY[TaskField.FIXED_COST_ACCRUAL.getValue()] = "Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.INDICATORS.getValue()] = "Indicators";
      TASK_COLUMNS_ARRAY[TaskField.HYPERLINK.getValue()] = "Hyperlink";
      TASK_COLUMNS_ARRAY[TaskField.HYPERLINK_ADDRESS.getValue()] = "Hyperlink Address";
      TASK_COLUMNS_ARRAY[TaskField.HYPERLINK_SUBADDRESS.getValue()] = "Hyperlink SubAddress";
      TASK_COLUMNS_ARRAY[TaskField.HYPERLINK_HREF.getValue()] = "Hyperlink Href";
      TASK_COLUMNS_ARRAY[TaskField.ASSIGNMENT.getValue()] = "Assignment";
      TASK_COLUMNS_ARRAY[TaskField.OVERALLOCATED.getValue()] = "Overallocated";
      TASK_COLUMNS_ARRAY[TaskField.EXTERNAL_TASK.getValue()] = "External Task";
      TASK_COLUMNS_ARRAY[TaskField.SUBPROJECT_READ_ONLY.getValue()] = "Subproject Read Only";
      TASK_COLUMNS_ARRAY[TaskField.RESPONSE_PENDING.getValue()] = "Response Pending";
      TASK_COLUMNS_ARRAY[TaskField.TEAMSTATUS_PENDING.getValue()] = "TeamStatus Pending";
      TASK_COLUMNS_ARRAY[TaskField.LEVELING_CAN_SPLIT.getValue()] = "Leveling Can Split";
      TASK_COLUMNS_ARRAY[TaskField.LEVEL_ASSIGNMENTS.getValue()] = "Level Assignments";
      TASK_COLUMNS_ARRAY[TaskField.WORK_CONTOUR.getValue()] = "Work Contour";
      TASK_COLUMNS_ARRAY[TaskField.COST4.getValue()] = "Cost4";
      TASK_COLUMNS_ARRAY[TaskField.COST5.getValue()] = "Cost5";
      TASK_COLUMNS_ARRAY[TaskField.COST6.getValue()] = "Cost6";
      TASK_COLUMNS_ARRAY[TaskField.COST7.getValue()] = "Cost7";
      TASK_COLUMNS_ARRAY[TaskField.COST8.getValue()] = "Cost8";
      TASK_COLUMNS_ARRAY[TaskField.COST9.getValue()] = "Cost9";
      TASK_COLUMNS_ARRAY[TaskField.COST10.getValue()] = "Cost10";
      TASK_COLUMNS_ARRAY[TaskField.DATE1.getValue()] = "Date1";
      TASK_COLUMNS_ARRAY[TaskField.DATE2.getValue()] = "Date2";
      TASK_COLUMNS_ARRAY[TaskField.DATE3.getValue()] = "Date3";
      TASK_COLUMNS_ARRAY[TaskField.DATE4.getValue()] = "Date4";
      TASK_COLUMNS_ARRAY[TaskField.DATE5.getValue()] = "Date5";
      TASK_COLUMNS_ARRAY[TaskField.DATE6.getValue()] = "Date6";
      TASK_COLUMNS_ARRAY[TaskField.DATE7.getValue()] = "Date7";
      TASK_COLUMNS_ARRAY[TaskField.DATE8.getValue()] = "Date8";
      TASK_COLUMNS_ARRAY[TaskField.DATE9.getValue()] = "Date9";
      TASK_COLUMNS_ARRAY[TaskField.DATE10.getValue()] = "Date10";
      TASK_COLUMNS_ARRAY[TaskField.DURATION4.getValue()] = "Duration4";
      TASK_COLUMNS_ARRAY[TaskField.DURATION5.getValue()] = "Duration5";
      TASK_COLUMNS_ARRAY[TaskField.DURATION6.getValue()] = "Duration6";
      TASK_COLUMNS_ARRAY[TaskField.DURATION7.getValue()] = "Duration7";
      TASK_COLUMNS_ARRAY[TaskField.DURATION8.getValue()] = "Duration8";
      TASK_COLUMNS_ARRAY[TaskField.DURATION9.getValue()] = "Duration9";
      TASK_COLUMNS_ARRAY[TaskField.DURATION10.getValue()] = "Duration10";
      TASK_COLUMNS_ARRAY[TaskField.START6.getValue()] = "Start6";
      TASK_COLUMNS_ARRAY[TaskField.FINISH6.getValue()] = "Finish6";
      TASK_COLUMNS_ARRAY[TaskField.START7.getValue()] = "Start7";
      TASK_COLUMNS_ARRAY[TaskField.FINISH7.getValue()] = "Finish7";
      TASK_COLUMNS_ARRAY[TaskField.START8.getValue()] = "Start8";
      TASK_COLUMNS_ARRAY[TaskField.FINISH8.getValue()] = "Finish8";
      TASK_COLUMNS_ARRAY[TaskField.START9.getValue()] = "Start9";
      TASK_COLUMNS_ARRAY[TaskField.FINISH9.getValue()] = "Finish9";
      TASK_COLUMNS_ARRAY[TaskField.START10.getValue()] = "Start10";
      TASK_COLUMNS_ARRAY[TaskField.FINISH10.getValue()] = "Finish10";
      TASK_COLUMNS_ARRAY[TaskField.FLAG11.getValue()] = "Flag11";
      TASK_COLUMNS_ARRAY[TaskField.FLAG12.getValue()] = "Flag12";
      TASK_COLUMNS_ARRAY[TaskField.FLAG13.getValue()] = "Flag13";
      TASK_COLUMNS_ARRAY[TaskField.FLAG14.getValue()] = "Flag14";
      TASK_COLUMNS_ARRAY[TaskField.FLAG15.getValue()] = "Flag15";
      TASK_COLUMNS_ARRAY[TaskField.FLAG16.getValue()] = "Flag16";
      TASK_COLUMNS_ARRAY[TaskField.FLAG17.getValue()] = "Flag17";
      TASK_COLUMNS_ARRAY[TaskField.FLAG18.getValue()] = "Flag18";
      TASK_COLUMNS_ARRAY[TaskField.FLAG19.getValue()] = "Flag19";
      TASK_COLUMNS_ARRAY[TaskField.FLAG20.getValue()] = "Flag20";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER6.getValue()] = "Number6";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER7.getValue()] = "Number7";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER8.getValue()] = "Number8";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER9.getValue()] = "Number9";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER10.getValue()] = "Number10";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER11.getValue()] = "Number11";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER12.getValue()] = "Number12";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER13.getValue()] = "Number13";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER14.getValue()] = "Number14";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER15.getValue()] = "Number15";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER16.getValue()] = "Number16";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER17.getValue()] = "Number17";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER18.getValue()] = "Number18";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER19.getValue()] = "Number19";
      TASK_COLUMNS_ARRAY[TaskField.NUMBER20.getValue()] = "Number20";
      TASK_COLUMNS_ARRAY[TaskField.TEXT11.getValue()] = "Text11";
      TASK_COLUMNS_ARRAY[TaskField.TEXT12.getValue()] = "Text12";
      TASK_COLUMNS_ARRAY[TaskField.TEXT13.getValue()] = "Text13";
      TASK_COLUMNS_ARRAY[TaskField.TEXT14.getValue()] = "Text14";
      TASK_COLUMNS_ARRAY[TaskField.TEXT15.getValue()] = "Text15";
      TASK_COLUMNS_ARRAY[TaskField.TEXT16.getValue()] = "Text16";
      TASK_COLUMNS_ARRAY[TaskField.TEXT17.getValue()] = "Text17";
      TASK_COLUMNS_ARRAY[TaskField.TEXT18.getValue()] = "Text18";
      TASK_COLUMNS_ARRAY[TaskField.TEXT19.getValue()] = "Text19";
      TASK_COLUMNS_ARRAY[TaskField.TEXT20.getValue()] = "Text20";
      TASK_COLUMNS_ARRAY[TaskField.TEXT21.getValue()] = "Text21";
      TASK_COLUMNS_ARRAY[TaskField.TEXT22.getValue()] = "Text22";
      TASK_COLUMNS_ARRAY[TaskField.TEXT23.getValue()] = "Text23";
      TASK_COLUMNS_ARRAY[TaskField.TEXT24.getValue()] = "Text24";
      TASK_COLUMNS_ARRAY[TaskField.TEXT25.getValue()] = "Text25";
      TASK_COLUMNS_ARRAY[TaskField.TEXT26.getValue()] = "Text26";
      TASK_COLUMNS_ARRAY[TaskField.TEXT27.getValue()] = "Text27";
      TASK_COLUMNS_ARRAY[TaskField.TEXT28.getValue()] = "Text28";
      TASK_COLUMNS_ARRAY[TaskField.TEXT29.getValue()] = "Text29";
      TASK_COLUMNS_ARRAY[TaskField.TEXT30.getValue()] = "Text30";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_PHONETICS.getValue()] = "Resource Phonetics";
      TASK_COLUMNS_ARRAY[TaskField.ASSIGNMENT_DELAY.getValue()] = "Assignment Delay";
      TASK_COLUMNS_ARRAY[TaskField.ASSIGNMENT_UNITS.getValue()] = "Assignment Units";
      TASK_COLUMNS_ARRAY[TaskField.COST_RATE_TABLE.getValue()] = "Cost Rate Table";
      TASK_COLUMNS_ARRAY[TaskField.PRELEVELED_START.getValue()] = "Preleveled Start";
      TASK_COLUMNS_ARRAY[TaskField.PRELEVELED_FINISH.getValue()] = "Preleveled Finish";
      TASK_COLUMNS_ARRAY[TaskField.ESTIMATED.getValue()] = "Estimated";
      TASK_COLUMNS_ARRAY[TaskField.IGNORE_RESOURCE_CALENDAR.getValue()] = "Ignore Resource Calendar";
      TASK_COLUMNS_ARRAY[TaskField.CALENDAR.getValue()] = "Task Calendar";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE1.getValue()] = "Outline Code1";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE2.getValue()] = "Outline Code2";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE3.getValue()] = "Outline Code3";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE4.getValue()] = "Outline Code4";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE5.getValue()] = "Outline Code5";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE6.getValue()] = "Outline Code6";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE7.getValue()] = "Outline Code7";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE8.getValue()] = "Outline Code8";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE9.getValue()] = "Outline Code9";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE10.getValue()] = "Outline Code10";
      TASK_COLUMNS_ARRAY[TaskField.DEADLINE.getValue()] = "Deadline";
      TASK_COLUMNS_ARRAY[TaskField.START_SLACK.getValue()] = "Start Slack";
      TASK_COLUMNS_ARRAY[TaskField.FINISH_SLACK.getValue()] = "Finish Slack";
      TASK_COLUMNS_ARRAY[TaskField.VAC.getValue()] = "VAC";
      TASK_COLUMNS_ARRAY[TaskField.GROUP_BY_SUMMARY.getValue()] = "Group By Summary";
      TASK_COLUMNS_ARRAY[TaskField.WBS_PREDECESSORS.getValue()] = "WBS Predecessors";
      TASK_COLUMNS_ARRAY[TaskField.WBS_SUCCESSORS.getValue()] = "WBS Successors";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_TYPE.getValue()] = "Resource Type";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_START.getValue()] = "Baseline1 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_FINISH.getValue()] = "Baseline1 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_COST.getValue()] = "Baseline1 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_WORK.getValue()] = "Baseline1 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_DURATION.getValue()] = "Baseline1 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_START.getValue()] = "Baseline2 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_FINISH.getValue()] = "Baseline2 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_COST.getValue()] = "Baseline2 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_WORK.getValue()] = "Baseline2 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_DURATION.getValue()] = "Baseline2 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_START.getValue()] = "Baseline3 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_FINISH.getValue()] = "Baseline3 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_COST.getValue()] = "Baseline3 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_WORK.getValue()] = "Baseline3 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_DURATION.getValue()] = "Baseline3 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_START.getValue()] = "Baseline4 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_FINISH.getValue()] = "Baseline4 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_COST.getValue()] = "Baseline4 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_WORK.getValue()] = "Baseline4 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_DURATION.getValue()] = "Baseline4 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_START.getValue()] = "Baseline5 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_FINISH.getValue()] = "Baseline5 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_COST.getValue()] = "Baseline5 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_WORK.getValue()] = "Baseline5 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_DURATION.getValue()] = "Baseline5 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_START.getValue()] = "Baseline6 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_FINISH.getValue()] = "Baseline6 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_COST.getValue()] = "Baseline6 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_WORK.getValue()] = "Baseline6 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_DURATION.getValue()] = "Baseline6 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_START.getValue()] = "Baseline7 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_FINISH.getValue()] = "Baseline7 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_COST.getValue()] = "Baseline7 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_WORK.getValue()] = "Baseline7 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_DURATION.getValue()] = "Baseline7 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_START.getValue()] = "Baseline8 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_FINISH.getValue()] = "Baseline8 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_COST.getValue()] = "Baseline8 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_WORK.getValue()] = "Baseline8 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_DURATION.getValue()] = "Baseline8 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_START.getValue()] = "Baseline9 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_FINISH.getValue()] = "Baseline9 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_COST.getValue()] = "Baseline9 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_WORK.getValue()] = "Baseline9 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_DURATION.getValue()] = "Baseline9 Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_START.getValue()] = "Baseline10 Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_FINISH.getValue()] = "Baseline10 Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_COST.getValue()] = "Baseline10 Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_WORK.getValue()] = "Baseline10 Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_DURATION.getValue()] = "Baseline10 Duration";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST1.getValue()] = "Enterprise Cost1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST2.getValue()] = "Enterprise Cost2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST3.getValue()] = "Enterprise Cost3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST4.getValue()] = "Enterprise Cost4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST5.getValue()] = "Enterprise Cost5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST6.getValue()] = "Enterprise Cost6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST7.getValue()] = "Enterprise Cost7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST8.getValue()] = "Enterprise Cost8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST9.getValue()] = "Enterprise Cost9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_COST10.getValue()] = "Enterprise Cost10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE1.getValue()] = "Enterprise Date1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE2.getValue()] = "Enterprise Date2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE3.getValue()] = "Enterprise Date3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE4.getValue()] = "Enterprise Date4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE5.getValue()] = "Enterprise Date5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE6.getValue()] = "Enterprise Date6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE7.getValue()] = "Enterprise Date7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE8.getValue()] = "Enterprise Date8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE9.getValue()] = "Enterprise Date9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE10.getValue()] = "Enterprise Date10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE11.getValue()] = "Enterprise Date11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE12.getValue()] = "Enterprise Date12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE13.getValue()] = "Enterprise Date13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE14.getValue()] = "Enterprise Date14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE15.getValue()] = "Enterprise Date15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE16.getValue()] = "Enterprise Date16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE17.getValue()] = "Enterprise Date17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE18.getValue()] = "Enterprise Date18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE19.getValue()] = "Enterprise Date19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE20.getValue()] = "Enterprise Date20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE21.getValue()] = "Enterprise Date21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE22.getValue()] = "Enterprise Date22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE23.getValue()] = "Enterprise Date23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE24.getValue()] = "Enterprise Date24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE25.getValue()] = "Enterprise Date25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE26.getValue()] = "Enterprise Date26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE27.getValue()] = "Enterprise Date27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE28.getValue()] = "Enterprise Date28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE29.getValue()] = "Enterprise Date29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATE30.getValue()] = "Enterprise Date30";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION1.getValue()] = "Enterprise Duration1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION2.getValue()] = "Enterprise Duration2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION3.getValue()] = "Enterprise Duration3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION4.getValue()] = "Enterprise Duration4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION5.getValue()] = "Enterprise Duration5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION6.getValue()] = "Enterprise Duration6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION7.getValue()] = "Enterprise Duration7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION8.getValue()] = "Enterprise Duration8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION9.getValue()] = "Enterprise Duration9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION10.getValue()] = "Enterprise Duration10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG1.getValue()] = "Enterprise Flag1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG2.getValue()] = "Enterprise Flag2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG3.getValue()] = "Enterprise Flag3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG4.getValue()] = "Enterprise Flag4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG5.getValue()] = "Enterprise Flag5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG6.getValue()] = "Enterprise Flag6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG7.getValue()] = "Enterprise Flag7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG8.getValue()] = "Enterprise Flag8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG9.getValue()] = "Enterprise Flag9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG10.getValue()] = "Enterprise Flag10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG11.getValue()] = "Enterprise Flag11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG12.getValue()] = "Enterprise Flag12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG13.getValue()] = "Enterprise Flag13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG14.getValue()] = "Enterprise Flag14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG15.getValue()] = "Enterprise Flag15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG16.getValue()] = "Enterprise Flag16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG17.getValue()] = "Enterprise Flag17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG18.getValue()] = "Enterprise Flag18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG19.getValue()] = "Enterprise Flag19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_FLAG20.getValue()] = "Enterprise Flag20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER1.getValue()] = "Enterprise Number1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER2.getValue()] = "Enterprise Number2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER3.getValue()] = "Enterprise Number3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER4.getValue()] = "Enterprise Number4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER5.getValue()] = "Enterprise Number5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER6.getValue()] = "Enterprise Number6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER7.getValue()] = "Enterprise Number7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER8.getValue()] = "Enterprise Number8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER9.getValue()] = "Enterprise Number9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER10.getValue()] = "Enterprise Number10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER11.getValue()] = "Enterprise Number11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER12.getValue()] = "Enterprise Number12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER13.getValue()] = "Enterprise Number13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER14.getValue()] = "Enterprise Number14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER15.getValue()] = "Enterprise Number15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER16.getValue()] = "Enterprise Number16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER17.getValue()] = "Enterprise Number17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER18.getValue()] = "Enterprise Number18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER19.getValue()] = "Enterprise Number19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER20.getValue()] = "Enterprise Number20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER21.getValue()] = "Enterprise Number21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER22.getValue()] = "Enterprise Number22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER23.getValue()] = "Enterprise Number23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER24.getValue()] = "Enterprise Number24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER25.getValue()] = "Enterprise Number25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER26.getValue()] = "Enterprise Number26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER27.getValue()] = "Enterprise Number27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER28.getValue()] = "Enterprise Number28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER29.getValue()] = "Enterprise Number29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER30.getValue()] = "Enterprise Number30";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER31.getValue()] = "Enterprise Number31";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER32.getValue()] = "Enterprise Number32";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER33.getValue()] = "Enterprise Number33";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER34.getValue()] = "Enterprise Number34";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER35.getValue()] = "Enterprise Number35";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER36.getValue()] = "Enterprise Number36";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER37.getValue()] = "Enterprise Number37";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER38.getValue()] = "Enterprise Number38";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER39.getValue()] = "Enterprise Number39";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_NUMBER40.getValue()] = "Enterprise Number40";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT1.getValue()] = "Enterprise Text1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT2.getValue()] = "Enterprise Text2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT3.getValue()] = "Enterprise Text3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT4.getValue()] = "Enterprise Text4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT5.getValue()] = "Enterprise Text5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT6.getValue()] = "Enterprise Text6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT7.getValue()] = "Enterprise Text7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT8.getValue()] = "Enterprise Text8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT9.getValue()] = "Enterprise Text9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT10.getValue()] = "Enterprise Text10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT11.getValue()] = "Enterprise Text11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT12.getValue()] = "Enterprise Text12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT13.getValue()] = "Enterprise Text13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT14.getValue()] = "Enterprise Text14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT15.getValue()] = "Enterprise Text15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT16.getValue()] = "Enterprise Text16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT17.getValue()] = "Enterprise Text17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT18.getValue()] = "Enterprise Text18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT19.getValue()] = "Enterprise Text19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT20.getValue()] = "Enterprise Text20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT21.getValue()] = "Enterprise Text21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT22.getValue()] = "Enterprise Text22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT23.getValue()] = "Enterprise Text23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT24.getValue()] = "Enterprise Text24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT25.getValue()] = "Enterprise Text25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT26.getValue()] = "Enterprise Text26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT27.getValue()] = "Enterprise Text27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT28.getValue()] = "Enterprise Text28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT29.getValue()] = "Enterprise Text29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT30.getValue()] = "Enterprise Text30";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT31.getValue()] = "Enterprise Text31";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT32.getValue()] = "Enterprise Text32";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT33.getValue()] = "Enterprise Text33";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT34.getValue()] = "Enterprise Text34";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT35.getValue()] = "Enterprise Text35";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT36.getValue()] = "Enterprise Text36";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT37.getValue()] = "Enterprise Text37";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT38.getValue()] = "Enterprise Text38";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT39.getValue()] = "Enterprise Text39";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_TEXT40.getValue()] = "Enterprise Text40";
      TASK_COLUMNS_ARRAY[TaskField.COMPLETE_THROUGH.getValue()] = "Complete Through";
      TASK_COLUMNS_ARRAY[TaskField.SUMMARY_PROGRESS.getValue()] = "Summary Progress";

      TASK_COLUMNS_ARRAY[TaskField.ACTIVE.getValue()] = "Active";
      TASK_COLUMNS_ARRAY[TaskField.GUID.getValue()] = "GUID";
      TASK_COLUMNS_ARRAY[TaskField.TASK_MODE.getValue()] = "Task Mode";
      TASK_COLUMNS_ARRAY[TaskField.ASSIGNMENT_OWNER.getValue()] = "Assignment Owner";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_BUDGET_COST.getValue()] = "Baseline Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_BUDGET_WORK.getValue()] = "Baseline Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_DELIVERABLE_FINISH.getValue()] = "Baseline Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_DELIVERABLE_START.getValue()] = "Baseline Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_ESTIMATED_DURATION.getValue()] = "Baseline Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_ESTIMATED_START.getValue()] = "Baseline Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_ESTIMATED_FINISH.getValue()] = "Baseline Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_FIXED_COST.getValue()] = "Baseline Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_FIXED_COST_ACCRUAL.getValue()] = "Baseline Fixed Cost Accrual";

      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_ESTIMATED_START.getValue()] = "Baseline1 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_ESTIMATED_FINISH.getValue()] = "Baseline1 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_ESTIMATED_DURATION.getValue()] = "Baseline1 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_FIXED_COST.getValue()] = "Baseline1 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_FIXED_COST_ACCRUAL.getValue()] = "Baseline1 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_BUDGET_COST.getValue()] = "Baseline1 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_BUDGET_WORK.getValue()] = "Baseline1 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_DELIVERABLE_FINISH.getValue()] = "Baseline1 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_DELIVERABLE_START.getValue()] = "Baseline1 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_ESTIMATED_START.getValue()] = "Baseline2 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_ESTIMATED_FINISH.getValue()] = "Baseline2 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_ESTIMATED_DURATION.getValue()] = "Baseline2 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_FIXED_COST.getValue()] = "Baseline2 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_FIXED_COST_ACCRUAL.getValue()] = "Baseline2 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_BUDGET_COST.getValue()] = "Baseline2 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_BUDGET_WORK.getValue()] = "Baseline2 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_DELIVERABLE_FINISH.getValue()] = "Baseline2 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_DELIVERABLE_START.getValue()] = "Baseline2 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_ESTIMATED_START.getValue()] = "Baseline3 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_ESTIMATED_FINISH.getValue()] = "Baseline3 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_ESTIMATED_DURATION.getValue()] = "Baseline3 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_FIXED_COST.getValue()] = "Baseline3 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_FIXED_COST_ACCRUAL.getValue()] = "Baseline3 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_BUDGET_COST.getValue()] = "Baseline3 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_BUDGET_WORK.getValue()] = "Baseline3 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_DELIVERABLE_FINISH.getValue()] = "Baseline3 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_DELIVERABLE_START.getValue()] = "Baseline3 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_ESTIMATED_START.getValue()] = "Baseline4 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_ESTIMATED_FINISH.getValue()] = "Baseline4 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_ESTIMATED_DURATION.getValue()] = "Baseline4 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_FIXED_COST.getValue()] = "Baseline4 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_FIXED_COST_ACCRUAL.getValue()] = "Baseline4 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_BUDGET_COST.getValue()] = "Baseline4 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_BUDGET_WORK.getValue()] = "Baseline4 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_DELIVERABLE_FINISH.getValue()] = "Baseline4 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_DELIVERABLE_START.getValue()] = "Baseline4 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_ESTIMATED_START.getValue()] = "Baseline5 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_ESTIMATED_FINISH.getValue()] = "Baseline5 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_ESTIMATED_DURATION.getValue()] = "Baseline5 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_FIXED_COST.getValue()] = "Baseline5 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_FIXED_COST_ACCRUAL.getValue()] = "Baseline5 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_BUDGET_COST.getValue()] = "Baseline5 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_BUDGET_WORK.getValue()] = "Baseline5 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_DELIVERABLE_FINISH.getValue()] = "Baseline5 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_DELIVERABLE_START.getValue()] = "Baseline5 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_ESTIMATED_START.getValue()] = "Baseline6 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_ESTIMATED_FINISH.getValue()] = "Baseline6 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_ESTIMATED_DURATION.getValue()] = "Baseline6 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_FIXED_COST.getValue()] = "Baseline6 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_FIXED_COST_ACCRUAL.getValue()] = "Baseline6 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_BUDGET_COST.getValue()] = "Baseline6 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_BUDGET_WORK.getValue()] = "Baseline6 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_DELIVERABLE_FINISH.getValue()] = "Baseline6 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_DELIVERABLE_START.getValue()] = "Baseline6 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_ESTIMATED_START.getValue()] = "Baseline7 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_ESTIMATED_FINISH.getValue()] = "Baseline7 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_ESTIMATED_DURATION.getValue()] = "Baseline7 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_FIXED_COST.getValue()] = "Baseline7 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_FIXED_COST_ACCRUAL.getValue()] = "Baseline7 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_BUDGET_COST.getValue()] = "Baseline7 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_BUDGET_WORK.getValue()] = "Baseline7 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_DELIVERABLE_FINISH.getValue()] = "Baseline7 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_DELIVERABLE_START.getValue()] = "Baseline7 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_ESTIMATED_START.getValue()] = "Baseline8 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_ESTIMATED_FINISH.getValue()] = "Baseline8 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_ESTIMATED_DURATION.getValue()] = "Baseline8 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_FIXED_COST.getValue()] = "Baseline8 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_FIXED_COST_ACCRUAL.getValue()] = "Baseline8 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_BUDGET_COST.getValue()] = "Baseline8 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_BUDGET_WORK.getValue()] = "Baseline8 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_DELIVERABLE_FINISH.getValue()] = "Baseline8 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_DELIVERABLE_START.getValue()] = "Baseline8 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_ESTIMATED_START.getValue()] = "Baseline9 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_ESTIMATED_FINISH.getValue()] = "Baseline9 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_ESTIMATED_DURATION.getValue()] = "Baseline9 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_FIXED_COST.getValue()] = "Baseline9 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_FIXED_COST_ACCRUAL.getValue()] = "Baseline9 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_BUDGET_COST.getValue()] = "Baseline9 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_BUDGET_WORK.getValue()] = "Baseline9 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_DELIVERABLE_FINISH.getValue()] = "Baseline9 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_DELIVERABLE_START.getValue()] = "Baseline9 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_ESTIMATED_START.getValue()] = "Baseline10 Estimated Start";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_ESTIMATED_FINISH.getValue()] = "Baseline10 Estimated Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_ESTIMATED_DURATION.getValue()] = "Baseline10 Estimated Duration";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_FIXED_COST.getValue()] = "Baseline10 Fixed Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_FIXED_COST_ACCRUAL.getValue()] = "Baseline10 Fixed Cost Accrual";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_BUDGET_COST.getValue()] = "Baseline10 Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_BUDGET_WORK.getValue()] = "Baseline10 Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_DELIVERABLE_FINISH.getValue()] = "Baseline10 Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_DELIVERABLE_START.getValue()] = "Baseline10 Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.CPI.getValue()] = "CPI";
      TASK_COLUMNS_ARRAY[TaskField.CVPERCENT.getValue()] = "CV%";
      TASK_COLUMNS_ARRAY[TaskField.DELIVERABLE_FINISH.getValue()] = "Deliverable Finish";
      TASK_COLUMNS_ARRAY[TaskField.DELIVERABLE_GUID.getValue()] = "Deliverable GUID";
      TASK_COLUMNS_ARRAY[TaskField.DELIVERABLE_NAME.getValue()] = "Deliverable Name";
      TASK_COLUMNS_ARRAY[TaskField.DELIVERABLE_START.getValue()] = "Deliverable Start";
      TASK_COLUMNS_ARRAY[TaskField.DELIVERABLE_TYPE.getValue()] = "Deliverable Type";
      TASK_COLUMNS_ARRAY[TaskField.EAC.getValue()] = "EAC";
      TASK_COLUMNS_ARRAY[TaskField.EARNED_VALUE_METHOD.getValue()] = "Earned Value Method";
      TASK_COLUMNS_ARRAY[TaskField.ERROR_MESSAGE.getValue()] = "Error Message";
      TASK_COLUMNS_ARRAY[TaskField.IGNORE_WARNINGS.getValue()] = "Ignore Warnings";
      TASK_COLUMNS_ARRAY[TaskField.PEAK.getValue()] = "Peak";
      TASK_COLUMNS_ARRAY[TaskField.PHYSICAL_PERCENT_COMPLETE.getValue()] = "Physical % Complete";
      TASK_COLUMNS_ARRAY[TaskField.PLACEHOLDER.getValue()] = "Placeholder";
      TASK_COLUMNS_ARRAY[TaskField.PUBLISH.getValue()] = "Publish";
      TASK_COLUMNS_ARRAY[TaskField.REQUEST_DEMAND.getValue()] = "Request/Demand";
      TASK_COLUMNS_ARRAY[TaskField.SCHEDULED_DURATION.getValue()] = "Scheduled Duration";
      TASK_COLUMNS_ARRAY[TaskField.SCHEDULED_FINISH.getValue()] = "Scheduled Finish";
      TASK_COLUMNS_ARRAY[TaskField.SCHEDULED_START.getValue()] = "Scheduled Start";
      TASK_COLUMNS_ARRAY[TaskField.SPI.getValue()] = "SPI";
      TASK_COLUMNS_ARRAY[TaskField.STATUS.getValue()] = "Status";
      TASK_COLUMNS_ARRAY[TaskField.STATUS_INDICATOR.getValue()] = "Status Indicator";
      TASK_COLUMNS_ARRAY[TaskField.STATUS_MANAGER.getValue()] = "Status Manager";
      TASK_COLUMNS_ARRAY[TaskField.SVPERCENT.getValue()] = "SV%";
      TASK_COLUMNS_ARRAY[TaskField.TASK_CALENDAR.getValue()] = "Task Calendar";
      TASK_COLUMNS_ARRAY[TaskField.TASK_CALENDAR_GUID.getValue()] = "Task Calendar GUID";
      TASK_COLUMNS_ARRAY[TaskField.TCPI.getValue()] = "TCPI";
      TASK_COLUMNS_ARRAY[TaskField.WARNING.getValue()] = "Warning";
      TASK_COLUMNS_ARRAY[TaskField.UNAVAILABLE.getValue()] = "<Unavailable>";

      TASK_COLUMNS_ARRAY[TaskField.DURATION_UNITS.getValue()] = "Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_DURATION_UNITS.getValue()] = "Baseline Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_DURATION_UNITS.getValue()] = "Actual Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.LEVELING_DELAY_UNITS.getValue()] = "Leveling Delay Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION1_UNITS.getValue()] = "Duration1 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION2_UNITS.getValue()] = "Duration2 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION3_UNITS.getValue()] = "Duration3 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION4_UNITS.getValue()] = "Duration4 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION5_UNITS.getValue()] = "Duration5 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION6_UNITS.getValue()] = "Duration6 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION7_UNITS.getValue()] = "Duration7 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION8_UNITS.getValue()] = "Duration8 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION9_UNITS.getValue()] = "Duration9 Units";
      TASK_COLUMNS_ARRAY[TaskField.DURATION10_UNITS.getValue()] = "Duration10 Units";
      TASK_COLUMNS_ARRAY[TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET.getValue()] = "Subproject Tasks Unique ID Offset";
      TASK_COLUMNS_ARRAY[TaskField.SUBPROJECT_UNIQUE_TASK_ID.getValue()] = "Subproject Unique Task ID";
      TASK_COLUMNS_ARRAY[TaskField.SUBPROJECT_TASK_ID.getValue()] = "Subproject Task ID";
      TASK_COLUMNS_ARRAY[TaskField.HYPERLINK_DATA.getValue()] = "Hyperlink Data";
      TASK_COLUMNS_ARRAY[TaskField.RECURRING_DATA.getValue()] = "Recurring Data";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE1_INDEX.getValue()] = "Outline Code1 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE2_INDEX.getValue()] = "Outline Code2 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE3_INDEX.getValue()] = "Outline Code3 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE4_INDEX.getValue()] = "Outline Code4 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE5_INDEX.getValue()] = "Outline Code5 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE6_INDEX.getValue()] = "Outline Code6 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE7_INDEX.getValue()] = "Outline Code7 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE8_INDEX.getValue()] = "Outline Code8 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE9_INDEX.getValue()] = "Outline Code9 Index";
      TASK_COLUMNS_ARRAY[TaskField.OUTLINE_CODE10_INDEX.getValue()] = "Outline Code10 Index";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DATA.getValue()] = "Enterprise Data";
      TASK_COLUMNS_ARRAY[TaskField.PARENT_TASK_UNIQUE_ID.getValue()] = "Parent Task Unique ID";
      TASK_COLUMNS_ARRAY[TaskField.CALENDAR_UNIQUE_ID.getValue()] = "Calendar Unique ID";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION1_UNITS.getValue()] = "Enterprise Duration1 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION2_UNITS.getValue()] = "Enterprise Duration2 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION3_UNITS.getValue()] = "Enterprise Duration3 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION4_UNITS.getValue()] = "Enterprise Duration4 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION5_UNITS.getValue()] = "Enterprise Duration5 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION6_UNITS.getValue()] = "Enterprise Duration6 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION7_UNITS.getValue()] = "Enterprise Duration7 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION8_UNITS.getValue()] = "Enterprise Duration8 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION9_UNITS.getValue()] = "Enterprise Duration9 Units";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_DURATION10_UNITS.getValue()] = "Enterprise Duration10 Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_DURATION_UNITS.getValue()] = "Baseline1 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_DURATION_UNITS.getValue()] = "Baseline2 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_DURATION_UNITS.getValue()] = "Baseline3 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_DURATION_UNITS.getValue()] = "Baseline4 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_DURATION_UNITS.getValue()] = "Baseline5 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_DURATION_UNITS.getValue()] = "Baseline6 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_DURATION_UNITS.getValue()] = "Baseline7 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_DURATION_UNITS.getValue()] = "Baseline8 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_DURATION_UNITS.getValue()] = "Baseline9 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_DURATION_UNITS.getValue()] = "Baseline10 Duration Units";
      TASK_COLUMNS_ARRAY[TaskField.FIXED_DURATION.getValue()] = "Fixed Duration";
      TASK_COLUMNS_ARRAY[TaskField.RESUME_NO_EARLIER_THAN.getValue()] = "Resume No Earlier Than";
      TASK_COLUMNS_ARRAY[TaskField.PARENT_TASK.getValue()] = "Parent Task";
      TASK_COLUMNS_ARRAY[TaskField.INDEX.getValue()] = "Index";
      TASK_COLUMNS_ARRAY[TaskField.DURATION1_ESTIMATED.getValue()] = "Duration1 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION2_ESTIMATED.getValue()] = "Duration2 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION3_ESTIMATED.getValue()] = "Duration3 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION4_ESTIMATED.getValue()] = "Duration4 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION5_ESTIMATED.getValue()] = "Duration5 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION6_ESTIMATED.getValue()] = "Duration6 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION7_ESTIMATED.getValue()] = "Duration7 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION8_ESTIMATED.getValue()] = "Duration8 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION9_ESTIMATED.getValue()] = "Duration9 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.DURATION10_ESTIMATED.getValue()] = "Duration10 Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE_DURATION_ESTIMATED.getValue()] = "Baseline Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.HYPERLINK_SCREEN_TIP.getValue()] = "Hyperlink Screen Tip";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE1.getValue()] = "Enterprise Outline Code1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE2.getValue()] = "Enterprise Outline Code2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE3.getValue()] = "Enterprise Outline Code3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE4.getValue()] = "Enterprise Outline Code4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE5.getValue()] = "Enterprise Outline Code5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE6.getValue()] = "Enterprise Outline Code6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE7.getValue()] = "Enterprise Outline Code7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE8.getValue()] = "Enterprise Outline Code8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE9.getValue()] = "Enterprise Outline Code9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE10.getValue()] = "Enterprise Outline Code10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE11.getValue()] = "Enterprise Outline Code11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE12.getValue()] = "Enterprise Outline Code12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE13.getValue()] = "Enterprise Outline Code13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE14.getValue()] = "Enterprise Outline Code14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE15.getValue()] = "Enterprise Outline Code15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE16.getValue()] = "Enterprise Outline Code16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE17.getValue()] = "Enterprise Outline Code17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE18.getValue()] = "Enterprise Outline Code18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE19.getValue()] = "Enterprise Outline Code19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE20.getValue()] = "Enterprise Outline Code20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE21.getValue()] = "Enterprise Outline Code21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE22.getValue()] = "Enterprise Outline Code22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE23.getValue()] = "Enterprise Outline Code23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE24.getValue()] = "Enterprise Outline Code24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE25.getValue()] = "Enterprise Outline Code25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE26.getValue()] = "Enterprise Outline Code26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE27.getValue()] = "Enterprise Outline Code27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE28.getValue()] = "Enterprise Outline Code28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE29.getValue()] = "Enterprise Outline Code29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_OUTLINE_CODE30.getValue()] = "Enterprise Outline Code30";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE1_DURATION_ESTIMATED.getValue()] = "Baseline1 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE2_DURATION_ESTIMATED.getValue()] = "Baseline2 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE3_DURATION_ESTIMATED.getValue()] = "Baseline3 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE4_DURATION_ESTIMATED.getValue()] = "Baseline4 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE5_DURATION_ESTIMATED.getValue()] = "Baseline5 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE6_DURATION_ESTIMATED.getValue()] = "Baseline6 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE7_DURATION_ESTIMATED.getValue()] = "Baseline7 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE8_DURATION_ESTIMATED.getValue()] = "Baseline8 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE9_DURATION_ESTIMATED.getValue()] = "Baseline9 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.BASELINE10_DURATION_ESTIMATED.getValue()] = "Baseline10 Duration Estimated";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST1.getValue()] = "Enterprise Project Cost1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST2.getValue()] = "Enterprise Project Cost2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST3.getValue()] = "Enterprise Project Cost3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST4.getValue()] = "Enterprise Project Cost4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST5.getValue()] = "Enterprise Project Cost5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST6.getValue()] = "Enterprise Project Cost6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST7.getValue()] = "Enterprise Project Cost7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST8.getValue()] = "Enterprise Project Cost8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST9.getValue()] = "Enterprise Project Cost9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_COST10.getValue()] = "Enterprise Project Cost10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE1.getValue()] = "Enterprise Project Date1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE2.getValue()] = "Enterprise Project Date2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE3.getValue()] = "Enterprise Project Date3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE4.getValue()] = "Enterprise Project Date4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE5.getValue()] = "Enterprise Project Date5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE6.getValue()] = "Enterprise Project Date6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE7.getValue()] = "Enterprise Project Date7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE8.getValue()] = "Enterprise Project Date8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE9.getValue()] = "Enterprise Project Date9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE10.getValue()] = "Enterprise Project Date10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE11.getValue()] = "Enterprise Project Date11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE12.getValue()] = "Enterprise Project Date12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE13.getValue()] = "Enterprise Project Date13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE14.getValue()] = "Enterprise Project Date14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE15.getValue()] = "Enterprise Project Date15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE16.getValue()] = "Enterprise Project Date16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE17.getValue()] = "Enterprise Project Date17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE18.getValue()] = "Enterprise Project Date18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE19.getValue()] = "Enterprise Project Date19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE20.getValue()] = "Enterprise Project Date20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE21.getValue()] = "Enterprise Project Date21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE22.getValue()] = "Enterprise Project Date22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE23.getValue()] = "Enterprise Project Date23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE24.getValue()] = "Enterprise Project Date24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE25.getValue()] = "Enterprise Project Date25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE26.getValue()] = "Enterprise Project Date26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE27.getValue()] = "Enterprise Project Date27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE28.getValue()] = "Enterprise Project Date28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE29.getValue()] = "Enterprise Project Date29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DATE30.getValue()] = "Enterprise Project Date30";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION1.getValue()] = "Enterprise Project Duration1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION2.getValue()] = "Enterprise Project Duration2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION3.getValue()] = "Enterprise Project Duration3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION4.getValue()] = "Enterprise Project Duration4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION5.getValue()] = "Enterprise Project Duration5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION6.getValue()] = "Enterprise Project Duration6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION7.getValue()] = "Enterprise Project Duration7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION8.getValue()] = "Enterprise Project Duration8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION9.getValue()] = "Enterprise Project Duration9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_DURATION10.getValue()] = "Enterprise Project Duration10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE1.getValue()] = "Enterprise Project Outline Code1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE2.getValue()] = "Enterprise Project Outline Code2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE3.getValue()] = "Enterprise Project Outline Code3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE4.getValue()] = "Enterprise Project Outline Code4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE5.getValue()] = "Enterprise Project Outline Code5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE6.getValue()] = "Enterprise Project Outline Code6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE7.getValue()] = "Enterprise Project Outline Code7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE8.getValue()] = "Enterprise Project Outline Code8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE9.getValue()] = "Enterprise Project Outline Code9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE10.getValue()] = "Enterprise Project Outline Code10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE11.getValue()] = "Enterprise Project Outline Code11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE12.getValue()] = "Enterprise Project Outline Code12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE13.getValue()] = "Enterprise Project Outline Code13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE14.getValue()] = "Enterprise Project Outline Code14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE15.getValue()] = "Enterprise Project Outline Code15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE16.getValue()] = "Enterprise Project Outline Code16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE17.getValue()] = "Enterprise Project Outline Code17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE18.getValue()] = "Enterprise Project Outline Code18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE19.getValue()] = "Enterprise Project Outline Code19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE20.getValue()] = "Enterprise Project Outline Code20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE21.getValue()] = "Enterprise Project Outline Code21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE22.getValue()] = "Enterprise Project Outline Code22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE23.getValue()] = "Enterprise Project Outline Code23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE24.getValue()] = "Enterprise Project Outline Code24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE25.getValue()] = "Enterprise Project Outline Code25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE26.getValue()] = "Enterprise Project Outline Code26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE27.getValue()] = "Enterprise Project Outline Code27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE28.getValue()] = "Enterprise Project Outline Code28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE29.getValue()] = "Enterprise Project Outline Code29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_OUTLINE_CODE30.getValue()] = "Enterprise Project Outline Code30";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG1.getValue()] = "Enterprise Project Flag1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG2.getValue()] = "Enterprise Project Flag2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG3.getValue()] = "Enterprise Project Flag3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG4.getValue()] = "Enterprise Project Flag4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG5.getValue()] = "Enterprise Project Flag5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG6.getValue()] = "Enterprise Project Flag6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG7.getValue()] = "Enterprise Project Flag7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG8.getValue()] = "Enterprise Project Flag8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG9.getValue()] = "Enterprise Project Flag9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG10.getValue()] = "Enterprise Project Flag10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG11.getValue()] = "Enterprise Project Flag11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG12.getValue()] = "Enterprise Project Flag12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG13.getValue()] = "Enterprise Project Flag13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG14.getValue()] = "Enterprise Project Flag14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG15.getValue()] = "Enterprise Project Flag15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG16.getValue()] = "Enterprise Project Flag16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG17.getValue()] = "Enterprise Project Flag17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG18.getValue()] = "Enterprise Project Flag18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG19.getValue()] = "Enterprise Project Flag19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_FLAG20.getValue()] = "Enterprise Project Flag20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER1.getValue()] = "Enterprise Project Number1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER2.getValue()] = "Enterprise Project Number2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER3.getValue()] = "Enterprise Project Number3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER4.getValue()] = "Enterprise Project Number4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER5.getValue()] = "Enterprise Project Number5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER6.getValue()] = "Enterprise Project Number6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER7.getValue()] = "Enterprise Project Number7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER8.getValue()] = "Enterprise Project Number8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER9.getValue()] = "Enterprise Project Number9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER10.getValue()] = "Enterprise Project Number10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER11.getValue()] = "Enterprise Project Number11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER12.getValue()] = "Enterprise Project Number12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER13.getValue()] = "Enterprise Project Number13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER14.getValue()] = "Enterprise Project Number14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER15.getValue()] = "Enterprise Project Number15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER16.getValue()] = "Enterprise Project Number16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER17.getValue()] = "Enterprise Project Number17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER18.getValue()] = "Enterprise Project Number18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER19.getValue()] = "Enterprise Project Number19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER20.getValue()] = "Enterprise Project Number20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER21.getValue()] = "Enterprise Project Number21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER22.getValue()] = "Enterprise Project Number22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER23.getValue()] = "Enterprise Project Number23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER24.getValue()] = "Enterprise Project Number24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER25.getValue()] = "Enterprise Project Number25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER26.getValue()] = "Enterprise Project Number26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER27.getValue()] = "Enterprise Project Number27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER28.getValue()] = "Enterprise Project Number28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER29.getValue()] = "Enterprise Project Number29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER30.getValue()] = "Enterprise Project Number30";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER31.getValue()] = "Enterprise Project Number31";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER32.getValue()] = "Enterprise Project Number32";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER33.getValue()] = "Enterprise Project Number33";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER34.getValue()] = "Enterprise Project Number34";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER35.getValue()] = "Enterprise Project Number35";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER36.getValue()] = "Enterprise Project Number36";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER37.getValue()] = "Enterprise Project Number37";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER38.getValue()] = "Enterprise Project Number38";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER39.getValue()] = "Enterprise Project Number39";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_NUMBER40.getValue()] = "Enterprise Project Number40";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT1.getValue()] = "Enterprise Project Text1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT2.getValue()] = "Enterprise Project Text2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT3.getValue()] = "Enterprise Project Text3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT4.getValue()] = "Enterprise Project Text4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT5.getValue()] = "Enterprise Project Text5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT6.getValue()] = "Enterprise Project Text6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT7.getValue()] = "Enterprise Project Text7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT8.getValue()] = "Enterprise Project Text8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT9.getValue()] = "Enterprise Project Text9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT10.getValue()] = "Enterprise Project Text10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT11.getValue()] = "Enterprise Project Text11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT12.getValue()] = "Enterprise Project Text12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT13.getValue()] = "Enterprise Project Text13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT14.getValue()] = "Enterprise Project Text14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT15.getValue()] = "Enterprise Project Text15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT16.getValue()] = "Enterprise Project Text16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT17.getValue()] = "Enterprise Project Text17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT18.getValue()] = "Enterprise Project Text18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT19.getValue()] = "Enterprise Project Text19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT20.getValue()] = "Enterprise Project Text20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT21.getValue()] = "Enterprise Project Text21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT22.getValue()] = "Enterprise Project Text22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT23.getValue()] = "Enterprise Project Text23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT24.getValue()] = "Enterprise Project Text24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT25.getValue()] = "Enterprise Project Text25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT26.getValue()] = "Enterprise Project Text26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT27.getValue()] = "Enterprise Project Text27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT28.getValue()] = "Enterprise Project Text28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT29.getValue()] = "Enterprise Project Text29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT30.getValue()] = "Enterprise Project Text30";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT31.getValue()] = "Enterprise Project Text31";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT32.getValue()] = "Enterprise Project Text32";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT33.getValue()] = "Enterprise Project Text33";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT34.getValue()] = "Enterprise Project Text34";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT35.getValue()] = "Enterprise Project Text35";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT36.getValue()] = "Enterprise Project Text36";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT37.getValue()] = "Enterprise Project Text37";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT38.getValue()] = "Enterprise Project Text38";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT39.getValue()] = "Enterprise Project Text39";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_PROJECT_TEXT40.getValue()] = "Enterprise Project Text40";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE1.getValue()] = "Resource Enterprise Outline Code1";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE2.getValue()] = "Resource Enterprise Outline Code2";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE3.getValue()] = "Resource Enterprise Outline Code3";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE4.getValue()] = "Resource Enterprise Outline Code4";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE5.getValue()] = "Resource Enterprise Outline Code5";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE6.getValue()] = "Resource Enterprise Outline Code6";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE7.getValue()] = "Resource Enterprise Outline Code7";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE8.getValue()] = "Resource Enterprise Outline Code8";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE9.getValue()] = "Resource Enterprise Outline Code9";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE10.getValue()] = "Resource Enterprise Outline Code10";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE11.getValue()] = "Resource Enterprise Outline Code11";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE12.getValue()] = "Resource Enterprise Outline Code12";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE13.getValue()] = "Resource Enterprise Outline Code13";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE14.getValue()] = "Resource Enterprise Outline Code14";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE15.getValue()] = "Resource Enterprise Outline Code15";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE16.getValue()] = "Resource Enterprise Outline Code16";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE17.getValue()] = "Resource Enterprise Outline Code17";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE18.getValue()] = "Resource Enterprise Outline Code18";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE19.getValue()] = "Resource Enterprise Outline Code19";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE20.getValue()] = "Resource Enterprise Outline Code20";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE21.getValue()] = "Resource Enterprise Outline Code21";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE22.getValue()] = "Resource Enterprise Outline Code22";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE23.getValue()] = "Resource Enterprise Outline Code23";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE24.getValue()] = "Resource Enterprise Outline Code24";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE25.getValue()] = "Resource Enterprise Outline Code25";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE26.getValue()] = "Resource Enterprise Outline Code26";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE27.getValue()] = "Resource Enterprise Outline Code27";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE28.getValue()] = "Resource Enterprise Outline Code28";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_OUTLINE_CODE29.getValue()] = "Resource Enterprise Outline Code29";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_RBS.getValue()] = "Resource Enterprise Rbs";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE20.getValue()] = "Resource Enterprise Multi Value Code20";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE21.getValue()] = "Resource Enterprise Multi Value Code21";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE22.getValue()] = "Resource Enterprise Multi Value Code22";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE23.getValue()] = "Resource Enterprise Multi Value Code23";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE24.getValue()] = "Resource Enterprise Multi Value Code24";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE25.getValue()] = "Resource Enterprise Multi Value Code25";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE26.getValue()] = "Resource Enterprise Multi Value Code26";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE27.getValue()] = "Resource Enterprise Multi Value Code27";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE28.getValue()] = "Resource Enterprise Multi Value Code28";
      TASK_COLUMNS_ARRAY[TaskField.RESOURCE_ENTERPRISE_MULTI_VALUE_CODE29.getValue()] = "Resource Enterprise Multi Value Code29";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_WORK_PROTECTED.getValue()] = "Actual Work Protected";
      TASK_COLUMNS_ARRAY[TaskField.ACTUAL_OVERTIME_WORK_PROTECTED.getValue()] = "Actual Overtime Work Protected";
      TASK_COLUMNS_ARRAY[TaskField.BUDGET_WORK.getValue()] = "Budget Work";
      TASK_COLUMNS_ARRAY[TaskField.BUDGET_COST.getValue()] = "Budget Cost";
      TASK_COLUMNS_ARRAY[TaskField.RECALC_OUTLINE_CODES.getValue()] = "Recalc Outline Codes";

      TASK_COLUMNS_ARRAY[TaskField.IS_START_VALID.getValue()] = "Is Start Valid";
      TASK_COLUMNS_ARRAY[TaskField.IS_FINISH_VALID.getValue()] = "Is Finish Valid";
      TASK_COLUMNS_ARRAY[TaskField.IS_DURATION_VALID.getValue()] = "Is Duration Valid";
      TASK_COLUMNS_ARRAY[TaskField.START_TEXT.getValue()] = "Start";
      TASK_COLUMNS_ARRAY[TaskField.FINISH_TEXT.getValue()] = "Finish";
      TASK_COLUMNS_ARRAY[TaskField.DURATION_TEXT.getValue()] = "Duration";

      TASK_COLUMNS_ARRAY[TaskField.MANUAL_DURATION.getValue()] = "Manual Duration";
      TASK_COLUMNS_ARRAY[TaskField.MANUAL_DURATION_UNITS.getValue()] = "Manual Duration Units";

      TASK_COLUMNS_ARRAY[TaskField.PATH_DRIVEN_SUCCESSOR.getValue()] = "Path Driven Successor";
      TASK_COLUMNS_ARRAY[TaskField.PATH_DRIVING_PREDECESSOR.getValue()] = "Path Driving Predecessor";
      TASK_COLUMNS_ARRAY[TaskField.PATH_PREDECESSOR.getValue()] = "Path Predecessor";
      TASK_COLUMNS_ARRAY[TaskField.PATH_SUCCESSOR.getValue()] = "Path Successor";

      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD1.getValue()] = "Enterprise Custom Field 1";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD2.getValue()] = "Enterprise Custom Field 2";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD3.getValue()] = "Enterprise Custom Field 3";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD4.getValue()] = "Enterprise Custom Field 4";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD5.getValue()] = "Enterprise Custom Field 5";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD6.getValue()] = "Enterprise Custom Field 6";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD7.getValue()] = "Enterprise Custom Field 7";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD8.getValue()] = "Enterprise Custom Field 8";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD9.getValue()] = "Enterprise Custom Field 9";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD10.getValue()] = "Enterprise Custom Field 10";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD11.getValue()] = "Enterprise Custom Field 11";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD12.getValue()] = "Enterprise Custom Field 12";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD13.getValue()] = "Enterprise Custom Field 13";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD14.getValue()] = "Enterprise Custom Field 14";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD15.getValue()] = "Enterprise Custom Field 15";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD16.getValue()] = "Enterprise Custom Field 16";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD17.getValue()] = "Enterprise Custom Field 17";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD18.getValue()] = "Enterprise Custom Field 18";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD19.getValue()] = "Enterprise Custom Field 19";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD20.getValue()] = "Enterprise Custom Field 20";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD21.getValue()] = "Enterprise Custom Field 21";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD22.getValue()] = "Enterprise Custom Field 22";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD23.getValue()] = "Enterprise Custom Field 23";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD24.getValue()] = "Enterprise Custom Field 24";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD25.getValue()] = "Enterprise Custom Field 25";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD26.getValue()] = "Enterprise Custom Field 26";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD27.getValue()] = "Enterprise Custom Field 27";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD28.getValue()] = "Enterprise Custom Field 28";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD29.getValue()] = "Enterprise Custom Field 29";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD30.getValue()] = "Enterprise Custom Field 30";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD31.getValue()] = "Enterprise Custom Field 31";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD32.getValue()] = "Enterprise Custom Field 32";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD33.getValue()] = "Enterprise Custom Field 33";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD34.getValue()] = "Enterprise Custom Field 34";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD35.getValue()] = "Enterprise Custom Field 35";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD36.getValue()] = "Enterprise Custom Field 36";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD37.getValue()] = "Enterprise Custom Field 37";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD38.getValue()] = "Enterprise Custom Field 38";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD39.getValue()] = "Enterprise Custom Field 39";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD40.getValue()] = "Enterprise Custom Field 40";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD41.getValue()] = "Enterprise Custom Field 41";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD42.getValue()] = "Enterprise Custom Field 42";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD43.getValue()] = "Enterprise Custom Field 43";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD44.getValue()] = "Enterprise Custom Field 44";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD45.getValue()] = "Enterprise Custom Field 45";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD46.getValue()] = "Enterprise Custom Field 46";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD47.getValue()] = "Enterprise Custom Field 47";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD48.getValue()] = "Enterprise Custom Field 48";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD49.getValue()] = "Enterprise Custom Field 49";
      TASK_COLUMNS_ARRAY[TaskField.ENTERPRISE_CUSTOM_FIELD50.getValue()] = "Enterprise Custom Field 50";

      RESOURCE_COLUMNS_ARRAY[ResourceField.ID.getValue()] = "ID";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NAME.getValue()] = "Name";
      RESOURCE_COLUMNS_ARRAY[ResourceField.INITIALS.getValue()] = "Initials";
      RESOURCE_COLUMNS_ARRAY[ResourceField.GROUP.getValue()] = "Group";
      RESOURCE_COLUMNS_ARRAY[ResourceField.MAX_UNITS.getValue()] = "Max Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASE_CALENDAR.getValue()] = "Base Calendar";
      RESOURCE_COLUMNS_ARRAY[ResourceField.STANDARD_RATE.getValue()] = "Standard Rate";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OVERTIME_RATE.getValue()] = "Overtime Rate";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT1.getValue()] = "Text1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT2.getValue()] = "Text2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.CODE.getValue()] = "Code";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTUAL_COST.getValue()] = "Actual Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST.getValue()] = "Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.WORK.getValue()] = "Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTUAL_WORK.getValue()] = "Actual Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE_WORK.getValue()] = "Baseline Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OVERTIME_WORK.getValue()] = "Overtime Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE_COST.getValue()] = "Baseline Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_PER_USE.getValue()] = "Cost Per Use";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACCRUE_AT.getValue()] = "Accrue At";
      RESOURCE_COLUMNS_ARRAY[ResourceField.REMAINING_COST.getValue()] = "Remaining Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.REMAINING_WORK.getValue()] = "Remaining Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.WORK_VARIANCE.getValue()] = "Work Variance";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_VARIANCE.getValue()] = "Cost Variance";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OVERALLOCATED.getValue()] = "Overallocated";
      RESOURCE_COLUMNS_ARRAY[ResourceField.PEAK.getValue()] = "Peak";
      RESOURCE_COLUMNS_ARRAY[ResourceField.UNIQUE_ID.getValue()] = "Unique ID";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NOTES.getValue()] = "Notes";
      RESOURCE_COLUMNS_ARRAY[ResourceField.PERCENT_WORK_COMPLETE.getValue()] = "% Work Complete";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT3.getValue()] = "Text3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT4.getValue()] = "Text4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT5.getValue()] = "Text5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OBJECTS.getValue()] = "Objects";
      RESOURCE_COLUMNS_ARRAY[ResourceField.LINKED_FIELDS.getValue()] = "Linked Fields";
      RESOURCE_COLUMNS_ARRAY[ResourceField.EMAIL_ADDRESS.getValue()] = "Email Address";
      RESOURCE_COLUMNS_ARRAY[ResourceField.REGULAR_WORK.getValue()] = "Regular Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTUAL_OVERTIME_WORK.getValue()] = "Actual Overtime Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.REMAINING_OVERTIME_WORK.getValue()] = "Remaining Overtime Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OVERTIME_COST.getValue()] = "Overtime Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTUAL_OVERTIME_COST.getValue()] = "Actual Overtime Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.REMAINING_OVERTIME_COST.getValue()] = "Remaining Overtime Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BCWS.getValue()] = "BCWS";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BCWP.getValue()] = "BCWP";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACWP.getValue()] = "ACWP";
      RESOURCE_COLUMNS_ARRAY[ResourceField.SV.getValue()] = "SV";
      RESOURCE_COLUMNS_ARRAY[ResourceField.AVAILABLE_FROM.getValue()] = "Available From";
      RESOURCE_COLUMNS_ARRAY[ResourceField.AVAILABLE_TO.getValue()] = "Available To";
      RESOURCE_COLUMNS_ARRAY[ResourceField.INDICATORS.getValue()] = "Indicators";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT6.getValue()] = "Text6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT7.getValue()] = "Text7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT8.getValue()] = "Text8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT9.getValue()] = "Text9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT10.getValue()] = "Text10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START1.getValue()] = "Start1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START2.getValue()] = "Start2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START3.getValue()] = "Start3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START4.getValue()] = "Start4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START5.getValue()] = "Start5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH1.getValue()] = "Finish1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH2.getValue()] = "Finish2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH3.getValue()] = "Finish3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH4.getValue()] = "Finish4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH5.getValue()] = "Finish5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER1.getValue()] = "Number1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER2.getValue()] = "Number2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER3.getValue()] = "Number3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER4.getValue()] = "Number4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER5.getValue()] = "Number5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION1.getValue()] = "Duration1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION2.getValue()] = "Duration2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION3.getValue()] = "Duration3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST1.getValue()] = "Cost1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST2.getValue()] = "Cost2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST3.getValue()] = "Cost3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG10.getValue()] = "Flag10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG1.getValue()] = "Flag1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG2.getValue()] = "Flag2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG3.getValue()] = "Flag3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG4.getValue()] = "Flag4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG5.getValue()] = "Flag5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG6.getValue()] = "Flag6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG7.getValue()] = "Flag7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG8.getValue()] = "Flag8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG9.getValue()] = "Flag9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.HYPERLINK.getValue()] = "Hyperlink";
      RESOURCE_COLUMNS_ARRAY[ResourceField.HYPERLINK_ADDRESS.getValue()] = "Hyperlink Address";
      RESOURCE_COLUMNS_ARRAY[ResourceField.HYPERLINK_SUBADDRESS.getValue()] = "Hyperlink SubAddress";
      RESOURCE_COLUMNS_ARRAY[ResourceField.HYPERLINK_HREF.getValue()] = "Hyperlink Href";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ASSIGNMENT.getValue()] = "Assignment";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TASK_SUMMARY_NAME.getValue()] = "Task Summary Name";
      RESOURCE_COLUMNS_ARRAY[ResourceField.CAN_LEVEL.getValue()] = "Can Level";
      RESOURCE_COLUMNS_ARRAY[ResourceField.WORK_CONTOUR.getValue()] = "Work Contour";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST4.getValue()] = "Cost4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST5.getValue()] = "Cost5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST6.getValue()] = "Cost6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST7.getValue()] = "Cost7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST8.getValue()] = "Cost8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST9.getValue()] = "Cost9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST10.getValue()] = "Cost10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE1.getValue()] = "Date1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE2.getValue()] = "Date2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE3.getValue()] = "Date3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE4.getValue()] = "Date4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE5.getValue()] = "Date5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE6.getValue()] = "Date6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE7.getValue()] = "Date7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE8.getValue()] = "Date8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE9.getValue()] = "Date9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DATE10.getValue()] = "Date10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION4.getValue()] = "Duration4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION5.getValue()] = "Duration5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION6.getValue()] = "Duration6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION7.getValue()] = "Duration7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION8.getValue()] = "Duration8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION9.getValue()] = "Duration9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION10.getValue()] = "Duration10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH6.getValue()] = "Finish6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH7.getValue()] = "Finish7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH8.getValue()] = "Finish8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH9.getValue()] = "Finish9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH10.getValue()] = "Finish10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG11.getValue()] = "Flag11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG12.getValue()] = "Flag12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG13.getValue()] = "Flag13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG14.getValue()] = "Flag14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG15.getValue()] = "Flag15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG16.getValue()] = "Flag16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG17.getValue()] = "Flag17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG18.getValue()] = "Flag18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG19.getValue()] = "Flag19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FLAG20.getValue()] = "Flag20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER6.getValue()] = "Number6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER7.getValue()] = "Number7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER8.getValue()] = "Number8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER9.getValue()] = "Number9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER10.getValue()] = "Number10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER11.getValue()] = "Number11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER12.getValue()] = "Number12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER13.getValue()] = "Number13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER14.getValue()] = "Number14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER15.getValue()] = "Number15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER16.getValue()] = "Number16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER17.getValue()] = "Number17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER18.getValue()] = "Number18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER19.getValue()] = "Number19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.NUMBER20.getValue()] = "Number20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START6.getValue()] = "Start6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START7.getValue()] = "Start7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START8.getValue()] = "Start8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START9.getValue()] = "Start9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START10.getValue()] = "Start10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT11.getValue()] = "Text11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT12.getValue()] = "Text12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT13.getValue()] = "Text13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT14.getValue()] = "Text14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT15.getValue()] = "Text15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT16.getValue()] = "Text16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT17.getValue()] = "Text17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT18.getValue()] = "Text18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT19.getValue()] = "Text19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT20.getValue()] = "Text20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT21.getValue()] = "Text21";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT22.getValue()] = "Text22";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT23.getValue()] = "Text23";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT24.getValue()] = "Text24";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT25.getValue()] = "Text25";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT26.getValue()] = "Text26";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT27.getValue()] = "Text27";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT28.getValue()] = "Text28";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT29.getValue()] = "Text29";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEXT30.getValue()] = "Text30";
      RESOURCE_COLUMNS_ARRAY[ResourceField.PHONETICS.getValue()] = "Phonetics";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ASSIGNMENT_DELAY.getValue()] = "Assignment Delay";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ASSIGNMENT_UNITS.getValue()] = "Assignment Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE_START.getValue()] = "Baseline Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE_FINISH.getValue()] = "Baseline Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.CONFIRMED.getValue()] = "Confirmed";
      RESOURCE_COLUMNS_ARRAY[ResourceField.FINISH.getValue()] = "Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.LEVELING_DELAY.getValue()] = "Leveling Delay";
      RESOURCE_COLUMNS_ARRAY[ResourceField.RESPONSE_PENDING.getValue()] = "Response Pending";
      RESOURCE_COLUMNS_ARRAY[ResourceField.START.getValue()] = "Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEAMSTATUS_PENDING.getValue()] = "TeamStatus Pending";
      RESOURCE_COLUMNS_ARRAY[ResourceField.CV.getValue()] = "CV";
      RESOURCE_COLUMNS_ARRAY[ResourceField.UPDATE_NEEDED.getValue()] = "Update Needed";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_RATE_TABLE.getValue()] = "Cost Rate Table";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTUAL_START.getValue()] = "Actual Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTUAL_FINISH.getValue()] = "Actual Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.WORKGROUP.getValue()] = "Workgroup";
      RESOURCE_COLUMNS_ARRAY[ResourceField.PROJECT.getValue()] = "Project";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE1.getValue()] = "Outline Code1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE2.getValue()] = "Outline Code2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE3.getValue()] = "Outline Code3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE4.getValue()] = "Outline Code4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE5.getValue()] = "Outline Code5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE6.getValue()] = "Outline Code6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE7.getValue()] = "Outline Code7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE8.getValue()] = "Outline Code8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE9.getValue()] = "Outline Code9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE10.getValue()] = "Outline Code10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.MATERIAL_LABEL.getValue()] = "Material Label";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TYPE.getValue()] = "Type";
      RESOURCE_COLUMNS_ARRAY[ResourceField.VAC.getValue()] = "VAC";
      RESOURCE_COLUMNS_ARRAY[ResourceField.GROUP_BY_SUMMARY.getValue()] = "Group By Summary";
      RESOURCE_COLUMNS_ARRAY[ResourceField.WINDOWS_USER_ACCOUNT.getValue()] = "Windows User Account";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE1_WORK.getValue()] = "Baseline1 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE1_COST.getValue()] = "Baseline1 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE2_WORK.getValue()] = "Baseline2 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE2_COST.getValue()] = "Baseline2 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE3_WORK.getValue()] = "Baseline3 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE3_COST.getValue()] = "Baseline3 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE4_WORK.getValue()] = "Baseline4 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE4_COST.getValue()] = "Baseline4 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE5_WORK.getValue()] = "Baseline5 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE5_COST.getValue()] = "Baseline5 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE6_WORK.getValue()] = "Baseline6 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE6_COST.getValue()] = "Baseline6 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE7_WORK.getValue()] = "Baseline7 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE7_COST.getValue()] = "Baseline7 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE8_WORK.getValue()] = "Baseline8 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE8_COST.getValue()] = "Baseline8 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE9_WORK.getValue()] = "Baseline9 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE9_COST.getValue()] = "Baseline9 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE10_WORK.getValue()] = "Baseline10 Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE10_COST.getValue()] = "Baseline10 Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST1.getValue()] = "Enterprise Cost1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST2.getValue()] = "Enterprise Cost2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST3.getValue()] = "Enterprise Cost3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST4.getValue()] = "Enterprise Cost4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST5.getValue()] = "Enterprise Cost5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST6.getValue()] = "Enterprise Cost6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST7.getValue()] = "Enterprise Cost7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST8.getValue()] = "Enterprise Cost8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST9.getValue()] = "Enterprise Cost9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_COST10.getValue()] = "Enterprise Cost10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE1.getValue()] = "Enterprise Date1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE2.getValue()] = "Enterprise Date2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE3.getValue()] = "Enterprise Date3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE4.getValue()] = "Enterprise Date4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE5.getValue()] = "Enterprise Date5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE6.getValue()] = "Enterprise Date6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE7.getValue()] = "Enterprise Date7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE8.getValue()] = "Enterprise Date8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE9.getValue()] = "Enterprise Date9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE10.getValue()] = "Enterprise Date10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE11.getValue()] = "Enterprise Date11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE12.getValue()] = "Enterprise Date12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE13.getValue()] = "Enterprise Date13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE14.getValue()] = "Enterprise Date14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE15.getValue()] = "Enterprise Date15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE16.getValue()] = "Enterprise Date16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE17.getValue()] = "Enterprise Date17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE18.getValue()] = "Enterprise Date18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE19.getValue()] = "Enterprise Date19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE20.getValue()] = "Enterprise Date20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE21.getValue()] = "Enterprise Date21";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE22.getValue()] = "Enterprise Date22";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE23.getValue()] = "Enterprise Date23";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE24.getValue()] = "Enterprise Date24";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE25.getValue()] = "Enterprise Date25";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE26.getValue()] = "Enterprise Date26";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE27.getValue()] = "Enterprise Date27";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE28.getValue()] = "Enterprise Date28";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE29.getValue()] = "Enterprise Date29";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATE30.getValue()] = "Enterprise Date30";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION1.getValue()] = "Enterprise Duration1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION2.getValue()] = "Enterprise Duration2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION3.getValue()] = "Enterprise Duration3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION4.getValue()] = "Enterprise Duration4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION5.getValue()] = "Enterprise Duration5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION6.getValue()] = "Enterprise Duration6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION7.getValue()] = "Enterprise Duration7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION8.getValue()] = "Enterprise Duration8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION9.getValue()] = "Enterprise Duration9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION10.getValue()] = "Enterprise Duration10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG1.getValue()] = "Enterprise Flag1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG2.getValue()] = "Enterprise Flag2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG3.getValue()] = "Enterprise Flag3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG4.getValue()] = "Enterprise Flag4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG5.getValue()] = "Enterprise Flag5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG6.getValue()] = "Enterprise Flag6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG7.getValue()] = "Enterprise Flag7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG8.getValue()] = "Enterprise Flag8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG9.getValue()] = "Enterprise Flag9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG10.getValue()] = "Enterprise Flag10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG11.getValue()] = "Enterprise Flag11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG12.getValue()] = "Enterprise Flag12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG13.getValue()] = "Enterprise Flag13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG14.getValue()] = "Enterprise Flag14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG15.getValue()] = "Enterprise Flag15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG16.getValue()] = "Enterprise Flag16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG17.getValue()] = "Enterprise Flag17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG18.getValue()] = "Enterprise Flag18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG19.getValue()] = "Enterprise Flag19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_FLAG20.getValue()] = "Enterprise Flag20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER1.getValue()] = "Enterprise Number1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER2.getValue()] = "Enterprise Number2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER3.getValue()] = "Enterprise Number3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER4.getValue()] = "Enterprise Number4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER5.getValue()] = "Enterprise Number5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER6.getValue()] = "Enterprise Number6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER7.getValue()] = "Enterprise Number7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER8.getValue()] = "Enterprise Number8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER9.getValue()] = "Enterprise Number9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER10.getValue()] = "Enterprise Number10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER11.getValue()] = "Enterprise Number11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER12.getValue()] = "Enterprise Number12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER13.getValue()] = "Enterprise Number13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER14.getValue()] = "Enterprise Number14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER15.getValue()] = "Enterprise Number15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER16.getValue()] = "Enterprise Number16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER17.getValue()] = "Enterprise Number17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER18.getValue()] = "Enterprise Number18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER19.getValue()] = "Enterprise Number19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER20.getValue()] = "Enterprise Number20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER21.getValue()] = "Enterprise Number21";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER22.getValue()] = "Enterprise Number22";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER23.getValue()] = "Enterprise Number23";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER24.getValue()] = "Enterprise Number24";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER25.getValue()] = "Enterprise Number25";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER26.getValue()] = "Enterprise Number26";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER27.getValue()] = "Enterprise Number27";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER28.getValue()] = "Enterprise Number28";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER29.getValue()] = "Enterprise Number29";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER30.getValue()] = "Enterprise Number30";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER31.getValue()] = "Enterprise Number31";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER32.getValue()] = "Enterprise Number32";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER33.getValue()] = "Enterprise Number33";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER34.getValue()] = "Enterprise Number34";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER35.getValue()] = "Enterprise Number35";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER36.getValue()] = "Enterprise Number36";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER37.getValue()] = "Enterprise Number37";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER38.getValue()] = "Enterprise Number38";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER39.getValue()] = "Enterprise Number39";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NUMBER40.getValue()] = "Enterprise Number40";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT1.getValue()] = "Enterprise Text1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT2.getValue()] = "Enterprise Text2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT3.getValue()] = "Enterprise Text3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT4.getValue()] = "Enterprise Text4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT5.getValue()] = "Enterprise Text5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT6.getValue()] = "Enterprise Text6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT7.getValue()] = "Enterprise Text7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT8.getValue()] = "Enterprise Text8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT9.getValue()] = "Enterprise Text9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT10.getValue()] = "Enterprise Text10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT11.getValue()] = "Enterprise Text11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT12.getValue()] = "Enterprise Text12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT13.getValue()] = "Enterprise Text13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT14.getValue()] = "Enterprise Text14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT15.getValue()] = "Enterprise Text15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT16.getValue()] = "Enterprise Text16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT17.getValue()] = "Enterprise Text17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT18.getValue()] = "Enterprise Text18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT19.getValue()] = "Enterprise Text19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT20.getValue()] = "Enterprise Text20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT21.getValue()] = "Enterprise Text21";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT22.getValue()] = "Enterprise Text22";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT23.getValue()] = "Enterprise Text23";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT24.getValue()] = "Enterprise Text24";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT25.getValue()] = "Enterprise Text25";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT26.getValue()] = "Enterprise Text26";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT27.getValue()] = "Enterprise Text27";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT28.getValue()] = "Enterprise Text28";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT29.getValue()] = "Enterprise Text29";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT30.getValue()] = "Enterprise Text30";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT31.getValue()] = "Enterprise Text31";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT32.getValue()] = "Enterprise Text32";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT33.getValue()] = "Enterprise Text33";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT34.getValue()] = "Enterprise Text34";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT35.getValue()] = "Enterprise Text35";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT36.getValue()] = "Enterprise Text36";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT37.getValue()] = "Enterprise Text37";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT38.getValue()] = "Enterprise Text38";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT39.getValue()] = "Enterprise Text39";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEXT40.getValue()] = "Enterprise Text40";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE.getValue()] = "Enterprise";
      RESOURCE_COLUMNS_ARRAY[ResourceField.IMPORT.getValue()] = "Import";
      RESOURCE_COLUMNS_ARRAY[ResourceField.CREATED.getValue()] = "Created";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BUDGET.getValue()] = "Budget";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TASK_OUTLINE_NUMBER.getValue()] = "Task Outline Number";
      RESOURCE_COLUMNS_ARRAY[ResourceField.GUID.getValue()] = "GUID";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTIVE.getValue()] = "Active";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ASSIGNMENT_OWNER.getValue()] = "Assignment Owner";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE_BUDGET_COST.getValue()] = "Baseline Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE_BUDGET_WORK.getValue()] = "Baseline Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE1_BUDGET_COST.getValue()] = "Baseline1 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE1_BUDGET_WORK.getValue()] = "Baseline1 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE1_FINISH.getValue()] = "Baseline1 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE1_START.getValue()] = "Baseline1 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE2_BUDGET_COST.getValue()] = "Baseline2 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE2_BUDGET_WORK.getValue()] = "Baseline2 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE2_FINISH.getValue()] = "Baseline2 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE2_START.getValue()] = "Baseline2 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE3_BUDGET_COST.getValue()] = "Baseline3 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE3_BUDGET_WORK.getValue()] = "Baseline3 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE3_FINISH.getValue()] = "Baseline3 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE3_START.getValue()] = "Baseline3 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE4_BUDGET_COST.getValue()] = "Baseline4 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE4_BUDGET_WORK.getValue()] = "Baseline4 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE4_FINISH.getValue()] = "Baseline4 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE4_START.getValue()] = "Baseline4 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE5_BUDGET_COST.getValue()] = "Baseline5 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE5_BUDGET_WORK.getValue()] = "Baseline5 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE5_FINISH.getValue()] = "Baseline5 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE5_START.getValue()] = "Baseline5 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE6_BUDGET_COST.getValue()] = "Baseline6 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE6_BUDGET_WORK.getValue()] = "Baseline6 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE6_FINISH.getValue()] = "Baseline6 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE6_START.getValue()] = "Baseline6 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE7_BUDGET_COST.getValue()] = "Baseline7 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE7_BUDGET_WORK.getValue()] = "Baseline7 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE7_FINISH.getValue()] = "Baseline7 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE7_START.getValue()] = "Baseline7 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE8_BUDGET_COST.getValue()] = "Baseline8 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE8_BUDGET_WORK.getValue()] = "Baseline8 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE8_FINISH.getValue()] = "Baseline8 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE8_START.getValue()] = "Baseline8 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE9_BUDGET_COST.getValue()] = "Baseline9 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE9_BUDGET_WORK.getValue()] = "Baseline9 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE9_FINISH.getValue()] = "Baseline9 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE9_START.getValue()] = "Baseline9 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE10_BUDGET_COST.getValue()] = "Baseline10 Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE10_BUDGET_WORK.getValue()] = "Baseline10 Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE10_FINISH.getValue()] = "Baseline10 Finish";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BASELINE10_START.getValue()] = "Baseline10 Start";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BOOKING_TYPE.getValue()] = "Booking Type";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BUDGET_COST.getValue()] = "Budget Cost";
      RESOURCE_COLUMNS_ARRAY[ResourceField.BUDGET_WORK.getValue()] = "Budget Work";
      RESOURCE_COLUMNS_ARRAY[ResourceField.CALENDAR_GUID.getValue()] = "Calendar GUID";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_CENTER.getValue()] = "Cost Center";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DEFAULT_ASSIGNMENT_OWNER.getValue()] = "Default Assignment Owner";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_BASE_CALENDAR.getValue()] = "Enterprise Base Calendar";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_REQUIRED_VALUES.getValue()] = "Enterprise Required Values";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_TEAM_MEMBER.getValue()] = "Enterprise Team Member";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_UNIQUE_ID.getValue()] = "Enterprise Unique ID";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ERROR_MESSAGE.getValue()] = "Error Message";
      RESOURCE_COLUMNS_ARRAY[ResourceField.GENERIC.getValue()] = "Generic";
      RESOURCE_COLUMNS_ARRAY[ResourceField.INACTIVE.getValue()] = "Inactive";
      RESOURCE_COLUMNS_ARRAY[ResourceField.REQUEST_DEMAND.getValue()] = "Request/Demand";
      RESOURCE_COLUMNS_ARRAY[ResourceField.SUMMARY.getValue()] = "Summary";
      RESOURCE_COLUMNS_ARRAY[ResourceField.TEAM_ASSIGNMENT_POOL.getValue()] = "Team Assignment Pool";
      RESOURCE_COLUMNS_ARRAY[ResourceField.WBS.getValue()] = "WBS";
      RESOURCE_COLUMNS_ARRAY[ResourceField.UNAVAILABLE.getValue()] = "<Unavailable>";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION1_UNITS.getValue()] = "Duration1 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION2_UNITS.getValue()] = "Duration2 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION3_UNITS.getValue()] = "Duration3 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION4_UNITS.getValue()] = "Duration4 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION5_UNITS.getValue()] = "Duration5 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION6_UNITS.getValue()] = "Duration6 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION7_UNITS.getValue()] = "Duration7 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION8_UNITS.getValue()] = "Duration8 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION9_UNITS.getValue()] = "Duration9 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.DURATION10_UNITS.getValue()] = "Duration10 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID.getValue()] = "Subproject Unique Resource ID";
      RESOURCE_COLUMNS_ARRAY[ResourceField.HYPERLINK_DATA.getValue()] = "Hyperlink Data";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE1_INDEX.getValue()] = "Outline Code1 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE2_INDEX.getValue()] = "Outline Code2 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE3_INDEX.getValue()] = "Outline Code3 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE4_INDEX.getValue()] = "Outline Code4 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE5_INDEX.getValue()] = "Outline Code5 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE6_INDEX.getValue()] = "Outline Code6 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE7_INDEX.getValue()] = "Outline Code7 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE8_INDEX.getValue()] = "Outline Code8 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE9_INDEX.getValue()] = "Outline Code9 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OUTLINE_CODE10_INDEX.getValue()] = "Outline Code10 Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_RATE_A.getValue()] = "Cost Rate A";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_RATE_B.getValue()] = "Cost Rate B";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_RATE_C.getValue()] = "Cost Rate C";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_RATE_D.getValue()] = "Cost Rate D";
      RESOURCE_COLUMNS_ARRAY[ResourceField.COST_RATE_E.getValue()] = "Cost Rate E";
      RESOURCE_COLUMNS_ARRAY[ResourceField.AVAILABILITY_DATA.getValue()] = "Availability Data";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DATA.getValue()] = "Enterprise Data";
      RESOURCE_COLUMNS_ARRAY[ResourceField.STANDARD_RATE_UNITS.getValue()] = "Standard Rate Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.OVERTIME_RATE_UNITS.getValue()] = "Overtime Rate Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION1_UNITS.getValue()] = "Enterprise Duration1 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION2_UNITS.getValue()] = "Enterprise Duration2 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION3_UNITS.getValue()] = "Enterprise Duration3 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION4_UNITS.getValue()] = "Enterprise Duration4 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION5_UNITS.getValue()] = "Enterprise Duration5 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION6_UNITS.getValue()] = "Enterprise Duration6 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION7_UNITS.getValue()] = "Enterprise Duration7 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION8_UNITS.getValue()] = "Enterprise Duration8 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION9_UNITS.getValue()] = "Enterprise Duration9 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_DURATION10_UNITS.getValue()] = "Enterprise Duration10 Units";
      RESOURCE_COLUMNS_ARRAY[ResourceField.INDEX.getValue()] = "Index";
      RESOURCE_COLUMNS_ARRAY[ResourceField.HYPERLINK_SCREEN_TIP.getValue()] = "Hyperlink Screen Tip";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE1.getValue()] = "Enterprise Outline Code1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE2.getValue()] = "Enterprise Outline Code2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE3.getValue()] = "Enterprise Outline Code3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE4.getValue()] = "Enterprise Outline Code4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE5.getValue()] = "Enterprise Outline Code5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE6.getValue()] = "Enterprise Outline Code6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE7.getValue()] = "Enterprise Outline Code7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE8.getValue()] = "Enterprise Outline Code8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE9.getValue()] = "Enterprise Outline Code9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE10.getValue()] = "Enterprise Outline Code10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE11.getValue()] = "Enterprise Outline Code11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE12.getValue()] = "Enterprise Outline Code12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE13.getValue()] = "Enterprise Outline Code13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE14.getValue()] = "Enterprise Outline Code14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE15.getValue()] = "Enterprise Outline Code15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE16.getValue()] = "Enterprise Outline Code16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE17.getValue()] = "Enterprise Outline Code17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE18.getValue()] = "Enterprise Outline Code18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE19.getValue()] = "Enterprise Outline Code19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE20.getValue()] = "Enterprise Outline Code20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE21.getValue()] = "Enterprise Outline Code21";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE22.getValue()] = "Enterprise Outline Code22";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE23.getValue()] = "Enterprise Outline Code23";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE24.getValue()] = "Enterprise Outline Code24";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE25.getValue()] = "Enterprise Outline Code25";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE26.getValue()] = "Enterprise Outline Code26";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE27.getValue()] = "Enterprise Outline Code27";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE28.getValue()] = "Enterprise Outline Code28";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_OUTLINE_CODE29.getValue()] = "Enterprise Outline Code29";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_RBS.getValue()] = "Enterprise RBS";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_NAME_USED.getValue()] = "Enterprise Name Used";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_IS_CHECKED_OUT.getValue()] = "Enterprise Is Checked Out";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CHECKED_OUT_BY.getValue()] = "Enterprise Checked Out By";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_LAST_MODIFIED_DATE.getValue()] = "Enterprise Last Modified Date";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE20.getValue()] = "Enterprise Multi Value20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE21.getValue()] = "Enterprise Multi Value21";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE22.getValue()] = "Enterprise Multi Value22";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE23.getValue()] = "Enterprise Multi Value23";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE24.getValue()] = "Enterprise Multi Value24";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE25.getValue()] = "Enterprise Multi Value25";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE26.getValue()] = "Enterprise Multi Value26";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE27.getValue()] = "Enterprise Multi Value27";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE28.getValue()] = "Enterprise Multi Value28";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_MULTI_VALUE29.getValue()] = "Enterprise Multi Value29";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTUAL_WORK_PROTECTED.getValue()] = "Actual Work Protected";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ACTUAL_OVERTIME_WORK_PROTECTED.getValue()] = "Actual Overtime Work Protected";

      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD1.getValue()] = "Enterprise Custom Field 1";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD2.getValue()] = "Enterprise Custom Field 2";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD3.getValue()] = "Enterprise Custom Field 3";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD4.getValue()] = "Enterprise Custom Field 4";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD5.getValue()] = "Enterprise Custom Field 5";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD6.getValue()] = "Enterprise Custom Field 6";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD7.getValue()] = "Enterprise Custom Field 7";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD8.getValue()] = "Enterprise Custom Field 8";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD9.getValue()] = "Enterprise Custom Field 9";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD10.getValue()] = "Enterprise Custom Field 10";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD11.getValue()] = "Enterprise Custom Field 11";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD12.getValue()] = "Enterprise Custom Field 12";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD13.getValue()] = "Enterprise Custom Field 13";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD14.getValue()] = "Enterprise Custom Field 14";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD15.getValue()] = "Enterprise Custom Field 15";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD16.getValue()] = "Enterprise Custom Field 16";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD17.getValue()] = "Enterprise Custom Field 17";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD18.getValue()] = "Enterprise Custom Field 18";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD19.getValue()] = "Enterprise Custom Field 19";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD20.getValue()] = "Enterprise Custom Field 20";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD21.getValue()] = "Enterprise Custom Field 21";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD22.getValue()] = "Enterprise Custom Field 22";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD23.getValue()] = "Enterprise Custom Field 23";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD24.getValue()] = "Enterprise Custom Field 24";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD25.getValue()] = "Enterprise Custom Field 25";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD26.getValue()] = "Enterprise Custom Field 26";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD27.getValue()] = "Enterprise Custom Field 27";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD28.getValue()] = "Enterprise Custom Field 28";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD29.getValue()] = "Enterprise Custom Field 29";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD30.getValue()] = "Enterprise Custom Field 30";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD31.getValue()] = "Enterprise Custom Field 31";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD32.getValue()] = "Enterprise Custom Field 32";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD33.getValue()] = "Enterprise Custom Field 33";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD34.getValue()] = "Enterprise Custom Field 34";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD35.getValue()] = "Enterprise Custom Field 35";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD36.getValue()] = "Enterprise Custom Field 36";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD37.getValue()] = "Enterprise Custom Field 37";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD38.getValue()] = "Enterprise Custom Field 38";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD39.getValue()] = "Enterprise Custom Field 39";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD40.getValue()] = "Enterprise Custom Field 40";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD41.getValue()] = "Enterprise Custom Field 41";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD42.getValue()] = "Enterprise Custom Field 42";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD43.getValue()] = "Enterprise Custom Field 43";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD44.getValue()] = "Enterprise Custom Field 44";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD45.getValue()] = "Enterprise Custom Field 45";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD46.getValue()] = "Enterprise Custom Field 46";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD47.getValue()] = "Enterprise Custom Field 47";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD48.getValue()] = "Enterprise Custom Field 48";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD49.getValue()] = "Enterprise Custom Field 49";
      RESOURCE_COLUMNS_ARRAY[ResourceField.ENTERPRISE_CUSTOM_FIELD50.getValue()] = "Enterprise Custom Field 50";

      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START.getValue()] = "Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ASSIGNMENT_UNITS.getValue()] = "Assignment Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.WORK.getValue()] = "Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE_START.getValue()] = "Baseline Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACTUAL_START.getValue()] = "Actual Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE_FINISH.getValue()] = "Baseline Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACTUAL_FINISH.getValue()] = "Actual Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE_WORK.getValue()] = "Baseline Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACTUAL_WORK.getValue()] = "Actual Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.OVERTIME_WORK.getValue()] = "Overtime Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST.getValue()] = "Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE_COST.getValue()] = "Baseline Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACTUAL_COST.getValue()] = "Actual Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ASSIGNMENT_DELAY.getValue()] = "Assignment Delay";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.WORK_CONTOUR.getValue()] = "Work Contour";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.REMAINING_WORK.getValue()] = "Remaining Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.LEVELING_DELAY.getValue()] = "Leveling Delay";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH.getValue()] = "Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.UNIQUE_ID.getValue()] = "Unique ID";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TASK_UNIQUE_ID.getValue()] = "Task Unique ID";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.RESOURCE_UNIQUE_ID.getValue()] = "Resource Unique ID";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_WORK.getValue()] = "Timephased Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_ACTUAL_WORK.getValue()] = "Timephased Actual Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_ACTUAL_OVERTIME_WORK.getValue()] = "Timephased Actual Overtime Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE_WORK.getValue()] = "Timephased Baseline Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE1_WORK.getValue()] = "Timephased Baseline1 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE2_WORK.getValue()] = "Timephased Baseline2 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE3_WORK.getValue()] = "Timephased Baseline3 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE4_WORK.getValue()] = "Timephased Baseline4 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE5_WORK.getValue()] = "Timephased Baseline5 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE6_WORK.getValue()] = "Timephased Baseline6 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE7_WORK.getValue()] = "Timephased Baseline7 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE8_WORK.getValue()] = "Timephased Baseline8 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE9_WORK.getValue()] = "Timephased Baseline9 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE10_WORK.getValue()] = "Timephased Baseline10 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE_COST.getValue()] = "Timephased Baseline Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE1_COST.getValue()] = "Timephased Baseline1 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE2_COST.getValue()] = "Timephased Baseline2 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE3_COST.getValue()] = "Timephased Baseline3 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE4_COST.getValue()] = "Timephased Baseline4 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE5_COST.getValue()] = "Timephased Baseline5 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE6_COST.getValue()] = "Timephased Baseline6 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE7_COST.getValue()] = "Timephased Baseline7 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE8_COST.getValue()] = "Timephased Baseline8 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE9_COST.getValue()] = "Timephased Baseline9 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TIMEPHASED_BASELINE10_COST.getValue()] = "Timephased Baseline10 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.VARIABLE_RATE_UNITS.getValue()] = "Variable Rate Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.LEVELING_DELAY_UNITS.getValue()] = "Leveling Delay Units";

      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TASK_ID.getValue()] = "Task ID";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.RESOURCE_ID.getValue()] = "Resource ID";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TASK_NAME.getValue()] = "Task Name";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.RESOURCE_NAME.getValue()] = "Resource Name";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.REGULAR_WORK.getValue()] = "Regular Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACTUAL_OVERTIME_WORK.getValue()] = "Actual Overtime Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.REMAINING_OVERTIME_WORK.getValue()] = "Remaining Overtime Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.PEAK.getValue()] = "Peak";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.OVERTIME_COST.getValue()] = "Overtime Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.REMAINING_COST.getValue()] = "Remaining Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACTUAL_OVERTIME_COST.getValue()] = "Actual Overtime Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.REMAINING_OVERTIME_COST.getValue()] = "Remaining Overtime Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BCWS.getValue()] = "BCWS";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BCWP.getValue()] = "BCWP";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACWP.getValue()] = "ACWP";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.SV.getValue()] = "SV";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST_VARIANCE.getValue()] = "Cost Variance";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.PERCENT_WORK_COMPLETE.getValue()] = "Percent Work Complete";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.PROJECT.getValue()] = "Project";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NOTES.getValue()] = "Notes";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.CONFIRMED.getValue()] = "Confirmed";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.RESPONSE_PENDING.getValue()] = "Response Pending";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.UPDATE_NEEDED.getValue()] = "Update Needed";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEAM_STATUS_PENDING.getValue()] = "Team Status Pending";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST_RATE_TABLE.getValue()] = "Cost Rate Table";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT1.getValue()] = "Text1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT2.getValue()] = "Text2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT3.getValue()] = "Text3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT4.getValue()] = "Text4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT5.getValue()] = "Text5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT6.getValue()] = "Text6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT7.getValue()] = "Text7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT8.getValue()] = "Text8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT9.getValue()] = "Text9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT10.getValue()] = "Text10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START1.getValue()] = "Start1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START2.getValue()] = "Start2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START3.getValue()] = "Start3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START4.getValue()] = "Start4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START5.getValue()] = "Start5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH1.getValue()] = "Finish1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH2.getValue()] = "Finish2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH3.getValue()] = "Finish3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH4.getValue()] = "Finish4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH5.getValue()] = "Finish5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER1.getValue()] = "Number1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER2.getValue()] = "Number2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER3.getValue()] = "Number3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER4.getValue()] = "Number4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER5.getValue()] = "Number5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION1.getValue()] = "Duration1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION2.getValue()] = "Duration2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION3.getValue()] = "Duration3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST1.getValue()] = "Cost1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST2.getValue()] = "Cost2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST3.getValue()] = "Cost3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG10.getValue()] = "Flag10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG1.getValue()] = "Flag1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG2.getValue()] = "Flag2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG3.getValue()] = "Flag3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG4.getValue()] = "Flag4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG5.getValue()] = "Flag5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG6.getValue()] = "Flag6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG7.getValue()] = "Flag7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG8.getValue()] = "Flag8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG9.getValue()] = "Flag9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.LINKED_FIELDS.getValue()] = "Linked Fields";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.OVERALLOCATED.getValue()] = "Overallocated";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TASK_SUMMARY_NAME.getValue()] = "Task Summary Name";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.HYPERLINK_DATA.getValue()] = "Hyperlink Data";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.HYPERLINK.getValue()] = "Hyperlink";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.HYPERLINK_ADDRESS.getValue()] = "Hyperlink Address";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.HYPERLINK_SUBADDRESS.getValue()] = "Hyperlink Subaddress";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.HYPERLINK_HREF.getValue()] = "Hyperlink Href";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST4.getValue()] = "Cost4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST5.getValue()] = "Cost5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST6.getValue()] = "Cost6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST7.getValue()] = "Cost7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST8.getValue()] = "Cost8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST9.getValue()] = "Cost9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.COST10.getValue()] = "Cost10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE1.getValue()] = "Date1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE2.getValue()] = "Date2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE3.getValue()] = "Date3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE4.getValue()] = "Date4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE5.getValue()] = "Date5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE6.getValue()] = "Date6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE7.getValue()] = "Date7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE8.getValue()] = "Date8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE9.getValue()] = "Date9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DATE10.getValue()] = "Date10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION4.getValue()] = "Duration4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION5.getValue()] = "Duration5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION6.getValue()] = "Duration6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION7.getValue()] = "Duration7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION8.getValue()] = "Duration8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION9.getValue()] = "Duration9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION10.getValue()] = "Duration10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH6.getValue()] = "Finish6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH7.getValue()] = "Finish7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH8.getValue()] = "Finish8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH9.getValue()] = "Finish9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH10.getValue()] = "Finish10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG11.getValue()] = "Flag11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG12.getValue()] = "Flag12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG13.getValue()] = "Flag13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG14.getValue()] = "Flag14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG15.getValue()] = "Flag15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG16.getValue()] = "Flag16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG17.getValue()] = "Flag17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG18.getValue()] = "Flag18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG19.getValue()] = "Flag19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FLAG20.getValue()] = "Flag20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER6.getValue()] = "Number6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER7.getValue()] = "Number7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER8.getValue()] = "Number8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER9.getValue()] = "Number9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER10.getValue()] = "Number10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER11.getValue()] = "Number11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER12.getValue()] = "Number12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER13.getValue()] = "Number13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER14.getValue()] = "Number14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER15.getValue()] = "Number15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER16.getValue()] = "Number16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER17.getValue()] = "Number17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER18.getValue()] = "Number18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER19.getValue()] = "Number19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.NUMBER20.getValue()] = "Number20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START6.getValue()] = "Start6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START7.getValue()] = "Start7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START8.getValue()] = "Start8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START9.getValue()] = "Start9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START10.getValue()] = "Start10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT11.getValue()] = "Text11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT12.getValue()] = "Text12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT13.getValue()] = "Text13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT14.getValue()] = "Text14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT15.getValue()] = "Text15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT16.getValue()] = "Text16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT17.getValue()] = "Text17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT18.getValue()] = "Text18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT19.getValue()] = "Text19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT20.getValue()] = "Text20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT21.getValue()] = "Text21";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT22.getValue()] = "Text22";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT23.getValue()] = "Text23";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT24.getValue()] = "Text24";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT25.getValue()] = "Text25";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT26.getValue()] = "Text26";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT27.getValue()] = "Text27";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT28.getValue()] = "Text28";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT29.getValue()] = "Text29";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TEXT30.getValue()] = "Text30";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.INDEX.getValue()] = "Index";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.CV.getValue()] = "CV";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.WORK_VARIANCE.getValue()] = "Work Variance";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.START_VARIANCE.getValue()] = "Start Variance";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FINISH_VARIANCE.getValue()] = "Finish Variance";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.VAC.getValue()] = "VAC";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.FIXED_MATERIAL_ASSIGNMENT.getValue()] = "Fixed Material Assignment";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.RESOURCE_TYPE.getValue()] = "Resource Type";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.HYPERLINK_SCREEN_TIP.getValue()] = "Hyperlink Screen Tip";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.WBS.getValue()] = "WBS";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE1_WORK.getValue()] = "Baseline1 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE1_COST.getValue()] = "Baseline1 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE1_START.getValue()] = "Baseline1 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE1_FINISH.getValue()] = "Baseline1 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE2_WORK.getValue()] = "Baseline2 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE2_COST.getValue()] = "Baseline2 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE2_START.getValue()] = "Baseline2 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE2_FINISH.getValue()] = "Baseline2 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE3_WORK.getValue()] = "Baseline3 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE3_COST.getValue()] = "Baseline3 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE3_START.getValue()] = "Baseline3 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE3_FINISH.getValue()] = "Baseline3 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE4_WORK.getValue()] = "Baseline4 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE4_COST.getValue()] = "Baseline4 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE4_START.getValue()] = "Baseline4 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE4_FINISH.getValue()] = "Baseline4 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE5_WORK.getValue()] = "Baseline5 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE5_COST.getValue()] = "Baseline5 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE5_START.getValue()] = "Baseline5 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE5_FINISH.getValue()] = "Baseline5 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE6_WORK.getValue()] = "Baseline6 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE6_COST.getValue()] = "Baseline6 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE6_START.getValue()] = "Baseline6 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE6_FINISH.getValue()] = "Baseline6 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE7_WORK.getValue()] = "Baseline7 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE7_COST.getValue()] = "Baseline7 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE7_START.getValue()] = "Baseline7 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE7_FINISH.getValue()] = "Baseline7 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE8_WORK.getValue()] = "Baseline8 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE8_COST.getValue()] = "Baseline8 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE8_START.getValue()] = "Baseline8 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE8_FINISH.getValue()] = "Baseline8 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE9_WORK.getValue()] = "Baseline9 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE9_COST.getValue()] = "Baseline9 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE9_START.getValue()] = "Baseline9 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE9_FINISH.getValue()] = "Baseline9 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE10_WORK.getValue()] = "Baseline10 Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE10_COST.getValue()] = "Baseline10 Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE10_START.getValue()] = "Baseline10 Start";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE10_FINISH.getValue()] = "Baseline10 Finish";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.TASK_OUTLINE_NUMBER.getValue()] = "Task Outline Number";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST1.getValue()] = "Enterprise Cost1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST2.getValue()] = "Enterprise Cost2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST3.getValue()] = "Enterprise Cost3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST4.getValue()] = "Enterprise Cost4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST5.getValue()] = "Enterprise Cost5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST6.getValue()] = "Enterprise Cost6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST7.getValue()] = "Enterprise Cost7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST8.getValue()] = "Enterprise Cost8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST9.getValue()] = "Enterprise Cost9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_COST10.getValue()] = "Enterprise Cost10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE1.getValue()] = "Enterprise Date1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE2.getValue()] = "Enterprise Date2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE3.getValue()] = "Enterprise Date3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE4.getValue()] = "Enterprise Date4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE5.getValue()] = "Enterprise Date5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE6.getValue()] = "Enterprise Date6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE7.getValue()] = "Enterprise Date7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE8.getValue()] = "Enterprise Date8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE9.getValue()] = "Enterprise Date9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE10.getValue()] = "Enterprise Date10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE11.getValue()] = "Enterprise Date11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE12.getValue()] = "Enterprise Date12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE13.getValue()] = "Enterprise Date13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE14.getValue()] = "Enterprise Date14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE15.getValue()] = "Enterprise Date15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE16.getValue()] = "Enterprise Date16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE17.getValue()] = "Enterprise Date17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE18.getValue()] = "Enterprise Date18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE19.getValue()] = "Enterprise Date19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE20.getValue()] = "Enterprise Date20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE21.getValue()] = "Enterprise Date21";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE22.getValue()] = "Enterprise Date22";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE23.getValue()] = "Enterprise Date23";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE24.getValue()] = "Enterprise Date24";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE25.getValue()] = "Enterprise Date25";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE26.getValue()] = "Enterprise Date26";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE27.getValue()] = "Enterprise Date27";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE28.getValue()] = "Enterprise Date28";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE29.getValue()] = "Enterprise Date29";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DATE30.getValue()] = "Enterprise Date30";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION1.getValue()] = "Enterprise Duration1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION2.getValue()] = "Enterprise Duration2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION3.getValue()] = "Enterprise Duration3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION4.getValue()] = "Enterprise Duration4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION5.getValue()] = "Enterprise Duration5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION6.getValue()] = "Enterprise Duration6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION7.getValue()] = "Enterprise Duration7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION8.getValue()] = "Enterprise Duration8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION9.getValue()] = "Enterprise Duration9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_DURATION10.getValue()] = "Enterprise Duration10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG1.getValue()] = "Enterprise Flag1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG2.getValue()] = "Enterprise Flag2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG3.getValue()] = "Enterprise Flag3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG4.getValue()] = "Enterprise Flag4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG5.getValue()] = "Enterprise Flag5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG6.getValue()] = "Enterprise Flag6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG7.getValue()] = "Enterprise Flag7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG8.getValue()] = "Enterprise Flag8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG9.getValue()] = "Enterprise Flag9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG10.getValue()] = "Enterprise Flag10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG11.getValue()] = "Enterprise Flag11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG12.getValue()] = "Enterprise Flag12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG13.getValue()] = "Enterprise Flag13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG14.getValue()] = "Enterprise Flag14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG15.getValue()] = "Enterprise Flag15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG16.getValue()] = "Enterprise Flag16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG17.getValue()] = "Enterprise Flag17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG18.getValue()] = "Enterprise Flag18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG19.getValue()] = "Enterprise Flag19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_FLAG20.getValue()] = "Enterprise Flag20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER1.getValue()] = "Enterprise Number1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER2.getValue()] = "Enterprise Number2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER3.getValue()] = "Enterprise Number3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER4.getValue()] = "Enterprise Number4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER5.getValue()] = "Enterprise Number5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER6.getValue()] = "Enterprise Number6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER7.getValue()] = "Enterprise Number7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER8.getValue()] = "Enterprise Number8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER9.getValue()] = "Enterprise Number9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER10.getValue()] = "Enterprise Number10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER11.getValue()] = "Enterprise Number11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER12.getValue()] = "Enterprise Number12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER13.getValue()] = "Enterprise Number13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER14.getValue()] = "Enterprise Number14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER15.getValue()] = "Enterprise Number15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER16.getValue()] = "Enterprise Number16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER17.getValue()] = "Enterprise Number17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER18.getValue()] = "Enterprise Number18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER19.getValue()] = "Enterprise Number19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER20.getValue()] = "Enterprise Number20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER21.getValue()] = "Enterprise Number21";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER22.getValue()] = "Enterprise Number22";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER23.getValue()] = "Enterprise Number23";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER24.getValue()] = "Enterprise Number24";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER25.getValue()] = "Enterprise Number25";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER26.getValue()] = "Enterprise Number26";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER27.getValue()] = "Enterprise Number27";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER28.getValue()] = "Enterprise Number28";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER29.getValue()] = "Enterprise Number29";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER30.getValue()] = "Enterprise Number30";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER31.getValue()] = "Enterprise Number31";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER32.getValue()] = "Enterprise Number32";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER33.getValue()] = "Enterprise Number33";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER34.getValue()] = "Enterprise Number34";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER35.getValue()] = "Enterprise Number35";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER36.getValue()] = "Enterprise Number36";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER37.getValue()] = "Enterprise Number37";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER38.getValue()] = "Enterprise Number38";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER39.getValue()] = "Enterprise Number39";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_NUMBER40.getValue()] = "Enterprise Number40";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT1.getValue()] = "Enterprise Text1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT2.getValue()] = "Enterprise Text2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT3.getValue()] = "Enterprise Text3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT4.getValue()] = "Enterprise Text4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT5.getValue()] = "Enterprise Text5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT6.getValue()] = "Enterprise Text6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT7.getValue()] = "Enterprise Text7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT8.getValue()] = "Enterprise Text8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT9.getValue()] = "Enterprise Text9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT10.getValue()] = "Enterprise Text10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT11.getValue()] = "Enterprise Text11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT12.getValue()] = "Enterprise Text12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT13.getValue()] = "Enterprise Text13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT14.getValue()] = "Enterprise Text14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT15.getValue()] = "Enterprise Text15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT16.getValue()] = "Enterprise Text16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT17.getValue()] = "Enterprise Text17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT18.getValue()] = "Enterprise Text18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT19.getValue()] = "Enterprise Text19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT20.getValue()] = "Enterprise Text20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT21.getValue()] = "Enterprise Text21";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT22.getValue()] = "Enterprise Text22";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT23.getValue()] = "Enterprise Text23";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT24.getValue()] = "Enterprise Text24";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT25.getValue()] = "Enterprise Text25";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT26.getValue()] = "Enterprise Text26";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT27.getValue()] = "Enterprise Text27";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT28.getValue()] = "Enterprise Text28";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT29.getValue()] = "Enterprise Text29";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT30.getValue()] = "Enterprise Text30";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT31.getValue()] = "Enterprise Text31";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT32.getValue()] = "Enterprise Text32";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT33.getValue()] = "Enterprise Text33";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT34.getValue()] = "Enterprise Text34";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT35.getValue()] = "Enterprise Text35";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT36.getValue()] = "Enterprise Text36";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT37.getValue()] = "Enterprise Text37";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT38.getValue()] = "Enterprise Text38";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT39.getValue()] = "Enterprise Text39";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEXT40.getValue()] = "Enterprise Text40";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE1.getValue()] = "Enterprise Resource Outline Code1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE2.getValue()] = "Enterprise Resource Outline Code2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE3.getValue()] = "Enterprise Resource Outline Code3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE4.getValue()] = "Enterprise Resource Outline Code4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE5.getValue()] = "Enterprise Resource Outline Code5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE6.getValue()] = "Enterprise Resource Outline Code6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE7.getValue()] = "Enterprise Resource Outline Code7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE8.getValue()] = "Enterprise Resource Outline Code8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE9.getValue()] = "Enterprise Resource Outline Code9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE10.getValue()] = "Enterprise Resource Outline Code10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE11.getValue()] = "Enterprise Resource Outline Code11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE12.getValue()] = "Enterprise Resource Outline Code12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE13.getValue()] = "Enterprise Resource Outline Code13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE14.getValue()] = "Enterprise Resource Outline Code14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE15.getValue()] = "Enterprise Resource Outline Code15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE16.getValue()] = "Enterprise Resource Outline Code16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE17.getValue()] = "Enterprise Resource Outline Code17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE18.getValue()] = "Enterprise Resource Outline Code18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE19.getValue()] = "Enterprise Resource Outline Code19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE20.getValue()] = "Enterprise Resource Outline Code20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE21.getValue()] = "Enterprise Resource Outline Code21";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE22.getValue()] = "Enterprise Resource Outline Code22";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE23.getValue()] = "Enterprise Resource Outline Code23";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE24.getValue()] = "Enterprise Resource Outline Code24";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE25.getValue()] = "Enterprise Resource Outline Code25";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE26.getValue()] = "Enterprise Resource Outline Code26";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE27.getValue()] = "Enterprise Resource Outline Code27";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE28.getValue()] = "Enterprise Resource Outline Code28";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_OUTLINE_CODE29.getValue()] = "Enterprise Resource Outline Code29";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_RBS.getValue()] = "Enterprise Resource RBS";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.RESOURCE_REQUEST_TYPE.getValue()] = "Resource Request Type";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_TEAM_MEMBER.getValue()] = "Enterprise Team Member";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE20.getValue()] = "Enterprise Resource Multi Value20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE21.getValue()] = "Enterprise Resource Multi Value21";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE22.getValue()] = "Enterprise Resource Multi Value22";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE23.getValue()] = "Enterprise Resource Multi Value23";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE24.getValue()] = "Enterprise Resource Multi Value24";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE25.getValue()] = "Enterprise Resource Multi Value25";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE26.getValue()] = "Enterprise Resource Multi Value26";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE27.getValue()] = "Enterprise Resource Multi Value27";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE28.getValue()] = "Enterprise Resource Multi Value28";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_RESOURCE_MULTI_VALUE29.getValue()] = "Enterprise Resource Multi Value29";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACTUAL_WORK_PROTECTED.getValue()] = "Actual Work Protected";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ACTUAL_OVERTIME_WORK_PROTECTED.getValue()] = "Actual Overtime Work Protected";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.CREATED.getValue()] = "Created";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.GUID.getValue()] = "Assignment GUID";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ASSIGNMENT_TASK_GUID.getValue()] = "Assignment Task GUID";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ASSIGNMENT_RESOURCE_GUID.getValue()] = "Assignment Resource GUID";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.SUMMARY.getValue()] = "Summary";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.OWNER.getValue()] = "Owner";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BUDGET_WORK.getValue()] = "Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BUDGET_COST.getValue()] = "Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE_BUDGET_WORK.getValue()] = "Baseline Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE_BUDGET_COST.getValue()] = "Baseline Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE1_BUDGET_WORK.getValue()] = "Baseline1 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE1_BUDGET_COST.getValue()] = "Baseline1 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE2_BUDGET_WORK.getValue()] = "Baseline2 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE2_BUDGET_COST.getValue()] = "Baseline2 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE3_BUDGET_WORK.getValue()] = "Baseline3 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE3_BUDGET_COST.getValue()] = "Baseline3 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE4_BUDGET_WORK.getValue()] = "Baseline4 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE4_BUDGET_COST.getValue()] = "Baseline4 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE5_BUDGET_WORK.getValue()] = "Baseline5 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE5_BUDGET_COST.getValue()] = "Baseline5 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE6_BUDGET_WORK.getValue()] = "Baseline6 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE6_BUDGET_COST.getValue()] = "Baseline6 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE7_BUDGET_WORK.getValue()] = "Baseline7 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE7_BUDGET_COST.getValue()] = "Baseline7 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE8_BUDGET_WORK.getValue()] = "Baseline8 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE8_BUDGET_COST.getValue()] = "Baseline8 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE9_BUDGET_WORK.getValue()] = "Baseline9 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE9_BUDGET_COST.getValue()] = "Baseline9 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE10_BUDGET_WORK.getValue()] = "Baseline10 Budget Work";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.BASELINE10_BUDGET_COST.getValue()] = "Baseline10 Budget Cost";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.UNAVAILABLE.getValue()] = "<Unavailable>";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION1_UNITS.getValue()] = "Duration1 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION2_UNITS.getValue()] = "Duration2 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION3_UNITS.getValue()] = "Duration3 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION4_UNITS.getValue()] = "Duration4 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION5_UNITS.getValue()] = "Duration5 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION6_UNITS.getValue()] = "Duration6 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION7_UNITS.getValue()] = "Duration7 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION8_UNITS.getValue()] = "Duration8 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION9_UNITS.getValue()] = "Duration9 Units";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.DURATION10_UNITS.getValue()] = "Duration10 Units";

      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD1.getValue()] = "Enterprise Custom Field 1";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD2.getValue()] = "Enterprise Custom Field 2";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD3.getValue()] = "Enterprise Custom Field 3";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD4.getValue()] = "Enterprise Custom Field 4";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD5.getValue()] = "Enterprise Custom Field 5";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD6.getValue()] = "Enterprise Custom Field 6";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD7.getValue()] = "Enterprise Custom Field 7";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD8.getValue()] = "Enterprise Custom Field 8";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD9.getValue()] = "Enterprise Custom Field 9";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD10.getValue()] = "Enterprise Custom Field 10";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD11.getValue()] = "Enterprise Custom Field 11";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD12.getValue()] = "Enterprise Custom Field 12";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD13.getValue()] = "Enterprise Custom Field 13";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD14.getValue()] = "Enterprise Custom Field 14";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD15.getValue()] = "Enterprise Custom Field 15";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD16.getValue()] = "Enterprise Custom Field 16";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD17.getValue()] = "Enterprise Custom Field 17";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD18.getValue()] = "Enterprise Custom Field 18";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD19.getValue()] = "Enterprise Custom Field 19";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD20.getValue()] = "Enterprise Custom Field 20";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD21.getValue()] = "Enterprise Custom Field 21";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD22.getValue()] = "Enterprise Custom Field 22";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD23.getValue()] = "Enterprise Custom Field 23";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD24.getValue()] = "Enterprise Custom Field 24";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD25.getValue()] = "Enterprise Custom Field 25";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD26.getValue()] = "Enterprise Custom Field 26";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD27.getValue()] = "Enterprise Custom Field 27";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD28.getValue()] = "Enterprise Custom Field 28";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD29.getValue()] = "Enterprise Custom Field 29";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD30.getValue()] = "Enterprise Custom Field 30";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD31.getValue()] = "Enterprise Custom Field 31";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD32.getValue()] = "Enterprise Custom Field 32";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD33.getValue()] = "Enterprise Custom Field 33";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD34.getValue()] = "Enterprise Custom Field 34";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD35.getValue()] = "Enterprise Custom Field 35";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD36.getValue()] = "Enterprise Custom Field 36";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD37.getValue()] = "Enterprise Custom Field 37";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD38.getValue()] = "Enterprise Custom Field 38";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD39.getValue()] = "Enterprise Custom Field 39";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD40.getValue()] = "Enterprise Custom Field 40";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD41.getValue()] = "Enterprise Custom Field 41";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD42.getValue()] = "Enterprise Custom Field 42";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD43.getValue()] = "Enterprise Custom Field 43";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD44.getValue()] = "Enterprise Custom Field 44";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD45.getValue()] = "Enterprise Custom Field 45";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD46.getValue()] = "Enterprise Custom Field 46";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD47.getValue()] = "Enterprise Custom Field 47";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD48.getValue()] = "Enterprise Custom Field 48";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD49.getValue()] = "Enterprise Custom Field 49";
      ASSIGNMENT_COLUMNS_ARRAY[AssignmentField.ENTERPRISE_CUSTOM_FIELD50.getValue()] = "Enterprise Custom Field 50";

      CONSTRAINT_COLUMNS_ARRAY[ConstraintField.UNIQUE_ID.getValue()] = "Unique ID";
      CONSTRAINT_COLUMNS_ARRAY[ConstraintField.TASK1.getValue()] = "Task 1";
      CONSTRAINT_COLUMNS_ARRAY[ConstraintField.TASK2.getValue()] = "Task 2";
   }

   private static final Object[][] RESOURCES =
   {
      {
         "TASK_COLUMNS",
         TASK_COLUMNS_ARRAY
      },
      {
         "RESOURCE_COLUMNS",
         RESOURCE_COLUMNS_ARRAY
      },
      {
         "ASSIGNMENT_COLUMNS",
         ASSIGNMENT_COLUMNS_ARRAY
      },
      {
         "CONSTRAINT_COLUMNS",
         CONSTRAINT_COLUMNS_ARRAY
      },
      {
         "PROJECT_COLUMNS",
         PROJECT_COLUMNS_ARRAY
      }

   };
}
