; Java Launcher with automatic JRE installation
;-----------------------------------------------
 
Name "ProjectLibre"
Caption "ProjectLibre"
Icon "projectlibre\msi_images\projectlibre.ico"
OutFile "projectlibre\projectlibre.exe"
 
VIAddVersionKey "ProductName" "ProjectLibre"
VIAddVersionKey "Comments" "ProjectLibre"
VIAddVersionKey "CompanyName" "ProjectLibre Inc."
VIAddVersionKey "LegalTrademarks" "ProjectLibre Inc."
VIAddVersionKey "LegalCopyright" "2012-2017 ProjectLibre Inc."
VIAddVersionKey "FileDescription" "ProjectLibre"
VIAddVersionKey "FileVersion" "1.7.0"
VIProductVersion "1.7.0.0"
 
!define CLASSPATH "projectlibre\projectlibre.jar:projectlibre\lib\openproj-contrib.jar:projectlibre\lib\openproj-reports.jar:projectlibre\lib\openproj-script.jar"
!define CLASS "com.projity.main.Main"
!define PRODUCT_NAME "ProjectLibre"
 
; Definitions for Java 6.0
!define JRE_VERSION "6.0"
!define JRE_URL "http://javadl.sun.com/webapps/download/AutoDL?BundleId=68735"
 
; use javaw.exe to avoid dosbox.
; use java.exe to keep stdout/stderr
!define JAVAEXE "javaw.exe"
 
RequestExecutionLevel user
SilentInstall silent
AutoCloseWindow true
ShowInstDetails nevershow
 
!include "FileFunc.nsh"
!insertmacro GetFileVersion
!insertmacro GetParameters
!include "WordFunc.nsh"
!insertmacro VersionCompare
 
Section ""
  Call GetJRE
  Pop $R0
 
  ; change for your purpose (-jar etc.)
  ${GetParameters} $1
  StrCpy $0 '"$R0" -jar projectlibre.jar $1'
 
  SetOutPath $EXEDIR
  Exec $0
SectionEnd
 
;  returns the full path of a valid java.exe
;  looks in:
;  1 - .\jre directory (JRE Installed with application)
;  2 - JAVA_HOME environment variable
;  3 - the registry
;  4 - hopes it is in current dir or PATH
Function GetJRE
    Push $R0
    Push $R1
    Push $2
 
  ; 1) Check local JRE
  CheckLocal:
    ClearErrors
    StrCpy $R0 "$EXEDIR\jre\bin\${JAVAEXE}"
    IfFileExists $R0 JreFound
 
  ; 2) Check for JAVA_HOME
  CheckJavaHome:
    ClearErrors
    ReadEnvStr $R0 "JAVA_HOME"
    StrCpy $R0 "$R0\bin\${JAVAEXE}"
    IfErrors CheckRegistry     
    IfFileExists $R0 0 CheckRegistry
    Call CheckJREVersion
    IfErrors CheckRegistry JreFound
 
  ; 3) Check for registry
  CheckRegistry:
    ClearErrors
    ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" "CurrentVersion"
    ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment\$R1" "JavaHome"
    StrCpy $R0 "$R0\bin\${JAVAEXE}"
    IfErrors DownloadJRE
    IfFileExists $R0 0 DownloadJRE
    Call CheckJREVersion
    IfErrors DownloadJRE JreFound
 
  DownloadJRE:
;    Call ElevateToAdmin
;    MessageBox MB_ICONINFORMATION "${PRODUCT_NAME} uses Java Runtime Environment ${JRE_VERSION}, it will now be downloaded and installed."
;    StrCpy $2 "$TEMP\Java Runtime Environment.exe"
;    nsisdl::download /TIMEOUT=30000 ${JRE_URL} $2
;    Pop $R0 ;Get the return value
;    StrCmp $R0 "success" +3
;      MessageBox MB_ICONSTOP "Download failed: $R0"
;      Abort
;    ExecWait $2
;    Delete $2
; 
;    ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" "CurrentVersion"
;    ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment\$R1" "JavaHome"
;    StrCpy $R0 "$R0\bin\${JAVAEXE}"
;    IfFileExists $R0 0 GoodLuck
;    Call CheckJREVersion
;    IfErrors GoodLuck JreFound
    MessageBox MB_ICONINFORMATION "ProjectLibre requires Java version 6 or later. Please install Java: http://www.java.com/download"
    Abort

  ; 4) wishing you good luck
  GoodLuck:
    StrCpy $R0 "${JAVAEXE}"
    ; MessageBox MB_ICONSTOP "Cannot find appropriate Java Runtime Environment."
    ; Abort
 
  JreFound:
    Pop $2
    Pop $R1
    Exch $R0
FunctionEnd
 
; Pass the "javaw.exe" path by $R0
Function CheckJREVersion
    Push $R1
 
    ; Get the file version of javaw.exe
    ${GetFileVersion} $R0 $R1
    ${VersionCompare} ${JRE_VERSION} $R1 $R1
 
    ; Check whether $R1 != "1"
    ClearErrors
    StrCmp $R1 "1" 0 CheckDone
    SetErrors
 
  CheckDone:
    Pop $R1
FunctionEnd
 
; Attempt to give the UAC plug-in a user process and an admin process.
;Function ElevateToAdmin
;  UAC_Elevate:
;    UAC::RunElevated
;    StrCmp 1223 $0 UAC_ElevationAborted ; UAC dialog aborted by user?
;    StrCmp 0 $0 0 UAC_Err ; Error?
;    StrCmp 1 $1 0 UAC_Success ;Are we the real deal or just the wrapper?
;    Quit
; 
;  UAC_ElevationAborted:
;    # elevation was aborted, run as normal?
;    MessageBox MB_ICONSTOP "This installer requires admin access, aborting!"
;    Abort
; 
;  UAC_Err:
;    MessageBox MB_ICONSTOP "Unable to elevate, error $0"
;    Abort
; 
;  UAC_Success:
;    StrCmp 1 $3 +4 ;Admin?
;    StrCmp 3 $1 0 UAC_ElevationAborted ;Try again?
;    MessageBox MB_ICONSTOP "This installer requires admin access, try again"
;    goto UAC_Elevate 
;FunctionEnd

