/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class ConstantTagFilter
extends SimplifiedVisitor
implements ConstantVisitor {
    private final int constantTagMask;
    private final ConstantVisitor constantVisitor;

    public ConstantTagFilter(int n, ConstantVisitor constantVisitor) {
        this.constantTagMask = 1 << n;
        this.constantVisitor = constantVisitor;
    }

    public ConstantTagFilter(int[] nArray, ConstantVisitor constantVisitor) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n |= 1 << nArray[i];
        }
        this.constantTagMask = n;
        this.constantVisitor = constantVisitor;
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
        if ((1 << constant.getTag() & this.constantTagMask) != 0) {
            constant.accept(clazz, this.constantVisitor);
        }
    }
}

