/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.utils;

import com.rtfparserkit.parser.IRtfParser;
import com.rtfparserkit.parser.RtfStreamSource;
import com.rtfparserkit.parser.standard.StandardRtfParserTest;
import com.rtfparserkit.utils.RtfDumpListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;

public class TestUtilities {
    public static String readStreamToString(InputStream is) throws IOException {
        int bytesRead;
        StringBuilder result = new StringBuilder();
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            result.append(new String(buffer, 0, bytesRead));
        }
        return result.toString();
    }

    public static void assertRtfParserDumpMatches(Object parentTest, IRtfParser parser, String filename) throws Exception {
        File outputFile = File.createTempFile(filename, ".xml");
        outputFile.deleteOnExit();
        InputStream is = null;
        OutputStream os = null;
        try {
            is = parentTest.getClass().getResourceAsStream("data/" + filename + ".rtf");
            os = new FileOutputStream(outputFile);
            parser.parse(new RtfStreamSource(is), new RtfDumpListener(os));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
        FileInputStream actualStream = null;
        InputStream expectedStream = null;
        try {
            actualStream = new FileInputStream(outputFile);
            expectedStream = parentTest.getClass().getResourceAsStream("data/" + filename + ".xml");
            String expectedText = TestUtilities.readStreamToString(expectedStream);
            String actualText = TestUtilities.readStreamToString(actualStream);
            Assert.assertEquals((Object)expectedText, (Object)actualText);
        }
        finally {
            if (actualStream != null) {
                try {
                    ((InputStream)actualStream).close();
                }
                catch (Exception exception) {}
            }
            if (expectedStream != null) {
                try {
                    expectedStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void dump(IRtfParser parser, String filename, String outputFilename) throws Exception {
        File outputFile = new File(outputFilename);
        InputStream is = null;
        OutputStream os = null;
        try {
            is = StandardRtfParserTest.class.getResourceAsStream("data/" + filename + ".rtf");
            os = new FileOutputStream(outputFile);
            parser.parse(new RtfStreamSource(is), new RtfDumpListener(os));
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }
}

