/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.utils;

import com.rtfparserkit.parser.IRtfListener;
import com.rtfparserkit.rtf.Command;
import com.sun.xml.internal.txw2.output.IndentingXMLStreamWriter;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class RtfDumpListener
implements IRtfListener {
    private final XMLStreamWriter writer;

    public RtfDumpListener(OutputStream stream) throws XMLStreamException {
        this.writer = new IndentingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(stream, "UTF-8"));
    }

    @Override
    public void processDocumentStart() {
        try {
            this.writer.writeStartDocument("UTF-8", "1.0");
            this.writer.writeStartElement("rtf");
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processDocumentEnd() {
        try {
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processCharacterBytes(byte[] data) {
        try {
            if (data.length != 0) {
                this.writer.writeStartElement("chars");
                this.writer.writeCharacters(new String(data));
                this.writer.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processBinaryBytes(byte[] data) {
        try {
            this.writer.writeStartElement("bytes");
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                this.writer.writeCharacters(Integer.toHexString(b));
                ++n2;
            }
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processGroupStart() {
        try {
            this.writer.writeStartElement("group");
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processGroupEnd() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processCommand(Command command, int parameter, boolean hasParameter, boolean optional) {
        try {
            this.writer.writeEmptyElement("command");
            this.writer.writeAttribute("name", command.getCommandName());
            if (hasParameter) {
                this.writer.writeAttribute("parameter", Integer.toString(parameter));
            }
            if (optional) {
                this.writer.writeAttribute("optional", "true");
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processString(String string) {
        try {
            this.writer.writeStartElement("chars");
            this.writer.writeCharacters(string);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }
}

