/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.parser.raw;

import com.rtfparserkit.parser.raw.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufferTest {
    @Test
    public void testBasicOperations() {
        ByteBuffer buffer = new ByteBuffer();
        byte[] array = buffer.toArray();
        Assert.assertEquals((long)0L, (long)array.length);
        Assert.assertTrue((boolean)buffer.isEmpty());
        buffer.add(1);
        array = buffer.toArray();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertFalse((boolean)buffer.isEmpty());
        buffer.clear();
        array = buffer.toArray();
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testBufferSizeIncrease() {
        Random r = new Random();
        byte[] array = new byte[1025];
        ByteBuffer buffer = new ByteBuffer();
        int loop = 0;
        while (loop < array.length) {
            byte value;
            array[loop] = value = (byte)r.nextInt();
            buffer.add(value);
            ++loop;
        }
        byte[] actualArray = buffer.toArray();
        Assert.assertArrayEquals((byte[])array, (byte[])actualArray);
    }
}

