/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.antlr.ASTParserException;
import org.codehaus.groovy.antlr.ASTRuntimeException;
import org.codehaus.groovy.antlr.AntlrASTProcessSnippets;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.codehaus.groovy.antlr.parser.GroovyTokenTypes;
import org.codehaus.groovy.antlr.treewalker.CompositeVisitor;
import org.codehaus.groovy.antlr.treewalker.MindMapPrinter;
import org.codehaus.groovy.antlr.treewalker.NodeAsHTMLPrinter;
import org.codehaus.groovy.antlr.treewalker.PreOrderTraversal;
import org.codehaus.groovy.antlr.treewalker.SourceCodeTraversal;
import org.codehaus.groovy.antlr.treewalker.SourcePrinter;
import org.codehaus.groovy.antlr.treewalker.SummaryCollector;
import org.codehaus.groovy.antlr.treewalker.TraversalHelper;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NegationExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ParserPlugin;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.ASTHelper;
import org.codehaus.groovy.syntax.Numbers;
import org.codehaus.groovy.syntax.ParserException;
import org.codehaus.groovy.syntax.Reduction;
import org.codehaus.groovy.syntax.SourceSummary;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;

public class AntlrParserPlugin
extends ASTHelper
implements ParserPlugin,
GroovyTokenTypes {
    private AST ast;
    private ClassNode classNode;
    private String[] tokenNames;

    public Reduction parseCST(final SourceUnit sourceUnit, Reader reader) throws CompilationFailedException {
        this.ast = null;
        this.setController(sourceUnit);
        SourceBuffer sourceBuffer = new SourceBuffer();
        UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(reader, sourceBuffer);
        GroovyLexer lexer = new GroovyLexer(unicodeReader);
        unicodeReader.setLexer(lexer);
        GroovyRecognizer parser = GroovyRecognizer.make(lexer);
        parser.setSourceBuffer(sourceBuffer);
        this.tokenNames = parser.getTokenNames();
        parser.setFilename(sourceUnit.getName());
        try {
            parser.compilationUnit();
        }
        catch (TokenStreamRecognitionException tsre) {
            RecognitionException e = tsre.recog;
            SyntaxException se = new SyntaxException(e.getMessage(), (Throwable)e, e.getLine(), e.getColumn());
            se.setFatal(true);
            sourceUnit.addError(se);
        }
        catch (RecognitionException e) {
            SyntaxException se = new SyntaxException(e.getMessage(), (Throwable)e, e.getLine(), e.getColumn());
            se.setFatal(true);
            sourceUnit.addError(se);
        }
        catch (TokenStreamException e) {
            sourceUnit.addException((Exception)((Object)e));
        }
        this.ast = parser.getAST();
        AntlrASTProcessSnippets snippets = new AntlrASTProcessSnippets(sourceBuffer);
        this.ast = snippets.process(this.ast);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AntlrParserPlugin.this.outputASTInVariousFormsIfNeeded(sourceUnit);
                return null;
            }
        });
        return null;
    }

    public SourceSummary getSummary() {
        SummaryCollector summaryCollector = new SummaryCollector();
        PreOrderTraversal treewalker = new PreOrderTraversal(summaryCollector);
        treewalker.process(this.ast);
        return summaryCollector.getSourceSummary();
    }

    private void outputASTInVariousFormsIfNeeded(SourceUnit sourceUnit) {
        TraversalHelper treewalker;
        VisitorAdapter visitor;
        PrintStream out;
        if ("xml".equals(System.getProperty("antlr.ast"))) {
            this.saveAsXML(sourceUnit.getName(), this.ast);
        }
        if ("groovy".equals(System.getProperty("antlr.ast"))) {
            try {
                out = new PrintStream(new FileOutputStream(sourceUnit.getName() + ".pretty.groovy"));
                visitor = new SourcePrinter(out, this.tokenNames);
                treewalker = new SourceCodeTraversal(visitor);
                treewalker.process(this.ast);
            }
            catch (FileNotFoundException e) {
                System.out.println("Cannot create " + sourceUnit.getName() + ".pretty.groovy");
            }
        }
        if ("mindmap".equals(System.getProperty("antlr.ast"))) {
            try {
                out = new PrintStream(new FileOutputStream(sourceUnit.getName() + ".mm"));
                visitor = new MindMapPrinter(out, this.tokenNames);
                treewalker = new PreOrderTraversal(visitor);
                treewalker.process(this.ast);
            }
            catch (FileNotFoundException e) {
                System.out.println("Cannot create " + sourceUnit.getName() + ".mm");
            }
        }
        if ("html".equals(System.getProperty("antlr.ast"))) {
            try {
                out = new PrintStream(new FileOutputStream(sourceUnit.getName() + ".html"));
                ArrayList<VisitorAdapter> v = new ArrayList<VisitorAdapter>();
                v.add(new NodeAsHTMLPrinter(out, this.tokenNames));
                v.add(new SourcePrinter(out, this.tokenNames));
                CompositeVisitor visitors = new CompositeVisitor(v);
                SourceCodeTraversal treewalker2 = new SourceCodeTraversal(visitors);
                treewalker2.process(this.ast);
            }
            catch (FileNotFoundException e) {
                System.out.println("Cannot create " + sourceUnit.getName() + ".html");
            }
        }
    }

    private void saveAsXML(String name, AST ast) {
        XStream xstream = new XStream();
        try {
            xstream.toXML((Object)ast, (Writer)new FileWriter(name + ".antlr.xml"));
            System.out.println("Written AST to " + name + ".antlr.xml");
        }
        catch (Exception e) {
            System.out.println("Couldn't write to " + name + ".antlr.xml");
            e.printStackTrace();
        }
    }

    public ModuleNode buildAST(SourceUnit sourceUnit, ClassLoader classLoader, Reduction cst) throws ParserException {
        this.setClassLoader(classLoader);
        this.makeModule();
        try {
            this.convertGroovy(this.ast);
        }
        catch (ASTRuntimeException e) {
            throw new ASTParserException(e.getMessage() + ". File: " + sourceUnit.getName(), e);
        }
        return this.output;
    }

    protected void convertGroovy(AST node) {
        while (node != null) {
            int type = node.getType();
            switch (type) {
                case 15: {
                    this.packageDef(node);
                    break;
                }
                case 28: {
                    this.importDef(node);
                    break;
                }
                case 13: {
                    this.classDef(node);
                    break;
                }
                case 14: {
                    this.interfaceDef(node);
                    break;
                }
                case 8: {
                    this.methodDef(node);
                    break;
                }
                default: {
                    Statement statement = this.statement(node);
                    this.output.addStatement(statement);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void packageDef(AST packageDef) {
        AST node = packageDef.getFirstChild();
        if (AntlrParserPlugin.isType(65, node)) {
            node = node.getNextSibling();
        }
        String name = AntlrParserPlugin.qualifiedName(node);
        this.setPackageName(name);
    }

    protected void importDef(AST importNode) {
        AST node = importNode.getFirstChild();
        String alias = null;
        if (AntlrParserPlugin.isType(110, node)) {
            node = node.getFirstChild();
            AST aliasNode = node.getNextSibling();
            alias = this.identifier(aliasNode);
        }
        if (node.getNumberOfChildren() == 0) {
            String name = this.identifier(node);
            ClassNode type = ClassHelper.make(name);
            this.configureAST(type, importNode);
            this.importClass(type, name, alias);
            return;
        }
        AST packageNode = node.getFirstChild();
        String packageName = AntlrParserPlugin.qualifiedName(packageNode);
        AST nameNode = packageNode.getNextSibling();
        if (AntlrParserPlugin.isType(109, nameNode)) {
            this.importPackageWithStar(packageName);
            if (alias != null) {
                throw new GroovyBugError("imports like 'import foo.* as Bar' are not supported and should be caught by the grammar");
            }
        } else {
            String name = this.identifier(nameNode);
            ClassNode type = ClassHelper.make(packageName + "." + name);
            this.configureAST(type, importNode);
            this.importClass(type, name, alias);
        }
    }

    protected void interfaceDef(AST classDef) {
        ArrayList annotations = new ArrayList();
        AST node = classDef.getFirstChild();
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            node = node.getNextSibling();
        }
        modifiers |= 0x600;
        String name = this.identifier(node);
        node = node.getNextSibling();
        ClassNode superClass = ClassHelper.OBJECT_TYPE;
        ClassNode[] interfaces = new ClassNode[]{};
        if (AntlrParserPlugin.isType(17, node)) {
            interfaces = this.interfaces(node);
            node = node.getNextSibling();
        }
        this.addNewClassName(name);
        this.classNode = new ClassNode(AntlrParserPlugin.dot(this.getPackageName(), name), modifiers, superClass, interfaces, null);
        this.classNode.addAnnotations(annotations);
        this.configureAST(this.classNode, classDef);
        this.assertNodeType(6, node);
        this.objectBlock(node);
        this.output.addClass(this.classNode);
        this.classNode = null;
    }

    protected void classDef(AST classDef) {
        ArrayList annotations = new ArrayList();
        AST node = classDef.getFirstChild();
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            node = node.getNextSibling();
        }
        String name = this.identifier(node);
        node = node.getNextSibling();
        ClassNode superClass = null;
        if (AntlrParserPlugin.isType(17, node)) {
            superClass = this.makeType(node);
            node = node.getNextSibling();
        }
        ClassNode[] interfaces = new ClassNode[]{};
        if (AntlrParserPlugin.isType(18, node)) {
            interfaces = this.interfaces(node);
            node = node.getNextSibling();
        }
        MixinNode[] mixins = new MixinNode[]{};
        this.addNewClassName(name);
        this.classNode = new ClassNode(AntlrParserPlugin.dot(this.getPackageName(), name), modifiers, superClass, interfaces, mixins);
        this.classNode.addAnnotations(annotations);
        this.configureAST(this.classNode, classDef);
        this.assertNodeType(6, node);
        this.objectBlock(node);
        this.output.addClass(this.classNode);
        this.classNode = null;
    }

    protected void objectBlock(AST objectBlock) {
        block8: for (AST node = objectBlock.getFirstChild(); node != null; node = node.getNextSibling()) {
            int type = node.getType();
            switch (type) {
                case 6: {
                    this.objectBlock(node);
                    continue block8;
                }
                case 8: {
                    this.methodDef(node);
                    continue block8;
                }
                case 45: {
                    this.constructorDef(node);
                    continue block8;
                }
                case 9: {
                    this.fieldDef(node);
                    continue block8;
                }
                case 11: {
                    this.staticInit(node);
                    continue block8;
                }
                case 10: {
                    this.objectInit(node);
                    continue block8;
                }
                default: {
                    this.unknownAST(node);
                }
            }
        }
    }

    protected void throwsList(AST node, List list) {
        String clazz = this.identifier(node);
        ClassNode exception = ClassHelper.make(clazz);
        list.add(exception);
        AST next = node.getNextSibling();
        if (next != null) {
            this.throwsList(next, list);
        }
        if ((next = node.getFirstChild()) != null) {
            this.throwsList(next, list);
        }
    }

    protected void methodDef(AST methodDef) {
        ArrayList annotations = new ArrayList();
        AST node = methodDef.getFirstChild();
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            node = node.getNextSibling();
        }
        if (this.classNode != null && (this.classNode.getModifiers() & 0x200) > 0) {
            modifiers |= 0x400;
        }
        ClassNode returnType = null;
        if (AntlrParserPlugin.isType(12, node)) {
            returnType = this.makeType(node);
            node = node.getNextSibling();
        }
        String name = this.identifier(node);
        if (this.classNode != null && this.classNode.getNameWithoutPackage().equals(name)) {
            throw new ASTRuntimeException(methodDef, "Invalid constructor format. Try remove the 'def' expression?");
        }
        node = node.getNextSibling();
        this.assertNodeType(19, node);
        Parameter[] parameters = this.parameters(node);
        if (parameters == null) {
            parameters = Parameter.EMPTY_ARRAY;
        }
        node = node.getNextSibling();
        ClassNode[] exceptions = new ClassNode[]{};
        if (AntlrParserPlugin.isType(127, node)) {
            AST throwsNode = node.getFirstChild();
            ArrayList exceptionList = new ArrayList();
            this.throwsList(throwsNode, exceptionList);
            exceptions = exceptionList.toArray(exceptions);
            node = node.getNextSibling();
        }
        Statement code = null;
        if ((modifiers & 0x400) == 0) {
            if (node == null) {
                throw new ASTRuntimeException(methodDef, "You defined a method without body. Try adding a body, or declare it abstract.");
            }
            this.assertNodeType(7, node);
            code = this.statementList(node);
        }
        MethodNode methodNode = new MethodNode(name, modifiers, returnType, parameters, exceptions, code);
        methodNode.addAnnotations(annotations);
        this.configureAST(methodNode, methodDef);
        if (this.classNode != null) {
            this.classNode.addMethod(methodNode);
        } else {
            this.output.addMethod(methodNode);
        }
    }

    protected void staticInit(AST staticInit) {
        BlockStatement code = (BlockStatement)this.statementList(staticInit);
        this.classNode.addStaticInitializerStatements(code.getStatements(), false);
    }

    protected void objectInit(AST init) {
        BlockStatement code = (BlockStatement)this.statementList(init);
        this.classNode.addObjectInitializerStatements(code);
    }

    protected void constructorDef(AST constructorDef) {
        ArrayList annotations = new ArrayList();
        AST node = constructorDef.getFirstChild();
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            node = node.getNextSibling();
        }
        this.assertNodeType(19, node);
        Parameter[] parameters = this.parameters(node);
        if (parameters == null) {
            parameters = Parameter.EMPTY_ARRAY;
        }
        node = node.getNextSibling();
        ClassNode[] exceptions = new ClassNode[]{};
        if (AntlrParserPlugin.isType(127, node)) {
            AST throwsNode = node.getFirstChild();
            ArrayList exceptionList = new ArrayList();
            this.throwsList(throwsNode, exceptionList);
            exceptions = exceptionList.toArray(exceptions);
            node = node.getNextSibling();
        }
        this.assertNodeType(7, node);
        Statement code = this.statementList(node);
        ConstructorNode constructorNode = this.classNode.addConstructor(modifiers, parameters, exceptions, code);
        constructorNode.addAnnotations(annotations);
        this.configureAST(constructorNode, constructorDef);
    }

    protected void fieldDef(AST fieldDef) {
        ArrayList annotations = new ArrayList();
        AST node = fieldDef.getFirstChild();
        int modifiers = 0;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            node = node.getNextSibling();
        }
        if (this.classNode.isInterface() && ((modifiers |= 0x18) & 6) == 0) {
            modifiers |= 1;
        }
        ClassNode type = null;
        if (AntlrParserPlugin.isType(12, node)) {
            type = this.makeType(node);
            node = node.getNextSibling();
        }
        String name = this.identifier(node);
        node = node.getNextSibling();
        Expression initialValue = null;
        if (node != null) {
            this.assertNodeType(120, node);
            initialValue = this.expression(node);
        }
        if (initialValue == null && type != null) {
            if (type == ClassHelper.int_TYPE) {
                initialValue = new ConstantExpression(new Integer(0));
            } else if (type == ClassHelper.long_TYPE) {
                initialValue = new ConstantExpression(new Long(0L));
            } else if (type == ClassHelper.double_TYPE) {
                initialValue = new ConstantExpression(new Double(0.0));
            } else if (type == ClassHelper.float_TYPE) {
                initialValue = new ConstantExpression(new Float(0.0f));
            } else if (type == ClassHelper.boolean_TYPE) {
                initialValue = ConstantExpression.FALSE;
            } else if (type == ClassHelper.short_TYPE) {
                initialValue = new ConstantExpression(new Short(0));
            } else if (type == ClassHelper.byte_TYPE) {
                initialValue = new ConstantExpression(new Byte(0));
            } else if (type == ClassHelper.char_TYPE) {
                initialValue = new ConstantExpression(new Character('\u0000'));
            }
        }
        FieldNode fieldNode = new FieldNode(name, modifiers, type, this.classNode, initialValue);
        fieldNode.addAnnotations(annotations);
        this.configureAST(fieldNode, fieldDef);
        if (!this.hasVisibility(modifiers)) {
            int fieldModifiers = 0;
            int flags = 216;
            if (!this.hasVisibility(modifiers)) {
                modifiers |= 1;
                fieldModifiers |= 2;
            }
            fieldNode.setModifiers(fieldModifiers |= modifiers & flags);
            PropertyNode propertyNode = new PropertyNode(fieldNode, modifiers, null, null);
            this.configureAST(propertyNode, fieldDef);
            this.classNode.addProperty(propertyNode);
        } else {
            fieldNode.setModifiers(modifiers);
            this.classNode.addField(fieldNode);
        }
    }

    protected ClassNode[] interfaces(AST node) {
        ArrayList<ClassNode> interfaceList = new ArrayList<ClassNode>();
        for (AST implementNode = node.getFirstChild(); implementNode != null; implementNode = implementNode.getNextSibling()) {
            interfaceList.add(ClassHelper.make(AntlrParserPlugin.qualifiedName(implementNode)));
        }
        ClassNode[] interfaces = new ClassNode[]{};
        if (!interfaceList.isEmpty()) {
            interfaces = new ClassNode[interfaceList.size()];
            interfaceList.toArray(interfaces);
        }
        return interfaces;
    }

    protected Parameter[] parameters(AST parametersNode) {
        AST node = parametersNode.getFirstChild();
        if (node == null) {
            if (AntlrParserPlugin.isType(50, parametersNode)) {
                return Parameter.EMPTY_ARRAY;
            }
            return null;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        do {
            parameters.add(this.parameter(node));
        } while ((node = node.getNextSibling()) != null);
        Parameter[] answer = new Parameter[parameters.size()];
        parameters.toArray(answer);
        return answer;
    }

    protected Parameter parameter(AST paramNode) {
        ArrayList annotations = new ArrayList();
        AST node = paramNode.getFirstChild();
        int modifiers = 0;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            node = node.getNextSibling();
        }
        ClassNode type = ClassHelper.DYNAMIC_TYPE;
        if (AntlrParserPlugin.isType(12, node)) {
            type = this.makeType(node);
            node = node.getNextSibling();
        }
        String name = this.identifier(node);
        node = node.getNextSibling();
        VariableExpression leftExpression = new VariableExpression(name, type);
        this.configureAST(leftExpression, paramNode);
        Parameter parameter = null;
        if (node != null) {
            this.assertNodeType(120, node);
            Expression rightExpression = this.expression(node.getFirstChild());
            parameter = new Parameter(type, name, rightExpression);
        } else {
            parameter = new Parameter(type, name);
        }
        return parameter;
    }

    protected int modifiers(AST modifierNode, List annotations, int defaultModifiers) {
        this.assertNodeType(5, modifierNode);
        boolean access = false;
        int answer = 0;
        block14: for (AST node = modifierNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            int type = node.getType();
            switch (type) {
                case 66: {
                    annotations.add(this.annotation(node));
                    continue block14;
                }
                case 111: {
                    answer = this.setModifierBit(node, answer, 2);
                    access = this.setAccessTrue(node, access);
                    continue block14;
                }
                case 113: {
                    answer = this.setModifierBit(node, answer, 4);
                    access = this.setAccessTrue(node, access);
                    continue block14;
                }
                case 112: {
                    answer = this.setModifierBit(node, answer, 1);
                    access = this.setAccessTrue(node, access);
                    continue block14;
                }
                case 38: {
                    answer = this.setModifierBit(node, answer, 1024);
                    continue block14;
                }
                case 37: {
                    answer = this.setModifierBit(node, answer, 16);
                    continue block14;
                }
                case 115: {
                    answer = this.setModifierBit(node, answer, 256);
                    continue block14;
                }
                case 80: {
                    answer = this.setModifierBit(node, answer, 8);
                    continue block14;
                }
                case 42: {
                    answer = this.setModifierBit(node, answer, 2048);
                    continue block14;
                }
                case 117: {
                    answer = this.setModifierBit(node, answer, 32);
                    continue block14;
                }
                case 114: {
                    answer = this.setModifierBit(node, answer, 128);
                    continue block14;
                }
                case 118: {
                    answer = this.setModifierBit(node, answer, 64);
                    continue block14;
                }
                default: {
                    this.unknownAST(node);
                }
            }
        }
        if (!access) {
            answer |= defaultModifiers;
        }
        return answer;
    }

    protected boolean setAccessTrue(AST node, boolean access) {
        if (!access) {
            return true;
        }
        throw new ASTRuntimeException(node, "Cannot specify modifier: " + node.getText() + " when access scope has already been defined");
    }

    protected int setModifierBit(AST node, int answer, int bit) {
        if ((answer & bit) != 0) {
            throw new ASTRuntimeException(node, "Cannot repeat modifier: " + node.getText());
        }
        return answer | bit;
    }

    protected AnnotationNode annotation(AST annotationNode) {
        AST node = annotationNode.getFirstChild();
        String name = this.identifier(node);
        AnnotationNode annotatedNode = new AnnotationNode(ClassHelper.make(name));
        this.configureAST(annotatedNode, node);
        while (AntlrParserPlugin.isType(67, node = node.getNextSibling())) {
            AST memberNode = node.getFirstChild();
            String param = this.identifier(memberNode);
            Expression expression = this.expression(memberNode.getNextSibling());
            annotatedNode.addMember(param, expression);
        }
        return annotatedNode;
    }

    protected Statement statement(AST node) {
        Statement statement = null;
        int type = node.getType();
        switch (type) {
            case 7: 
            case 150: {
                statement = this.statementList(node);
                break;
            }
            case 26: {
                statement = this.methodCall(node);
                break;
            }
            case 9: {
                statement = this.variableDef(node);
                break;
            }
            case 21: {
                statement = this.labelledStatement(node);
                break;
            }
            case 145: {
                statement = this.assertStatement(node);
                break;
            }
            case 142: {
                statement = this.breakStatement(node);
                break;
            }
            case 143: {
                statement = this.continueStatement(node);
                break;
            }
            case 134: {
                statement = this.ifStatement(node);
                break;
            }
            case 139: {
                statement = this.forStatement(node);
                break;
            }
            case 141: {
                statement = this.returnStatement(node);
                break;
            }
            case 117: {
                statement = this.synchronizedStatement(node);
                break;
            }
            case 138: {
                statement = this.switchStatement(node);
                break;
            }
            case 137: {
                statement = this.withStatement(node);
                break;
            }
            case 149: {
                statement = this.tryStatement(node);
                break;
            }
            case 144: {
                statement = this.throwStatement(node);
                break;
            }
            case 136: {
                statement = this.whileStatement(node);
                break;
            }
            default: {
                statement = new ExpressionStatement(this.expression(node));
            }
        }
        if (statement != null) {
            this.configureAST(statement, node);
        }
        return statement;
    }

    protected Statement statementList(AST code) {
        return this.statementListNoChild(code.getFirstChild());
    }

    protected Statement statementListNoChild(AST node) {
        BlockStatement block = new BlockStatement();
        while (node != null) {
            block.addStatement(this.statement(node));
            node = node.getNextSibling();
        }
        return block;
    }

    protected Statement assertStatement(AST assertNode) {
        AST node = assertNode.getFirstChild();
        BooleanExpression booleanExpression = this.booleanExpression(node);
        Expression messageExpression = null;
        messageExpression = (node = node.getNextSibling()) != null ? this.expression(node) : ConstantExpression.NULL;
        AssertStatement assertStatement = new AssertStatement(booleanExpression, messageExpression);
        this.configureAST(assertStatement, assertNode);
        return assertStatement;
    }

    protected Statement breakStatement(AST node) {
        BreakStatement breakStatement = new BreakStatement(this.label(node));
        this.configureAST(breakStatement, node);
        return breakStatement;
    }

    protected Statement continueStatement(AST node) {
        ContinueStatement continueStatement = new ContinueStatement(this.label(node));
        this.configureAST(continueStatement, node);
        return continueStatement;
    }

    protected Statement forStatement(AST forNode) {
        this.assertNotLegacyFor(forNode);
        AST inNode = forNode.getFirstChild();
        AST variableNode = inNode.getFirstChild();
        AST collectionNode = variableNode.getNextSibling();
        ClassNode type = ClassHelper.OBJECT_TYPE;
        if (AntlrParserPlugin.isType(9, variableNode)) {
            AST typeNode = variableNode.getFirstChild();
            this.assertNodeType(12, typeNode);
            type = this.type(typeNode);
            variableNode = typeNode.getNextSibling();
        }
        String variable = this.identifier(variableNode);
        Expression collectionExpression = this.expression(collectionNode);
        Statement block = this.statement(inNode.getNextSibling());
        Parameter forParameter = new Parameter(type, variable);
        ForStatement forStatement = new ForStatement(forParameter, collectionExpression, block);
        this.configureAST(forStatement, forNode);
        return forStatement;
    }

    private void assertNotLegacyFor(AST forNode) {
        boolean legacy = false;
        for (AST childNode = forNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            int type = childNode.getType();
            if (type != 33 && type != 34 && type != 35) continue;
            legacy = true;
            break;
        }
        if (legacy) {
            throw new ASTRuntimeException(forNode, "For statement contains unexpected tokens. Possible attempt to use unsupported Java-style for loop.");
        }
    }

    protected Statement ifStatement(AST ifNode) {
        AST node = ifNode.getFirstChild();
        this.assertNodeType(27, node);
        BooleanExpression booleanExpression = this.booleanExpression(node);
        node = node.getNextSibling();
        Statement ifBlock = this.statement(node);
        Statement elseBlock = EmptyStatement.INSTANCE;
        node = node.getNextSibling();
        if (node != null) {
            elseBlock = this.statement(node);
        }
        IfStatement ifStatement = new IfStatement(booleanExpression, ifBlock, elseBlock);
        this.configureAST(ifStatement, ifNode);
        return ifStatement;
    }

    protected Statement labelledStatement(AST labelNode) {
        AST node = labelNode.getFirstChild();
        String label = this.identifier(node);
        Statement statement = this.statement(node.getNextSibling());
        statement.setStatementLabel(label);
        return statement;
    }

    protected Statement methodCall(AST code) {
        Expression expression = this.methodCallExpression(code);
        ExpressionStatement expressionStatement = new ExpressionStatement(expression);
        this.configureAST(expressionStatement, code);
        return expressionStatement;
    }

    protected Statement variableDef(AST variableDef) {
        AST node = variableDef.getFirstChild();
        ClassNode type = null;
        if (AntlrParserPlugin.isType(5, node)) {
            node = node.getNextSibling();
        }
        if (AntlrParserPlugin.isType(12, node)) {
            type = this.makeType(node);
            node = node.getNextSibling();
        }
        String name = this.identifier(node);
        node = node.getNextSibling();
        VariableExpression leftExpression = new VariableExpression(name, type);
        this.configureAST(leftExpression, variableDef);
        Expression rightExpression = ConstantExpression.NULL;
        if (node != null) {
            this.assertNodeType(120, node);
            rightExpression = this.expression(node.getFirstChild());
        }
        Token token = AntlrParserPlugin.makeToken(100, variableDef);
        DeclarationExpression expression = new DeclarationExpression(leftExpression, token, rightExpression);
        this.configureAST(expression, variableDef);
        ExpressionStatement expressionStatement = new ExpressionStatement(expression);
        this.configureAST(expressionStatement, variableDef);
        return expressionStatement;
    }

    protected Statement returnStatement(AST node) {
        AST exprNode = node.getFirstChild();
        if (exprNode != null) {
            ConstantExpression constantExpr;
            Expression expression = this.expression(exprNode);
            if (expression instanceof ConstantExpression && (constantExpr = (ConstantExpression)expression).getValue() == null) {
                return ReturnStatement.RETURN_NULL_OR_VOID;
            }
            ReturnStatement returnStatement = new ReturnStatement(expression);
            this.configureAST(returnStatement, node);
            return returnStatement;
        }
        return ReturnStatement.RETURN_NULL_OR_VOID;
    }

    protected Statement switchStatement(AST switchNode) {
        AST node = switchNode.getFirstChild();
        Expression expression = this.expression(node);
        Statement defaultStatement = EmptyStatement.INSTANCE;
        ArrayList<CaseStatement> list = new ArrayList<CaseStatement>();
        node = node.getNextSibling();
        while (AntlrParserPlugin.isType(31, node)) {
            AST child = node.getFirstChild();
            if (AntlrParserPlugin.isType(148, child)) {
                list.add(this.caseStatement(child));
            } else {
                defaultStatement = this.statement(child.getNextSibling());
            }
            node = node.getNextSibling();
        }
        if (node != null) {
            this.unknownAST(node);
        }
        SwitchStatement switchStatement = new SwitchStatement(expression, list, defaultStatement);
        this.configureAST(switchStatement, switchNode);
        return switchStatement;
    }

    protected CaseStatement caseStatement(AST node) {
        CaseStatement answer;
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        Statement statement = EmptyStatement.INSTANCE;
        AST nextSibling = node;
        do {
            Expression expression = this.expression(nextSibling.getFirstChild());
            expressions.add(expression);
        } while (AntlrParserPlugin.isType(148, nextSibling = nextSibling.getNextSibling()));
        if (!AntlrParserPlugin.isType(126, nextSibling) && nextSibling != null) {
            statement = this.statement(nextSibling);
        }
        if (expressions.size() == 1) {
            answer = new CaseStatement((Expression)expressions.get(0), statement);
        } else {
            ListExpression listExpression = new ListExpression(expressions);
            answer = new CaseStatement(listExpression, statement);
        }
        this.configureAST(answer, node);
        return answer;
    }

    protected Statement synchronizedStatement(AST syncNode) {
        AST node = syncNode.getFirstChild();
        Expression expression = this.expression(node);
        Statement code = this.statement(node.getNextSibling());
        SynchronizedStatement synchronizedStatement = new SynchronizedStatement(expression, code);
        this.configureAST(synchronizedStatement, syncNode);
        return synchronizedStatement;
    }

    protected Statement throwStatement(AST node) {
        AST expressionNode = node.getFirstChild();
        if (expressionNode == null) {
            expressionNode = node.getNextSibling();
        }
        if (expressionNode == null) {
            throw new ASTRuntimeException(node, "No expression available");
        }
        ThrowStatement throwStatement = new ThrowStatement(this.expression(expressionNode));
        this.configureAST(throwStatement, node);
        return throwStatement;
    }

    protected Statement tryStatement(AST tryStatementNode) {
        AST node;
        AST tryNode = tryStatementNode.getFirstChild();
        Statement tryStatement = this.statement(tryNode);
        Statement finallyStatement = EmptyStatement.INSTANCE;
        ArrayList<CatchStatement> catches = new ArrayList<CatchStatement>();
        for (node = tryNode.getNextSibling(); node != null && AntlrParserPlugin.isType(151, node); node = node.getNextSibling()) {
            catches.add(this.catchStatement(node));
        }
        if (AntlrParserPlugin.isType(150, node)) {
            finallyStatement = this.statement(node);
            node = node.getNextSibling();
        }
        TryCatchStatement tryCatchStatement = new TryCatchStatement(tryStatement, finallyStatement);
        this.configureAST(tryCatchStatement, tryStatementNode);
        Iterator iter = catches.iterator();
        while (iter.hasNext()) {
            CatchStatement statement = (CatchStatement)iter.next();
            tryCatchStatement.addCatch(statement);
        }
        return tryCatchStatement;
    }

    protected CatchStatement catchStatement(AST catchNode) {
        AST node = catchNode.getFirstChild();
        Parameter parameter = this.parameter(node);
        ClassNode exceptionType = parameter.getType();
        String variable = parameter.getName();
        node = node.getNextSibling();
        Statement code = this.statement(node);
        Parameter catchParameter = new Parameter(exceptionType, variable);
        CatchStatement answer = new CatchStatement(catchParameter, code);
        this.configureAST(answer, catchNode);
        return answer;
    }

    protected Statement whileStatement(AST whileNode) {
        AST node = whileNode.getFirstChild();
        this.assertNodeType(27, node);
        BooleanExpression booleanExpression = this.booleanExpression(node);
        node = node.getNextSibling();
        Statement block = this.statement(node);
        WhileStatement whileStatement = new WhileStatement(booleanExpression, block);
        this.configureAST(whileStatement, whileNode);
        return whileStatement;
    }

    protected Statement withStatement(AST node) {
        this.notImplementedYet(node);
        return null;
    }

    protected Expression expression(AST node) {
        return this.expression(node, false);
    }

    protected Expression expression(AST node, boolean convertToConstant) {
        Expression expression = this.expressionSwitch(node);
        if (convertToConstant && expression != VariableExpression.THIS_EXPRESSION && expression != VariableExpression.SUPER_EXPRESSION && expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            expression = new ConstantExpression(ve.getName());
        }
        this.configureAST(expression, node);
        return expression;
    }

    protected Expression expressionSwitch(AST node) {
        int type = node.getType();
        switch (type) {
            case 27: {
                return this.expression(node.getFirstChild());
            }
            case 32: {
                return this.expressionList(node);
            }
            case 7: {
                return this.blockExpression(node);
            }
            case 49: {
                return this.closureExpression(node);
            }
            case 43: {
                return this.specialConstructorCallExpression(node, ClassNode.SUPER);
            }
            case 26: {
                return this.methodCallExpression(node);
            }
            case 192: {
                return this.constructorCallExpression(node.getFirstChild());
            }
            case 44: {
                return this.specialConstructorCallExpression(node, ClassNode.THIS);
            }
            case 91: {
                return this.ternaryExpression(node);
            }
            case 86: 
            case 152: 
            case 153: {
                return this.dotExpression(node);
            }
            case 83: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return this.variableExpression(node);
            }
            case 57: {
                return this.listExpression(node);
            }
            case 58: {
                return this.mapExpression(node);
            }
            case 53: {
                return this.mapEntryExpression(node);
            }
            case 54: {
                return this.spreadExpression(node);
            }
            case 55: {
                return this.spreadMapExpression(node);
            }
            case 154: {
                return this.methodPointerExpression(node);
            }
            case 23: {
                return this.indexExpression(node);
            }
            case 178: {
                return this.instanceofExpression(node);
            }
            case 110: {
                return this.asExpression(node);
            }
            case 22: {
                return this.castExpression(node);
            }
            case 193: {
                return ConstantExpression.TRUE;
            }
            case 194: {
                return ConstantExpression.FALSE;
            }
            case 195: {
                return ConstantExpression.NULL;
            }
            case 130: {
                ConstantExpression constantExpression = new ConstantExpression(node.getText());
                this.configureAST(constantExpression, node);
                return constantExpression;
            }
            case 47: {
                return this.gstring(node);
            }
            case 197: 
            case 199: 
            case 201: {
                return this.decimalExpression(node);
            }
            case 196: 
            case 198: 
            case 200: {
                return this.integerExpression(node);
            }
            case 129: {
                return VariableExpression.THIS_EXPRESSION;
            }
            case 93: {
                return VariableExpression.SUPER_EXPRESSION;
            }
            case 188: {
                NotExpression notExpression = new NotExpression(this.expression(node.getFirstChild()));
                this.configureAST(notExpression, node);
                return notExpression;
            }
            case 29: {
                return this.negateExpression(node);
            }
            case 187: {
                BitwiseNegExpression bitwiseNegExpression = new BitwiseNegExpression(this.expression(node.getFirstChild()));
                this.configureAST(bitwiseNegExpression, node);
                return bitwiseNegExpression;
            }
            case 30: {
                return this.expression(node.getFirstChild());
            }
            case 182: {
                return this.prefixExpression(node, 250);
            }
            case 185: {
                return this.prefixExpression(node, 260);
            }
            case 24: {
                return this.postfixExpression(node, 250);
            }
            case 25: {
                return this.postfixExpression(node, 260);
            }
            case 120: {
                return this.binaryExpression(100, node);
            }
            case 174: {
                return this.binaryExpression(123, node);
            }
            case 173: {
                return this.binaryExpression(120, node);
            }
            case 175: {
                return this.binaryExpression(128, node);
            }
            case 176: {
                return this.binaryExpression(125, node);
            }
            case 94: {
                return this.binaryExpression(124, node);
            }
            case 96: {
                return this.binaryExpression(126, node);
            }
            case 177: {
                return this.binaryExpression(127, node);
            }
            case 168: {
                return this.binaryExpression(164, node);
            }
            case 167: {
                return this.binaryExpression(162, node);
            }
            case 121: {
                return this.binaryExpression(341, node);
            }
            case 163: {
                return this.binaryExpression(351, node);
            }
            case 169: {
                return this.binaryExpression(340, node);
            }
            case 165: {
                return this.binaryExpression(350, node);
            }
            case 170: {
                return this.binaryExpression(342, node);
            }
            case 164: {
                return this.binaryExpression(352, node);
            }
            case 146: {
                return this.binaryExpression(200, node);
            }
            case 155: {
                return this.binaryExpression(210, node);
            }
            case 147: {
                return this.binaryExpression(201, node);
            }
            case 156: {
                return this.binaryExpression(211, node);
            }
            case 109: {
                return this.binaryExpression(202, node);
            }
            case 157: {
                return this.binaryExpression(212, node);
            }
            case 186: {
                return this.binaryExpression(206, node);
            }
            case 166: {
                return this.binaryExpression(216, node);
            }
            case 183: {
                return this.binaryExpression(203, node);
            }
            case 158: {
                return this.binaryExpression(213, node);
            }
            case 184: {
                return this.binaryExpression(205, node);
            }
            case 159: {
                return this.binaryExpression(215, node);
            }
            case 179: {
                return this.binaryExpression(280, node);
            }
            case 162: {
                return this.binaryExpression(285, node);
            }
            case 97: {
                return this.binaryExpression(281, node);
            }
            case 160: {
                return this.binaryExpression(286, node);
            }
            case 98: {
                return this.binaryExpression(282, node);
            }
            case 161: {
                return this.binaryExpression(287, node);
            }
            case 171: {
                return this.binaryExpression(90, node);
            }
            case 172: {
                return this.binaryExpression(94, node);
            }
            case 180: {
                return this.rangeExpression(node, true);
            }
            case 181: {
                return this.rangeExpression(node, false);
            }
            case 52: {
                return this.dynamicMemberExpression(node);
            }
            case 140: {
                return this.binaryExpression(573, node);
            }
        }
        this.unknownAST(node);
        return null;
    }

    protected Expression dynamicMemberExpression(AST dynamicMemberNode) {
        AST node = dynamicMemberNode.getFirstChild();
        return this.expression(node);
    }

    protected Expression ternaryExpression(AST ternaryNode) {
        AST node = ternaryNode.getFirstChild();
        BooleanExpression booleanExpression = this.booleanExpression(node);
        node = node.getNextSibling();
        Expression left = this.expression(node);
        Expression right = this.expression(node.getNextSibling());
        TernaryExpression ternaryExpression = new TernaryExpression(booleanExpression, left, right);
        this.configureAST(ternaryExpression, ternaryNode);
        return ternaryExpression;
    }

    protected Expression variableExpression(AST node) {
        String text = node.getText();
        VariableExpression variableExpression = new VariableExpression(text);
        this.configureAST(variableExpression, node);
        return variableExpression;
    }

    protected Expression rangeExpression(AST rangeNode, boolean inclusive) {
        AST node = rangeNode.getFirstChild();
        Expression left = this.expression(node);
        Expression right = this.expression(node.getNextSibling());
        RangeExpression rangeExpression = new RangeExpression(left, right, inclusive);
        this.configureAST(rangeExpression, rangeNode);
        return rangeExpression;
    }

    protected Expression spreadExpression(AST node) {
        AST exprNode = node.getFirstChild();
        AST listNode = exprNode.getFirstChild();
        Expression right = this.expression(listNode);
        SpreadExpression spreadExpression = new SpreadExpression(right);
        this.configureAST(spreadExpression, node);
        return spreadExpression;
    }

    protected Expression spreadMapExpression(AST node) {
        AST exprNode = node.getFirstChild();
        Expression expr = this.expression(exprNode);
        SpreadMapExpression spreadMapExpression = new SpreadMapExpression(expr);
        this.configureAST(spreadMapExpression, node);
        return spreadMapExpression;
    }

    protected Expression methodPointerExpression(AST node) {
        AST exprNode = node.getFirstChild();
        String methodName = this.identifier(exprNode.getNextSibling());
        Expression expression = this.expression(exprNode);
        MethodPointerExpression methodPointerExpression = new MethodPointerExpression(expression, methodName);
        this.configureAST(methodPointerExpression, node);
        return methodPointerExpression;
    }

    protected Expression listExpression(AST listNode) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        AST elist = listNode.getFirstChild();
        this.assertNodeType(32, elist);
        for (AST node = elist.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case 53: {
                    this.assertNodeType(95, node);
                    break;
                }
                case 55: {
                    this.assertNodeType(54, node);
                }
            }
            expressions.add(this.expression(node));
        }
        ListExpression listExpression = new ListExpression(expressions);
        this.configureAST(listExpression, listNode);
        return listExpression;
    }

    protected Expression mapExpression(AST mapNode) {
        ArrayList<MapEntryExpression> expressions = new ArrayList<MapEntryExpression>();
        AST elist = mapNode.getFirstChild();
        if (elist != null) {
            this.assertNodeType(32, elist);
            for (AST node = elist.getFirstChild(); node != null; node = node.getNextSibling()) {
                switch (node.getType()) {
                    case 53: 
                    case 55: {
                        break;
                    }
                    case 54: {
                        this.assertNodeType(55, node);
                        break;
                    }
                    default: {
                        this.assertNodeType(53, node);
                    }
                }
                expressions.add(this.mapEntryExpression(node));
            }
        }
        MapExpression mapExpression = new MapExpression(expressions);
        this.configureAST(mapExpression, mapNode);
        return mapExpression;
    }

    protected MapEntryExpression mapEntryExpression(AST node) {
        if (node.getType() == 55) {
            AST rightNode = node.getFirstChild();
            Expression keyExpression = this.spreadMapExpression(node);
            Expression rightExpression = this.expression(rightNode);
            MapEntryExpression mapEntryExpression = new MapEntryExpression(keyExpression, rightExpression);
            this.configureAST(mapEntryExpression, node);
            return mapEntryExpression;
        }
        AST keyNode = node.getFirstChild();
        Expression keyExpression = this.expression(keyNode);
        AST valueNode = keyNode.getNextSibling();
        Expression valueExpression = this.expression(valueNode);
        MapEntryExpression mapEntryExpression = new MapEntryExpression(keyExpression, valueExpression);
        this.configureAST(mapEntryExpression, node);
        return mapEntryExpression;
    }

    protected Expression instanceofExpression(AST node) {
        AST leftNode = node.getFirstChild();
        Expression leftExpression = this.expression(leftNode);
        AST rightNode = leftNode.getNextSibling();
        ClassNode type = this.buildName(rightNode);
        this.assertTypeNotNull(type, rightNode);
        ClassExpression rightExpression = new ClassExpression(type);
        this.configureAST(rightExpression, rightNode);
        BinaryExpression binaryExpression = new BinaryExpression(leftExpression, AntlrParserPlugin.makeToken(544, node), rightExpression);
        this.configureAST(binaryExpression, node);
        return binaryExpression;
    }

    protected void assertTypeNotNull(ClassNode type, AST rightNode) {
        if (type == null) {
            throw new ASTRuntimeException(rightNode, "No type available for: " + AntlrParserPlugin.qualifiedName(rightNode));
        }
    }

    protected Expression asExpression(AST node) {
        AST leftNode = node.getFirstChild();
        Expression leftExpression = this.expression(leftNode);
        AST rightNode = leftNode.getNextSibling();
        ClassNode type = this.buildName(rightNode);
        return CastExpression.asExpression(type, leftExpression);
    }

    protected Expression castExpression(AST castNode) {
        AST node = castNode.getFirstChild();
        ClassNode type = this.buildName(node);
        this.assertTypeNotNull(type, node);
        AST expressionNode = node.getNextSibling();
        Expression expression = this.expression(expressionNode);
        CastExpression castExpression = new CastExpression(type, expression);
        this.configureAST(castExpression, castNode);
        return castExpression;
    }

    protected Expression indexExpression(AST indexNode) {
        AST leftNode = indexNode.getFirstChild();
        Expression leftExpression = this.expression(leftNode);
        AST rightNode = leftNode.getNextSibling();
        Expression rightExpression = this.expression(rightNode);
        BinaryExpression binaryExpression = new BinaryExpression(leftExpression, AntlrParserPlugin.makeToken(30, indexNode), rightExpression);
        this.configureAST(binaryExpression, indexNode);
        return binaryExpression;
    }

    protected Expression binaryExpression(int type, AST node) {
        Token token = AntlrParserPlugin.makeToken(type, node);
        AST leftNode = node.getFirstChild();
        Expression leftExpression = this.expression(leftNode);
        AST rightNode = leftNode.getNextSibling();
        if (rightNode == null) {
            return leftExpression;
        }
        if (!(!Types.ofType(type, 1100) || leftExpression instanceof VariableExpression || leftExpression.getClass() == PropertyExpression.class || leftExpression instanceof FieldExpression || leftExpression instanceof AttributeExpression || leftExpression instanceof DeclarationExpression)) {
            if (leftExpression instanceof ConstantExpression) {
                throw new ASTRuntimeException(node, "\n[" + ((ConstantExpression)leftExpression).getValue() + "] is a constant expression, but it should be a variable expression");
            }
            if (leftExpression instanceof BinaryExpression) {
                Expression leftexp = ((BinaryExpression)leftExpression).getLeftExpression();
                int lefttype = ((BinaryExpression)leftExpression).getOperation().getType();
                if (!Types.ofType(lefttype, 1100) && lefttype != 30) {
                    throw new ASTRuntimeException(node, "\n" + ((BinaryExpression)leftExpression).getText() + " is a binary expression, but it should be a variable expression");
                }
            } else {
                if (leftExpression instanceof GStringExpression) {
                    throw new ASTRuntimeException(node, "\n\"" + ((GStringExpression)leftExpression).getText() + "\" is a GString expression, but it should be a variable expression");
                }
                if (leftExpression instanceof MethodCallExpression) {
                    throw new ASTRuntimeException(node, "\n\"" + ((MethodCallExpression)leftExpression).getText() + "\" is a method call expression, but it should be a variable expression");
                }
                if (leftExpression instanceof MapExpression) {
                    throw new ASTRuntimeException(node, "\n'" + ((MapExpression)leftExpression).getText() + "' is a map expression, but it should be a variable expression");
                }
                throw new ASTRuntimeException(node, "\n" + leftExpression.getClass() + ", with its value '" + leftExpression.getText() + "', is a bad expression as the LSH of an assignment operator");
            }
        }
        Expression rightExpression = this.expression(rightNode);
        BinaryExpression binaryExpression = new BinaryExpression(leftExpression, token, rightExpression);
        this.configureAST(binaryExpression, node);
        return binaryExpression;
    }

    protected Expression prefixExpression(AST node, int token) {
        Expression expression = this.expression(node.getFirstChild());
        PrefixExpression prefixExpression = new PrefixExpression(AntlrParserPlugin.makeToken(token, node), expression);
        this.configureAST(prefixExpression, node);
        return prefixExpression;
    }

    protected Expression postfixExpression(AST node, int token) {
        Expression expression = this.expression(node.getFirstChild());
        PostfixExpression postfixExpression = new PostfixExpression(expression, AntlrParserPlugin.makeToken(token, node));
        this.configureAST(postfixExpression, node);
        return postfixExpression;
    }

    protected BooleanExpression booleanExpression(AST node) {
        BooleanExpression booleanExpression = new BooleanExpression(this.expression(node));
        this.configureAST(booleanExpression, node);
        return booleanExpression;
    }

    protected Expression dotExpression(AST node) {
        AST identifierNode;
        AST leftNode = node.getFirstChild();
        if (leftNode != null && (identifierNode = leftNode.getNextSibling()) != null) {
            Expression leftExpression = this.expression(leftNode);
            if (AntlrParserPlugin.isType(51, identifierNode)) {
                Expression field = this.expression(identifierNode.getFirstChild(), true);
                AttributeExpression attributeExpression = new AttributeExpression(leftExpression, field, node.getType() != 86);
                if (node.getType() == 152) {
                    attributeExpression.setSpreadSafe(true);
                }
                this.configureAST(attributeExpression, node);
                return attributeExpression;
            }
            Expression property = this.expression(identifierNode, true);
            PropertyExpression propertyExpression = new PropertyExpression(leftExpression, property, node.getType() != 86);
            if (node.getType() == 152) {
                propertyExpression.setSpreadSafe(true);
            }
            this.configureAST(propertyExpression, node);
            return propertyExpression;
        }
        return this.methodCallExpression(node);
    }

    protected Expression specialConstructorCallExpression(AST methodCallNode, ClassNode special) {
        AST node = methodCallNode.getFirstChild();
        Expression arguments = this.arguments(node);
        ConstructorCallExpression expression = new ConstructorCallExpression(special, arguments);
        this.configureAST(expression, methodCallNode);
        return expression;
    }

    private int getTypeInParenthesis(AST node) {
        if (!AntlrParserPlugin.isType(27, node)) {
            node = node.getFirstChild();
        }
        while (node != null && AntlrParserPlugin.isType(27, node) && node.getNextSibling() == null) {
            node = node.getFirstChild();
        }
        if (node == null) {
            return -1;
        }
        return node.getType();
    }

    protected Expression methodCallExpression(AST methodCallNode) {
        AST selector;
        Expression objectExpression;
        AST node = methodCallNode.getFirstChild();
        AST elist = node.getNextSibling();
        boolean implicitThis = false;
        boolean safe = AntlrParserPlugin.isType(153, node);
        boolean spreadSafe = AntlrParserPlugin.isType(152, node);
        if (AntlrParserPlugin.isType(86, node) || safe || spreadSafe) {
            AST objectNode = node.getFirstChild();
            objectExpression = this.expression(objectNode);
            selector = objectNode.getNextSibling();
        } else {
            implicitThis = true;
            objectExpression = VariableExpression.THIS_EXPRESSION;
            selector = node;
        }
        Expression name = null;
        if (AntlrParserPlugin.isType(93, selector)) {
            implicitThis = true;
            name = new ConstantExpression("super");
            if (objectExpression == VariableExpression.THIS_EXPRESSION) {
                objectExpression = VariableExpression.SUPER_EXPRESSION;
            }
        } else {
            if (this.isPrimitiveTypeLiteral(selector)) {
                throw new ASTRuntimeException(selector, "Primitive type literal: " + selector.getText() + " cannot be used as a method name");
            }
            if (AntlrParserPlugin.isType(51, selector)) {
                Expression field = this.expression(selector.getFirstChild(), true);
                AttributeExpression attributeExpression = new AttributeExpression(objectExpression, field, node.getType() != 86);
                this.configureAST(attributeExpression, node);
                Expression arguments = this.arguments(elist);
                MethodCallExpression expression = new MethodCallExpression((Expression)attributeExpression, "call", arguments);
                this.configureAST(expression, methodCallNode);
                return expression;
            }
            if (AntlrParserPlugin.isType(52, selector) || AntlrParserPlugin.isType(83, selector) || AntlrParserPlugin.isType(47, selector) || AntlrParserPlugin.isType(130, selector)) {
                name = this.expression(selector, true);
            } else {
                implicitThis = false;
                name = new ConstantExpression("call");
                objectExpression = this.expression(selector, true);
            }
        }
        Expression arguments = this.arguments(elist);
        MethodCallExpression expression = new MethodCallExpression(objectExpression, name, arguments);
        expression.setSafe(safe);
        expression.setSpreadSafe(spreadSafe);
        expression.setImplicitThis(implicitThis);
        Expression ret = expression;
        if (implicitThis && "this".equals(expression.getMethodAsString())) {
            ret = new ConstructorCallExpression(this.classNode, arguments);
        }
        this.configureAST(ret, methodCallNode);
        return ret;
    }

    protected Expression constructorCallExpression(AST node) {
        AST elist;
        AST constructorCallNode = node;
        ClassNode type = this.buildName(constructorCallNode);
        if (AntlrParserPlugin.isType(44, node) || AntlrParserPlugin.isType(192, node)) {
            node = node.getFirstChild();
        }
        if ((elist = node.getNextSibling()) == null && AntlrParserPlugin.isType(32, node)) {
            elist = node;
            if ("(".equals(type.getName())) {
                type = this.classNode;
            }
        }
        if (AntlrParserPlugin.isType(16, elist)) {
            AST expressionNode = elist.getFirstChild();
            if (expressionNode == null) {
                throw new ASTRuntimeException(elist, "No expression for the array constructor call");
            }
            List size = this.arraySizeExpression(expressionNode);
            ArrayExpression arrayExpression = new ArrayExpression(type, null, size);
            this.configureAST(arrayExpression, constructorCallNode);
            return arrayExpression;
        }
        Expression arguments = this.arguments(elist);
        ConstructorCallExpression expression = new ConstructorCallExpression(type, arguments);
        this.configureAST(expression, constructorCallNode);
        return expression;
    }

    protected List arraySizeExpression(AST node) {
        List<Expression> list;
        Expression size = null;
        if (AntlrParserPlugin.isType(16, node)) {
            AST right = node.getNextSibling();
            size = right != null ? this.expression(right) : ConstantExpression.EMTPY_EXPRESSION;
            list = this.arraySizeExpression(node.getFirstChild());
        } else {
            size = this.expression(node);
            list = new ArrayList<Expression>();
        }
        list.add(size);
        return list;
    }

    protected Expression arguments(AST elist) {
        ArrayList expressionList = new ArrayList();
        boolean namedArguments = false;
        for (AST node = elist; node != null; node = node.getNextSibling()) {
            if (AntlrParserPlugin.isType(32, node)) {
                for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    namedArguments |= this.addArgumentExpression(child, expressionList);
                }
                continue;
            }
            namedArguments |= this.addArgumentExpression(node, expressionList);
        }
        if (namedArguments) {
            if (!expressionList.isEmpty()) {
                ArrayList<Expression> argumentList = new ArrayList<Expression>();
                Iterator iter = expressionList.iterator();
                while (iter.hasNext()) {
                    Expression expression = (Expression)iter.next();
                    if (expression instanceof MapEntryExpression) continue;
                    argumentList.add(expression);
                }
                if (!argumentList.isEmpty()) {
                    expressionList.removeAll(argumentList);
                    MapExpression mapExpression = new MapExpression(expressionList);
                    this.configureAST(mapExpression, elist);
                    argumentList.add(0, mapExpression);
                    ArgumentListExpression argumentListExpression = new ArgumentListExpression(argumentList);
                    this.configureAST(argumentListExpression, elist);
                    return argumentListExpression;
                }
            }
            NamedArgumentListExpression namedArgumentListExpression = new NamedArgumentListExpression(expressionList);
            this.configureAST(namedArgumentListExpression, elist);
            return namedArgumentListExpression;
        }
        ArgumentListExpression argumentListExpression = new ArgumentListExpression(expressionList);
        this.configureAST(argumentListExpression, elist);
        return argumentListExpression;
    }

    protected boolean addArgumentExpression(AST node, List expressionList) {
        if (node.getType() == 55) {
            AST rightNode = node.getFirstChild();
            Expression keyExpression = this.spreadMapExpression(node);
            Expression rightExpression = this.expression(rightNode);
            MapEntryExpression mapEntryExpression = new MapEntryExpression(keyExpression, rightExpression);
            expressionList.add(mapEntryExpression);
            return true;
        }
        Expression expression = this.expression(node);
        expressionList.add(expression);
        return expression instanceof MapEntryExpression;
    }

    protected Expression expressionList(AST node) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            expressionList.add(this.expression(child));
        }
        if (expressionList.size() == 1) {
            return (Expression)expressionList.get(0);
        }
        ListExpression listExpression = new ListExpression(expressionList);
        this.configureAST(listExpression, node);
        return listExpression;
    }

    protected ClosureExpression closureExpression(AST node) {
        AST paramNode = node.getFirstChild();
        Parameter[] parameters = null;
        AST codeNode = paramNode;
        if (AntlrParserPlugin.isType(19, paramNode) || AntlrParserPlugin.isType(50, paramNode)) {
            parameters = this.parameters(paramNode);
            codeNode = paramNode.getNextSibling();
        }
        Statement code = this.statementListNoChild(codeNode);
        ClosureExpression closureExpression = new ClosureExpression(parameters, code);
        this.configureAST(closureExpression, node);
        return closureExpression;
    }

    protected Expression blockExpression(AST node) {
        AST codeNode = node.getFirstChild();
        if (codeNode == null) {
            return ConstantExpression.NULL;
        }
        if (codeNode.getType() == 27 && codeNode.getNextSibling() == null) {
            return this.expression(codeNode);
        }
        Parameter[] parameters = Parameter.EMPTY_ARRAY;
        Statement code = this.statementListNoChild(codeNode);
        ClosureExpression closureExpression = new ClosureExpression(parameters, code);
        this.configureAST(closureExpression, node);
        String callName = "call";
        ArgumentListExpression noArguments = new ArgumentListExpression();
        MethodCallExpression call = new MethodCallExpression((Expression)closureExpression, callName, (Expression)noArguments);
        this.configureAST(call, node);
        return call;
    }

    protected Expression negateExpression(AST negateExpr) {
        AST node = negateExpr.getFirstChild();
        String text = node.getText();
        switch (node.getType()) {
            case 197: 
            case 199: 
            case 201: {
                ConstantExpression constantExpression = new ConstantExpression(Numbers.parseDecimal("-" + text));
                this.configureAST(constantExpression, negateExpr);
                return constantExpression;
            }
            case 196: 
            case 198: 
            case 200: {
                ConstantExpression constantLongExpression = new ConstantExpression(Numbers.parseInteger("-" + text));
                this.configureAST(constantLongExpression, negateExpr);
                return constantLongExpression;
            }
        }
        NegationExpression negationExpression = new NegationExpression(this.expression(node));
        this.configureAST(negationExpression, negateExpr);
        return negationExpression;
    }

    protected ConstantExpression decimalExpression(AST node) {
        String text = node.getText();
        ConstantExpression constantExpression = new ConstantExpression(Numbers.parseDecimal(text));
        this.configureAST(constantExpression, node);
        return constantExpression;
    }

    protected ConstantExpression integerExpression(AST node) {
        String text = node.getText();
        ConstantExpression constantExpression = new ConstantExpression(Numbers.parseInteger(text));
        this.configureAST(constantExpression, node);
        return constantExpression;
    }

    protected Expression gstring(AST gstringNode) {
        ArrayList<ConstantExpression> strings = new ArrayList<ConstantExpression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        StringBuffer buffer = new StringBuffer();
        boolean isPrevString = false;
        block3: for (AST node = gstringNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            int type = node.getType();
            String text = null;
            switch (type) {
                case 130: {
                    if (isPrevString) {
                        this.assertNodeType(83, node);
                    }
                    isPrevString = true;
                    text = node.getText();
                    ConstantExpression constantExpression = new ConstantExpression(text);
                    this.configureAST(constantExpression, node);
                    strings.add(constantExpression);
                    buffer.append(text);
                    continue block3;
                }
                default: {
                    if (!isPrevString) {
                        this.assertNodeType(83, node);
                    }
                    isPrevString = false;
                    Expression expression = this.expression(node);
                    values.add(expression);
                    buffer.append("$");
                    buffer.append(expression.getText());
                }
            }
        }
        GStringExpression gStringExpression = new GStringExpression(buffer.toString(), strings, values);
        this.configureAST(gStringExpression, gstringNode);
        return gStringExpression;
    }

    protected ClassNode type(AST typeNode) {
        return this.buildName(typeNode.getFirstChild());
    }

    public static String qualifiedName(AST qualifiedNameNode) {
        if (AntlrParserPlugin.isType(83, qualifiedNameNode)) {
            return qualifiedNameNode.getText();
        }
        if (AntlrParserPlugin.isType(86, qualifiedNameNode)) {
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (AST node = qualifiedNameNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(".");
                }
                buffer.append(AntlrParserPlugin.qualifiedName(node));
            }
            return buffer.toString();
        }
        return qualifiedNameNode.getText();
    }

    protected ClassNode makeType(AST typeNode) {
        ClassNode answer = ClassHelper.DYNAMIC_TYPE;
        AST node = typeNode.getFirstChild();
        if (node != null) {
            if (AntlrParserPlugin.isType(23, node) || AntlrParserPlugin.isType(16, node)) {
                return this.makeType(node).makeArray();
            }
            return ClassHelper.make(AntlrParserPlugin.qualifiedName(node));
        }
        return answer;
    }

    protected ClassNode buildName(AST node) {
        if (AntlrParserPlugin.isType(12, node)) {
            node = node.getFirstChild();
        }
        ClassNode answer = null;
        if (AntlrParserPlugin.isType(86, node) || AntlrParserPlugin.isType(153, node)) {
            answer = ClassHelper.make(AntlrParserPlugin.qualifiedName(node));
        } else if (this.isPrimitiveTypeLiteral(node)) {
            answer = ClassHelper.make(node.getText());
        } else {
            if (AntlrParserPlugin.isType(23, node) || AntlrParserPlugin.isType(16, node)) {
                AST child = node.getFirstChild();
                return this.buildName(child).makeArray();
            }
            String identifier = node.getText();
            answer = ClassHelper.make(identifier);
        }
        AST nextSibling = node.getNextSibling();
        if (AntlrParserPlugin.isType(23, nextSibling) || AntlrParserPlugin.isType(16, node)) {
            return answer.makeArray();
        }
        return answer;
    }

    protected boolean isPrimitiveTypeLiteral(AST node) {
        int type = node.getType();
        switch (type) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return true;
            }
        }
        return false;
    }

    protected String identifier(AST node) {
        this.assertNodeType(83, node);
        return node.getText();
    }

    protected String label(AST labelNode) {
        AST node = labelNode.getFirstChild();
        if (node == null) {
            return null;
        }
        return this.identifier(node);
    }

    protected boolean hasVisibility(int modifiers) {
        return (modifiers & 7) != 0;
    }

    protected void configureAST(ASTNode node, AST ast) {
        if (ast == null) {
            throw new ASTRuntimeException(ast, "PARSER BUG: Tried to configure " + node.getClass().getName() + " with null Node");
        }
        node.setColumnNumber(ast.getColumn());
        node.setLineNumber(ast.getLine());
        if (ast instanceof GroovySourceAST) {
            node.setLastColumnNumber(((GroovySourceAST)ast).getColumnLast());
            node.setLastLineNumber(((GroovySourceAST)ast).getLineLast());
        }
    }

    protected static Token makeToken(int typeCode, AST node) {
        return Token.newSymbol(typeCode, node.getLine(), node.getColumn());
    }

    protected String getFirstChildText(AST node) {
        AST child = node.getFirstChild();
        return child != null ? child.getText() : null;
    }

    public static boolean isType(int typeCode, AST node) {
        return node != null && node.getType() == typeCode;
    }

    private String getTokenName(int token) {
        if (this.tokenNames == null) {
            return "" + token;
        }
        return this.tokenNames[token];
    }

    private String getTokenName(AST node) {
        if (node == null) {
            return "null";
        }
        return this.getTokenName(node.getType());
    }

    protected void assertNodeType(int type, AST node) {
        if (node == null) {
            throw new ASTRuntimeException(node, "No child node available in AST when expecting type: " + this.getTokenName(type));
        }
        if (node.getType() != type) {
            throw new ASTRuntimeException(node, "Unexpected node type: " + this.getTokenName(node) + " found when expecting type: " + this.getTokenName(type));
        }
    }

    protected void notImplementedYet(AST node) {
        throw new ASTRuntimeException(node, "AST node not implemented yet for type: " + this.getTokenName(node));
    }

    protected void unknownAST(AST node) {
        if (node.getType() == 13) {
            throw new ASTRuntimeException(node, "Class definition not expected here. Possible attempt to use inner class. Inner classes not supported, perhaps try using a closure instead.");
        }
        throw new ASTRuntimeException(node, "Unknown type: " + this.getTokenName(node));
    }

    protected void dumpTree(AST ast) {
        for (AST node = ast.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.dump(node);
        }
    }

    protected void dump(AST node) {
        System.out.println("Type: " + this.getTokenName(node) + " text: " + node.getText());
    }
}

