/*
**  CWLocalCacheManager.m
**
**  Copyright (c) 2001-2004
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/CWLocalCacheManager.h>

#include <Pantomime/CWConstants.h>
#include <Pantomime/CWLocalFolder.h>
#include <Pantomime/CWLocalMessage.h>

#include <Foundation/NSArchiver.h>
#include <Foundation/NSException.h>
#include <Foundation/NSFileManager.h>
#include <Foundation/NSValue.h>


//
//
//
@implementation CWLocalCacheManager

- (id) initWithPath: (NSString *) thePath
{
  self = [super initWithPath: thePath];
  
  [self setModificationDate: [NSDate date]];
  _size = 0;

  return self;
}


//
//
//
- (void) dealloc
{
  RELEASE(_modificationDate);
  [super dealloc];
}


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: _modificationDate];
  [theCoder encodeObject: [NSNumber numberWithInt: _size]];
  [theCoder encodeObject: _cache];
}

- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super initWithPath: nil]; 
  
  [self setModificationDate: [theCoder decodeObject]];
  _size = [[theCoder decodeObject] intValue];
  [self setCache: [theCoder decodeObject]];
  
  return self;
}


//
// access/mutation methods
//
- (NSDate *) modificationDate
{
  return _modificationDate;
}

- (void) setModificationDate: (NSDate *) theDate
{
  ASSIGN(_modificationDate, theDate);
}


//
//
//
- (unsigned int) fileSize
{
  return _size;
}

- (void) setFileSize: (unsigned int) theSize
{
  _size = theSize;
}


//
//
//
- (NSString *) pathToFolder
{
  return _pathToFolder;
}

//
// We don't need to retain this ivar since it's retained in the folder object
// already.
//
- (void) setPathToFolder: (NSString *) thePathToFolder
{
  _pathToFolder = thePathToFolder;
}


//
//
//
- (BOOL) synchronize
{
  NSDictionary *attributes;
  
  attributes = [[NSFileManager defaultManager] fileAttributesAtPath: _pathToFolder
					       traverseLink: YES];
  
  [self setModificationDate: [attributes objectForKey: NSFileModificationDate]];
  [self setFileSize: [[attributes objectForKey: NSFileSize] intValue]];
  
  return [super synchronize];
}


//
// class methods
//
+ (id) cacheWithPath: (NSString *) thePath
{
  id o;

  o = [super cacheWithPath: thePath];
    
  if (!o)
    {
      o = [[CWLocalCacheManager alloc] initWithPath: thePath];
      AUTORELEASE(o);
    }
  
  return o;
}


@end
