/*
**  CWIMAPMessage.m
**
**  Copyright (c) 2001-2004
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/CWIMAPMessage.h>

#include <Pantomime/CWConstants.h>
#include <Pantomime/CWFlags.h>
#include <Pantomime/CWIMAPFolder.h>
#include <Pantomime/CWIMAPStore.h>

#include <Foundation/NSDebug.h>
#include <Foundation/NSValue.h>

//
//
//
@implementation CWIMAPMessage 

- (id) init
{
  self = [super init]; 
  _UID = 0;
  return self;
}


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  // Must also encode Message's superclass
  [super encodeWithCoder: theCoder];
  [theCoder encodeObject: [NSNumber numberWithInt: _UID]];
}


//
//
//
- (id) initWithCoder: (NSCoder *) theCoder
{
  // Must also decode Message's superclass
  self = [super initWithCoder: theCoder];
  _UID = [[theCoder decodeObject] intValue];
  return self;
}


//
//
//
- (unsigned int) UID
{
  return _UID;
}

- (void) setUID: (unsigned int) theUID
{
  _UID = theUID;
}


//
// This method is called to initialize the message if it wasn't.
// If we set it to NO and we HAD a content, we release the content.
//
- (void) setInitialized: (BOOL) aBOOL
{
  [super setInitialized: aBOOL];

  if (aBOOL)
    {
      id aStore;

      aStore = [(CWIMAPFolder *)[self folder] store];

      [aStore sendCommand: IMAP_UID_FETCH_HEADER_FIELDS_NOT  info: nil  arguments: @"UID FETCH %d:%d BODY.PEEK[HEADER.FIELDS.NOT (From To Cc Subject Date Message-ID References In-Reply-To Content-Type)]", _UID, _UID];

      // If we are no longer connected to the IMAP server, we don't send the 2nd command.
      // This will prevent us from calling the delegate method twice (the one that handles
      // the disconnection from the IMAP server).
      if ([aStore isConnected])
	{
	  [aStore sendCommand: IMAP_UID_FETCH_BODY_TEXT  info: nil  arguments: @"UID FETCH %d:%d BODY[TEXT]", _UID, _UID];
	}
    }
  else
    {
      DESTROY(_content);
    }
}


//
// IMAP specific implementation of the rawSource method. This method
// is always non-blocking. It might return nil if the raw source of the
// message hasn't yet been fetched from the IMAP server. The IMAPStore
// notifies the delegate when the fetch has been completed.
//
- (NSData *) rawSource
{
  if (!_rawSource)
    {
      [(CWIMAPStore *)[[self folder] store] sendCommand: IMAP_UID_FETCH_RFC822  info: nil  arguments: @"UID FETCH %d:%d RFC822", _UID, _UID];
    }
  
  return _rawSource;
}


//
// This method will REPLACE all the flags on the server
// for this message with the flags specified in the argument.
//
- (void) setFlags: (CWFlags *) theFlags
{
  [[self folder] setFlags: theFlags
		 messages: [NSArray arrayWithObject: self]];
}

@end
