# - Try to find librobotvision
#
#  ROBOTVISION_FOUND - system has librobotvision
#  ROBOTVISION_INCLUDE_DIR - the librobotvision include directories
#  ROBOTVISION_LIBRARY - link these to use librobotvision

FIND_PATH(
  ROBOTVISION_INCLUDE_DIR
  NAMES robotvision/bundle_adjuster.h
  PATHS ${CMAKE_SOURCE_DIR}/.. /usr/include/robotvision /usr/local/include/robotvision
)

FIND_LIBRARY(
  ROBOTVISION_LIBRARY
  NAMES robotvision
  PATHS ${CMAKE_SOURCE_DIR}/../robotvision/release /usr/lib /usr/local/lib
) 

IF (ROBOTVISION_INCLUDE_DIR AND ROBOTVISION_LIBRARY)
   SET(ROBOTVISION_FOUND TRUE)
ENDIF (ROBOTVISION_INCLUDE_DIR AND ROBOTVISION_LIBRARY)

IF (ROBOTVISION_FOUND)
   IF (NOT ROBOTVISION_FIND_QUIETLY)
      MESSAGE(STATUS "Found ROBOTVISION: ${ROBOTVISION_LIBRARY}")
   ENDIF (NOT ROBOTVISION_FIND_QUIETLY)
ELSE (ROBOTVISION_FOUND)
   IF (ROBOTVISION_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find ROBOTVISION")
   ENDIF (ROBOTVISION_FIND_REQUIRED)
ENDIF (ROBOTVISION_FOUND)
