# - Try to find Pleora SDK
#
#  Pleora_FOUND - system has pleora eUSB SDK
#  Pleora_INCLUDE_DIRS - the pleora eUSB SDK include directories
#  Pleora_LIBRARIES - link these to use pleora eUSB SDK
#  Pleora_BASE_DIR - set env varivales to this to use pleora eUSB SDK

if(NOT PLEORA_ARCH)
  set(PLEORA_ARCH "Ubuntu-12.04-x86_64")
endif()

set( INCLUDE_SEARCH_PATHS
	"/opt/pleora/ebus_sdk/${PLEORA_ARCH}/include"
	"$ENV{ProgramFiles}/Pleora Technologies Inc/eBUS SDK/Includes"
)

set( LIBRARIES_SEARCH_PATHS
	"/opt/pleora/ebus_sdk/${PLEORA_ARCH}/lib"
	"$ENV{ProgramFiles}/Pleora Technologies Inc/eBUS SDK/Libraries"
)

set( GENAPI_SEARCH_PATHS
   "/opt/pleora/ebus_sdk/${PLEORA_ARCH}/lib/genicam/bin/Linux64_x64"
   "/opt/pleora/ebus_sdk/${PLEORA_ARCH}/lib/genicam/bin/Linux32_ARM"
   "$ENV{ProgramW6432}/GenICam_v2_4/library/CPP/lib/Win64_x64"
)

IF (${CMAKE_CL_64})
   set (LIB_NAME_SUFFIX "64")
ELSE()
   set (LIB_NAME_SUFFIX "")
ENDIF()

# Find header files
FIND_PATH(
  PVBASE_INCLUDE_DIR PvBase.h
  HINTS ${PC_PLEORA_DIR}/include
  PATHS ${INCLUDE_SEARCH_PATHS}
)
FIND_PATH(
  PVDEVICE_INCLUDE_DIR PvDevice.h
  HINTS ${PC_PLEORA_DIR}/include
  PATHS ${INCLUDE_SEARCH_PATHS}
)
FIND_PATH(
  PVBUFFER_INCLUDE_DIR PvBuffer.h
  HINTS ${PC_PLEORA_DIR}/include
  PATHS ${INCLUDE_SEARCH_PATHS}
)
FIND_PATH(
  PVGENICAM_INCLUDE_DIR PvGenICamLib.h
  HINTS ${PC_PLEORA_DIR}/include
  PATHS ${INCLUDE_SEARCH_PATHS}
)
FIND_PATH(
  PVSTREAM_INCLUDE_DIR PvStream.h
  HINTS ${PC_PLEORA_DIR}/include
  PATHS ${INCLUDE_SEARCH_PATHS}
)
FIND_PATH(
  PVTRANSMITTER_INCLUDE_DIR PvTransmitterLib.h
  HINTS ${PC_PLEORA_DIR}/include
  PATHS ${INCLUDE_SEARCH_PATHS}
)
FIND_PATH(
  PVVIRTUALDEVICE_INCLUDE_DIR PvVirtualDeviceLib.h
  HINTS ${PC_PLEORA_DIR}/include
  PATHS ${INCLUDE_SEARCH_PATHS}
)
FIND_PATH(
  PVSAMPLEUTILS_INCLUDE_DIR PvSampleUtils.h
  HINTS ${PC_PLEORA_DIR}/include
  PATHS ${INCLUDE_SEARCH_PATHS}
)

# Find Library files
FIND_LIBRARY(
  PVBASE_LIBRARY
  NAMES "PvBase${LIB_NAME_SUFFIX}"
  HINTS ${PC_PLEORA_DIR}/lib
  PATH ${LIBRARIES_SEARCH_PATHS}
)
FIND_LIBRARY(
  PVDEVICE_LIBRARY
  NAMES "PvDevice${LIB_NAME_SUFFIX}"
  HINTS ${PC_PLEORA_DIR}/lib
  PATH ${LIBRARIES_SEARCH_PATHS}
)

FIND_LIBRARY(
  PVBUFFER_LIBRARY
  NAMES "PvBuffer${LIB_NAME_SUFFIX}"
  HINTS ${PC_PLEORA_DIR}/lib
  PATH ${LIBRARIES_SEARCH_PATHS}
)
FIND_LIBRARY(
  PVGENICAM_LIBRARY
  NAMES "PvGenICam${LIB_NAME_SUFFIX}"
  HINTS ${PC_PLEORA_DIR}/lib
  PATH ${LIBRARIES_SEARCH_PATHS}
)
FIND_LIBRARY(
  PVSTREAM_LIBRARY
  NAMES "PvStream${LIB_NAME_SUFFIX}"
  HINTS ${PC_PLEORA_DIR}/lib
  PATH ${LIBRARIES_SEARCH_PATHS}
)
FIND_LIBRARY(
  PVTRANSMITTER_LIBRARY
  NAMES "PvTransmitter${LIB_NAME_SUFFIX}"
  HINTS ${PC_PLEORA_DIR}/lib
  PATH ${LIBRARIES_SEARCH_PATHS}
)
FIND_LIBRARY(
  PVVIRTUALDEVICE_LIBRARY
  NAMES "PvVirtualDevice${LIB_NAME_SUFFIX}"
  HINTS ${PC_PLEORA_DIR}/lib
  PATH ${LIBRARIES_SEARCH_PATHS}
)
FIND_LIBRARY(
  GENAPI_LIBRARY
  NAMES GenApi_gcc40_v2_4 GenApi_gcc43_v2_4 GenApi_MD_VC80_v2_4
  HINTS ${PC_GENAPI_LIBRARY_DIR}
  PATH ${GENAPI_SEARCH_PATHS}
)

IF(PVBASE_INCLUDE_DIR AND PVDEVICE_INCLUDE_DIR AND PVBUFFER_INCLUDE_DIR AND PVGENICAM_INCLUDE_DIR AND PVSTREAM_INCLUDE_DIR AND PVTRANSMITTER_INCLUDE_DIR AND PVVIRTUALDEVICE_INCLUDE_DIR AND PVSAMPLEUTILS_INCLUDE_DIR AND PVBASE_LIBRARY AND PVDEVICE_LIBRARY AND PVBUFFER_LIBRARY AND PVGENICAM_LIBRARY AND PVSTREAM_LIBRARY AND PVTRANSMITTER_LIBRARY AND PVVIRTUALDEVICE_LIBRARY AND GENAPI_LIBRARY)
   SET(Pleora_FOUND TRUE)
   string(REGEX REPLACE "include$" "" Pleora_BASE_DIR ${PVBASE_INCLUDE_DIR})
   SET(Pleora_LIBRARIES ${PVBASE_LIBRARY} ${PVDEVICE_LIBRARY} ${PVBUFFER_LIBRARY} ${PVGENICAM_LIBRARY} ${PVSTREAM_LIBRARY} ${PVTRANSMITTER_LIBRARY} ${PVVIRTUALDEVICE_LIBRARY} ${GENAPI_LIBRARY})
   SET(Pleora_INCLUDE_DIRS ${PVBASE_INCLUDE_DIR} ${PVDEVICE_INCLUDE_DIR} ${PVBUFFER_INCLUDE_DIR} ${PVGENICAM_INCLUDE_DIR} ${PVSTREAM_INCLUDE_DIR} ${PVTRANSMITTER_INCLUDE_DIR} ${PVVIRTUALDEVICE_INCLUDE_DIR} ${PVSAMPLEUTILS_INCLUDE_DIR})
ENDIF()


IF (Pleora_FOUND)
   IF (NOT Pleora_FIND_QUIETLY)
      message(STATUS "Found Pleora: ${Pleora_LIBRARIES}")
   ENDIF (NOT Pleora_FIND_QUIETLY)
ELSE (Pleora_FOUND)
   IF (Pleora_FIND_REQUIRED)
      message(FATAL_ERROR "Could not find Pleora")
   ENDIF (Pleora_FIND_REQUIRED)
ENDIF (Pleora_FOUND)
