/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

class TestErrorMessage : public GTLTest::Case {
  public:
    TestErrorMessage() : GTLTest::Case("ErrorMessage")
    {
    }
    virtual void runTest()
    {
      GTLCore::CompilationMessage emsg( CompilationMessage::ERROR, "test", 10, "bouh");
      GTLTEST_CHECK_EQUAL(emsg.message(), "test");
      GTLTEST_CHECK_EQUAL(emsg.line(), 10);
      GTLTEST_CHECK_EQUAL(emsg.fileName(), "bouh");
      GTLCore::CompilationMessage emsg2( CompilationMessage::ERROR, "test2");
      GTLTEST_CHECK_EQUAL(emsg2.message(), "test2");
      GTLTEST_CHECK_EQUAL(emsg2.line(), -1);
      GTLTEST_CHECK_EQUAL(emsg2.fileName(), "");
      emsg2.setLine(20);
      GTLTEST_CHECK_EQUAL(emsg2.line(), 20);
      emsg2.setFileName("bouh2");
      GTLTEST_CHECK_EQUAL(emsg2.fileName(), "bouh2");
    }
};
