/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFITS;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#ifndef COMMON_MACRO
#define COMMON_MACRO

#include "common_sb.h"
#include "common_s.h"
#include "common_d.h"
#include "common_q.h"

#include "common_c.h"
#include "common_z.h"
#include "common_x.h"

#ifndef COMPLEX
#ifdef XDOUBLE

#define	AMAX_K			QAMAX_K
#define	AMIN_K			QAMIN_K
#define	MAX_K			QMAX_K
#define	MIN_K			QMIN_K
#define	IAMAX_K			IQAMAX_K
#define	IAMIN_K			IQAMIN_K
#define	IMAX_K			IQMAX_K
#define	IMIN_K			IQMIN_K
#define	ASUM_K			QASUM_K
#define	AXPYU_K			QAXPYU_K
#define	AXPYC_K			QAXPYC_K
#define	COPY_K			QCOPY_K
#define	DOTU_K			QDOTU_K
#define	DOTC_K			QDOTC_K
#define	NRM2_K			QNRM2_K
#define	SCAL_K			QSCAL_K
#define	SUM_K			QSUM_K
#define	SWAP_K			QSWAP_K
#define	ROT_K			QROT_K

#define	GEMV_N			QGEMV_N
#define	GEMV_T			QGEMV_T
#define	GEMV_R			QGEMV_R
#define	GEMV_C			QGEMV_C
#define	GEMV_O			QGEMV_O
#define	GEMV_U			QGEMV_U
#define	GEMV_S			QGEMV_S
#define	GEMV_D			QGEMV_D

#define	GERU_K			QGERU_K
#define	GERC_K			QGERC_K
#define	GERV_K			QGERV_K
#define	GERD_K			QGERD_K

#define	SYMV_U			QSYMV_U
#define	SYMV_L			QSYMV_L

#define	SYMV_THREAD_U		QSYMV_THREAD_U
#define	SYMV_THREAD_L		QSYMV_THREAD_L

#define	GEMM_ONCOPY		QGEMM_ONCOPY
#define	GEMM_OTCOPY		QGEMM_OTCOPY
#define	GEMM_INCOPY		QGEMM_INCOPY
#define	GEMM_ITCOPY		QGEMM_ITCOPY

#ifdef UNIT

#define	TRMM_OUNCOPY		QTRMM_OUNUCOPY
#define	TRMM_OUTCOPY		QTRMM_OUTUCOPY
#define	TRMM_OLNCOPY		QTRMM_OLNUCOPY
#define	TRMM_OLTCOPY		QTRMM_OLTUCOPY
#define	TRSM_OUNCOPY		QTRSM_OUNUCOPY
#define	TRSM_OUTCOPY		QTRSM_OUTUCOPY
#define	TRSM_OLNCOPY		QTRSM_OLNUCOPY
#define	TRSM_OLTCOPY		QTRSM_OLTUCOPY

#define	TRMM_IUNCOPY		QTRMM_IUNUCOPY
#define	TRMM_IUTCOPY		QTRMM_IUTUCOPY
#define	TRMM_ILNCOPY		QTRMM_ILNUCOPY
#define	TRMM_ILTCOPY		QTRMM_ILTUCOPY
#define	TRSM_IUNCOPY		QTRSM_IUNUCOPY
#define	TRSM_IUTCOPY		QTRSM_IUTUCOPY
#define	TRSM_ILNCOPY		QTRSM_ILNUCOPY
#define	TRSM_ILTCOPY		QTRSM_ILTUCOPY

#else

#define	TRMM_OUNCOPY		QTRMM_OUNNCOPY
#define	TRMM_OUTCOPY		QTRMM_OUTNCOPY
#define	TRMM_OLNCOPY		QTRMM_OLNNCOPY
#define	TRMM_OLTCOPY		QTRMM_OLTNCOPY
#define	TRSM_OUNCOPY		QTRSM_OUNNCOPY
#define	TRSM_OUTCOPY		QTRSM_OUTNCOPY
#define	TRSM_OLNCOPY		QTRSM_OLNNCOPY
#define	TRSM_OLTCOPY		QTRSM_OLTNCOPY

#define	TRMM_IUNCOPY		QTRMM_IUNNCOPY
#define	TRMM_IUTCOPY		QTRMM_IUTNCOPY
#define	TRMM_ILNCOPY		QTRMM_ILNNCOPY
#define	TRMM_ILTCOPY		QTRMM_ILTNCOPY
#define	TRSM_IUNCOPY		QTRSM_IUNNCOPY
#define	TRSM_IUTCOPY		QTRSM_IUTNCOPY
#define	TRSM_ILNCOPY		QTRSM_ILNNCOPY
#define	TRSM_ILTCOPY		QTRSM_ILTNCOPY

#endif

#define	GEMM_BETA		QGEMM_BETA

#define	GEMM_KERNEL_N		QGEMM_KERNEL
#define	GEMM_KERNEL_L		QGEMM_KERNEL
#define	GEMM_KERNEL_R		QGEMM_KERNEL
#define	GEMM_KERNEL_B		QGEMM_KERNEL

#define	TRMM_KERNEL_LN		QTRMM_KERNEL_LN
#define	TRMM_KERNEL_LT		QTRMM_KERNEL_LT
#define	TRMM_KERNEL_LR		QTRMM_KERNEL_LN
#define	TRMM_KERNEL_LC		QTRMM_KERNEL_LT
#define	TRMM_KERNEL_RN		QTRMM_KERNEL_RN
#define	TRMM_KERNEL_RT		QTRMM_KERNEL_RT
#define	TRMM_KERNEL_RR		QTRMM_KERNEL_RN
#define	TRMM_KERNEL_RC		QTRMM_KERNEL_RT

#define	TRSM_KERNEL_LN		QTRSM_KERNEL_LN
#define	TRSM_KERNEL_LT		QTRSM_KERNEL_LT
#define	TRSM_KERNEL_LR		QTRSM_KERNEL_LN
#define	TRSM_KERNEL_LC		QTRSM_KERNEL_LT
#define	TRSM_KERNEL_RN		QTRSM_KERNEL_RN
#define	TRSM_KERNEL_RT		QTRSM_KERNEL_RT
#define	TRSM_KERNEL_RR		QTRSM_KERNEL_RN
#define	TRSM_KERNEL_RC		QTRSM_KERNEL_RT

#define SYMM_IUTCOPY		QSYMM_IUTCOPY
#define SYMM_ILTCOPY		QSYMM_ILTCOPY
#define SYMM_OUTCOPY		QSYMM_OUTCOPY
#define SYMM_OLTCOPY		QSYMM_OLTCOPY

#define	GEMM_NN			QGEMM_NN
#define	GEMM_CN			QGEMM_TN
#define	GEMM_TN			QGEMM_TN
#define	GEMM_NC			QGEMM_NT
#define	GEMM_NT			QGEMM_NT
#define	GEMM_CC			QGEMM_TT
#define	GEMM_CT			QGEMM_TT
#define	GEMM_TC			QGEMM_TT
#define	GEMM_TT			QGEMM_TT
#define	GEMM_NR			QGEMM_NN
#define	GEMM_TR			QGEMM_TN
#define	GEMM_CR			QGEMM_TN
#define	GEMM_RN			QGEMM_NN
#define	GEMM_RT			QGEMM_NT
#define	GEMM_RC			QGEMM_NT
#define	GEMM_RR			QGEMM_NN

#define	SYMM_LU			QSYMM_LU
#define	SYMM_LL			QSYMM_LL
#define	SYMM_RU			QSYMM_RU
#define	SYMM_RL			QSYMM_RL

#define	HEMM_LU			QHEMM_LU
#define	HEMM_LL			QHEMM_LL
#define	HEMM_RU			QHEMM_RU
#define	HEMM_RL			QHEMM_RL

#define	SYRK_UN			QSYRK_UN
#define	SYRK_UT			QSYRK_UT
#define	SYRK_LN			QSYRK_LN
#define	SYRK_LT			QSYRK_LT
#define	SYRK_UR			QSYRK_UN
#define	SYRK_UC			QSYRK_UT
#define	SYRK_LR			QSYRK_LN
#define	SYRK_LC			QSYRK_LT

#define	SYRK_KERNEL_U		QSYRK_KERNEL_U
#define	SYRK_KERNEL_L		QSYRK_KERNEL_L

#define	HERK_UN			QSYRK_UN
#define	HERK_LN			QSYRK_LN
#define	HERK_UC			QSYRK_UT
#define	HERK_LC			QSYRK_LT

#define	HER2K_UN		QSYR2K_UN
#define	HER2K_LN		QSYR2K_LN
#define	HER2K_UC		QSYR2K_UT
#define	HER2K_LC		QSYR2K_LT

#define	SYR2K_UN		QSYR2K_UN
#define	SYR2K_UT		QSYR2K_UT
#define	SYR2K_LN		QSYR2K_LN
#define	SYR2K_LT		QSYR2K_LT
#define	SYR2K_UR		QSYR2K_UN
#define	SYR2K_UC		QSYR2K_UT
#define	SYR2K_LR		QSYR2K_LN
#define	SYR2K_LC		QSYR2K_LT

#define	SYR2K_KERNEL_U		QSYR2K_KERNEL_U
#define	SYR2K_KERNEL_L		QSYR2K_KERNEL_L

#define	TRMM_LNUU		QTRMM_LNUU
#define	TRMM_LNUN		QTRMM_LNUN
#define	TRMM_LNLU		QTRMM_LNLU
#define	TRMM_LNLN		QTRMM_LNLN
#define	TRMM_LTUU		QTRMM_LTUU
#define	TRMM_LTUN		QTRMM_LTUN
#define	TRMM_LTLU		QTRMM_LTLU
#define	TRMM_LTLN		QTRMM_LTLN
#define	TRMM_LRUU		QTRMM_LNUU
#define	TRMM_LRUN		QTRMM_LNUN
#define	TRMM_LRLU		QTRMM_LNLU
#define	TRMM_LRLN		QTRMM_LNLN
#define	TRMM_LCUU		QTRMM_LTUU
#define	TRMM_LCUN		QTRMM_LTUN
#define	TRMM_LCLU		QTRMM_LTLU
#define	TRMM_LCLN		QTRMM_LTLN
#define	TRMM_RNUU		QTRMM_RNUU
#define	TRMM_RNUN		QTRMM_RNUN
#define	TRMM_RNLU		QTRMM_RNLU
#define	TRMM_RNLN		QTRMM_RNLN
#define	TRMM_RTUU		QTRMM_RTUU
#define	TRMM_RTUN		QTRMM_RTUN
#define	TRMM_RTLU		QTRMM_RTLU
#define	TRMM_RTLN		QTRMM_RTLN
#define	TRMM_RRUU		QTRMM_RNUU
#define	TRMM_RRUN		QTRMM_RNUN
#define	TRMM_RRLU		QTRMM_RNLU
#define	TRMM_RRLN		QTRMM_RNLN
#define	TRMM_RCUU		QTRMM_RTUU
#define	TRMM_RCUN		QTRMM_RTUN
#define	TRMM_RCLU		QTRMM_RTLU
#define	TRMM_RCLN		QTRMM_RTLN

#define	TRSM_LNUU		QTRSM_LNUU
#define	TRSM_LNUN		QTRSM_LNUN
#define	TRSM_LNLU		QTRSM_LNLU
#define	TRSM_LNLN		QTRSM_LNLN
#define	TRSM_LTUU		QTRSM_LTUU
#define	TRSM_LTUN		QTRSM_LTUN
#define	TRSM_LTLU		QTRSM_LTLU
#define	TRSM_LTLN		QTRSM_LTLN
#define	TRSM_LRUU		QTRSM_LNUU
#define	TRSM_LRUN		QTRSM_LNUN
#define	TRSM_LRLU		QTRSM_LNLU
#define	TRSM_LRLN		QTRSM_LNLN
#define	TRSM_LCUU		QTRSM_LTUU
#define	TRSM_LCUN		QTRSM_LTUN
#define	TRSM_LCLU		QTRSM_LTLU
#define	TRSM_LCLN		QTRSM_LTLN
#define	TRSM_RNUU		QTRSM_RNUU
#define	TRSM_RNUN		QTRSM_RNUN
#define	TRSM_RNLU		QTRSM_RNLU
#define	TRSM_RNLN		QTRSM_RNLN
#define	TRSM_RTUU		QTRSM_RTUU
#define	TRSM_RTUN		QTRSM_RTUN
#define	TRSM_RTLU		QTRSM_RTLU
#define	TRSM_RTLN		QTRSM_RTLN
#define	TRSM_RRUU		QTRSM_RNUU
#define	TRSM_RRUN		QTRSM_RNUN
#define	TRSM_RRLU		QTRSM_RNLU
#define	TRSM_RRLN		QTRSM_RNLN
#define	TRSM_RCUU		QTRSM_RTUU
#define	TRSM_RCUN		QTRSM_RTUN
#define	TRSM_RCLU		QTRSM_RTLU
#define	TRSM_RCLN		QTRSM_RTLN

#define	GEMM_THREAD_NN		QGEMM_THREAD_NN
#define	GEMM_THREAD_CN		QGEMM_THREAD_TN
#define	GEMM_THREAD_TN		QGEMM_THREAD_TN
#define	GEMM_THREAD_NC		QGEMM_THREAD_NT
#define	GEMM_THREAD_NT		QGEMM_THREAD_NT
#define	GEMM_THREAD_CC		QGEMM_THREAD_TT
#define	GEMM_THREAD_CT		QGEMM_THREAD_TT
#define	GEMM_THREAD_TC		QGEMM_THREAD_TT
#define	GEMM_THREAD_TT		QGEMM_THREAD_TT
#define	GEMM_THREAD_NR		QGEMM_THREAD_NN
#define	GEMM_THREAD_TR		QGEMM_THREAD_TN
#define	GEMM_THREAD_CR		QGEMM_THREAD_TN
#define	GEMM_THREAD_RN		QGEMM_THREAD_NN
#define	GEMM_THREAD_RT		QGEMM_THREAD_NT
#define	GEMM_THREAD_RC		QGEMM_THREAD_NT
#define	GEMM_THREAD_RR		QGEMM_THREAD_NN

#define	SYMM_THREAD_LU		QSYMM_THREAD_LU
#define	SYMM_THREAD_LL		QSYMM_THREAD_LL
#define	SYMM_THREAD_RU		QSYMM_THREAD_RU
#define	SYMM_THREAD_RL		QSYMM_THREAD_RL

#define	HEMM_THREAD_LU		QHEMM_THREAD_LU
#define	HEMM_THREAD_LL		QHEMM_THREAD_LL
#define	HEMM_THREAD_RU		QHEMM_THREAD_RU
#define	HEMM_THREAD_RL		QHEMM_THREAD_RL

#define	SYRK_THREAD_UN		QSYRK_THREAD_UN
#define	SYRK_THREAD_UT		QSYRK_THREAD_UT
#define	SYRK_THREAD_LN		QSYRK_THREAD_LN
#define	SYRK_THREAD_LT		QSYRK_THREAD_LT
#define	SYRK_THREAD_UR		QSYRK_THREAD_UR
#define	SYRK_THREAD_UC		QSYRK_THREAD_UC
#define	SYRK_THREAD_LR		QSYRK_THREAD_LN
#define	SYRK_THREAD_LC		QSYRK_THREAD_LT

#define	HERK_THREAD_UN		QSYRK_THREAD_UN
#define	HERK_THREAD_UT		QSYRK_THREAD_UT
#define	HERK_THREAD_LN		QSYRK_THREAD_LN
#define	HERK_THREAD_LT		QSYRK_THREAD_LT
#define	HERK_THREAD_UR		QSYRK_THREAD_UR
#define	HERK_THREAD_UC		QSYRK_THREAD_UC
#define	HERK_THREAD_LR		QSYRK_THREAD_LN
#define	HERK_THREAD_LC		QSYRK_THREAD_LT

#elif defined(DOUBLE)

#define	AMAX_K			DAMAX_K
#define	AMIN_K			DAMIN_K
#define	MAX_K			DMAX_K
#define	MIN_K			DMIN_K
#define	IAMAX_K			IDAMAX_K
#define	IAMIN_K			IDAMIN_K
#define	IMAX_K			IDMAX_K
#define	IMIN_K			IDMIN_K
#define	ASUM_K			DASUM_K
#define	AXPYU_K			DAXPYU_K
#define	AXPYC_K			DAXPYC_K
#define	COPY_K			DCOPY_K
#define	DOTU_K			DDOTU_K
#define	DOTC_K			DDOTC_K
#define	NRM2_K			DNRM2_K
#define	SCAL_K			DSCAL_K
#define	SUM_K			DSUM_K
#define	SWAP_K			DSWAP_K
#define	ROT_K			DROT_K

#define	GEMV_N			DGEMV_N
#define	GEMV_T			DGEMV_T
#define	GEMV_R			DGEMV_R
#define	GEMV_C			DGEMV_C
#define	GEMV_O			DGEMV_O
#define	GEMV_U			DGEMV_U
#define	GEMV_S			DGEMV_S
#define	GEMV_D			DGEMV_D

#define	GERU_K			DGERU_K
#define	GERC_K			DGERC_K
#define	GERV_K			DGERV_K
#define	GERD_K			DGERD_K

#define	SYMV_U			DSYMV_U
#define	SYMV_L			DSYMV_L

#define	SYMV_THREAD_U		DSYMV_THREAD_U
#define	SYMV_THREAD_L		DSYMV_THREAD_L

#define	GEMM_ONCOPY		DGEMM_ONCOPY
#define	GEMM_OTCOPY		DGEMM_OTCOPY
#define	GEMM_INCOPY		DGEMM_INCOPY
#define	GEMM_ITCOPY		DGEMM_ITCOPY

#ifdef UNIT

#define	TRMM_OUNCOPY		DTRMM_OUNUCOPY
#define	TRMM_OUTCOPY		DTRMM_OUTUCOPY
#define	TRMM_OLNCOPY		DTRMM_OLNUCOPY
#define	TRMM_OLTCOPY		DTRMM_OLTUCOPY
#define	TRSM_OUNCOPY		DTRSM_OUNUCOPY
#define	TRSM_OUTCOPY		DTRSM_OUTUCOPY
#define	TRSM_OLNCOPY		DTRSM_OLNUCOPY
#define	TRSM_OLTCOPY		DTRSM_OLTUCOPY

#define	TRMM_IUNCOPY		DTRMM_IUNUCOPY
#define	TRMM_IUTCOPY		DTRMM_IUTUCOPY
#define	TRMM_ILNCOPY		DTRMM_ILNUCOPY
#define	TRMM_ILTCOPY		DTRMM_ILTUCOPY
#define	TRSM_IUNCOPY		DTRSM_IUNUCOPY
#define	TRSM_IUTCOPY		DTRSM_IUTUCOPY
#define	TRSM_ILNCOPY		DTRSM_ILNUCOPY
#define	TRSM_ILTCOPY		DTRSM_ILTUCOPY

#else

#define	TRMM_OUNCOPY		DTRMM_OUNNCOPY
#define	TRMM_OUTCOPY		DTRMM_OUTNCOPY
#define	TRMM_OLNCOPY		DTRMM_OLNNCOPY
#define	TRMM_OLTCOPY		DTRMM_OLTNCOPY
#define	TRSM_OUNCOPY		DTRSM_OUNNCOPY
#define	TRSM_OUTCOPY		DTRSM_OUTNCOPY
#define	TRSM_OLNCOPY		DTRSM_OLNNCOPY
#define	TRSM_OLTCOPY		DTRSM_OLTNCOPY

#define	TRMM_IUNCOPY		DTRMM_IUNNCOPY
#define	TRMM_IUTCOPY		DTRMM_IUTNCOPY
#define	TRMM_ILNCOPY		DTRMM_ILNNCOPY
#define	TRMM_ILTCOPY		DTRMM_ILTNCOPY
#define	TRSM_IUNCOPY		DTRSM_IUNNCOPY
#define	TRSM_IUTCOPY		DTRSM_IUTNCOPY
#define	TRSM_ILNCOPY		DTRSM_ILNNCOPY
#define	TRSM_ILTCOPY		DTRSM_ILTNCOPY

#endif

#define	GEMM_BETA		DGEMM_BETA

#define	GEMM_KERNEL_N		DGEMM_KERNEL
#define	GEMM_KERNEL_L		DGEMM_KERNEL
#define	GEMM_KERNEL_R		DGEMM_KERNEL
#define	GEMM_KERNEL_B		DGEMM_KERNEL

#define	TRMM_KERNEL_LN		DTRMM_KERNEL_LN
#define	TRMM_KERNEL_LT		DTRMM_KERNEL_LT
#define	TRMM_KERNEL_LR		DTRMM_KERNEL_LN
#define	TRMM_KERNEL_LC		DTRMM_KERNEL_LT
#define	TRMM_KERNEL_RN		DTRMM_KERNEL_RN
#define	TRMM_KERNEL_RT		DTRMM_KERNEL_RT
#define	TRMM_KERNEL_RR		DTRMM_KERNEL_RN
#define	TRMM_KERNEL_RC		DTRMM_KERNEL_RT

#define	TRSM_KERNEL_LN		DTRSM_KERNEL_LN
#define	TRSM_KERNEL_LT		DTRSM_KERNEL_LT
#define	TRSM_KERNEL_LR		DTRSM_KERNEL_LN
#define	TRSM_KERNEL_LC		DTRSM_KERNEL_LT
#define	TRSM_KERNEL_RN		DTRSM_KERNEL_RN
#define	TRSM_KERNEL_RT		DTRSM_KERNEL_RT
#define	TRSM_KERNEL_RR		DTRSM_KERNEL_RN
#define	TRSM_KERNEL_RC		DTRSM_KERNEL_RT

#define SYMM_IUTCOPY		DSYMM_IUTCOPY
#define SYMM_ILTCOPY		DSYMM_ILTCOPY
#define SYMM_OUTCOPY		DSYMM_OUTCOPY
#define SYMM_OLTCOPY		DSYMM_OLTCOPY

#define	GEMM_NN			DGEMM_NN
#define	GEMM_CN			DGEMM_TN
#define	GEMM_TN			DGEMM_TN
#define	GEMM_NC			DGEMM_NT
#define	GEMM_NT			DGEMM_NT
#define	GEMM_CC			DGEMM_TT
#define	GEMM_CT			DGEMM_TT
#define	GEMM_TC			DGEMM_TT
#define	GEMM_TT			DGEMM_TT
#define	GEMM_NR			DGEMM_NN
#define	GEMM_TR			DGEMM_TN
#define	GEMM_CR			DGEMM_TN
#define	GEMM_RN			DGEMM_NN
#define	GEMM_RT			DGEMM_NT
#define	GEMM_RC			DGEMM_NT
#define	GEMM_RR			DGEMM_NN

#define	SYMM_LU			DSYMM_LU
#define	SYMM_LL			DSYMM_LL
#define	SYMM_RU			DSYMM_RU
#define	SYMM_RL			DSYMM_RL

#define	HEMM_LU			DHEMM_LU
#define	HEMM_LL			DHEMM_LL
#define	HEMM_RU			DHEMM_RU
#define	HEMM_RL			DHEMM_RL

#define	SYRK_UN			DSYRK_UN
#define	SYRK_UT			DSYRK_UT
#define	SYRK_LN			DSYRK_LN
#define	SYRK_LT			DSYRK_LT
#define	SYRK_UR			DSYRK_UN
#define	SYRK_UC			DSYRK_UT
#define	SYRK_LR			DSYRK_LN
#define	SYRK_LC			DSYRK_LT

#define	SYRK_KERNEL_U		DSYRK_KERNEL_U
#define	SYRK_KERNEL_L		DSYRK_KERNEL_L

#define	HERK_UN			DSYRK_UN
#define	HERK_LN			DSYRK_LN
#define	HERK_UC			DSYRK_UT
#define	HERK_LC			DSYRK_LT

#define	HER2K_UN		DSYR2K_UN
#define	HER2K_LN		DSYR2K_LN
#define	HER2K_UC		DSYR2K_UT
#define	HER2K_LC		DSYR2K_LT

#define	SYR2K_UN		DSYR2K_UN
#define	SYR2K_UT		DSYR2K_UT
#define	SYR2K_LN		DSYR2K_LN
#define	SYR2K_LT		DSYR2K_LT
#define	SYR2K_UR		DSYR2K_UN
#define	SYR2K_UC		DSYR2K_UT
#define	SYR2K_LR		DSYR2K_LN
#define	SYR2K_LC		DSYR2K_LT

#define	SYR2K_KERNEL_U		DSYR2K_KERNEL_U
#define	SYR2K_KERNEL_L		DSYR2K_KERNEL_L

#define	TRMM_LNUU		DTRMM_LNUU
#define	TRMM_LNUN		DTRMM_LNUN
#define	TRMM_LNLU		DTRMM_LNLU
#define	TRMM_LNLN		DTRMM_LNLN
#define	TRMM_LTUU		DTRMM_LTUU
#define	TRMM_LTUN		DTRMM_LTUN
#define	TRMM_LTLU		DTRMM_LTLU
#define	TRMM_LTLN		DTRMM_LTLN
#define	TRMM_LRUU		DTRMM_LNUU
#define	TRMM_LRUN		DTRMM_LNUN
#define	TRMM_LRLU		DTRMM_LNLU
#define	TRMM_LRLN		DTRMM_LNLN
#define	TRMM_LCUU		DTRMM_LTUU
#define	TRMM_LCUN		DTRMM_LTUN
#define	TRMM_LCLU		DTRMM_LTLU
#define	TRMM_LCLN		DTRMM_LTLN
#define	TRMM_RNUU		DTRMM_RNUU
#define	TRMM_RNUN		DTRMM_RNUN
#define	TRMM_RNLU		DTRMM_RNLU
#define	TRMM_RNLN		DTRMM_RNLN
#define	TRMM_RTUU		DTRMM_RTUU
#define	TRMM_RTUN		DTRMM_RTUN
#define	TRMM_RTLU		DTRMM_RTLU
#define	TRMM_RTLN		DTRMM_RTLN
#define	TRMM_RRUU		DTRMM_RNUU
#define	TRMM_RRUN		DTRMM_RNUN
#define	TRMM_RRLU		DTRMM_RNLU
#define	TRMM_RRLN		DTRMM_RNLN
#define	TRMM_RCUU		DTRMM_RTUU
#define	TRMM_RCUN		DTRMM_RTUN
#define	TRMM_RCLU		DTRMM_RTLU
#define	TRMM_RCLN		DTRMM_RTLN

#define	TRSM_LNUU		DTRSM_LNUU
#define	TRSM_LNUN		DTRSM_LNUN
#define	TRSM_LNLU		DTRSM_LNLU
#define	TRSM_LNLN		DTRSM_LNLN
#define	TRSM_LTUU		DTRSM_LTUU
#define	TRSM_LTUN		DTRSM_LTUN
#define	TRSM_LTLU		DTRSM_LTLU
#define	TRSM_LTLN		DTRSM_LTLN
#define	TRSM_LRUU		DTRSM_LNUU
#define	TRSM_LRUN		DTRSM_LNUN
#define	TRSM_LRLU		DTRSM_LNLU
#define	TRSM_LRLN		DTRSM_LNLN
#define	TRSM_LCUU		DTRSM_LTUU
#define	TRSM_LCUN		DTRSM_LTUN
#define	TRSM_LCLU		DTRSM_LTLU
#define	TRSM_LCLN		DTRSM_LTLN
#define	TRSM_RNUU		DTRSM_RNUU
#define	TRSM_RNUN		DTRSM_RNUN
#define	TRSM_RNLU		DTRSM_RNLU
#define	TRSM_RNLN		DTRSM_RNLN
#define	TRSM_RTUU		DTRSM_RTUU
#define	TRSM_RTUN		DTRSM_RTUN
#define	TRSM_RTLU		DTRSM_RTLU
#define	TRSM_RTLN		DTRSM_RTLN
#define	TRSM_RRUU		DTRSM_RNUU
#define	TRSM_RRUN		DTRSM_RNUN
#define	TRSM_RRLU		DTRSM_RNLU
#define	TRSM_RRLN		DTRSM_RNLN
#define	TRSM_RCUU		DTRSM_RTUU
#define	TRSM_RCUN		DTRSM_RTUN
#define	TRSM_RCLU		DTRSM_RTLU
#define	TRSM_RCLN		DTRSM_RTLN

#define	GEMM_THREAD_NN		DGEMM_THREAD_NN
#define	GEMM_THREAD_CN		DGEMM_THREAD_TN
#define	GEMM_THREAD_TN		DGEMM_THREAD_TN
#define	GEMM_THREAD_NC		DGEMM_THREAD_NT
#define	GEMM_THREAD_NT		DGEMM_THREAD_NT
#define	GEMM_THREAD_CC		DGEMM_THREAD_TT
#define	GEMM_THREAD_CT		DGEMM_THREAD_TT
#define	GEMM_THREAD_TC		DGEMM_THREAD_TT
#define	GEMM_THREAD_TT		DGEMM_THREAD_TT
#define	GEMM_THREAD_NR		DGEMM_THREAD_NN
#define	GEMM_THREAD_TR		DGEMM_THREAD_TN
#define	GEMM_THREAD_CR		DGEMM_THREAD_TN
#define	GEMM_THREAD_RN		DGEMM_THREAD_NN
#define	GEMM_THREAD_RT		DGEMM_THREAD_NT
#define	GEMM_THREAD_RC		DGEMM_THREAD_NT
#define	GEMM_THREAD_RR		DGEMM_THREAD_NN

#define	SYMM_THREAD_LU		DSYMM_THREAD_LU
#define	SYMM_THREAD_LL		DSYMM_THREAD_LL
#define	SYMM_THREAD_RU		DSYMM_THREAD_RU
#define	SYMM_THREAD_RL		DSYMM_THREAD_RL

#define	HEMM_THREAD_LU		DHEMM_THREAD_LU
#define	HEMM_THREAD_LL		DHEMM_THREAD_LL
#define	HEMM_THREAD_RU		DHEMM_THREAD_RU
#define	HEMM_THREAD_RL		DHEMM_THREAD_RL

#define	SYRK_THREAD_UN		DSYRK_THREAD_UN
#define	SYRK_THREAD_UT		DSYRK_THREAD_UT
#define	SYRK_THREAD_LN		DSYRK_THREAD_LN
#define	SYRK_THREAD_LT		DSYRK_THREAD_LT
#define	SYRK_THREAD_UR		DSYRK_THREAD_UR
#define	SYRK_THREAD_UC		DSYRK_THREAD_UC
#define	SYRK_THREAD_LR		DSYRK_THREAD_LN
#define	SYRK_THREAD_LC		DSYRK_THREAD_LT

#define	HERK_THREAD_UN		DSYRK_THREAD_UN
#define	HERK_THREAD_UT		DSYRK_THREAD_UT
#define	HERK_THREAD_LN		DSYRK_THREAD_LN
#define	HERK_THREAD_LT		DSYRK_THREAD_LT
#define	HERK_THREAD_UR		DSYRK_THREAD_UR
#define	HERK_THREAD_UC		DSYRK_THREAD_UC
#define	HERK_THREAD_LR		DSYRK_THREAD_LN
#define	HERK_THREAD_LC		DSYRK_THREAD_LT

#define	AXPBY_K			DAXPBY_K

#define OMATCOPY_K_CN		DOMATCOPY_K_CN
#define OMATCOPY_K_RN		DOMATCOPY_K_RN
#define OMATCOPY_K_CT		DOMATCOPY_K_CT
#define OMATCOPY_K_RT		DOMATCOPY_K_RT
#define IMATCOPY_K_CN		DIMATCOPY_K_CN
#define IMATCOPY_K_RN		DIMATCOPY_K_RN
#define IMATCOPY_K_CT		DIMATCOPY_K_CT
#define IMATCOPY_K_RT		DIMATCOPY_K_RT

#define GEADD_K                 DGEADD_K

#elif defined(BFLOAT16)

#define D_TO_BF16_K     SBDTOBF16_K
#define D_BF16_TO_K     DBF16TOD_K
#define S_TO_BF16_K     SBSTOBF16_K
#define S_BF16_TO_K     SBF16TOS_K
#define SBGEMV_N        SBGEMV_N_K
#define SBGEMV_T        SBGEMV_T_K

#define	AMAX_K			SAMAX_K
#define	AMIN_K			SAMIN_K
#define	MAX_K			SMAX_K
#define	MIN_K			SMIN_K
#define	IAMAX_K			ISAMAX_K
#define	IAMIN_K			ISAMIN_K
#define	IMAX_K			ISMAX_K
#define	IMIN_K			ISMIN_K
#define	ASUM_K			SASUM_K
#define	DOTU_K			SDOTU_K
#define	DOTC_K			SDOTC_K
#define BF16_DOT_K      SBDOT_K
#define	AXPYU_K			SAXPYU_K
#define	AXPYC_K			SAXPYC_K
#define AXPBY_K     SAXPBY_K
#define SCAL_K			SSCAL_K
#define GEMV_N			SGEMV_N
#define GEMV_T			SGEMV_T
#define SYMV_U			SSYMV_U
#define SYMV_L			SSYMV_L
#define	GERU_K			SGERU_K
#define	GERC_K			SGERC_K
#define	GERV_K			SGERV_K
#define	GERD_K			SGERD_K
#define	SUM_K			SSUM_K
#define	SWAP_K			SSWAP_K
#define	ROT_K			SROT_K
#define COPY_K    SCOPY_K
#define NRM2_K    SNRM2_K
#define SYMV_THREAD_U		SSYMV_THREAD_U
#define SYMV_THREAD_L		SSYMV_THREAD_L
#define GEMM_BETA               SBGEMM_BETA
#define	GEMM_KERNEL_N		SBGEMM_KERNEL
#define	GEMM_KERNEL_L		SBGEMM_KERNEL
#define	GEMM_KERNEL_R		SBGEMM_KERNEL
#define	GEMM_KERNEL_B		SBGEMM_KERNEL

#define	GEMM_NN			SBGEMM_NN
#define	GEMM_CN			SBGEMM_TN
#define	GEMM_TN			SBGEMM_TN
#define	GEMM_NC			SBGEMM_NT
#define	GEMM_NT			SBGEMM_NT
#define	GEMM_CC			SBGEMM_TT
#define	GEMM_CT			SBGEMM_TT
#define	GEMM_TC			SBGEMM_TT
#define	GEMM_TT			SBGEMM_TT
#define	GEMM_NR			SBGEMM_NN
#define	GEMM_TR			SBGEMM_TN
#define	GEMM_CR			SBGEMM_TN
#define	GEMM_RN			SBGEMM_NN
#define	GEMM_RT			SBGEMM_NT
#define	GEMM_RC			SBGEMM_NT
#define	GEMM_RR			SBGEMM_NN
#define	GEMM_ONCOPY		SBGEMM_ONCOPY
#define	GEMM_OTCOPY		SBGEMM_OTCOPY
#define	GEMM_INCOPY		SBGEMM_INCOPY
#define	GEMM_ITCOPY		SBGEMM_ITCOPY
#define SYMM_THREAD_LU          SSYMM_THREAD_LU
#define SYMM_THREAD_LL          SSYMM_THREAD_LL
#define SYMM_THREAD_RU          SSYMM_THREAD_RU
#define SYMM_THREAD_RL          SSYMM_THREAD_RL
#define SYMM_LU                 SSYMM_LU
#define SYMM_LL                 SSYMM_LL
#define SYMM_RU                 SSYMM_RU
#define SYMM_RL                 SSYMM_RL


#define HEMM_THREAD_LU          SHEMM_THREAD_LU
#define HEMM_THREAD_LL          SHEMM_THREAD_LL
#define HEMM_THREAD_RU          SHEMM_THREAD_RU
#define HEMM_THREAD_RL          SHEMM_THREAD_RL

#define	GEMM_THREAD_NN		SBGEMM_THREAD_NN
#define	GEMM_THREAD_CN		SBGEMM_THREAD_TN
#define	GEMM_THREAD_TN		SBGEMM_THREAD_TN
#define	GEMM_THREAD_NC		SBGEMM_THREAD_NT
#define	GEMM_THREAD_NT		SBGEMM_THREAD_NT
#define	GEMM_THREAD_CC		SBGEMM_THREAD_TT
#define	GEMM_THREAD_CT		SBGEMM_THREAD_TT
#define	GEMM_THREAD_TC		SBGEMM_THREAD_TT
#define	GEMM_THREAD_TT		SBGEMM_THREAD_TT
#define	GEMM_THREAD_NR		SBGEMM_THREAD_NN
#define	GEMM_THREAD_TR		SBGEMM_THREAD_TN
#define	GEMM_THREAD_CR		SBGEMM_THREAD_TN
#define	GEMM_THREAD_RN		SBGEMM_THREAD_NN
#define	GEMM_THREAD_RT		SBGEMM_THREAD_NT
#define	GEMM_THREAD_RC		SBGEMM_THREAD_NT
#define	GEMM_THREAD_RR		SBGEMM_THREAD_NN

#ifdef UNIT

#define	TRMM_OUNCOPY		STRMM_OUNUCOPY
#define	TRMM_OUTCOPY		STRMM_OUTUCOPY
#define	TRMM_OLNCOPY		STRMM_OLNUCOPY
#define	TRMM_OLTCOPY		STRMM_OLTUCOPY
#define	TRSM_OUNCOPY		STRSM_OUNUCOPY
#define	TRSM_OUTCOPY		STRSM_OUTUCOPY
#define	TRSM_OLNCOPY		STRSM_OLNUCOPY
#define	TRSM_OLTCOPY		STRSM_OLTUCOPY

#define	TRMM_IUNCOPY		STRMM_IUNUCOPY
#define	TRMM_IUTCOPY		STRMM_IUTUCOPY
#define	TRMM_ILNCOPY		STRMM_ILNUCOPY
#define	TRMM_ILTCOPY		STRMM_ILTUCOPY
#define	TRSM_IUNCOPY		STRSM_IUNUCOPY
#define	TRSM_IUTCOPY		STRSM_IUTUCOPY
#define	TRSM_ILNCOPY		STRSM_ILNUCOPY
#define	TRSM_ILTCOPY		STRSM_ILTUCOPY

#else

#define	TRMM_OUNCOPY		STRMM_OUNNCOPY
#define	TRMM_OUTCOPY		STRMM_OUTNCOPY
#define	TRMM_OLNCOPY		STRMM_OLNNCOPY
#define	TRMM_OLTCOPY		STRMM_OLTNCOPY
#define	TRSM_OUNCOPY		STRSM_OUNNCOPY
#define	TRSM_OUTCOPY		STRSM_OUTNCOPY
#define	TRSM_OLNCOPY		STRSM_OLNNCOPY
#define	TRSM_OLTCOPY		STRSM_OLTNCOPY

#define	TRMM_IUNCOPY		STRMM_IUNNCOPY
#define	TRMM_IUTCOPY		STRMM_IUTNCOPY
#define	TRMM_ILNCOPY		STRMM_ILNNCOPY
#define	TRMM_ILTCOPY		STRMM_ILTNCOPY
#define	TRSM_IUNCOPY		STRSM_IUNNCOPY
#define	TRSM_IUTCOPY		STRSM_IUTNCOPY
#define	TRSM_ILNCOPY		STRSM_ILNNCOPY
#define	TRSM_ILTCOPY		STRSM_ILTNCOPY

#define	TRMM_KERNEL_LN		STRMM_KERNEL_LN
#define	TRMM_KERNEL_LT		STRMM_KERNEL_LT
#define	TRMM_KERNEL_LR		STRMM_KERNEL_LN
#define	TRMM_KERNEL_LC		STRMM_KERNEL_LT
#define	TRMM_KERNEL_RN		STRMM_KERNEL_RN
#define	TRMM_KERNEL_RT		STRMM_KERNEL_RT
#define	TRMM_KERNEL_RR		STRMM_KERNEL_RN
#define	TRMM_KERNEL_RC		STRMM_KERNEL_RT

#define	TRSM_KERNEL_LN		STRSM_KERNEL_LN
#define	TRSM_KERNEL_LT		STRSM_KERNEL_LT
#define	TRSM_KERNEL_LR		STRSM_KERNEL_LN
#define	TRSM_KERNEL_LC		STRSM_KERNEL_LT
#define	TRSM_KERNEL_RN		STRSM_KERNEL_RN
#define	TRSM_KERNEL_RT		STRSM_KERNEL_RT
#define	TRSM_KERNEL_RR		STRSM_KERNEL_RN
#define	TRSM_KERNEL_RC		STRSM_KERNEL_RT

#define SYMM_IUTCOPY		SSYMM_IUTCOPY
#define SYMM_ILTCOPY		SSYMM_ILTCOPY
#define SYMM_OUTCOPY		SSYMM_OUTCOPY
#define SYMM_OLTCOPY		SSYMM_OLTCOPY
#define	TRMM_LNUU		STRMM_LNUU
#define	TRMM_LNUN		STRMM_LNUN
#define	TRMM_LNLU		STRMM_LNLU
#define	TRMM_LNLN		STRMM_LNLN
#define	TRMM_LTUU		STRMM_LTUU
#define	TRMM_LTUN		STRMM_LTUN
#define	TRMM_LTLU		STRMM_LTLU
#define	TRMM_LTLN		STRMM_LTLN
#define	TRMM_LRUU		STRMM_LNUU
#define	TRMM_LRUN		STRMM_LNUN
#define	TRMM_LRLU		STRMM_LNLU
#define	TRMM_LRLN		STRMM_LNLN
#define	TRMM_LCUU		STRMM_LTUU
#define	TRMM_LCUN		STRMM_LTUN
#define	TRMM_LCLU		STRMM_LTLU
#define	TRMM_LCLN		STRMM_LTLN
#define	TRMM_RNUU		STRMM_RNUU
#define	TRMM_RNUN		STRMM_RNUN
#define	TRMM_RNLU		STRMM_RNLU
#define	TRMM_RNLN		STRMM_RNLN
#define	TRMM_RTUU		STRMM_RTUU
#define	TRMM_RTUN		STRMM_RTUN
#define	TRMM_RTLU		STRMM_RTLU
#define	TRMM_RTLN		STRMM_RTLN
#define	TRMM_RRUU		STRMM_RNUU
#define	TRMM_RRUN		STRMM_RNUN
#define	TRMM_RRLU		STRMM_RNLU
#define	TRMM_RRLN		STRMM_RNLN
#define	TRMM_RCUU		STRMM_RTUU
#define	TRMM_RCUN		STRMM_RTUN
#define	TRMM_RCLU		STRMM_RTLU
#define	TRMM_RCLN		STRMM_RTLN

#define	TRSM_LNUU		STRSM_LNUU
#define	TRSM_LNUN		STRSM_LNUN
#define	TRSM_LNLU		STRSM_LNLU
#define	TRSM_LNLN		STRSM_LNLN
#define	TRSM_LTUU		STRSM_LTUU
#define	TRSM_LTUN		STRSM_LTUN
#define	TRSM_LTLU		STRSM_LTLU
#define	TRSM_LTLN		STRSM_LTLN
#define	TRSM_LRUU		STRSM_LNUU
#define	TRSM_LRUN		STRSM_LNUN
#define	TRSM_LRLU		STRSM_LNLU
#define	TRSM_LRLN		STRSM_LNLN
#define	TRSM_LCUU		STRSM_LTUU
#define	TRSM_LCUN		STRSM_LTUN
#define	TRSM_LCLU		STRSM_LTLU
#define	TRSM_LCLN		STRSM_LTLN
#define	TRSM_RNUU		STRSM_RNUU
#define	TRSM_RNUN		STRSM_RNUN
#define	TRSM_RNLU		STRSM_RNLU
#define	TRSM_RNLN		STRSM_RNLN
#define	TRSM_RTUU		STRSM_RTUU
#define	TRSM_RTUN		STRSM_RTUN
#define	TRSM_RTLU		STRSM_RTLU
#define	TRSM_RTLN		STRSM_RTLN
#define	TRSM_RRUU		STRSM_RNUU
#define	TRSM_RRUN		STRSM_RNUN
#define	TRSM_RRLU		STRSM_RNLU
#define	TRSM_RRLN		STRSM_RNLN
#define	TRSM_RCUU		STRSM_RTUU
#define	TRSM_RCUN		STRSM_RTUN
#define	TRSM_RCLU		STRSM_RTLU
#define	TRSM_RCLN		STRSM_RTLN
#define	SYRK_UN			SSYRK_UN
#define	SYRK_UT			SSYRK_UT
#define	SYRK_LN			SSYRK_LN
#define	SYRK_LT			SSYRK_LT
#define	SYRK_UR			SSYRK_UN
#define	SYRK_UC			SSYRK_UT
#define	SYRK_LR			SSYRK_LN
#define	SYRK_LC			SSYRK_LT

#define	SYRK_KERNEL_U		SSYRK_KERNEL_U
#define	SYRK_KERNEL_L		SSYRK_KERNEL_L

#define	HERK_UN			SSYRK_UN
#define	HERK_LN			SSYRK_LN
#define	HERK_UC			SSYRK_UT
#define	HERK_LC			SSYRK_LT

#define	HER2K_UN		SSYR2K_UN
#define	HER2K_LN		SSYR2K_LN
#define	HER2K_UC		SSYR2K_UT
#define	HER2K_LC		SSYR2K_LT

#define	SYR2K_UN		SSYR2K_UN
#define	SYR2K_UT		SSYR2K_UT
#define	SYR2K_LN		SSYR2K_LN
#define	SYR2K_LT		SSYR2K_LT
#define	SYR2K_UR		SSYR2K_UN
#define	SYR2K_UC		SSYR2K_UT
#define	SYR2K_LR		SSYR2K_LN
#define	SYR2K_LC		SSYR2K_LT

#define	SYR2K_KERNEL_U		SSYR2K_KERNEL_U
#define	SYR2K_KERNEL_L		SSYR2K_KERNEL_L
#define	SYRK_THREAD_UN		SSYRK_THREAD_UN
#define	SYRK_THREAD_UT		SSYRK_THREAD_UT
#define	SYRK_THREAD_LN		SSYRK_THREAD_LN
#define	SYRK_THREAD_LT		SSYRK_THREAD_LT
#define	SYRK_THREAD_UR		SSYRK_THREAD_UR
#define	SYRK_THREAD_UC		SSYRK_THREAD_UC
#define	SYRK_THREAD_LR		SSYRK_THREAD_LN
#define	SYRK_THREAD_LC		SSYRK_THREAD_LT

#define	HERK_THREAD_UN		SSYRK_THREAD_UN
#define	HERK_THREAD_UT		SSYRK_THREAD_UT
#define	HERK_THREAD_LN		SSYRK_THREAD_LN
#define	HERK_THREAD_LT		SSYRK_THREAD_LT
#define	HERK_THREAD_UR		SSYRK_THREAD_UR
#define	HERK_THREAD_UC		SSYRK_THREAD_UC
#define	HERK_THREAD_LR		SSYRK_THREAD_LN
#define	HERK_THREAD_LC		SSYRK_THREAD_LT

#define OMATCOPY_K_CN		SOMATCOPY_K_CN
#define OMATCOPY_K_RN		SOMATCOPY_K_RN
#define OMATCOPY_K_CT		SOMATCOPY_K_CT
#define OMATCOPY_K_RT		SOMATCOPY_K_RT
#define IMATCOPY_K_CN		SIMATCOPY_K_CN
#define IMATCOPY_K_RN		SIMATCOPY_K_RN
#define IMATCOPY_K_CT		SIMATCOPY_K_CT
#define IMATCOPY_K_RT		SIMATCOPY_K_RT

#define GEADD_K 		SGEADD_K

#endif

#else

#define	AMAX_K			SAMAX_K
#define	AMIN_K			SAMIN_K
#define	MAX_K			SMAX_K
#define	MIN_K			SMIN_K
#define	IAMAX_K			ISAMAX_K
#define	IAMIN_K			ISAMIN_K
#define	IMAX_K			ISMAX_K
#define	IMIN_K			ISMIN_K
#define	ASUM_K			SASUM_K
#define	AXPYU_K			SAXPYU_K
#define	AXPYC_K			SAXPYU_K
#define	COPY_K			SCOPY_K
#define	DOTU_K			SDOTU_K
#define	DOTC_K			SDOTC_K
#define	NRM2_K			SNRM2_K
#define	SCAL_K			SSCAL_K
#define	SUM_K			SSUM_K
#define	SWAP_K			SSWAP_K
#define	ROT_K			SROT_K

#define	GEMV_N			SGEMV_N
#define	GEMV_T			SGEMV_T
#define	GEMV_R			SGEMV_R
#define	GEMV_C			SGEMV_C
#define	GEMV_O			SGEMV_O
#define	GEMV_U			SGEMV_U
#define	GEMV_S			SGEMV_S
#define	GEMV_D			SGEMV_D


#define	SYMV_U			SSYMV_U
#define	SYMV_L			SSYMV_L
#define	GERU_K			SGERU_K
#define	GERC_K			SGERC_K
#define	GERV_K			SGERV_K
#define	GERD_K			SGERD_K

#define	SYMV_THREAD_U		SSYMV_THREAD_U
#define	SYMV_THREAD_L		SSYMV_THREAD_L

#define	GEMM_ONCOPY		SGEMM_ONCOPY
#define	GEMM_OTCOPY		SGEMM_OTCOPY
#define	GEMM_INCOPY		SGEMM_INCOPY
#define	GEMM_ITCOPY		SGEMM_ITCOPY

#ifdef UNIT

#define	TRMM_OUNCOPY		STRMM_OUNUCOPY
#define	TRMM_OUTCOPY		STRMM_OUTUCOPY
#define	TRMM_OLNCOPY		STRMM_OLNUCOPY
#define	TRMM_OLTCOPY		STRMM_OLTUCOPY
#define	TRSM_OUNCOPY		STRSM_OUNUCOPY
#define	TRSM_OUTCOPY		STRSM_OUTUCOPY
#define	TRSM_OLNCOPY		STRSM_OLNUCOPY
#define	TRSM_OLTCOPY		STRSM_OLTUCOPY

#define	TRMM_IUNCOPY		STRMM_IUNUCOPY
#define	TRMM_IUTCOPY		STRMM_IUTUCOPY
#define	TRMM_ILNCOPY		STRMM_ILNUCOPY
#define	TRMM_ILTCOPY		STRMM_ILTUCOPY
#define	TRSM_IUNCOPY		STRSM_IUNUCOPY
#define	TRSM_IUTCOPY		STRSM_IUTUCOPY
#define	TRSM_ILNCOPY		STRSM_ILNUCOPY
#define	TRSM_ILTCOPY		STRSM_ILTUCOPY

#else

#define	TRMM_OUNCOPY		STRMM_OUNNCOPY
#define	TRMM_OUTCOPY		STRMM_OUTNCOPY
#define	TRMM_OLNCOPY		STRMM_OLNNCOPY
#define	TRMM_OLTCOPY		STRMM_OLTNCOPY
#define	TRSM_OUNCOPY		STRSM_OUNNCOPY
#define	TRSM_OUTCOPY		STRSM_OUTNCOPY
#define	TRSM_OLNCOPY		STRSM_OLNNCOPY
#define	TRSM_OLTCOPY		STRSM_OLTNCOPY

#define	TRMM_IUNCOPY		STRMM_IUNNCOPY
#define	TRMM_IUTCOPY		STRMM_IUTNCOPY
#define	TRMM_ILNCOPY		STRMM_ILNNCOPY
#define	TRMM_ILTCOPY		STRMM_ILTNCOPY
#define	TRSM_IUNCOPY		STRSM_IUNNCOPY
#define	TRSM_IUTCOPY		STRSM_IUTNCOPY
#define	TRSM_ILNCOPY		STRSM_ILNNCOPY
#define	TRSM_ILTCOPY		STRSM_ILTNCOPY

#endif

#define	GEMM_BETA		SGEMM_BETA

#define	GEMM_KERNEL_N		SGEMM_KERNEL
#define	GEMM_KERNEL_L		SGEMM_KERNEL
#define	GEMM_KERNEL_R		SGEMM_KERNEL
#define	GEMM_KERNEL_B		SGEMM_KERNEL

#define	TRMM_KERNEL_LN		STRMM_KERNEL_LN
#define	TRMM_KERNEL_LT		STRMM_KERNEL_LT
#define	TRMM_KERNEL_LR		STRMM_KERNEL_LN
#define	TRMM_KERNEL_LC		STRMM_KERNEL_LT
#define	TRMM_KERNEL_RN		STRMM_KERNEL_RN
#define	TRMM_KERNEL_RT		STRMM_KERNEL_RT
#define	TRMM_KERNEL_RR		STRMM_KERNEL_RN
#define	TRMM_KERNEL_RC		STRMM_KERNEL_RT

#define	TRSM_KERNEL_LN		STRSM_KERNEL_LN
#define	TRSM_KERNEL_LT		STRSM_KERNEL_LT
#define	TRSM_KERNEL_LR		STRSM_KERNEL_LN
#define	TRSM_KERNEL_LC		STRSM_KERNEL_LT
#define	TRSM_KERNEL_RN		STRSM_KERNEL_RN
#define	TRSM_KERNEL_RT		STRSM_KERNEL_RT
#define	TRSM_KERNEL_RR		STRSM_KERNEL_RN
#define	TRSM_KERNEL_RC		STRSM_KERNEL_RT

#define SYMM_IUTCOPY		SSYMM_IUTCOPY
#define SYMM_ILTCOPY		SSYMM_ILTCOPY
#define SYMM_OUTCOPY		SSYMM_OUTCOPY
#define SYMM_OLTCOPY		SSYMM_OLTCOPY

#define	GEMM_NN			SGEMM_NN
#define	GEMM_CN			SGEMM_TN
#define	GEMM_TN			SGEMM_TN
#define	GEMM_NC			SGEMM_NT
#define	GEMM_NT			SGEMM_NT
#define	GEMM_CC			SGEMM_TT
#define	GEMM_CT			SGEMM_TT
#define	GEMM_TC			SGEMM_TT
#define	GEMM_TT			SGEMM_TT
#define	GEMM_NR			SGEMM_NN
#define	GEMM_TR			SGEMM_TN
#define	GEMM_CR			SGEMM_TN
#define	GEMM_RN			SGEMM_NN
#define	GEMM_RT			SGEMM_NT
#define	GEMM_RC			SGEMM_NT
#define	GEMM_RR			SGEMM_NN

#define	SYMM_LU			SSYMM_LU
#define	SYMM_LL			SSYMM_LL
#define	SYMM_RU			SSYMM_RU
#define	SYMM_RL			SSYMM_RL

#define	HEMM_LU			SHEMM_LU
#define	HEMM_LL			SHEMM_LL
#define	HEMM_RU			SHEMM_RU
#define	HEMM_RL			SHEMM_RL

#define	SYRK_UN			SSYRK_UN
#define	SYRK_UT			SSYRK_UT
#define	SYRK_LN			SSYRK_LN
#define	SYRK_LT			SSYRK_LT
#define	SYRK_UR			SSYRK_UN
#define	SYRK_UC			SSYRK_UT
#define	SYRK_LR			SSYRK_LN
#define	SYRK_LC			SSYRK_LT

#define	SYRK_KERNEL_U		SSYRK_KERNEL_U
#define	SYRK_KERNEL_L		SSYRK_KERNEL_L

#define	HERK_UN			SSYRK_UN
#define	HERK_LN			SSYRK_LN
#define	HERK_UC			SSYRK_UT
#define	HERK_LC			SSYRK_LT

#define	HER2K_UN		SSYR2K_UN
#define	HER2K_LN		SSYR2K_LN
#define	HER2K_UC		SSYR2K_UT
#define	HER2K_LC		SSYR2K_LT

#define	SYR2K_UN		SSYR2K_UN
#define	SYR2K_UT		SSYR2K_UT
#define	SYR2K_LN		SSYR2K_LN
#define	SYR2K_LT		SSYR2K_LT
#define	SYR2K_UR		SSYR2K_UN
#define	SYR2K_UC		SSYR2K_UT
#define	SYR2K_LR		SSYR2K_LN
#define	SYR2K_LC		SSYR2K_LT

#define	SYR2K_KERNEL_U		SSYR2K_KERNEL_U
#define	SYR2K_KERNEL_L		SSYR2K_KERNEL_L

#define	TRMM_LNUU		STRMM_LNUU
#define	TRMM_LNUN		STRMM_LNUN
#define	TRMM_LNLU		STRMM_LNLU
#define	TRMM_LNLN		STRMM_LNLN
#define	TRMM_LTUU		STRMM_LTUU
#define	TRMM_LTUN		STRMM_LTUN
#define	TRMM_LTLU		STRMM_LTLU
#define	TRMM_LTLN		STRMM_LTLN
#define	TRMM_LRUU		STRMM_LNUU
#define	TRMM_LRUN		STRMM_LNUN
#define	TRMM_LRLU		STRMM_LNLU
#define	TRMM_LRLN		STRMM_LNLN
#define	TRMM_LCUU		STRMM_LTUU
#define	TRMM_LCUN		STRMM_LTUN
#define	TRMM_LCLU		STRMM_LTLU
#define	TRMM_LCLN		STRMM_LTLN
#define	TRMM_RNUU		STRMM_RNUU
#define	TRMM_RNUN		STRMM_RNUN
#define	TRMM_RNLU		STRMM_RNLU
#define	TRMM_RNLN		STRMM_RNLN
#define	TRMM_RTUU		STRMM_RTUU
#define	TRMM_RTUN		STRMM_RTUN
#define	TRMM_RTLU		STRMM_RTLU
#define	TRMM_RTLN		STRMM_RTLN
#define	TRMM_RRUU		STRMM_RNUU
#define	TRMM_RRUN		STRMM_RNUN
#define	TRMM_RRLU		STRMM_RNLU
#define	TRMM_RRLN		STRMM_RNLN
#define	TRMM_RCUU		STRMM_RTUU
#define	TRMM_RCUN		STRMM_RTUN
#define	TRMM_RCLU		STRMM_RTLU
#define	TRMM_RCLN		STRMM_RTLN

#define	TRSM_LNUU		STRSM_LNUU
#define	TRSM_LNUN		STRSM_LNUN
#define	TRSM_LNLU		STRSM_LNLU
#define	TRSM_LNLN		STRSM_LNLN
#define	TRSM_LTUU		STRSM_LTUU
#define	TRSM_LTUN		STRSM_LTUN
#define	TRSM_LTLU		STRSM_LTLU
#define	TRSM_LTLN		STRSM_LTLN
#define	TRSM_LRUU		STRSM_LNUU
#define	TRSM_LRUN		STRSM_LNUN
#define	TRSM_LRLU		STRSM_LNLU
#define	TRSM_LRLN		STRSM_LNLN
#define	TRSM_LCUU		STRSM_LTUU
#define	TRSM_LCUN		STRSM_LTUN
#define	TRSM_LCLU		STRSM_LTLU
#define	TRSM_LCLN		STRSM_LTLN
#define	TRSM_RNUU		STRSM_RNUU
#define	TRSM_RNUN		STRSM_RNUN
#define	TRSM_RNLU		STRSM_RNLU
#define	TRSM_RNLN		STRSM_RNLN
#define	TRSM_RTUU		STRSM_RTUU
#define	TRSM_RTUN		STRSM_RTUN
#define	TRSM_RTLU		STRSM_RTLU
#define	TRSM_RTLN		STRSM_RTLN
#define	TRSM_RRUU		STRSM_RNUU
#define	TRSM_RRUN		STRSM_RNUN
#define	TRSM_RRLU		STRSM_RNLU
#define	TRSM_RRLN		STRSM_RNLN
#define	TRSM_RCUU		STRSM_RTUU
#define	TRSM_RCUN		STRSM_RTUN
#define	TRSM_RCLU		STRSM_RTLU
#define	TRSM_RCLN		STRSM_RTLN

#define	GEMM_THREAD_NN		SGEMM_THREAD_NN
#define	GEMM_THREAD_CN		SGEMM_THREAD_TN
#define	GEMM_THREAD_TN		SGEMM_THREAD_TN
#define	GEMM_THREAD_NC		SGEMM_THREAD_NT
#define	GEMM_THREAD_NT		SGEMM_THREAD_NT
#define	GEMM_THREAD_CC		SGEMM_THREAD_TT
#define	GEMM_THREAD_CT		SGEMM_THREAD_TT
#define	GEMM_THREAD_TC		SGEMM_THREAD_TT
#define	GEMM_THREAD_TT		SGEMM_THREAD_TT
#define	GEMM_THREAD_NR		SGEMM_THREAD_NN
#define	GEMM_THREAD_TR		SGEMM_THREAD_TN
#define	GEMM_THREAD_CR		SGEMM_THREAD_TN
#define	GEMM_THREAD_RN		SGEMM_THREAD_NN
#define	GEMM_THREAD_RT		SGEMM_THREAD_NT
#define	GEMM_THREAD_RC		SGEMM_THREAD_NT
#define	GEMM_THREAD_RR		SGEMM_THREAD_NN

#define	SYMM_THREAD_LU		SSYMM_THREAD_LU
#define	SYMM_THREAD_LL		SSYMM_THREAD_LL
#define	SYMM_THREAD_RU		SSYMM_THREAD_RU
#define	SYMM_THREAD_RL		SSYMM_THREAD_RL

#define	HEMM_THREAD_LU		SHEMM_THREAD_LU
#define	HEMM_THREAD_LL		SHEMM_THREAD_LL
#define	HEMM_THREAD_RU		SHEMM_THREAD_RU
#define	HEMM_THREAD_RL		SHEMM_THREAD_RL

#define	SYRK_THREAD_UN		SSYRK_THREAD_UN
#define	SYRK_THREAD_UT		SSYRK_THREAD_UT
#define	SYRK_THREAD_LN		SSYRK_THREAD_LN
#define	SYRK_THREAD_LT		SSYRK_THREAD_LT
#define	SYRK_THREAD_UR		SSYRK_THREAD_UR
#define	SYRK_THREAD_UC		SSYRK_THREAD_UC
#define	SYRK_THREAD_LR		SSYRK_THREAD_LN
#define	SYRK_THREAD_LC		SSYRK_THREAD_LT

#define	HERK_THREAD_UN		SSYRK_THREAD_UN
#define	HERK_THREAD_UT		SSYRK_THREAD_UT
#define	HERK_THREAD_LN		SSYRK_THREAD_LN
#define	HERK_THREAD_LT		SSYRK_THREAD_LT
#define	HERK_THREAD_UR		SSYRK_THREAD_UR
#define	HERK_THREAD_UC		SSYRK_THREAD_UC
#define	HERK_THREAD_LR		SSYRK_THREAD_LN
#define	HERK_THREAD_LC		SSYRK_THREAD_LT

#define	AXPBY_K			SAXPBY_K

#define OMATCOPY_K_CN		SOMATCOPY_K_CN
#define OMATCOPY_K_RN		SOMATCOPY_K_RN
#define OMATCOPY_K_CT		SOMATCOPY_K_CT
#define OMATCOPY_K_RT		SOMATCOPY_K_RT
#define IMATCOPY_K_CN		SIMATCOPY_K_CN
#define IMATCOPY_K_RN		SIMATCOPY_K_RN
#define IMATCOPY_K_CT		SIMATCOPY_K_CT
#define IMATCOPY_K_RT		SIMATCOPY_K_RT

#define GEADD_K 		SGEADD_K
#endif
#else
#ifdef XDOUBLE

#define	AMAX_K			XAMAX_K
#define	AMIN_K			XAMIN_K
#define	MAX_K			XMAX_K
#define	MIN_K			XMIN_K
#define	IAMAX_K			IXAMAX_K
#define	IAMIN_K			IXAMIN_K
#define	IMAX_K			IXMAX_K
#define	IMIN_K			IXMIN_K
#define	ASUM_K			XASUM_K
#define	AXPYU_K			XAXPYU_K
#define	AXPYC_K			XAXPYC_K
#define	COPY_K			XCOPY_K
#define	DOTU_K			XDOTU_K
#define	DOTC_K			XDOTC_K
#define	NRM2_K			XNRM2_K
#define	SCAL_K			XSCAL_K
#define	SUM_K			XSUM_K
#define	SWAP_K			XSWAP_K
#define	ROT_K			XROT_K

#define	GEMV_N			XGEMV_N
#define	GEMV_T			XGEMV_T
#define	GEMV_R			XGEMV_R
#define	GEMV_C			XGEMV_C
#define	GEMV_O			XGEMV_O
#define	GEMV_U			XGEMV_U
#define	GEMV_S			XGEMV_S
#define	GEMV_D			XGEMV_D

#define	GERU_K			XGERU_K
#define	GERC_K			XGERC_K
#define	GERV_K			XGERV_K
#define	GERD_K			XGERD_K

#define	SYMV_U			XSYMV_U
#define	SYMV_L			XSYMV_L
#define	HEMV_U			XHEMV_U
#define	HEMV_L			XHEMV_L
#define	HEMV_V			XHEMV_V
#define	HEMV_M			XHEMV_M

#define	SYMV_THREAD_U		XSYMV_THREAD_U
#define	SYMV_THREAD_L		XSYMV_THREAD_L
#define	HEMV_THREAD_U		XHEMV_THREAD_U
#define	HEMV_THREAD_L		XHEMV_THREAD_L
#define	HEMV_THREAD_V		XHEMV_THREAD_V
#define	HEMV_THREAD_M		XHEMV_THREAD_M

#define	GEMM_ONCOPY		XGEMM_ONCOPY
#define	GEMM_OTCOPY		XGEMM_OTCOPY
#define	GEMM_INCOPY		XGEMM_INCOPY
#define	GEMM_ITCOPY		XGEMM_ITCOPY

#define	GEMM3M_ONCOPYB		XGEMM3M_ONCOPYB
#define	GEMM3M_ONCOPYR		XGEMM3M_ONCOPYR
#define	GEMM3M_ONCOPYI		XGEMM3M_ONCOPYI
#define	GEMM3M_OTCOPYB		XGEMM3M_OTCOPYB
#define	GEMM3M_OTCOPYR		XGEMM3M_OTCOPYR
#define	GEMM3M_OTCOPYI		XGEMM3M_OTCOPYI
#define	GEMM3M_INCOPYB		XGEMM3M_INCOPYB
#define	GEMM3M_INCOPYR		XGEMM3M_INCOPYR
#define	GEMM3M_INCOPYI		XGEMM3M_INCOPYI
#define	GEMM3M_ITCOPYB		XGEMM3M_ITCOPYB
#define	GEMM3M_ITCOPYR		XGEMM3M_ITCOPYR
#define	GEMM3M_ITCOPYI		XGEMM3M_ITCOPYI

#ifdef UNIT

#define	TRMM_OUNCOPY		XTRMM_OUNUCOPY
#define	TRMM_OUTCOPY		XTRMM_OUTUCOPY
#define	TRMM_OLNCOPY		XTRMM_OLNUCOPY
#define	TRMM_OLTCOPY		XTRMM_OLTUCOPY
#define	TRSM_OUNCOPY		XTRSM_OUNUCOPY
#define	TRSM_OUTCOPY		XTRSM_OUTUCOPY
#define	TRSM_OLNCOPY		XTRSM_OLNUCOPY
#define	TRSM_OLTCOPY		XTRSM_OLTUCOPY

#define	TRMM_IUNCOPY		XTRMM_IUNUCOPY
#define	TRMM_IUTCOPY		XTRMM_IUTUCOPY
#define	TRMM_ILNCOPY		XTRMM_ILNUCOPY
#define	TRMM_ILTCOPY		XTRMM_ILTUCOPY
#define	TRSM_IUNCOPY		XTRSM_IUNUCOPY
#define	TRSM_IUTCOPY		XTRSM_IUTUCOPY
#define	TRSM_ILNCOPY		XTRSM_ILNUCOPY
#define	TRSM_ILTCOPY		XTRSM_ILTUCOPY

#else

#define	TRMM_OUNCOPY		XTRMM_OUNNCOPY
#define	TRMM_OUTCOPY		XTRMM_OUTNCOPY
#define	TRMM_OLNCOPY		XTRMM_OLNNCOPY
#define	TRMM_OLTCOPY		XTRMM_OLTNCOPY
#define	TRSM_OUNCOPY		XTRSM_OUNNCOPY
#define	TRSM_OUTCOPY		XTRSM_OUTNCOPY
#define	TRSM_OLNCOPY		XTRSM_OLNNCOPY
#define	TRSM_OLTCOPY		XTRSM_OLTNCOPY

#define	TRMM_IUNCOPY		XTRMM_IUNNCOPY
#define	TRMM_IUTCOPY		XTRMM_IUTNCOPY
#define	TRMM_ILNCOPY		XTRMM_ILNNCOPY
#define	TRMM_ILTCOPY		XTRMM_ILTNCOPY
#define	TRSM_IUNCOPY		XTRSM_IUNNCOPY
#define	TRSM_IUTCOPY		XTRSM_IUTNCOPY
#define	TRSM_ILNCOPY		XTRSM_ILNNCOPY
#define	TRSM_ILTCOPY		XTRSM_ILTNCOPY

#endif

#define	SYMM3M_ILCOPYB		XSYMM3M_ILCOPYB
#define	SYMM3M_IUCOPYB		XSYMM3M_IUCOPYB
#define	SYMM3M_ILCOPYR		XSYMM3M_ILCOPYR
#define	SYMM3M_IUCOPYR		XSYMM3M_IUCOPYR
#define	SYMM3M_ILCOPYI		XSYMM3M_ILCOPYI
#define	SYMM3M_IUCOPYI		XSYMM3M_IUCOPYI

#define	SYMM3M_OLCOPYB		XSYMM3M_OLCOPYB
#define	SYMM3M_OUCOPYB		XSYMM3M_OUCOPYB
#define	SYMM3M_OLCOPYR		XSYMM3M_OLCOPYR
#define	SYMM3M_OUCOPYR		XSYMM3M_OUCOPYR
#define	SYMM3M_OLCOPYI		XSYMM3M_OLCOPYI
#define	SYMM3M_OUCOPYI		XSYMM3M_OUCOPYI

#define	HEMM3M_ILCOPYB		XHEMM3M_ILCOPYB
#define	HEMM3M_IUCOPYB		XHEMM3M_IUCOPYB
#define	HEMM3M_ILCOPYR		XHEMM3M_ILCOPYR
#define	HEMM3M_IUCOPYR		XHEMM3M_IUCOPYR
#define	HEMM3M_ILCOPYI		XHEMM3M_ILCOPYI
#define	HEMM3M_IUCOPYI		XHEMM3M_IUCOPYI

#define	HEMM3M_OLCOPYB		XHEMM3M_OLCOPYB
#define	HEMM3M_OUCOPYB		XHEMM3M_OUCOPYB
#define	HEMM3M_OLCOPYR		XHEMM3M_OLCOPYR
#define	HEMM3M_OUCOPYR		XHEMM3M_OUCOPYR
#define	HEMM3M_OLCOPYI		XHEMM3M_OLCOPYI
#define	HEMM3M_OUCOPYI		XHEMM3M_OUCOPYI

#define	GEMM_BETA		XGEMM_BETA

#define	GEMM_KERNEL_N		XGEMM_KERNEL_N
#define	GEMM_KERNEL_L		XGEMM_KERNEL_L
#define	GEMM_KERNEL_R		XGEMM_KERNEL_R
#define	GEMM_KERNEL_B		XGEMM_KERNEL_B

#define	GEMM3M_KERNEL		XGEMM3M_KERNEL

#define	TRMM_KERNEL_LN		XTRMM_KERNEL_LN
#define	TRMM_KERNEL_LT		XTRMM_KERNEL_LT
#define	TRMM_KERNEL_LR		XTRMM_KERNEL_LR
#define	TRMM_KERNEL_LC		XTRMM_KERNEL_LC
#define	TRMM_KERNEL_RN		XTRMM_KERNEL_RN
#define	TRMM_KERNEL_RT		XTRMM_KERNEL_RT
#define	TRMM_KERNEL_RR		XTRMM_KERNEL_RR
#define	TRMM_KERNEL_RC		XTRMM_KERNEL_RC

#define	TRSM_KERNEL_LN		XTRSM_KERNEL_LN
#define	TRSM_KERNEL_LT		XTRSM_KERNEL_LT
#define	TRSM_KERNEL_LR		XTRSM_KERNEL_LR
#define	TRSM_KERNEL_LC		XTRSM_KERNEL_LC
#define	TRSM_KERNEL_RN		XTRSM_KERNEL_RN
#define	TRSM_KERNEL_RT		XTRSM_KERNEL_RT
#define	TRSM_KERNEL_RR		XTRSM_KERNEL_RR
#define	TRSM_KERNEL_RC		XTRSM_KERNEL_RC

#define	GEMM_NN			XGEMM_NN
#define	GEMM_CN			XGEMM_CN
#define	GEMM_TN			XGEMM_TN
#define	GEMM_NC			XGEMM_NC
#define	GEMM_NT			XGEMM_NT
#define	GEMM_CC			XGEMM_CC
#define	GEMM_CT			XGEMM_CT
#define	GEMM_TC			XGEMM_TC
#define	GEMM_TT			XGEMM_TT
#define	GEMM_NR			XGEMM_NR
#define	GEMM_TR			XGEMM_TR
#define	GEMM_CR			XGEMM_CR
#define	GEMM_RN			XGEMM_RN
#define	GEMM_RT			XGEMM_RT
#define	GEMM_RC			XGEMM_RC
#define	GEMM_RR			XGEMM_RR

#define	SYMM_LU			XSYMM_LU
#define	SYMM_LL			XSYMM_LL
#define	SYMM_RU			XSYMM_RU
#define	SYMM_RL			XSYMM_RL

#define	HEMM_LU			XHEMM_LU
#define	HEMM_LL			XHEMM_LL
#define	HEMM_RU			XHEMM_RU
#define	HEMM_RL			XHEMM_RL

#define HEMM_IUTCOPY		XHEMM_IUTCOPY
#define HEMM_ILTCOPY		XHEMM_ILTCOPY
#define HEMM_OUTCOPY		XHEMM_OUTCOPY
#define HEMM_OLTCOPY		XHEMM_OLTCOPY

#define	SYRK_UN			XSYRK_UN
#define	SYRK_UT			XSYRK_UT
#define	SYRK_LN			XSYRK_LN
#define	SYRK_LT			XSYRK_LT
#define	SYRK_UR			XSYRK_UN
#define	SYRK_UC			XSYRK_UT
#define	SYRK_LR			XSYRK_LN
#define	SYRK_LC			XSYRK_LT

#define	SYRK_KERNEL_U		XSYRK_KERNEL_U
#define	SYRK_KERNEL_L		XSYRK_KERNEL_L

#define	HERK_UN			XHERK_UN
#define	HERK_LN			XHERK_LN
#define	HERK_UC			XHERK_UC
#define	HERK_LC			XHERK_LC

#define	HER2K_UN		XHER2K_UN
#define	HER2K_LN		XHER2K_LN
#define	HER2K_UC		XHER2K_UC
#define	HER2K_LC		XHER2K_LC

#define	SYR2K_UN		XSYR2K_UN
#define	SYR2K_UT		XSYR2K_UT
#define	SYR2K_LN		XSYR2K_LN
#define	SYR2K_LT		XSYR2K_LT
#define	SYR2K_UR		XSYR2K_UN
#define	SYR2K_UC		XSYR2K_UT
#define	SYR2K_LR		XSYR2K_LN
#define	SYR2K_LC		XSYR2K_LT

#define	SYR2K_KERNEL_U		XSYR2K_KERNEL_U
#define	SYR2K_KERNEL_L		XSYR2K_KERNEL_L

#define	TRMM_LNUU		XTRMM_LNUU
#define	TRMM_LNUN		XTRMM_LNUN
#define	TRMM_LNLU		XTRMM_LNLU
#define	TRMM_LNLN		XTRMM_LNLN
#define	TRMM_LTUU		XTRMM_LTUU
#define	TRMM_LTUN		XTRMM_LTUN
#define	TRMM_LTLU		XTRMM_LTLU
#define	TRMM_LTLN		XTRMM_LTLN
#define	TRMM_LRUU		XTRMM_LRUU
#define	TRMM_LRUN		XTRMM_LRUN
#define	TRMM_LRLU		XTRMM_LRLU
#define	TRMM_LRLN		XTRMM_LRLN
#define	TRMM_LCUU		XTRMM_LCUU
#define	TRMM_LCUN		XTRMM_LCUN
#define	TRMM_LCLU		XTRMM_LCLU
#define	TRMM_LCLN		XTRMM_LCLN
#define	TRMM_RNUU		XTRMM_RNUU
#define	TRMM_RNUN		XTRMM_RNUN
#define	TRMM_RNLU		XTRMM_RNLU
#define	TRMM_RNLN		XTRMM_RNLN
#define	TRMM_RTUU		XTRMM_RTUU
#define	TRMM_RTUN		XTRMM_RTUN
#define	TRMM_RTLU		XTRMM_RTLU
#define	TRMM_RTLN		XTRMM_RTLN
#define	TRMM_RRUU		XTRMM_RRUU
#define	TRMM_RRUN		XTRMM_RRUN
#define	TRMM_RRLU		XTRMM_RRLU
#define	TRMM_RRLN		XTRMM_RRLN
#define	TRMM_RCUU		XTRMM_RCUU
#define	TRMM_RCUN		XTRMM_RCUN
#define	TRMM_RCLU		XTRMM_RCLU
#define	TRMM_RCLN		XTRMM_RCLN

#define	TRSM_LNUU		XTRSM_LNUU
#define	TRSM_LNUN		XTRSM_LNUN
#define	TRSM_LNLU		XTRSM_LNLU
#define	TRSM_LNLN		XTRSM_LNLN
#define	TRSM_LTUU		XTRSM_LTUU
#define	TRSM_LTUN		XTRSM_LTUN
#define	TRSM_LTLU		XTRSM_LTLU
#define	TRSM_LTLN		XTRSM_LTLN
#define	TRSM_LRUU		XTRSM_LRUU
#define	TRSM_LRUN		XTRSM_LRUN
#define	TRSM_LRLU		XTRSM_LRLU
#define	TRSM_LRLN		XTRSM_LRLN
#define	TRSM_LCUU		XTRSM_LCUU
#define	TRSM_LCUN		XTRSM_LCUN
#define	TRSM_LCLU		XTRSM_LCLU
#define	TRSM_LCLN		XTRSM_LCLN
#define	TRSM_RNUU		XTRSM_RNUU
#define	TRSM_RNUN		XTRSM_RNUN
#define	TRSM_RNLU		XTRSM_RNLU
#define	TRSM_RNLN		XTRSM_RNLN
#define	TRSM_RTUU		XTRSM_RTUU
#define	TRSM_RTUN		XTRSM_RTUN
#define	TRSM_RTLU		XTRSM_RTLU
#define	TRSM_RTLN		XTRSM_RTLN
#define	TRSM_RRUU		XTRSM_RRUU
#define	TRSM_RRUN		XTRSM_RRUN
#define	TRSM_RRLU		XTRSM_RRLU
#define	TRSM_RRLN		XTRSM_RRLN
#define	TRSM_RCUU		XTRSM_RCUU
#define	TRSM_RCUN		XTRSM_RCUN
#define	TRSM_RCLU		XTRSM_RCLU
#define	TRSM_RCLN		XTRSM_RCLN


#define	GEMM_THREAD_NN		XGEMM_THREAD_NN
#define	GEMM_THREAD_CN		XGEMM_THREAD_CN
#define	GEMM_THREAD_TN		XGEMM_THREAD_TN
#define	GEMM_THREAD_NC		XGEMM_THREAD_NC
#define	GEMM_THREAD_NT		XGEMM_THREAD_NT
#define	GEMM_THREAD_CC		XGEMM_THREAD_CC
#define	GEMM_THREAD_CT		XGEMM_THREAD_CT
#define	GEMM_THREAD_TC		XGEMM_THREAD_TC
#define	GEMM_THREAD_TT		XGEMM_THREAD_TT
#define	GEMM_THREAD_NR		XGEMM_THREAD_NR
#define	GEMM_THREAD_TR		XGEMM_THREAD_TR
#define	GEMM_THREAD_CR		XGEMM_THREAD_CR
#define	GEMM_THREAD_RN		XGEMM_THREAD_RN
#define	GEMM_THREAD_RT		XGEMM_THREAD_RT
#define	GEMM_THREAD_RC		XGEMM_THREAD_RC
#define	GEMM_THREAD_RR		XGEMM_THREAD_RR

#define	SYMM_THREAD_LU		XSYMM_THREAD_LU
#define	SYMM_THREAD_LL		XSYMM_THREAD_LL
#define	SYMM_THREAD_RU		XSYMM_THREAD_RU
#define	SYMM_THREAD_RL		XSYMM_THREAD_RL

#define	HEMM_THREAD_LU		XHEMM_THREAD_LU
#define	HEMM_THREAD_LL		XHEMM_THREAD_LL
#define	HEMM_THREAD_RU		XHEMM_THREAD_RU
#define	HEMM_THREAD_RL		XHEMM_THREAD_RL

#define	SYRK_THREAD_UN		XSYRK_THREAD_UN
#define	SYRK_THREAD_UT		XSYRK_THREAD_UT
#define	SYRK_THREAD_LN		XSYRK_THREAD_LN
#define	SYRK_THREAD_LT		XSYRK_THREAD_LT
#define	SYRK_THREAD_UR		XSYRK_THREAD_UR
#define	SYRK_THREAD_UC		XSYRK_THREAD_UC
#define	SYRK_THREAD_LR		XSYRK_THREAD_LR
#define	SYRK_THREAD_LC		XSYRK_THREAD_LC

#define	HERK_THREAD_UN		XHERK_THREAD_UN
#define	HERK_THREAD_UT		XHERK_THREAD_UT
#define	HERK_THREAD_LN		XHERK_THREAD_LN
#define	HERK_THREAD_LT		XHERK_THREAD_LT
#define	HERK_THREAD_UR		XHERK_THREAD_UR
#define	HERK_THREAD_UC		XHERK_THREAD_UC
#define	HERK_THREAD_LR		XHERK_THREAD_LR
#define	HERK_THREAD_LC		XHERK_THREAD_LC

#define	GEMM3M_NN		XGEMM3M_NN
#define	GEMM3M_CN		XGEMM3M_CN
#define	GEMM3M_TN		XGEMM3M_TN
#define	GEMM3M_NC		XGEMM3M_NC
#define	GEMM3M_NT		XGEMM3M_NT
#define	GEMM3M_CC		XGEMM3M_CC
#define	GEMM3M_CT		XGEMM3M_CT
#define	GEMM3M_TC		XGEMM3M_TC
#define	GEMM3M_TT		XGEMM3M_TT
#define	GEMM3M_NR		XGEMM3M_NR
#define	GEMM3M_TR		XGEMM3M_TR
#define	GEMM3M_CR		XGEMM3M_CR
#define	GEMM3M_RN		XGEMM3M_RN
#define	GEMM3M_RT		XGEMM3M_RT
#define	GEMM3M_RC		XGEMM3M_RC
#define	GEMM3M_RR		XGEMM3M_RR

#define	GEMM3M_THREAD_NN	XGEMM3M_THREAD_NN
#define	GEMM3M_THREAD_CN	XGEMM3M_THREAD_CN
#define	GEMM3M_THREAD_TN	XGEMM3M_THREAD_TN
#define	GEMM3M_THREAD_NC	XGEMM3M_THREAD_NC
#define	GEMM3M_THREAD_NT	XGEMM3M_THREAD_NT
#define	GEMM3M_THREAD_CC	XGEMM3M_THREAD_CC
#define	GEMM3M_THREAD_CT	XGEMM3M_THREAD_CT
#define	GEMM3M_THREAD_TC	XGEMM3M_THREAD_TC
#define	GEMM3M_THREAD_TT	XGEMM3M_THREAD_TT
#define	GEMM3M_THREAD_NR	XGEMM3M_THREAD_NR
#define	GEMM3M_THREAD_TR	XGEMM3M_THREAD_TR
#define	GEMM3M_THREAD_CR	XGEMM3M_THREAD_CR
#define	GEMM3M_THREAD_RN	XGEMM3M_THREAD_RN
#define	GEMM3M_THREAD_RT	XGEMM3M_THREAD_RT
#define	GEMM3M_THREAD_RC	XGEMM3M_THREAD_RC
#define	GEMM3M_THREAD_RR	XGEMM3M_THREAD_RR

#define	SYMM3M_LU		XSYMM3M_LU
#define	SYMM3M_LL		XSYMM3M_LL
#define	SYMM3M_RU		XSYMM3M_RU
#define	SYMM3M_RL		XSYMM3M_RL

#define	SYMM3M_THREAD_LU	XSYMM3M_THREAD_LU
#define	SYMM3M_THREAD_LL	XSYMM3M_THREAD_LL
#define	SYMM3M_THREAD_RU	XSYMM3M_THREAD_RU
#define	SYMM3M_THREAD_RL	XSYMM3M_THREAD_RL

#define	HEMM3M_LU		XHEMM3M_LU
#define	HEMM3M_LL		XHEMM3M_LL
#define	HEMM3M_RU		XHEMM3M_RU
#define	HEMM3M_RL		XHEMM3M_RL

#define	HEMM3M_THREAD_LU	XHEMM3M_THREAD_LU
#define	HEMM3M_THREAD_LL	XHEMM3M_THREAD_LL
#define	HEMM3M_THREAD_RU	XHEMM3M_THREAD_RU
#define	HEMM3M_THREAD_RL	XHEMM3M_THREAD_RL

#define SYMM_IUTCOPY		XSYMM_IUTCOPY
#define SYMM_ILTCOPY		XSYMM_ILTCOPY
#define SYMM_OUTCOPY		XSYMM_OUTCOPY
#define SYMM_OLTCOPY		XSYMM_OLTCOPY

#elif defined(DOUBLE)

#define	AMAX_K			ZAMAX_K
#define	AMIN_K			ZAMIN_K
#define	MAX_K			ZMAX_K
#define	MIN_K			ZMIN_K
#define	IAMAX_K			IZAMAX_K
#define	IAMIN_K			IZAMIN_K
#define	IMAX_K			IZMAX_K
#define	IMIN_K			IZMIN_K
#define	ASUM_K			ZASUM_K
#define	AXPYU_K			ZAXPYU_K
#define	AXPYC_K			ZAXPYC_K
#define	COPY_K			ZCOPY_K
#define	DOTU_K			ZDOTU_K
#define	DOTC_K			ZDOTC_K
#define	NRM2_K			ZNRM2_K
#define	SCAL_K			ZSCAL_K
#define	SUM_K			ZSUM_K
#define	SWAP_K			ZSWAP_K
#define	ROT_K			ZROT_K

#define	GEMV_N			ZGEMV_N
#define	GEMV_T			ZGEMV_T
#define	GEMV_R			ZGEMV_R
#define	GEMV_C			ZGEMV_C
#define	GEMV_O			ZGEMV_O
#define	GEMV_U			ZGEMV_U
#define	GEMV_S			ZGEMV_S
#define	GEMV_D			ZGEMV_D

#define	GERU_K			ZGERU_K
#define	GERC_K			ZGERC_K
#define	GERV_K			ZGERV_K
#define	GERD_K			ZGERD_K

#define	SYMV_U			ZSYMV_U
#define	SYMV_L			ZSYMV_L
#define	HEMV_U			ZHEMV_U
#define	HEMV_L			ZHEMV_L
#define	HEMV_V			ZHEMV_V
#define	HEMV_M			ZHEMV_M

#define	SYMV_THREAD_U		ZSYMV_THREAD_U
#define	SYMV_THREAD_L		ZSYMV_THREAD_L
#define	HEMV_THREAD_U		ZHEMV_THREAD_U
#define	HEMV_THREAD_L		ZHEMV_THREAD_L
#define	HEMV_THREAD_V		ZHEMV_THREAD_V
#define	HEMV_THREAD_M		ZHEMV_THREAD_M

#define	GEMM_ONCOPY		ZGEMM_ONCOPY
#define	GEMM_OTCOPY		ZGEMM_OTCOPY
#define	GEMM_INCOPY		ZGEMM_INCOPY
#define	GEMM_ITCOPY		ZGEMM_ITCOPY

#define	GEMM3M_ONCOPYB		ZGEMM3M_ONCOPYB
#define	GEMM3M_ONCOPYR		ZGEMM3M_ONCOPYR
#define	GEMM3M_ONCOPYI		ZGEMM3M_ONCOPYI
#define	GEMM3M_OTCOPYB		ZGEMM3M_OTCOPYB
#define	GEMM3M_OTCOPYR		ZGEMM3M_OTCOPYR
#define	GEMM3M_OTCOPYI		ZGEMM3M_OTCOPYI
#define	GEMM3M_INCOPYB		ZGEMM3M_INCOPYB
#define	GEMM3M_INCOPYR		ZGEMM3M_INCOPYR
#define	GEMM3M_INCOPYI		ZGEMM3M_INCOPYI
#define	GEMM3M_ITCOPYB		ZGEMM3M_ITCOPYB
#define	GEMM3M_ITCOPYR		ZGEMM3M_ITCOPYR
#define	GEMM3M_ITCOPYI		ZGEMM3M_ITCOPYI

#ifdef UNIT

#define	TRMM_OUNCOPY		ZTRMM_OUNUCOPY
#define	TRMM_OUTCOPY		ZTRMM_OUTUCOPY
#define	TRMM_OLNCOPY		ZTRMM_OLNUCOPY
#define	TRMM_OLTCOPY		ZTRMM_OLTUCOPY
#define	TRSM_OUNCOPY		ZTRSM_OUNUCOPY
#define	TRSM_OUTCOPY		ZTRSM_OUTUCOPY
#define	TRSM_OLNCOPY		ZTRSM_OLNUCOPY
#define	TRSM_OLTCOPY		ZTRSM_OLTUCOPY

#define	TRMM_IUNCOPY		ZTRMM_IUNUCOPY
#define	TRMM_IUTCOPY		ZTRMM_IUTUCOPY
#define	TRMM_ILNCOPY		ZTRMM_ILNUCOPY
#define	TRMM_ILTCOPY		ZTRMM_ILTUCOPY
#define	TRSM_IUNCOPY		ZTRSM_IUNUCOPY
#define	TRSM_IUTCOPY		ZTRSM_IUTUCOPY
#define	TRSM_ILNCOPY		ZTRSM_ILNUCOPY
#define	TRSM_ILTCOPY		ZTRSM_ILTUCOPY

#else

#define	TRMM_OUNCOPY		ZTRMM_OUNNCOPY
#define	TRMM_OUTCOPY		ZTRMM_OUTNCOPY
#define	TRMM_OLNCOPY		ZTRMM_OLNNCOPY
#define	TRMM_OLTCOPY		ZTRMM_OLTNCOPY
#define	TRSM_OUNCOPY		ZTRSM_OUNNCOPY
#define	TRSM_OUTCOPY		ZTRSM_OUTNCOPY
#define	TRSM_OLNCOPY		ZTRSM_OLNNCOPY
#define	TRSM_OLTCOPY		ZTRSM_OLTNCOPY

#define	TRMM_IUNCOPY		ZTRMM_IUNNCOPY
#define	TRMM_IUTCOPY		ZTRMM_IUTNCOPY
#define	TRMM_ILNCOPY		ZTRMM_ILNNCOPY
#define	TRMM_ILTCOPY		ZTRMM_ILTNCOPY
#define	TRSM_IUNCOPY		ZTRSM_IUNNCOPY
#define	TRSM_IUTCOPY		ZTRSM_IUTNCOPY
#define	TRSM_ILNCOPY		ZTRSM_ILNNCOPY
#define	TRSM_ILTCOPY		ZTRSM_ILTNCOPY

#endif

#define	SYMM3M_ILCOPYB		ZSYMM3M_ILCOPYB
#define	SYMM3M_IUCOPYB		ZSYMM3M_IUCOPYB
#define	SYMM3M_ILCOPYR		ZSYMM3M_ILCOPYR
#define	SYMM3M_IUCOPYR		ZSYMM3M_IUCOPYR
#define	SYMM3M_ILCOPYI		ZSYMM3M_ILCOPYI
#define	SYMM3M_IUCOPYI		ZSYMM3M_IUCOPYI

#define	SYMM3M_OLCOPYB		ZSYMM3M_OLCOPYB
#define	SYMM3M_OUCOPYB		ZSYMM3M_OUCOPYB
#define	SYMM3M_OLCOPYR		ZSYMM3M_OLCOPYR
#define	SYMM3M_OUCOPYR		ZSYMM3M_OUCOPYR
#define	SYMM3M_OLCOPYI		ZSYMM3M_OLCOPYI
#define	SYMM3M_OUCOPYI		ZSYMM3M_OUCOPYI

#define	HEMM3M_ILCOPYB		ZHEMM3M_ILCOPYB
#define	HEMM3M_IUCOPYB		ZHEMM3M_IUCOPYB
#define	HEMM3M_ILCOPYR		ZHEMM3M_ILCOPYR
#define	HEMM3M_IUCOPYR		ZHEMM3M_IUCOPYR
#define	HEMM3M_ILCOPYI		ZHEMM3M_ILCOPYI
#define	HEMM3M_IUCOPYI		ZHEMM3M_IUCOPYI

#define	HEMM3M_OLCOPYB		ZHEMM3M_OLCOPYB
#define	HEMM3M_OUCOPYB		ZHEMM3M_OUCOPYB
#define	HEMM3M_OLCOPYR		ZHEMM3M_OLCOPYR
#define	HEMM3M_OUCOPYR		ZHEMM3M_OUCOPYR
#define	HEMM3M_OLCOPYI		ZHEMM3M_OLCOPYI
#define	HEMM3M_OUCOPYI		ZHEMM3M_OUCOPYI

#define	GEMM_BETA		ZGEMM_BETA

#define	GEMM_KERNEL_N		ZGEMM_KERNEL_N
#define	GEMM_KERNEL_L		ZGEMM_KERNEL_L
#define	GEMM_KERNEL_R		ZGEMM_KERNEL_R
#define	GEMM_KERNEL_B		ZGEMM_KERNEL_B

#define	GEMM3M_KERNEL		ZGEMM3M_KERNEL

#define	TRMM_KERNEL_LN		ZTRMM_KERNEL_LN
#define	TRMM_KERNEL_LT		ZTRMM_KERNEL_LT
#define	TRMM_KERNEL_LR		ZTRMM_KERNEL_LR
#define	TRMM_KERNEL_LC		ZTRMM_KERNEL_LC
#define	TRMM_KERNEL_RN		ZTRMM_KERNEL_RN
#define	TRMM_KERNEL_RT		ZTRMM_KERNEL_RT
#define	TRMM_KERNEL_RR		ZTRMM_KERNEL_RR
#define	TRMM_KERNEL_RC		ZTRMM_KERNEL_RC

#define	TRSM_KERNEL_LN		ZTRSM_KERNEL_LN
#define	TRSM_KERNEL_LT		ZTRSM_KERNEL_LT
#define	TRSM_KERNEL_LR		ZTRSM_KERNEL_LR
#define	TRSM_KERNEL_LC		ZTRSM_KERNEL_LC
#define	TRSM_KERNEL_RN		ZTRSM_KERNEL_RN
#define	TRSM_KERNEL_RT		ZTRSM_KERNEL_RT
#define	TRSM_KERNEL_RR		ZTRSM_KERNEL_RR
#define	TRSM_KERNEL_RC		ZTRSM_KERNEL_RC

#define	GEMM_NN			ZGEMM_NN
#define	GEMM_CN			ZGEMM_CN
#define	GEMM_TN			ZGEMM_TN
#define	GEMM_NC			ZGEMM_NC
#define	GEMM_NT			ZGEMM_NT
#define	GEMM_CC			ZGEMM_CC
#define	GEMM_CT			ZGEMM_CT
#define	GEMM_TC			ZGEMM_TC
#define	GEMM_TT			ZGEMM_TT
#define	GEMM_NR			ZGEMM_NR
#define	GEMM_TR			ZGEMM_TR
#define	GEMM_CR			ZGEMM_CR
#define	GEMM_RN			ZGEMM_RN
#define	GEMM_RT			ZGEMM_RT
#define	GEMM_RC			ZGEMM_RC
#define	GEMM_RR			ZGEMM_RR

#define	SYMM_LU			ZSYMM_LU
#define	SYMM_LL			ZSYMM_LL
#define	SYMM_RU			ZSYMM_RU
#define	SYMM_RL			ZSYMM_RL

#define	HEMM_LU			ZHEMM_LU
#define	HEMM_LL			ZHEMM_LL
#define	HEMM_RU			ZHEMM_RU
#define	HEMM_RL			ZHEMM_RL

#define HEMM_IUTCOPY		ZHEMM_IUTCOPY
#define HEMM_ILTCOPY		ZHEMM_ILTCOPY
#define HEMM_OUTCOPY		ZHEMM_OUTCOPY
#define HEMM_OLTCOPY		ZHEMM_OLTCOPY

#define	SYRK_UN			ZSYRK_UN
#define	SYRK_UT			ZSYRK_UT
#define	SYRK_LN			ZSYRK_LN
#define	SYRK_LT			ZSYRK_LT
#define	SYRK_UR			ZSYRK_UN
#define	SYRK_UC			ZSYRK_UT
#define	SYRK_LR			ZSYRK_LN
#define	SYRK_LC			ZSYRK_LT

#define	SYRK_KERNEL_U		ZSYRK_KERNEL_U
#define	SYRK_KERNEL_L		ZSYRK_KERNEL_L

#define	HERK_UN			ZHERK_UN
#define	HERK_LN			ZHERK_LN
#define	HERK_UC			ZHERK_UC
#define	HERK_LC			ZHERK_LC

#define	HER2K_UN		ZHER2K_UN
#define	HER2K_LN		ZHER2K_LN
#define	HER2K_UC		ZHER2K_UC
#define	HER2K_LC		ZHER2K_LC

#define	SYR2K_UN		ZSYR2K_UN
#define	SYR2K_UT		ZSYR2K_UT
#define	SYR2K_LN		ZSYR2K_LN
#define	SYR2K_LT		ZSYR2K_LT
#define	SYR2K_UR		ZSYR2K_UN
#define	SYR2K_UC		ZSYR2K_UT
#define	SYR2K_LR		ZSYR2K_LN
#define	SYR2K_LC		ZSYR2K_LT

#define	SYR2K_KERNEL_U		ZSYR2K_KERNEL_U
#define	SYR2K_KERNEL_L		ZSYR2K_KERNEL_L

#define	TRMM_LNUU		ZTRMM_LNUU
#define	TRMM_LNUN		ZTRMM_LNUN
#define	TRMM_LNLU		ZTRMM_LNLU
#define	TRMM_LNLN		ZTRMM_LNLN
#define	TRMM_LTUU		ZTRMM_LTUU
#define	TRMM_LTUN		ZTRMM_LTUN
#define	TRMM_LTLU		ZTRMM_LTLU
#define	TRMM_LTLN		ZTRMM_LTLN
#define	TRMM_LRUU		ZTRMM_LRUU
#define	TRMM_LRUN		ZTRMM_LRUN
#define	TRMM_LRLU		ZTRMM_LRLU
#define	TRMM_LRLN		ZTRMM_LRLN
#define	TRMM_LCUU		ZTRMM_LCUU
#define	TRMM_LCUN		ZTRMM_LCUN
#define	TRMM_LCLU		ZTRMM_LCLU
#define	TRMM_LCLN		ZTRMM_LCLN
#define	TRMM_RNUU		ZTRMM_RNUU
#define	TRMM_RNUN		ZTRMM_RNUN
#define	TRMM_RNLU		ZTRMM_RNLU
#define	TRMM_RNLN		ZTRMM_RNLN
#define	TRMM_RTUU		ZTRMM_RTUU
#define	TRMM_RTUN		ZTRMM_RTUN
#define	TRMM_RTLU		ZTRMM_RTLU
#define	TRMM_RTLN		ZTRMM_RTLN
#define	TRMM_RRUU		ZTRMM_RRUU
#define	TRMM_RRUN		ZTRMM_RRUN
#define	TRMM_RRLU		ZTRMM_RRLU
#define	TRMM_RRLN		ZTRMM_RRLN
#define	TRMM_RCUU		ZTRMM_RCUU
#define	TRMM_RCUN		ZTRMM_RCUN
#define	TRMM_RCLU		ZTRMM_RCLU
#define	TRMM_RCLN		ZTRMM_RCLN

#define	TRSM_LNUU		ZTRSM_LNUU
#define	TRSM_LNUN		ZTRSM_LNUN
#define	TRSM_LNLU		ZTRSM_LNLU
#define	TRSM_LNLN		ZTRSM_LNLN
#define	TRSM_LTUU		ZTRSM_LTUU
#define	TRSM_LTUN		ZTRSM_LTUN
#define	TRSM_LTLU		ZTRSM_LTLU
#define	TRSM_LTLN		ZTRSM_LTLN
#define	TRSM_LRUU		ZTRSM_LRUU
#define	TRSM_LRUN		ZTRSM_LRUN
#define	TRSM_LRLU		ZTRSM_LRLU
#define	TRSM_LRLN		ZTRSM_LRLN
#define	TRSM_LCUU		ZTRSM_LCUU
#define	TRSM_LCUN		ZTRSM_LCUN
#define	TRSM_LCLU		ZTRSM_LCLU
#define	TRSM_LCLN		ZTRSM_LCLN
#define	TRSM_RNUU		ZTRSM_RNUU
#define	TRSM_RNUN		ZTRSM_RNUN
#define	TRSM_RNLU		ZTRSM_RNLU
#define	TRSM_RNLN		ZTRSM_RNLN
#define	TRSM_RTUU		ZTRSM_RTUU
#define	TRSM_RTUN		ZTRSM_RTUN
#define	TRSM_RTLU		ZTRSM_RTLU
#define	TRSM_RTLN		ZTRSM_RTLN
#define	TRSM_RRUU		ZTRSM_RRUU
#define	TRSM_RRUN		ZTRSM_RRUN
#define	TRSM_RRLU		ZTRSM_RRLU
#define	TRSM_RRLN		ZTRSM_RRLN
#define	TRSM_RCUU		ZTRSM_RCUU
#define	TRSM_RCUN		ZTRSM_RCUN
#define	TRSM_RCLU		ZTRSM_RCLU
#define	TRSM_RCLN		ZTRSM_RCLN


#define	GEMM_THREAD_NN		ZGEMM_THREAD_NN
#define	GEMM_THREAD_CN		ZGEMM_THREAD_CN
#define	GEMM_THREAD_TN		ZGEMM_THREAD_TN
#define	GEMM_THREAD_NC		ZGEMM_THREAD_NC
#define	GEMM_THREAD_NT		ZGEMM_THREAD_NT
#define	GEMM_THREAD_CC		ZGEMM_THREAD_CC
#define	GEMM_THREAD_CT		ZGEMM_THREAD_CT
#define	GEMM_THREAD_TC		ZGEMM_THREAD_TC
#define	GEMM_THREAD_TT		ZGEMM_THREAD_TT
#define	GEMM_THREAD_NR		ZGEMM_THREAD_NR
#define	GEMM_THREAD_TR		ZGEMM_THREAD_TR
#define	GEMM_THREAD_CR		ZGEMM_THREAD_CR
#define	GEMM_THREAD_RN		ZGEMM_THREAD_RN
#define	GEMM_THREAD_RT		ZGEMM_THREAD_RT
#define	GEMM_THREAD_RC		ZGEMM_THREAD_RC
#define	GEMM_THREAD_RR		ZGEMM_THREAD_RR

#define	SYMM_THREAD_LU		ZSYMM_THREAD_LU
#define	SYMM_THREAD_LL		ZSYMM_THREAD_LL
#define	SYMM_THREAD_RU		ZSYMM_THREAD_RU
#define	SYMM_THREAD_RL		ZSYMM_THREAD_RL

#define	HEMM_THREAD_LU		ZHEMM_THREAD_LU
#define	HEMM_THREAD_LL		ZHEMM_THREAD_LL
#define	HEMM_THREAD_RU		ZHEMM_THREAD_RU
#define	HEMM_THREAD_RL		ZHEMM_THREAD_RL

#define	SYRK_THREAD_UN		ZSYRK_THREAD_UN
#define	SYRK_THREAD_UT		ZSYRK_THREAD_UT
#define	SYRK_THREAD_LN		ZSYRK_THREAD_LN
#define	SYRK_THREAD_LT		ZSYRK_THREAD_LT
#define	SYRK_THREAD_UR		ZSYRK_THREAD_UR
#define	SYRK_THREAD_UC		ZSYRK_THREAD_UC
#define	SYRK_THREAD_LR		ZSYRK_THREAD_LR
#define	SYRK_THREAD_LC		ZSYRK_THREAD_LC

#define	HERK_THREAD_UN		ZHERK_THREAD_UN
#define	HERK_THREAD_UT		ZHERK_THREAD_UT
#define	HERK_THREAD_LN		ZHERK_THREAD_LN
#define	HERK_THREAD_LT		ZHERK_THREAD_LT
#define	HERK_THREAD_UR		ZHERK_THREAD_UR
#define	HERK_THREAD_UC		ZHERK_THREAD_UC
#define	HERK_THREAD_LR		ZHERK_THREAD_LR
#define	HERK_THREAD_LC		ZHERK_THREAD_LC

#define	GEMM3M_NN		ZGEMM3M_NN
#define	GEMM3M_CN		ZGEMM3M_CN
#define	GEMM3M_TN		ZGEMM3M_TN
#define	GEMM3M_NC		ZGEMM3M_NC
#define	GEMM3M_NT		ZGEMM3M_NT
#define	GEMM3M_CC		ZGEMM3M_CC
#define	GEMM3M_CT		ZGEMM3M_CT
#define	GEMM3M_TC		ZGEMM3M_TC
#define	GEMM3M_TT		ZGEMM3M_TT
#define	GEMM3M_NR		ZGEMM3M_NR
#define	GEMM3M_TR		ZGEMM3M_TR
#define	GEMM3M_CR		ZGEMM3M_CR
#define	GEMM3M_RN		ZGEMM3M_RN
#define	GEMM3M_RT		ZGEMM3M_RT
#define	GEMM3M_RC		ZGEMM3M_RC
#define	GEMM3M_RR		ZGEMM3M_RR

#define	GEMM3M_THREAD_NN	ZGEMM3M_THREAD_NN
#define	GEMM3M_THREAD_CN	ZGEMM3M_THREAD_CN
#define	GEMM3M_THREAD_TN	ZGEMM3M_THREAD_TN
#define	GEMM3M_THREAD_NC	ZGEMM3M_THREAD_NC
#define	GEMM3M_THREAD_NT	ZGEMM3M_THREAD_NT
#define	GEMM3M_THREAD_CC	ZGEMM3M_THREAD_CC
#define	GEMM3M_THREAD_CT	ZGEMM3M_THREAD_CT
#define	GEMM3M_THREAD_TC	ZGEMM3M_THREAD_TC
#define	GEMM3M_THREAD_TT	ZGEMM3M_THREAD_TT
#define	GEMM3M_THREAD_NR	ZGEMM3M_THREAD_NR
#define	GEMM3M_THREAD_TR	ZGEMM3M_THREAD_TR
#define	GEMM3M_THREAD_CR	ZGEMM3M_THREAD_CR
#define	GEMM3M_THREAD_RN	ZGEMM3M_THREAD_RN
#define	GEMM3M_THREAD_RT	ZGEMM3M_THREAD_RT
#define	GEMM3M_THREAD_RC	ZGEMM3M_THREAD_RC
#define	GEMM3M_THREAD_RR	ZGEMM3M_THREAD_RR

#define	SYMM3M_LU		ZSYMM3M_LU
#define	SYMM3M_LL		ZSYMM3M_LL
#define	SYMM3M_RU		ZSYMM3M_RU
#define	SYMM3M_RL		ZSYMM3M_RL

#define	SYMM3M_THREAD_LU	ZSYMM3M_THREAD_LU
#define	SYMM3M_THREAD_LL	ZSYMM3M_THREAD_LL
#define	SYMM3M_THREAD_RU	ZSYMM3M_THREAD_RU
#define	SYMM3M_THREAD_RL	ZSYMM3M_THREAD_RL

#define	HEMM3M_LU		ZHEMM3M_LU
#define	HEMM3M_LL		ZHEMM3M_LL
#define	HEMM3M_RU		ZHEMM3M_RU
#define	HEMM3M_RL		ZHEMM3M_RL

#define	HEMM3M_THREAD_LU	ZHEMM3M_THREAD_LU
#define	HEMM3M_THREAD_LL	ZHEMM3M_THREAD_LL
#define	HEMM3M_THREAD_RU	ZHEMM3M_THREAD_RU
#define	HEMM3M_THREAD_RL	ZHEMM3M_THREAD_RL

#define SYMM_IUTCOPY		ZSYMM_IUTCOPY
#define SYMM_ILTCOPY		ZSYMM_ILTCOPY
#define SYMM_OUTCOPY		ZSYMM_OUTCOPY
#define SYMM_OLTCOPY		ZSYMM_OLTCOPY

#define AXPBY_K                 ZAXPBY_K

#define OMATCOPY_K_CN		ZOMATCOPY_K_CN
#define OMATCOPY_K_RN		ZOMATCOPY_K_RN
#define OMATCOPY_K_CT		ZOMATCOPY_K_CT
#define OMATCOPY_K_RT		ZOMATCOPY_K_RT
#define OMATCOPY_K_CNC		ZOMATCOPY_K_CNC
#define OMATCOPY_K_RNC		ZOMATCOPY_K_RNC
#define OMATCOPY_K_CTC		ZOMATCOPY_K_CTC
#define OMATCOPY_K_RTC		ZOMATCOPY_K_RTC
#define IMATCOPY_K_CN		ZIMATCOPY_K_CN
#define IMATCOPY_K_RN		ZIMATCOPY_K_RN
#define IMATCOPY_K_CT		ZIMATCOPY_K_CT
#define IMATCOPY_K_RT		ZIMATCOPY_K_RT
#define IMATCOPY_K_CNC		ZIMATCOPY_K_CNC
#define IMATCOPY_K_RNC		ZIMATCOPY_K_RNC
#define IMATCOPY_K_CTC		ZIMATCOPY_K_CTC
#define IMATCOPY_K_RTC		ZIMATCOPY_K_RTC

#define GEADD_K                 ZGEADD_K

#else

#define	AMAX_K			CAMAX_K
#define	AMIN_K			CAMIN_K
#define	MAX_K			CMAX_K
#define	MIN_K			CMIN_K
#define	IAMAX_K			ICAMAX_K
#define	IAMIN_K			ICAMIN_K
#define	IMAX_K			ICMAX_K
#define	IMIN_K			ICMIN_K
#define	ASUM_K			CASUM_K
#define	AXPYU_K			CAXPYU_K
#define	AXPYC_K			CAXPYC_K
#define	COPY_K			CCOPY_K
#define	DOTU_K			CDOTU_K
#define	DOTC_K			CDOTC_K
#define	NRM2_K			CNRM2_K
#define	SCAL_K			CSCAL_K
#define	SUM_K			CSUM_K
#define	SWAP_K			CSWAP_K
#define	ROT_K			CROT_K

#define	GEMV_N			CGEMV_N
#define	GEMV_T			CGEMV_T
#define	GEMV_R			CGEMV_R
#define	GEMV_C			CGEMV_C
#define	GEMV_O			CGEMV_O
#define	GEMV_U			CGEMV_U
#define	GEMV_S			CGEMV_S
#define	GEMV_D			CGEMV_D

#define	GERU_K			CGERU_K
#define	GERC_K			CGERC_K
#define	GERV_K			CGERV_K
#define	GERD_K			CGERD_K

#define	SYMV_U			CSYMV_U
#define	SYMV_L			CSYMV_L
#define	HEMV_U			CHEMV_U
#define	HEMV_L			CHEMV_L
#define	HEMV_V			CHEMV_V
#define	HEMV_M			CHEMV_M

#define	SYMV_THREAD_U		CSYMV_THREAD_U
#define	SYMV_THREAD_L		CSYMV_THREAD_L
#define	HEMV_THREAD_U		CHEMV_THREAD_U
#define	HEMV_THREAD_L		CHEMV_THREAD_L
#define	HEMV_THREAD_V		CHEMV_THREAD_V
#define	HEMV_THREAD_M		CHEMV_THREAD_M

#define	GEMM_ONCOPY		CGEMM_ONCOPY
#define	GEMM_OTCOPY		CGEMM_OTCOPY
#define	GEMM_INCOPY		CGEMM_INCOPY
#define	GEMM_ITCOPY		CGEMM_ITCOPY

#define	GEMM3M_ONCOPYB		CGEMM3M_ONCOPYB
#define	GEMM3M_ONCOPYR		CGEMM3M_ONCOPYR
#define	GEMM3M_ONCOPYI		CGEMM3M_ONCOPYI
#define	GEMM3M_OTCOPYB		CGEMM3M_OTCOPYB
#define	GEMM3M_OTCOPYR		CGEMM3M_OTCOPYR
#define	GEMM3M_OTCOPYI		CGEMM3M_OTCOPYI
#define	GEMM3M_INCOPYB		CGEMM3M_INCOPYB
#define	GEMM3M_INCOPYR		CGEMM3M_INCOPYR
#define	GEMM3M_INCOPYI		CGEMM3M_INCOPYI
#define	GEMM3M_ITCOPYB		CGEMM3M_ITCOPYB
#define	GEMM3M_ITCOPYR		CGEMM3M_ITCOPYR
#define	GEMM3M_ITCOPYI		CGEMM3M_ITCOPYI

#ifdef UNIT

#define	TRMM_OUNCOPY		CTRMM_OUNUCOPY
#define	TRMM_OUTCOPY		CTRMM_OUTUCOPY
#define	TRMM_OLNCOPY		CTRMM_OLNUCOPY
#define	TRMM_OLTCOPY		CTRMM_OLTUCOPY
#define	TRSM_OUNCOPY		CTRSM_OUNUCOPY
#define	TRSM_OUTCOPY		CTRSM_OUTUCOPY
#define	TRSM_OLNCOPY		CTRSM_OLNUCOPY
#define	TRSM_OLTCOPY		CTRSM_OLTUCOPY

#define	TRMM_IUNCOPY		CTRMM_IUNUCOPY
#define	TRMM_IUTCOPY		CTRMM_IUTUCOPY
#define	TRMM_ILNCOPY		CTRMM_ILNUCOPY
#define	TRMM_ILTCOPY		CTRMM_ILTUCOPY
#define	TRSM_IUNCOPY		CTRSM_IUNUCOPY
#define	TRSM_IUTCOPY		CTRSM_IUTUCOPY
#define	TRSM_ILNCOPY		CTRSM_ILNUCOPY
#define	TRSM_ILTCOPY		CTRSM_ILTUCOPY

#else

#define	TRMM_OUNCOPY		CTRMM_OUNNCOPY
#define	TRMM_OUTCOPY		CTRMM_OUTNCOPY
#define	TRMM_OLNCOPY		CTRMM_OLNNCOPY
#define	TRMM_OLTCOPY		CTRMM_OLTNCOPY
#define	TRSM_OUNCOPY		CTRSM_OUNNCOPY
#define	TRSM_OUTCOPY		CTRSM_OUTNCOPY
#define	TRSM_OLNCOPY		CTRSM_OLNNCOPY
#define	TRSM_OLTCOPY		CTRSM_OLTNCOPY

#define	TRMM_IUNCOPY		CTRMM_IUNNCOPY
#define	TRMM_IUTCOPY		CTRMM_IUTNCOPY
#define	TRMM_ILNCOPY		CTRMM_ILNNCOPY
#define	TRMM_ILTCOPY		CTRMM_ILTNCOPY
#define	TRSM_IUNCOPY		CTRSM_IUNNCOPY
#define	TRSM_IUTCOPY		CTRSM_IUTNCOPY
#define	TRSM_ILNCOPY		CTRSM_ILNNCOPY
#define	TRSM_ILTCOPY		CTRSM_ILTNCOPY

#endif

#define	SYMM3M_ILCOPYB		CSYMM3M_ILCOPYB
#define	SYMM3M_IUCOPYB		CSYMM3M_IUCOPYB
#define	SYMM3M_ILCOPYR		CSYMM3M_ILCOPYR
#define	SYMM3M_IUCOPYR		CSYMM3M_IUCOPYR
#define	SYMM3M_ILCOPYI		CSYMM3M_ILCOPYI
#define	SYMM3M_IUCOPYI		CSYMM3M_IUCOPYI

#define	SYMM3M_OLCOPYB		CSYMM3M_OLCOPYB
#define	SYMM3M_OUCOPYB		CSYMM3M_OUCOPYB
#define	SYMM3M_OLCOPYR		CSYMM3M_OLCOPYR
#define	SYMM3M_OUCOPYR		CSYMM3M_OUCOPYR
#define	SYMM3M_OLCOPYI		CSYMM3M_OLCOPYI
#define	SYMM3M_OUCOPYI		CSYMM3M_OUCOPYI

#define	HEMM3M_ILCOPYB		CHEMM3M_ILCOPYB
#define	HEMM3M_IUCOPYB		CHEMM3M_IUCOPYB
#define	HEMM3M_ILCOPYR		CHEMM3M_ILCOPYR
#define	HEMM3M_IUCOPYR		CHEMM3M_IUCOPYR
#define	HEMM3M_ILCOPYI		CHEMM3M_ILCOPYI
#define	HEMM3M_IUCOPYI		CHEMM3M_IUCOPYI

#define	HEMM3M_OLCOPYB		CHEMM3M_OLCOPYB
#define	HEMM3M_OUCOPYB		CHEMM3M_OUCOPYB
#define	HEMM3M_OLCOPYR		CHEMM3M_OLCOPYR
#define	HEMM3M_OUCOPYR		CHEMM3M_OUCOPYR
#define	HEMM3M_OLCOPYI		CHEMM3M_OLCOPYI
#define	HEMM3M_OUCOPYI		CHEMM3M_OUCOPYI

#define	GEMM_BETA		CGEMM_BETA

#define	GEMM_KERNEL_N		CGEMM_KERNEL_N
#define	GEMM_KERNEL_L		CGEMM_KERNEL_L
#define	GEMM_KERNEL_R		CGEMM_KERNEL_R
#define	GEMM_KERNEL_B		CGEMM_KERNEL_B

#define	GEMM3M_KERNEL		CGEMM3M_KERNEL

#define	TRMM_KERNEL_LN		CTRMM_KERNEL_LN
#define	TRMM_KERNEL_LT		CTRMM_KERNEL_LT
#define	TRMM_KERNEL_LR		CTRMM_KERNEL_LR
#define	TRMM_KERNEL_LC		CTRMM_KERNEL_LC
#define	TRMM_KERNEL_RN		CTRMM_KERNEL_RN
#define	TRMM_KERNEL_RT		CTRMM_KERNEL_RT
#define	TRMM_KERNEL_RR		CTRMM_KERNEL_RR
#define	TRMM_KERNEL_RC		CTRMM_KERNEL_RC

#define	TRSM_KERNEL_LN		CTRSM_KERNEL_LN
#define	TRSM_KERNEL_LT		CTRSM_KERNEL_LT
#define	TRSM_KERNEL_LR		CTRSM_KERNEL_LR
#define	TRSM_KERNEL_LC		CTRSM_KERNEL_LC
#define	TRSM_KERNEL_RN		CTRSM_KERNEL_RN
#define	TRSM_KERNEL_RT		CTRSM_KERNEL_RT
#define	TRSM_KERNEL_RR		CTRSM_KERNEL_RR
#define	TRSM_KERNEL_RC		CTRSM_KERNEL_RC

#define	GEMM_NN			CGEMM_NN
#define	GEMM_CN			CGEMM_CN
#define	GEMM_TN			CGEMM_TN
#define	GEMM_NC			CGEMM_NC
#define	GEMM_NT			CGEMM_NT
#define	GEMM_CC			CGEMM_CC
#define	GEMM_CT			CGEMM_CT
#define	GEMM_TC			CGEMM_TC
#define	GEMM_TT			CGEMM_TT
#define	GEMM_NR			CGEMM_NR
#define	GEMM_TR			CGEMM_TR
#define	GEMM_CR			CGEMM_CR
#define	GEMM_RN			CGEMM_RN
#define	GEMM_RT			CGEMM_RT
#define	GEMM_RC			CGEMM_RC
#define	GEMM_RR			CGEMM_RR

#define	SYMM_LU			CSYMM_LU
#define	SYMM_LL			CSYMM_LL
#define	SYMM_RU			CSYMM_RU
#define	SYMM_RL			CSYMM_RL

#define	HEMM_LU			CHEMM_LU
#define	HEMM_LL			CHEMM_LL
#define	HEMM_RU			CHEMM_RU
#define	HEMM_RL			CHEMM_RL

#define HEMM_IUTCOPY		CHEMM_IUTCOPY
#define HEMM_ILTCOPY		CHEMM_ILTCOPY
#define HEMM_OUTCOPY		CHEMM_OUTCOPY
#define HEMM_OLTCOPY		CHEMM_OLTCOPY

#define	SYRK_UN			CSYRK_UN
#define	SYRK_UT			CSYRK_UT
#define	SYRK_LN			CSYRK_LN
#define	SYRK_LT			CSYRK_LT
#define	SYRK_UR			CSYRK_UN
#define	SYRK_UC			CSYRK_UT
#define	SYRK_LR			CSYRK_LN
#define	SYRK_LC			CSYRK_LT

#define	SYRK_KERNEL_U		CSYRK_KERNEL_U
#define	SYRK_KERNEL_L		CSYRK_KERNEL_L

#define	HERK_UN			CHERK_UN
#define	HERK_LN			CHERK_LN
#define	HERK_UC			CHERK_UC
#define	HERK_LC			CHERK_LC

#define	HER2K_UN		CHER2K_UN
#define	HER2K_LN		CHER2K_LN
#define	HER2K_UC		CHER2K_UC
#define	HER2K_LC		CHER2K_LC

#define	SYR2K_UN		CSYR2K_UN
#define	SYR2K_UT		CSYR2K_UT
#define	SYR2K_LN		CSYR2K_LN
#define	SYR2K_LT		CSYR2K_LT
#define	SYR2K_UR		CSYR2K_UN
#define	SYR2K_UC		CSYR2K_UT
#define	SYR2K_LR		CSYR2K_LN
#define	SYR2K_LC		CSYR2K_LT

#define	SYR2K_KERNEL_U		CSYR2K_KERNEL_U
#define	SYR2K_KERNEL_L		CSYR2K_KERNEL_L

#define	TRMM_LNUU		CTRMM_LNUU
#define	TRMM_LNUN		CTRMM_LNUN
#define	TRMM_LNLU		CTRMM_LNLU
#define	TRMM_LNLN		CTRMM_LNLN
#define	TRMM_LTUU		CTRMM_LTUU
#define	TRMM_LTUN		CTRMM_LTUN
#define	TRMM_LTLU		CTRMM_LTLU
#define	TRMM_LTLN		CTRMM_LTLN
#define	TRMM_LRUU		CTRMM_LRUU
#define	TRMM_LRUN		CTRMM_LRUN
#define	TRMM_LRLU		CTRMM_LRLU
#define	TRMM_LRLN		CTRMM_LRLN
#define	TRMM_LCUU		CTRMM_LCUU
#define	TRMM_LCUN		CTRMM_LCUN
#define	TRMM_LCLU		CTRMM_LCLU
#define	TRMM_LCLN		CTRMM_LCLN
#define	TRMM_RNUU		CTRMM_RNUU
#define	TRMM_RNUN		CTRMM_RNUN
#define	TRMM_RNLU		CTRMM_RNLU
#define	TRMM_RNLN		CTRMM_RNLN
#define	TRMM_RTUU		CTRMM_RTUU
#define	TRMM_RTUN		CTRMM_RTUN
#define	TRMM_RTLU		CTRMM_RTLU
#define	TRMM_RTLN		CTRMM_RTLN
#define	TRMM_RRUU		CTRMM_RRUU
#define	TRMM_RRUN		CTRMM_RRUN
#define	TRMM_RRLU		CTRMM_RRLU
#define	TRMM_RRLN		CTRMM_RRLN
#define	TRMM_RCUU		CTRMM_RCUU
#define	TRMM_RCUN		CTRMM_RCUN
#define	TRMM_RCLU		CTRMM_RCLU
#define	TRMM_RCLN		CTRMM_RCLN

#define	TRSM_LNUU		CTRSM_LNUU
#define	TRSM_LNUN		CTRSM_LNUN
#define	TRSM_LNLU		CTRSM_LNLU
#define	TRSM_LNLN		CTRSM_LNLN
#define	TRSM_LTUU		CTRSM_LTUU
#define	TRSM_LTUN		CTRSM_LTUN
#define	TRSM_LTLU		CTRSM_LTLU
#define	TRSM_LTLN		CTRSM_LTLN
#define	TRSM_LRUU		CTRSM_LRUU
#define	TRSM_LRUN		CTRSM_LRUN
#define	TRSM_LRLU		CTRSM_LRLU
#define	TRSM_LRLN		CTRSM_LRLN
#define	TRSM_LCUU		CTRSM_LCUU
#define	TRSM_LCUN		CTRSM_LCUN
#define	TRSM_LCLU		CTRSM_LCLU
#define	TRSM_LCLN		CTRSM_LCLN
#define	TRSM_RNUU		CTRSM_RNUU
#define	TRSM_RNUN		CTRSM_RNUN
#define	TRSM_RNLU		CTRSM_RNLU
#define	TRSM_RNLN		CTRSM_RNLN
#define	TRSM_RTUU		CTRSM_RTUU
#define	TRSM_RTUN		CTRSM_RTUN
#define	TRSM_RTLU		CTRSM_RTLU
#define	TRSM_RTLN		CTRSM_RTLN
#define	TRSM_RRUU		CTRSM_RRUU
#define	TRSM_RRUN		CTRSM_RRUN
#define	TRSM_RRLU		CTRSM_RRLU
#define	TRSM_RRLN		CTRSM_RRLN
#define	TRSM_RCUU		CTRSM_RCUU
#define	TRSM_RCUN		CTRSM_RCUN
#define	TRSM_RCLU		CTRSM_RCLU
#define	TRSM_RCLN		CTRSM_RCLN


#define	GEMM_THREAD_NN		CGEMM_THREAD_NN
#define	GEMM_THREAD_CN		CGEMM_THREAD_CN
#define	GEMM_THREAD_TN		CGEMM_THREAD_TN
#define	GEMM_THREAD_NC		CGEMM_THREAD_NC
#define	GEMM_THREAD_NT		CGEMM_THREAD_NT
#define	GEMM_THREAD_CC		CGEMM_THREAD_CC
#define	GEMM_THREAD_CT		CGEMM_THREAD_CT
#define	GEMM_THREAD_TC		CGEMM_THREAD_TC
#define	GEMM_THREAD_TT		CGEMM_THREAD_TT
#define	GEMM_THREAD_NR		CGEMM_THREAD_NR
#define	GEMM_THREAD_TR		CGEMM_THREAD_TR
#define	GEMM_THREAD_CR		CGEMM_THREAD_CR
#define	GEMM_THREAD_RN		CGEMM_THREAD_RN
#define	GEMM_THREAD_RT		CGEMM_THREAD_RT
#define	GEMM_THREAD_RC		CGEMM_THREAD_RC
#define	GEMM_THREAD_RR		CGEMM_THREAD_RR

#define	SYMM_THREAD_LU		CSYMM_THREAD_LU
#define	SYMM_THREAD_LL		CSYMM_THREAD_LL
#define	SYMM_THREAD_RU		CSYMM_THREAD_RU
#define	SYMM_THREAD_RL		CSYMM_THREAD_RL

#define	HEMM_THREAD_LU		CHEMM_THREAD_LU
#define	HEMM_THREAD_LL		CHEMM_THREAD_LL
#define	HEMM_THREAD_RU		CHEMM_THREAD_RU
#define	HEMM_THREAD_RL		CHEMM_THREAD_RL

#define	SYRK_THREAD_UN		CSYRK_THREAD_UN
#define	SYRK_THREAD_UT		CSYRK_THREAD_UT
#define	SYRK_THREAD_LN		CSYRK_THREAD_LN
#define	SYRK_THREAD_LT		CSYRK_THREAD_LT
#define	SYRK_THREAD_UR		CSYRK_THREAD_UR
#define	SYRK_THREAD_UC		CSYRK_THREAD_UC
#define	SYRK_THREAD_LR		CSYRK_THREAD_LR
#define	SYRK_THREAD_LC		CSYRK_THREAD_LC

#define	HERK_THREAD_UN		CHERK_THREAD_UN
#define	HERK_THREAD_UT		CHERK_THREAD_UT
#define	HERK_THREAD_LN		CHERK_THREAD_LN
#define	HERK_THREAD_LT		CHERK_THREAD_LT
#define	HERK_THREAD_UR		CHERK_THREAD_UR
#define	HERK_THREAD_UC		CHERK_THREAD_UC
#define	HERK_THREAD_LR		CHERK_THREAD_LR
#define	HERK_THREAD_LC		CHERK_THREAD_LC

#define	GEMM3M_NN		CGEMM3M_NN
#define	GEMM3M_CN		CGEMM3M_CN
#define	GEMM3M_TN		CGEMM3M_TN
#define	GEMM3M_NC		CGEMM3M_NC
#define	GEMM3M_NT		CGEMM3M_NT
#define	GEMM3M_CC		CGEMM3M_CC
#define	GEMM3M_CT		CGEMM3M_CT
#define	GEMM3M_TC		CGEMM3M_TC
#define	GEMM3M_TT		CGEMM3M_TT
#define	GEMM3M_NR		CGEMM3M_NR
#define	GEMM3M_TR		CGEMM3M_TR
#define	GEMM3M_CR		CGEMM3M_CR
#define	GEMM3M_RN		CGEMM3M_RN
#define	GEMM3M_RT		CGEMM3M_RT
#define	GEMM3M_RC		CGEMM3M_RC
#define	GEMM3M_RR		CGEMM3M_RR

#define	GEMM3M_THREAD_NN	CGEMM3M_THREAD_NN
#define	GEMM3M_THREAD_CN	CGEMM3M_THREAD_CN
#define	GEMM3M_THREAD_TN	CGEMM3M_THREAD_TN
#define	GEMM3M_THREAD_NC	CGEMM3M_THREAD_NC
#define	GEMM3M_THREAD_NT	CGEMM3M_THREAD_NT
#define	GEMM3M_THREAD_CC	CGEMM3M_THREAD_CC
#define	GEMM3M_THREAD_CT	CGEMM3M_THREAD_CT
#define	GEMM3M_THREAD_TC	CGEMM3M_THREAD_TC
#define	GEMM3M_THREAD_TT	CGEMM3M_THREAD_TT
#define	GEMM3M_THREAD_NR	CGEMM3M_THREAD_NR
#define	GEMM3M_THREAD_TR	CGEMM3M_THREAD_TR
#define	GEMM3M_THREAD_CR	CGEMM3M_THREAD_CR
#define	GEMM3M_THREAD_RN	CGEMM3M_THREAD_RN
#define	GEMM3M_THREAD_RT	CGEMM3M_THREAD_RT
#define	GEMM3M_THREAD_RC	CGEMM3M_THREAD_RC
#define	GEMM3M_THREAD_RR	CGEMM3M_THREAD_RR

#define	SYMM3M_LU		CSYMM3M_LU
#define	SYMM3M_LL		CSYMM3M_LL
#define	SYMM3M_RU		CSYMM3M_RU
#define	SYMM3M_RL		CSYMM3M_RL

#define	SYMM3M_THREAD_LU	CSYMM3M_THREAD_LU
#define	SYMM3M_THREAD_LL	CSYMM3M_THREAD_LL
#define	SYMM3M_THREAD_RU	CSYMM3M_THREAD_RU
#define	SYMM3M_THREAD_RL	CSYMM3M_THREAD_RL

#define	HEMM3M_LU		CHEMM3M_LU
#define	HEMM3M_LL		CHEMM3M_LL
#define	HEMM3M_RU		CHEMM3M_RU
#define	HEMM3M_RL		CHEMM3M_RL

#define	HEMM3M_THREAD_LU	CHEMM3M_THREAD_LU
#define	HEMM3M_THREAD_LL	CHEMM3M_THREAD_LL
#define	HEMM3M_THREAD_RU	CHEMM3M_THREAD_RU
#define	HEMM3M_THREAD_RL	CHEMM3M_THREAD_RL

#define SYMM_IUTCOPY		CSYMM_IUTCOPY
#define SYMM_ILTCOPY		CSYMM_ILTCOPY
#define SYMM_OUTCOPY		CSYMM_OUTCOPY
#define SYMM_OLTCOPY		CSYMM_OLTCOPY

#define AXPBY_K                 CAXPBY_K

#define OMATCOPY_K_CN		COMATCOPY_K_CN
#define OMATCOPY_K_RN		COMATCOPY_K_RN
#define OMATCOPY_K_CT		COMATCOPY_K_CT
#define OMATCOPY_K_RT		COMATCOPY_K_RT
#define OMATCOPY_K_CNC		COMATCOPY_K_CNC
#define OMATCOPY_K_RNC		COMATCOPY_K_RNC
#define OMATCOPY_K_CTC		COMATCOPY_K_CTC
#define OMATCOPY_K_RTC		COMATCOPY_K_RTC
#define IMATCOPY_K_CN		CIMATCOPY_K_CN
#define IMATCOPY_K_RN		CIMATCOPY_K_RN
#define IMATCOPY_K_CT		CIMATCOPY_K_CT
#define IMATCOPY_K_RT		CIMATCOPY_K_RT
#define IMATCOPY_K_CNC		CIMATCOPY_K_CNC
#define IMATCOPY_K_RNC		CIMATCOPY_K_RNC
#define IMATCOPY_K_CTC		CIMATCOPY_K_CTC
#define IMATCOPY_K_RTC		CIMATCOPY_K_RTC

#define GEADD_K                 CGEADD_K

#endif
#endif

#ifndef ASSEMBLER
#if defined(ARCH_X86) || defined(ARCH_X86_64) || defined(ARCH_IA64) || defined(ARCH_MIPS64) || defined(ARCH_ARM64)\
|| defined(ARCH_LOONGARCH64)
extern BLASLONG gemm_offset_a;
extern BLASLONG gemm_offset_b;
extern BLASLONG sbgemm_p;
extern BLASLONG sbgemm_q;
extern BLASLONG sbgemm_r;
extern BLASLONG sgemm_p;
extern BLASLONG sgemm_q;
extern BLASLONG sgemm_r;
extern BLASLONG dgemm_p;
extern BLASLONG dgemm_q;
extern BLASLONG dgemm_r;
extern BLASLONG qgemm_p;
extern BLASLONG qgemm_q;
extern BLASLONG qgemm_r;
extern BLASLONG cgemm_p;
extern BLASLONG cgemm_q;
extern BLASLONG cgemm_r;
extern BLASLONG zgemm_p;
extern BLASLONG zgemm_q;
extern BLASLONG zgemm_r;
extern BLASLONG xgemm_p;
extern BLASLONG xgemm_q;
extern BLASLONG xgemm_r;
#endif

typedef struct {
  void *a, *b, *c, *d, *alpha, *beta;
  BLASLONG	m, n, k, lda, ldb, ldc, ldd;

#ifdef SMP
  void *common;
  BLASLONG nthreads;
#endif

#ifdef PARAMTEST
  BLASLONG gemm_p, gemm_q, gemm_r;
#endif

#ifdef PREFETCHTEST
  BLASLONG prea, preb, prec, pred;
#endif

} blas_arg_t;
#endif

#ifdef XDOUBLE

#define TRSV_NUU qtrsv_NUU
#define TRSV_NUN qtrsv_NUN
#define TRSV_NLU qtrsv_NLU
#define TRSV_NLN qtrsv_NLN
#define TRSV_TUU qtrsv_TUU
#define TRSV_TUN qtrsv_TUN
#define TRSV_TLU qtrsv_TLU
#define TRSV_TLN qtrsv_TLN

#define ZTRSV_NUU xtrsv_NUU
#define ZTRSV_NUN xtrsv_NUN
#define ZTRSV_NLU xtrsv_NLU
#define ZTRSV_NLN xtrsv_NLN
#define ZTRSV_TUU xtrsv_TUU
#define ZTRSV_TUN xtrsv_TUN
#define ZTRSV_TLU xtrsv_TLU
#define ZTRSV_TLN xtrsv_TLN
#define ZTRSV_RUU xtrsv_RUU
#define ZTRSV_RUN xtrsv_RUN
#define ZTRSV_RLU xtrsv_RLU
#define ZTRSV_RLN xtrsv_RLN
#define ZTRSV_CUU xtrsv_CUU
#define ZTRSV_CUN xtrsv_CUN
#define ZTRSV_CLU xtrsv_CLU
#define ZTRSV_CLN xtrsv_CLN

#define TRMV_NUU qtrmv_NUU
#define TRMV_NUN qtrmv_NUN
#define TRMV_NLU qtrmv_NLU
#define TRMV_NLN qtrmv_NLN
#define TRMV_TUU qtrmv_TUU
#define TRMV_TUN qtrmv_TUN
#define TRMV_TLU qtrmv_TLU
#define TRMV_TLN qtrmv_TLN

#define TRMV_THREAD_NUU qtrmv_thread_NUU
#define TRMV_THREAD_NUN qtrmv_thread_NUN
#define TRMV_THREAD_NLU qtrmv_thread_NLU
#define TRMV_THREAD_NLN qtrmv_thread_NLN
#define TRMV_THREAD_TUU qtrmv_thread_TUU
#define TRMV_THREAD_TUN qtrmv_thread_TUN
#define TRMV_THREAD_TLU qtrmv_thread_TLU
#define TRMV_THREAD_TLN qtrmv_thread_TLN

#define ZTRMV_NUU xtrmv_NUU
#define ZTRMV_NUN xtrmv_NUN
#define ZTRMV_NLU xtrmv_NLU
#define ZTRMV_NLN xtrmv_NLN
#define ZTRMV_TUU xtrmv_TUU
#define ZTRMV_TUN xtrmv_TUN
#define ZTRMV_TLU xtrmv_TLU
#define ZTRMV_TLN xtrmv_TLN
#define ZTRMV_RUU xtrmv_RUU
#define ZTRMV_RUN xtrmv_RUN
#define ZTRMV_RLU xtrmv_RLU
#define ZTRMV_RLN xtrmv_RLN
#define ZTRMV_CUU xtrmv_CUU
#define ZTRMV_CUN xtrmv_CUN
#define ZTRMV_CLU xtrmv_CLU
#define ZTRMV_CLN xtrmv_CLN

#define ZTRMV_THREAD_NUU xtrmv_thread_NUU
#define ZTRMV_THREAD_NUN xtrmv_thread_NUN
#define ZTRMV_THREAD_NLU xtrmv_thread_NLU
#define ZTRMV_THREAD_NLN xtrmv_thread_NLN
#define ZTRMV_THREAD_TUU xtrmv_thread_TUU
#define ZTRMV_THREAD_TUN xtrmv_thread_TUN
#define ZTRMV_THREAD_TLU xtrmv_thread_TLU
#define ZTRMV_THREAD_TLN xtrmv_thread_TLN
#define ZTRMV_THREAD_RUU xtrmv_thread_RUU
#define ZTRMV_THREAD_RUN xtrmv_thread_RUN
#define ZTRMV_THREAD_RLU xtrmv_thread_RLU
#define ZTRMV_THREAD_RLN xtrmv_thread_RLN
#define ZTRMV_THREAD_CUU xtrmv_thread_CUU
#define ZTRMV_THREAD_CUN xtrmv_thread_CUN
#define ZTRMV_THREAD_CLU xtrmv_thread_CLU
#define ZTRMV_THREAD_CLN xtrmv_thread_CLN

#elif defined(DOUBLE)

#define TRSV_NUU dtrsv_NUU
#define TRSV_NUN dtrsv_NUN
#define TRSV_NLU dtrsv_NLU
#define TRSV_NLN dtrsv_NLN
#define TRSV_TUU dtrsv_TUU
#define TRSV_TUN dtrsv_TUN
#define TRSV_TLU dtrsv_TLU
#define TRSV_TLN dtrsv_TLN

#define ZTRSV_NUU ztrsv_NUU
#define ZTRSV_NUN ztrsv_NUN
#define ZTRSV_NLU ztrsv_NLU
#define ZTRSV_NLN ztrsv_NLN
#define ZTRSV_TUU ztrsv_TUU
#define ZTRSV_TUN ztrsv_TUN
#define ZTRSV_TLU ztrsv_TLU
#define ZTRSV_TLN ztrsv_TLN
#define ZTRSV_RUU ztrsv_RUU
#define ZTRSV_RUN ztrsv_RUN
#define ZTRSV_RLU ztrsv_RLU
#define ZTRSV_RLN ztrsv_RLN
#define ZTRSV_CUU ztrsv_CUU
#define ZTRSV_CUN ztrsv_CUN
#define ZTRSV_CLU ztrsv_CLU
#define ZTRSV_CLN ztrsv_CLN

#define TRMV_NUU dtrmv_NUU
#define TRMV_NUN dtrmv_NUN
#define TRMV_NLU dtrmv_NLU
#define TRMV_NLN dtrmv_NLN
#define TRMV_TUU dtrmv_TUU
#define TRMV_TUN dtrmv_TUN
#define TRMV_TLU dtrmv_TLU
#define TRMV_TLN dtrmv_TLN

#define TRMV_THREAD_NUU dtrmv_thread_NUU
#define TRMV_THREAD_NUN dtrmv_thread_NUN
#define TRMV_THREAD_NLU dtrmv_thread_NLU
#define TRMV_THREAD_NLN dtrmv_thread_NLN
#define TRMV_THREAD_TUU dtrmv_thread_TUU
#define TRMV_THREAD_TUN dtrmv_thread_TUN
#define TRMV_THREAD_TLU dtrmv_thread_TLU
#define TRMV_THREAD_TLN dtrmv_thread_TLN

#define ZTRMV_NUU ztrmv_NUU
#define ZTRMV_NUN ztrmv_NUN
#define ZTRMV_NLU ztrmv_NLU
#define ZTRMV_NLN ztrmv_NLN
#define ZTRMV_TUU ztrmv_TUU
#define ZTRMV_TUN ztrmv_TUN
#define ZTRMV_TLU ztrmv_TLU
#define ZTRMV_TLN ztrmv_TLN
#define ZTRMV_RUU ztrmv_RUU
#define ZTRMV_RUN ztrmv_RUN
#define ZTRMV_RLU ztrmv_RLU
#define ZTRMV_RLN ztrmv_RLN
#define ZTRMV_CUU ztrmv_CUU
#define ZTRMV_CUN ztrmv_CUN
#define ZTRMV_CLU ztrmv_CLU
#define ZTRMV_CLN ztrmv_CLN

#define ZTRMV_THREAD_NUU ztrmv_thread_NUU
#define ZTRMV_THREAD_NUN ztrmv_thread_NUN
#define ZTRMV_THREAD_NLU ztrmv_thread_NLU
#define ZTRMV_THREAD_NLN ztrmv_thread_NLN
#define ZTRMV_THREAD_TUU ztrmv_thread_TUU
#define ZTRMV_THREAD_TUN ztrmv_thread_TUN
#define ZTRMV_THREAD_TLU ztrmv_thread_TLU
#define ZTRMV_THREAD_TLN ztrmv_thread_TLN
#define ZTRMV_THREAD_RUU ztrmv_thread_RUU
#define ZTRMV_THREAD_RUN ztrmv_thread_RUN
#define ZTRMV_THREAD_RLU ztrmv_thread_RLU
#define ZTRMV_THREAD_RLN ztrmv_thread_RLN
#define ZTRMV_THREAD_CUU ztrmv_thread_CUU
#define ZTRMV_THREAD_CUN ztrmv_thread_CUN
#define ZTRMV_THREAD_CLU ztrmv_thread_CLU
#define ZTRMV_THREAD_CLN ztrmv_thread_CLN

#else

#define TRSV_NUU strsv_NUU
#define TRSV_NUN strsv_NUN
#define TRSV_NLU strsv_NLU
#define TRSV_NLN strsv_NLN
#define TRSV_TUU strsv_TUU
#define TRSV_TUN strsv_TUN
#define TRSV_TLU strsv_TLU
#define TRSV_TLN strsv_TLN

#define ZTRSV_NUU ctrsv_NUU
#define ZTRSV_NUN ctrsv_NUN
#define ZTRSV_NLU ctrsv_NLU
#define ZTRSV_NLN ctrsv_NLN
#define ZTRSV_TUU ctrsv_TUU
#define ZTRSV_TUN ctrsv_TUN
#define ZTRSV_TLU ctrsv_TLU
#define ZTRSV_TLN ctrsv_TLN
#define ZTRSV_RUU ctrsv_RUU
#define ZTRSV_RUN ctrsv_RUN
#define ZTRSV_RLU ctrsv_RLU
#define ZTRSV_RLN ctrsv_RLN
#define ZTRSV_CUU ctrsv_CUU
#define ZTRSV_CUN ctrsv_CUN
#define ZTRSV_CLU ctrsv_CLU
#define ZTRSV_CLN ctrsv_CLN

#define TRMV_NUU strmv_NUU
#define TRMV_NUN strmv_NUN
#define TRMV_NLU strmv_NLU
#define TRMV_NLN strmv_NLN
#define TRMV_TUU strmv_TUU
#define TRMV_TUN strmv_TUN
#define TRMV_TLU strmv_TLU
#define TRMV_TLN strmv_TLN

#define TRMV_THREAD_NUU strmv_thread_NUU
#define TRMV_THREAD_NUN strmv_thread_NUN
#define TRMV_THREAD_NLU strmv_thread_NLU
#define TRMV_THREAD_NLN strmv_thread_NLN
#define TRMV_THREAD_TUU strmv_thread_TUU
#define TRMV_THREAD_TUN strmv_thread_TUN
#define TRMV_THREAD_TLU strmv_thread_TLU
#define TRMV_THREAD_TLN strmv_thread_TLN

#define ZTRMV_NUU ctrmv_NUU
#define ZTRMV_NUN ctrmv_NUN
#define ZTRMV_NLU ctrmv_NLU
#define ZTRMV_NLN ctrmv_NLN
#define ZTRMV_TUU ctrmv_TUU
#define ZTRMV_TUN ctrmv_TUN
#define ZTRMV_TLU ctrmv_TLU
#define ZTRMV_TLN ctrmv_TLN
#define ZTRMV_RUU ctrmv_RUU
#define ZTRMV_RUN ctrmv_RUN
#define ZTRMV_RLU ctrmv_RLU
#define ZTRMV_RLN ctrmv_RLN
#define ZTRMV_CUU ctrmv_CUU
#define ZTRMV_CUN ctrmv_CUN
#define ZTRMV_CLU ctrmv_CLU
#define ZTRMV_CLN ctrmv_CLN

#define ZTRMV_THREAD_NUU ctrmv_thread_NUU
#define ZTRMV_THREAD_NUN ctrmv_thread_NUN
#define ZTRMV_THREAD_NLU ctrmv_thread_NLU
#define ZTRMV_THREAD_NLN ctrmv_thread_NLN
#define ZTRMV_THREAD_TUU ctrmv_thread_TUU
#define ZTRMV_THREAD_TUN ctrmv_thread_TUN
#define ZTRMV_THREAD_TLU ctrmv_thread_TLU
#define ZTRMV_THREAD_TLN ctrmv_thread_TLN
#define ZTRMV_THREAD_RUU ctrmv_thread_RUU
#define ZTRMV_THREAD_RUN ctrmv_thread_RUN
#define ZTRMV_THREAD_RLU ctrmv_thread_RLU
#define ZTRMV_THREAD_RLN ctrmv_thread_RLN
#define ZTRMV_THREAD_CUU ctrmv_thread_CUU
#define ZTRMV_THREAD_CUN ctrmv_thread_CUN
#define ZTRMV_THREAD_CLU ctrmv_thread_CLU
#define ZTRMV_THREAD_CLN ctrmv_thread_CLN

#endif

#define SGETF2	sgetf2_k
#define DGETF2	dgetf2_k
#define QGETF2	qgetf2_k
#define CGETF2	cgetf2_k
#define ZGETF2	zgetf2_k
#define XGETF2	xgetf2_k

#define SLASWP_PLUS	slaswp_plus
#define SLASWP_MINUS	slaswp_minus
#define DLASWP_PLUS	dlaswp_plus
#define DLASWP_MINUS	dlaswp_minus
#define QLASWP_PLUS	qlaswp_plus
#define QLASWP_MINUS	qlaswp_minus
#define CLASWP_PLUS	claswp_plus
#define CLASWP_MINUS	claswp_minus
#define ZLASWP_PLUS	zlaswp_plus
#define ZLASWP_MINUS	zlaswp_minus
#define XLASWP_PLUS	xlaswp_plus
#define XLASWP_MINUS	xlaswp_minus

#define	SLARF_L		slarf_L
#define	SLARF_R		slarf_R
#define	DLARF_L		dlarf_L
#define	DLARF_R		dlarf_R
#define	QLARF_L		qlarf_L
#define	QLARF_R		qlarf_R
#define	CLARF_L		clarf_L
#define	CLARF_R		clarf_R
#define	ZLARF_L		zlarf_L
#define	ZLARF_R		zlarf_R
#define	XLARF_L		xlarf_L
#define	XLARF_R		xlarf_R

#ifndef COMPLEX
#ifdef XDOUBLE
#define GETF2	QGETF2
#define GETRF	QGETRF
#define GETRS_N_SINGLE	qgetrs_N_single
#define GETRS_T_SINGLE	qgetrs_T_single
#define GETRS_R_SINGLE	qgetrs_N_single
#define GETRS_C_SINGLE	qgetrs_T_single
#define GETRS_N_PARALLEL	qgetrs_N_parallel
#define GETRS_T_PARALLEL	qgetrs_T_parallel
#define GETRS_R_PARALLEL	qgetrs_N_parallel
#define GETRS_C_PARALLEL	qgetrs_T_parallel
#define LASWP_PLUS	QLASWP_PLUS
#define LASWP_MINUS	QLASWP_MINUS
#define LASWP_NCOPY	QLASWP_NCOPY
#define GETRS_N		QGETRS_N
#define GETRS_T		QGETRS_T
#define GETRF_SINGLE	qgetrf_single
#define GETRF_PARALLEL	qgetrf_parallel
#define NEG_TCOPY	QNEG_TCOPY
#define	LARF_L		QLARF_L
#define	LARF_R		QLARF_R
#elif defined(DOUBLE)
#define GETF2	DGETF2
#define GETRF	DGETRF
#define GETRS_N_SINGLE	dgetrs_N_single
#define GETRS_T_SINGLE	dgetrs_T_single
#define GETRS_R_SINGLE	dgetrs_N_single
#define GETRS_C_SINGLE	dgetrs_T_single
#define GETRS_N_PARALLEL	dgetrs_N_parallel
#define GETRS_T_PARALLEL	dgetrs_T_parallel
#define GETRS_R_PARALLEL	dgetrs_N_parallel
#define GETRS_C_PARALLEL	dgetrs_T_parallel
#define LASWP_PLUS	DLASWP_PLUS
#define LASWP_MINUS	DLASWP_MINUS
#define LASWP_NCOPY	DLASWP_NCOPY
#define GETRS_N		DGETRS_N
#define GETRS_T		DGETRS_T
#define GETRF_SINGLE	dgetrf_single
#define GETRF_PARALLEL	dgetrf_parallel
#define NEG_TCOPY	DNEG_TCOPY
#define	LARF_L		DLARF_L
#define	LARF_R		DLARF_R
#else
#define GETF2	SGETF2
#define GETRF	SGETRF
#define GETRS_N_SINGLE	sgetrs_N_single
#define GETRS_T_SINGLE	sgetrs_T_single
#define GETRS_R_SINGLE	sgetrs_N_single
#define GETRS_C_SINGLE	sgetrs_T_single
#define GETRS_N_PARALLEL	sgetrs_N_parallel
#define GETRS_T_PARALLEL	sgetrs_T_parallel
#define GETRS_R_PARALLEL	sgetrs_N_parallel
#define GETRS_C_PARALLEL	sgetrs_T_parallel
#define LASWP_PLUS	SLASWP_PLUS
#define LASWP_MINUS	SLASWP_MINUS
#define LASWP_NCOPY	SLASWP_NCOPY
#define GETRS_N		SGETRS_N
#define GETRS_T		SGETRS_T
#define GETRF_SINGLE	sgetrf_single
#define GETRF_PARALLEL	sgetrf_parallel
#define NEG_TCOPY	SNEG_TCOPY
#define	LARF_L		SLARF_L
#define	LARF_R		SLARF_R
#endif
#else
#ifdef XDOUBLE
#define GETF2	XGETF2
#define GETRF	XGETRF
#define GETRS_N_SINGLE	xgetrs_N_single
#define GETRS_T_SINGLE	xgetrs_T_single
#define GETRS_R_SINGLE	xgetrs_R_single
#define GETRS_C_SINGLE	xgetrs_C_single
#define GETRS_N_PARALLEL	xgetrs_N_parallel
#define GETRS_T_PARALLEL	xgetrs_T_parallel
#define GETRS_R_PARALLEL	xgetrs_R_parallel
#define GETRS_C_PARALLEL	xgetrs_C_parallel
#define LASWP_PLUS	XLASWP_PLUS
#define LASWP_MINUS	XLASWP_MINUS
#define LASWP_NCOPY	XLASWP_NCOPY
#define GETRS_N		XGETRS_N
#define GETRS_T		XGETRS_T
#define GETRF_SINGLE	xgetrf_single
#define GETRF_PARALLEL	xgetrf_parallel
#define NEG_TCOPY	XNEG_TCOPY
#define	LARF_L		XLARF_L
#define	LARF_R		XLARF_R
#elif defined(DOUBLE)
#define GETF2	ZGETF2
#define GETRF	ZGETRF
#define GETRS_N_SINGLE	zgetrs_N_single
#define GETRS_T_SINGLE	zgetrs_T_single
#define GETRS_R_SINGLE	zgetrs_R_single
#define GETRS_C_SINGLE	zgetrs_C_single
#define GETRS_N_PARALLEL	zgetrs_N_parallel
#define GETRS_T_PARALLEL	zgetrs_T_parallel
#define GETRS_R_PARALLEL	zgetrs_R_parallel
#define GETRS_C_PARALLEL	zgetrs_C_parallel
#define LASWP_PLUS	ZLASWP_PLUS
#define LASWP_MINUS	ZLASWP_MINUS
#define LASWP_NCOPY	ZLASWP_NCOPY
#define GETRS_N		ZGETRS_N
#define GETRS_T		ZGETRS_T
#define GETRF_SINGLE	zgetrf_single
#define GETRF_PARALLEL	zgetrf_parallel
#define NEG_TCOPY	ZNEG_TCOPY
#define	LARF_L		ZLARF_L
#define	LARF_R		ZLARF_R
#else
#define GETF2	CGETF2
#define GETRF	CGETRF
#define GETRS_N_SINGLE	cgetrs_N_single
#define GETRS_T_SINGLE	cgetrs_T_single
#define GETRS_R_SINGLE	cgetrs_R_single
#define GETRS_C_SINGLE	cgetrs_C_single
#define GETRS_N_PARALLEL	cgetrs_N_parallel
#define GETRS_T_PARALLEL	cgetrs_T_parallel
#define GETRS_R_PARALLEL	cgetrs_R_parallel
#define GETRS_C_PARALLEL	cgetrs_C_parallel
#define LASWP_PLUS	CLASWP_PLUS
#define LASWP_MINUS	CLASWP_MINUS
#define LASWP_NCOPY	CLASWP_NCOPY
#define GETRS_N		CGETRS_N
#define GETRS_T		CGETRS_T
#define GETRF_SINGLE	cgetrf_single
#define GETRF_PARALLEL	cgetrf_parallel
#define NEG_TCOPY	CNEG_TCOPY
#define	LARF_L		CLARF_L
#define	LARF_R		CLARF_R
#endif
#endif

#ifndef COMPLEX
#ifdef XDOUBLE
#define  POTF2_U  qpotf2_U
#define  POTF2_L  qpotf2_L
#define  LAUU2_U  qlauu2_U
#define  LAUU2_L  qlauu2_L
#define  POTRF_U_SINGLE qpotrf_U_single
#define  POTRF_L_SINGLE qpotrf_L_single
#define  POTRF_U_PARALLEL qpotrf_U_parallel
#define  POTRF_L_PARALLEL qpotrf_L_parallel
#define  LAUUM_U_SINGLE qlauum_U_single
#define  LAUUM_L_SINGLE qlauum_L_single
#define  LAUUM_U_PARALLEL qlauum_U_parallel
#define  LAUUM_L_PARALLEL qlauum_L_parallel
#define  TRTI2_UU qtrti2_UU
#define  TRTI2_UN qtrti2_UN
#define  TRTI2_LU qtrti2_LU
#define  TRTI2_LN qtrti2_LN
#define  TRTRI_UU_SINGLE qtrtri_UU_single
#define  TRTRI_UN_SINGLE qtrtri_UN_single
#define  TRTRI_LU_SINGLE qtrtri_LU_single
#define  TRTRI_LN_SINGLE qtrtri_LN_single
#define  TRTRI_UU_PARALLEL qtrtri_UU_parallel
#define  TRTRI_UN_PARALLEL qtrtri_UN_parallel
#define  TRTRI_LU_PARALLEL qtrtri_LU_parallel
#define  TRTRI_LN_PARALLEL qtrtri_LN_parallel
#elif defined(DOUBLE)
#define  POTF2_U  dpotf2_U
#define  POTF2_L  dpotf2_L
#define  LAUU2_U  dlauu2_U
#define  LAUU2_L  dlauu2_L
#define  POTRF_U_SINGLE dpotrf_U_single
#define  POTRF_L_SINGLE dpotrf_L_single
#define  POTRF_U_PARALLEL dpotrf_U_parallel
#define  POTRF_L_PARALLEL dpotrf_L_parallel
#define  LAUUM_U_SINGLE dlauum_U_single
#define  LAUUM_L_SINGLE dlauum_L_single
#define  LAUUM_U_PARALLEL dlauum_U_parallel
#define  LAUUM_L_PARALLEL dlauum_L_parallel
#define  TRTI2_UU dtrti2_UU
#define  TRTI2_UN dtrti2_UN
#define  TRTI2_LU dtrti2_LU
#define  TRTI2_LN dtrti2_LN
#define  TRTRI_UU_SINGLE dtrtri_UU_single
#define  TRTRI_UN_SINGLE dtrtri_UN_single
#define  TRTRI_LU_SINGLE dtrtri_LU_single
#define  TRTRI_LN_SINGLE dtrtri_LN_single
#define  TRTRI_UU_PARALLEL dtrtri_UU_parallel
#define  TRTRI_UN_PARALLEL dtrtri_UN_parallel
#define  TRTRI_LU_PARALLEL dtrtri_LU_parallel
#define  TRTRI_LN_PARALLEL dtrtri_LN_parallel
#else
#define  POTF2_U  spotf2_U
#define  POTF2_L  spotf2_L
#define  LAUU2_U  slauu2_U
#define  LAUU2_L  slauu2_L
#define  POTRF_U_SINGLE spotrf_U_single
#define  POTRF_L_SINGLE spotrf_L_single
#define  POTRF_U_PARALLEL spotrf_U_parallel
#define  POTRF_L_PARALLEL spotrf_L_parallel
#define  LAUUM_U_SINGLE slauum_U_single
#define  LAUUM_L_SINGLE slauum_L_single
#define  LAUUM_U_PARALLEL slauum_U_parallel
#define  LAUUM_L_PARALLEL slauum_L_parallel
#define  TRTI2_UU strti2_UU
#define  TRTI2_UN strti2_UN
#define  TRTI2_LU strti2_LU
#define  TRTI2_LN strti2_LN
#define  TRTRI_UU_SINGLE strtri_UU_single
#define  TRTRI_UN_SINGLE strtri_UN_single
#define  TRTRI_LU_SINGLE strtri_LU_single
#define  TRTRI_LN_SINGLE strtri_LN_single
#define  TRTRI_UU_PARALLEL strtri_UU_parallel
#define  TRTRI_UN_PARALLEL strtri_UN_parallel
#define  TRTRI_LU_PARALLEL strtri_LU_parallel
#define  TRTRI_LN_PARALLEL strtri_LN_parallel
#endif
#else
#ifdef XDOUBLE
#define  POTF2_U  xpotf2_U
#define  POTF2_L  xpotf2_L
#define  LAUU2_U  xlauu2_U
#define  LAUU2_L  xlauu2_L
#define  POTRF_U_SINGLE xpotrf_U_single
#define  POTRF_L_SINGLE xpotrf_L_single
#define  POTRF_U_PARALLEL xpotrf_U_parallel
#define  POTRF_L_PARALLEL xpotrf_L_parallel
#define  LAUUM_U_SINGLE xlauum_U_single
#define  LAUUM_L_SINGLE xlauum_L_single
#define  LAUUM_U_PARALLEL xlauum_U_parallel
#define  LAUUM_L_PARALLEL xlauum_L_parallel
#define  TRTI2_UU xtrti2_UU
#define  TRTI2_UN xtrti2_UN
#define  TRTI2_LU xtrti2_LU
#define  TRTI2_LN xtrti2_LN
#define  TRTRI_UU_SINGLE xtrtri_UU_single
#define  TRTRI_UN_SINGLE xtrtri_UN_single
#define  TRTRI_LU_SINGLE xtrtri_LU_single
#define  TRTRI_LN_SINGLE xtrtri_LN_single
#define  TRTRI_UU_PARALLEL xtrtri_UU_parallel
#define  TRTRI_UN_PARALLEL xtrtri_UN_parallel
#define  TRTRI_LU_PARALLEL xtrtri_LU_parallel
#define  TRTRI_LN_PARALLEL xtrtri_LN_parallel
#elif defined(DOUBLE)
#define  POTF2_U  zpotf2_U
#define  POTF2_L  zpotf2_L
#define  LAUU2_U  zlauu2_U
#define  LAUU2_L  zlauu2_L
#define  POTRF_U_SINGLE zpotrf_U_single
#define  POTRF_L_SINGLE zpotrf_L_single
#define  POTRF_U_PARALLEL zpotrf_U_parallel
#define  POTRF_L_PARALLEL zpotrf_L_parallel
#define  LAUUM_U_SINGLE zlauum_U_single
#define  LAUUM_L_SINGLE zlauum_L_single
#define  LAUUM_U_PARALLEL zlauum_U_parallel
#define  LAUUM_L_PARALLEL zlauum_L_parallel
#define  TRTI2_UU ztrti2_UU
#define  TRTI2_UN ztrti2_UN
#define  TRTI2_LU ztrti2_LU
#define  TRTI2_LN ztrti2_LN
#define  TRTRI_UU_SINGLE ztrtri_UU_single
#define  TRTRI_UN_SINGLE ztrtri_UN_single
#define  TRTRI_LU_SINGLE ztrtri_LU_single
#define  TRTRI_LN_SINGLE ztrtri_LN_single
#define  TRTRI_UU_PARALLEL ztrtri_UU_parallel
#define  TRTRI_UN_PARALLEL ztrtri_UN_parallel
#define  TRTRI_LU_PARALLEL ztrtri_LU_parallel
#define  TRTRI_LN_PARALLEL ztrtri_LN_parallel
#else
#define  POTF2_U  cpotf2_U
#define  POTF2_L  cpotf2_L
#define  LAUU2_U  clauu2_U
#define  LAUU2_L  clauu2_L
#define  POTRF_U_SINGLE cpotrf_U_single
#define  POTRF_L_SINGLE cpotrf_L_single
#define  POTRF_U_PARALLEL cpotrf_U_parallel
#define  POTRF_L_PARALLEL cpotrf_L_parallel
#define  LAUUM_U_SINGLE clauum_U_single
#define  LAUUM_L_SINGLE clauum_L_single
#define  LAUUM_U_PARALLEL clauum_U_parallel
#define  LAUUM_L_PARALLEL clauum_L_parallel
#define  TRTI2_UU ctrti2_UU
#define  TRTI2_UN ctrti2_UN
#define  TRTI2_LU ctrti2_LU
#define  TRTI2_LN ctrti2_LN
#define  TRTRI_UU_SINGLE ctrtri_UU_single
#define  TRTRI_UN_SINGLE ctrtri_UN_single
#define  TRTRI_LU_SINGLE ctrtri_LU_single
#define  TRTRI_LN_SINGLE ctrtri_LN_single
#define  TRTRI_UU_PARALLEL ctrtri_UU_parallel
#define  TRTRI_UN_PARALLEL ctrtri_UN_parallel
#define  TRTRI_LU_PARALLEL ctrtri_LU_parallel
#define  TRTRI_LN_PARALLEL ctrtri_LN_parallel
#endif
#endif

#endif

#ifndef COMPLEX
#ifdef XDOUBLE
#define  TRTRS_UNU_SINGLE  qtrtrs_UNU_single
#define  TRTRS_UNN_SINGLE  qtrtrs_UNN_single
#define  TRTRS_UTU_SINGLE  qtrtrs_UTU_single
#define  TRTRS_UTN_SINGLE  qtrtrs_UTN_single
#define  TRTRS_LNU_SINGLE  qtrtrs_LNU_single
#define  TRTRS_LNN_SINGLE  qtrtrs_LNN_single
#define  TRTRS_LTU_SINGLE  qtrtrs_LTU_single
#define  TRTRS_LTN_SINGLE  qtrtrs_LTN_single
#define  TRTRS_UNU_PARALLEL  qtrtrs_UNU_parallel
#define  TRTRS_UNN_PARALLEL  qtrtrs_UNN_parallel
#define  TRTRS_UTU_PARALLEL  qtrtrs_UTU_parallel
#define  TRTRS_UTN_PARALLEL  qtrtrs_UTN_parallel
#define  TRTRS_LNU_PARALLEL  qtrtrs_LNU_parallel
#define  TRTRS_LNN_PARALLEL  qtrtrs_LNN_parallel
#define  TRTRS_LTU_PARALLEL  qtrtrs_LTU_parallel
#define  TRTRS_LTN_PARALLEL  qtrtrs_LTN_parallel

#elif defined(DOUBLE)
#define  TRTRS_UNU_SINGLE  dtrtrs_UNU_single
#define  TRTRS_UNN_SINGLE  dtrtrs_UNN_single
#define  TRTRS_UTU_SINGLE  dtrtrs_UTU_single
#define  TRTRS_UTN_SINGLE  dtrtrs_UTN_single
#define  TRTRS_LNU_SINGLE  dtrtrs_LNU_single
#define  TRTRS_LNN_SINGLE  dtrtrs_LNN_single
#define  TRTRS_LTU_SINGLE  dtrtrs_LTU_single
#define  TRTRS_LTN_SINGLE  dtrtrs_LTN_single
#define  TRTRS_UNU_PARALLEL  dtrtrs_UNU_parallel
#define  TRTRS_UNN_PARALLEL  dtrtrs_UNN_parallel
#define  TRTRS_UTU_PARALLEL  dtrtrs_UTU_parallel
#define  TRTRS_UTN_PARALLEL  dtrtrs_UTN_parallel
#define  TRTRS_LNU_PARALLEL  dtrtrs_LNU_parallel
#define  TRTRS_LNN_PARALLEL  dtrtrs_LNN_parallel
#define  TRTRS_LTU_PARALLEL  dtrtrs_LTU_parallel
#define  TRTRS_LTN_PARALLEL  dtrtrs_LTN_parallel
#else
#define  TRTRS_UNU_SINGLE  strtrs_UNU_single
#define  TRTRS_UNN_SINGLE  strtrs_UNN_single
#define  TRTRS_UTU_SINGLE  strtrs_UTU_single
#define  TRTRS_UTN_SINGLE  strtrs_UTN_single
#define  TRTRS_LNU_SINGLE  strtrs_LNU_single
#define  TRTRS_LNN_SINGLE  strtrs_LNN_single
#define  TRTRS_LTU_SINGLE  strtrs_LTU_single
#define  TRTRS_LTN_SINGLE  strtrs_LTN_single
#define  TRTRS_UNU_PARALLEL  strtrs_UNU_parallel
#define  TRTRS_UNN_PARALLEL  strtrs_UNN_parallel
#define  TRTRS_UTU_PARALLEL  strtrs_UTU_parallel
#define  TRTRS_UTN_PARALLEL  strtrs_UTN_parallel
#define  TRTRS_LNU_PARALLEL  strtrs_LNU_parallel
#define  TRTRS_LNN_PARALLEL  strtrs_LNN_parallel
#define  TRTRS_LTU_PARALLEL  strtrs_LTU_parallel
#define  TRTRS_LTN_PARALLEL  strtrs_LTN_parallel
#endif
#else
#ifdef XDOUBLE
#define  TRTRS_UNU_SINGLE  xtrtrs_UNU_single
#define  TRTRS_UNN_SINGLE  xtrtrs_UNN_single
#define  TRTRS_UTU_SINGLE  xtrtrs_UTU_single
#define  TRTRS_UTN_SINGLE  xtrtrs_UTN_single
#define  TRTRS_URU_SINGLE  xtrtrs_URU_single
#define  TRTRS_URN_SINGLE  xtrtrs_URN_single
#define  TRTRS_UCU_SINGLE  xtrtrs_UCU_single
#define  TRTRS_UCN_SINGLE  xtrtrs_UCN_single
#define  TRTRS_LNU_SINGLE  xtrtrs_LNU_single
#define  TRTRS_LNN_SINGLE  xtrtrs_LNN_single
#define  TRTRS_LTU_SINGLE  xtrtrs_LTU_single
#define  TRTRS_LTN_SINGLE  xtrtrs_LTN_single
#define  TRTRS_LRU_SINGLE  xtrtrs_LRU_single
#define  TRTRS_LRN_SINGLE  xtrtrs_LRN_single
#define  TRTRS_LCU_SINGLE  xtrtrs_LCU_single
#define  TRTRS_LCN_SINGLE  xtrtrs_LCN_single
#define  TRTRS_UNU_PARALLEL  xtrtrs_UNU_parallel
#define  TRTRS_UNN_PARALLEL  xtrtrs_UNN_parallel
#define  TRTRS_UTU_PARALLEL  xtrtrs_UTU_parallel
#define  TRTRS_UTN_PARALLEL  xtrtrs_UTN_parallel
#define  TRTRS_URU_PARALLEL  xtrtrs_URU_parallel
#define  TRTRS_URN_PARALLEL  xtrtrs_URN_parallel
#define  TRTRS_UCU_PARALLEL  xtrtrs_UCU_parallel
#define  TRTRS_UCN_PARALLEL  xtrtrs_UCN_parallel
#define  TRTRS_LNU_PARALLEL  xtrtrs_LNU_parallel
#define  TRTRS_LNN_PARALLEL  xtrtrs_LNN_parallel
#define  TRTRS_LTU_PARALLEL  xtrtrs_LTU_parallel
#define  TRTRS_LTN_PARALLEL  xtrtrs_LTN_parallel
#define  TRTRS_LRU_PARALLEL  xtrtrs_LRU_parallel
#define  TRTRS_LRN_PARALLEL  xtrtrs_LRN_parallel
#define  TRTRS_LCU_PARALLEL  xtrtrs_LCU_parallel
#define  TRTRS_LCN_PARALLEL  xtrtrs_LCN_parallel
#elif defined(DOUBLE)
#define  TRTRS_UNU_SINGLE  ztrtrs_UNU_single
#define  TRTRS_UNN_SINGLE  ztrtrs_UNN_single
#define  TRTRS_UTU_SINGLE  ztrtrs_UTU_single
#define  TRTRS_UTN_SINGLE  ztrtrs_UTN_single
#define  TRTRS_URU_SINGLE  ztrtrs_URU_single
#define  TRTRS_URN_SINGLE  ztrtrs_URN_single
#define  TRTRS_UCU_SINGLE  ztrtrs_UCU_single
#define  TRTRS_UCN_SINGLE  ztrtrs_UCN_single
#define  TRTRS_LNU_SINGLE  ztrtrs_LNU_single
#define  TRTRS_LNN_SINGLE  ztrtrs_LNN_single
#define  TRTRS_LTU_SINGLE  ztrtrs_LTU_single
#define  TRTRS_LTN_SINGLE  ztrtrs_LTN_single
#define  TRTRS_LRU_SINGLE  ztrtrs_LRU_single
#define  TRTRS_LRN_SINGLE  ztrtrs_LRN_single
#define  TRTRS_LCU_SINGLE  ztrtrs_LCU_single
#define  TRTRS_LCN_SINGLE  ztrtrs_LCN_single
#define  TRTRS_UNU_PARALLEL  ztrtrs_UNU_parallel
#define  TRTRS_UNN_PARALLEL  ztrtrs_UNN_parallel
#define  TRTRS_UTU_PARALLEL  ztrtrs_UTU_parallel
#define  TRTRS_UTN_PARALLEL  ztrtrs_UTN_parallel
#define  TRTRS_URU_PARALLEL  ztrtrs_URU_parallel
#define  TRTRS_URN_PARALLEL  ztrtrs_URN_parallel
#define  TRTRS_UCU_PARALLEL  ztrtrs_UCU_parallel
#define  TRTRS_UCN_PARALLEL  ztrtrs_UCN_parallel
#define  TRTRS_LNU_PARALLEL  ztrtrs_LNU_parallel
#define  TRTRS_LNN_PARALLEL  ztrtrs_LNN_parallel
#define  TRTRS_LTU_PARALLEL  ztrtrs_LTU_parallel
#define  TRTRS_LTN_PARALLEL  ztrtrs_LTN_parallel
#define  TRTRS_LRU_PARALLEL  ztrtrs_LRU_parallel
#define  TRTRS_LRN_PARALLEL  ztrtrs_LRN_parallel
#define  TRTRS_LCU_PARALLEL  ztrtrs_LCU_parallel
#define  TRTRS_LCN_PARALLEL  ztrtrs_LCN_parallel
#else
#define  TRTRS_UNU_SINGLE  ctrtrs_UNU_single
#define  TRTRS_UNN_SINGLE  ctrtrs_UNN_single
#define  TRTRS_UTU_SINGLE  ctrtrs_UTU_single
#define  TRTRS_UTN_SINGLE  ctrtrs_UTN_single
#define  TRTRS_URU_SINGLE  ctrtrs_URU_single
#define  TRTRS_URN_SINGLE  ctrtrs_URN_single
#define  TRTRS_UCU_SINGLE  ctrtrs_UCU_single
#define  TRTRS_UCN_SINGLE  ctrtrs_UCN_single
#define  TRTRS_LNU_SINGLE  ctrtrs_LNU_single
#define  TRTRS_LNN_SINGLE  ctrtrs_LNN_single
#define  TRTRS_LTU_SINGLE  ctrtrs_LTU_single
#define  TRTRS_LTN_SINGLE  ctrtrs_LTN_single
#define  TRTRS_LRU_SINGLE  ctrtrs_LRU_single
#define  TRTRS_LRN_SINGLE  ctrtrs_LRN_single
#define  TRTRS_LCU_SINGLE  ctrtrs_LCU_single
#define  TRTRS_LCN_SINGLE  ctrtrs_LCN_single
#define  TRTRS_UNU_PARALLEL  ctrtrs_UNU_parallel
#define  TRTRS_UNN_PARALLEL  ctrtrs_UNN_parallel
#define  TRTRS_UTU_PARALLEL  ctrtrs_UTU_parallel
#define  TRTRS_UTN_PARALLEL  ctrtrs_UTN_parallel
#define  TRTRS_URU_PARALLEL  ctrtrs_URU_parallel
#define  TRTRS_URN_PARALLEL  ctrtrs_URN_parallel
#define  TRTRS_UCU_PARALLEL  ctrtrs_UCU_parallel
#define  TRTRS_UCN_PARALLEL  ctrtrs_UCN_parallel
#define  TRTRS_LNU_PARALLEL  ctrtrs_LNU_parallel
#define  TRTRS_LNN_PARALLEL  ctrtrs_LNN_parallel
#define  TRTRS_LTU_PARALLEL  ctrtrs_LTU_parallel
#define  TRTRS_LTN_PARALLEL  ctrtrs_LTN_parallel
#define  TRTRS_LRU_PARALLEL  ctrtrs_LRU_parallel
#define  TRTRS_LRN_PARALLEL  ctrtrs_LRN_parallel
#define  TRTRS_LCU_PARALLEL  ctrtrs_LCU_parallel
#define  TRTRS_LCN_PARALLEL  ctrtrs_LCN_parallel
#endif
#endif
