/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.matching.NearString;
import org.omegat.core.statistics.FindMatches;
import org.omegat.core.statistics.IStatsConsumer;
import org.omegat.core.statistics.MatchStatCounts;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.threads.LongProcessInterruptedException;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.TextUtil;

public class CalcMatchStatistics
extends LongProcessThread {
    private final String[] header = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters")};
    private final String[] rowsTotal = new String[]{OStrings.getString("CT_STATSMATCH_RowRepetitions"), OStrings.getString("CT_STATSMATCH_RowExactMatch"), OStrings.getString("CT_STATSMATCH_RowMatch95"), OStrings.getString("CT_STATSMATCH_RowMatch85"), OStrings.getString("CT_STATSMATCH_RowMatch75"), OStrings.getString("CT_STATSMATCH_RowMatch50"), OStrings.getString("CT_STATSMATCH_RowNoMatch"), OStrings.getString("CT_STATSMATCH_Total")};
    private final String[] rowsPerFile = new String[]{OStrings.getString("CT_STATSMATCH_RowRepetitionsWithinThisFile"), OStrings.getString("CT_STATSMATCH_RowRepetitionsFromOtherFiles"), OStrings.getString("CT_STATSMATCH_RowExactMatch"), OStrings.getString("CT_STATSMATCH_RowMatch95"), OStrings.getString("CT_STATSMATCH_RowMatch85"), OStrings.getString("CT_STATSMATCH_RowMatch75"), OStrings.getString("CT_STATSMATCH_RowMatch50"), OStrings.getString("CT_STATSMATCH_RowNoMatch"), OStrings.getString("CT_STATSMATCH_Total")};
    private final boolean[] align = new boolean[]{false, true, true, true, true};
    private final IStatsConsumer callback;
    private final boolean perFile;
    protected int entriesToProcess;
    private final Set<String> alreadyProcessedInFile = new HashSet<String>();
    private final Set<String> alreadyProcessedInProject = new HashSet<String>();
    private final ThreadLocal<ISimilarityCalculator> distanceCalculator = ThreadLocal.withInitial(LevenshteinDistance::new);
    private final ThreadLocal<FindMatches> finder = ThreadLocal.withInitial(() -> new FindMatches(Core.getProject(), 5, true, false, false));
    private final StringBuilder textForLog = new StringBuilder();
    int treated;
    int percent;

    public CalcMatchStatistics(IStatsConsumer callback, boolean perFile) {
        this.callback = callback;
        this.perFile = perFile;
    }

    @Override
    public void run() {
        if (this.perFile) {
            this.entriesToProcess = Core.getProject().getAllEntries().size() * 2;
            this.calcPerFile();
        } else {
            this.entriesToProcess = Core.getProject().getAllEntries().size();
            this.calcTotal(true);
        }
        this.callback.finishData();
    }

    void appendText(String text) {
        this.textForLog.append(text);
        this.callback.appendTextData(text);
    }

    void showText(String text) {
        this.textForLog.setLength(0);
        this.textForLog.append(text);
        this.callback.setTextData(text);
    }

    void appendTable(String title, String[][] table) {
        this.callback.appendTable(title, this.header, table);
    }

    void showTable(String[][] table) {
        this.callback.setTable(this.header, table);
    }

    void calcPerFile() {
        int fileNumber = 0;
        for (IProject.FileInfo fi : Core.getProject().getProjectFiles()) {
            MatchStatCounts perFileCounts = this.forFile(fi);
            this.checkInterrupted();
            String[][] table = perFileCounts.calcTable(this.rowsPerFile);
            String outText = TextUtil.showTextTable(this.header, table, this.align);
            String title = StringUtil.format(OStrings.getString("CT_STATSMATCH_File"), ++fileNumber, fi.filePath);
            this.appendText(title + "\n");
            this.appendText(outText + "\n");
            this.appendTable(title, table);
        }
        MatchStatCounts total = this.calcTotal(false);
        String title = OStrings.getString("CT_STATSMATCH_FileTotal");
        this.appendText(title + "\n");
        String[][] table = total.calcTable(this.rowsTotal, i -> i != 1);
        String outText = TextUtil.showTextTable(this.header, table, this.align);
        this.appendText(outText + "\n");
        this.appendTable(title, table);
        String fn = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats_match_per_file.txt";
        Statistics.writeStat(fn, this.textForLog.toString());
        this.callback.setDataFile(fn);
    }

    MatchStatCounts calcTotal(boolean outData) {
        String outText;
        String[][] table;
        MatchStatCounts result = new MatchStatCounts();
        this.alreadyProcessedInProject.clear();
        ArrayList<SourceTextEntry> untranslatedEntries = new ArrayList<SourceTextEntry>();
        for (SourceTextEntry ste : Core.getProject().getAllEntries()) {
            this.checkInterrupted();
            StatCount count = new StatCount(ste);
            boolean isFirst = this.alreadyProcessedInProject.add(ste.getSrcText());
            if (Core.getProject().getTranslationInfo(ste).isTranslated()) {
                result.addExact(count);
                this.entryProcessed();
                continue;
            }
            if (!isFirst) {
                result.addRepetition(count);
                this.entryProcessed();
                continue;
            }
            untranslatedEntries.add(ste);
        }
        if (outData) {
            table = result.calcTableWithoutPercentage(this.rowsTotal);
            outText = TextUtil.showTextTable(this.header, table, this.align);
            this.showText(outText);
            this.showTable(table);
        }
        this.calcSimilarity(untranslatedEntries).ifPresent(result::addCounts);
        if (outData) {
            table = result.calcTable(this.rowsTotal, i -> i != 1);
            outText = TextUtil.showTextTable(this.header, table, this.align);
            this.showText(outText);
            this.showTable(table);
            String fn = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats_match.txt";
            Statistics.writeStat(fn, outText);
            this.callback.setDataFile(fn);
        }
        return result;
    }

    MatchStatCounts forFile(IProject.FileInfo fi) {
        MatchStatCounts result = new MatchStatCounts();
        this.alreadyProcessedInFile.clear();
        ArrayList<SourceTextEntry> untranslatedEntries = new ArrayList<SourceTextEntry>();
        for (SourceTextEntry ste : fi.entries) {
            this.checkInterrupted();
            StatCount count = new StatCount(ste);
            boolean existInFile = this.alreadyProcessedInFile.contains(ste.getSrcText());
            boolean existInPreviousFiles = this.alreadyProcessedInProject.contains(ste.getSrcText());
            if (Core.getProject().getTranslationInfo(ste).isTranslated()) {
                result.addExact(count);
                ++this.treated;
                continue;
            }
            if (existInPreviousFiles) {
                result.addRepetitionFromOtherFiles(count);
                this.entryProcessed();
                continue;
            }
            if (existInFile) {
                result.addRepetitionWithinThisFile(count);
                this.entryProcessed();
                continue;
            }
            untranslatedEntries.add(ste);
            this.alreadyProcessedInFile.add(ste.getSrcText());
        }
        this.alreadyProcessedInProject.addAll(this.alreadyProcessedInFile);
        this.calcSimilarity(untranslatedEntries).ifPresent(result::addCounts);
        return result;
    }

    Optional<MatchStatCounts> calcSimilarity(List<SourceTextEntry> untranslatedEntries) {
        boolean doParallel = Runtime.getRuntime().availableProcessors() > 1;
        Stream stream = doParallel ? untranslatedEntries.parallelStream() : untranslatedEntries.stream();
        long startTime = System.currentTimeMillis();
        MatchStatCounts result = null;
        try {
            result = stream.collect(MatchStatCounts::new, (counts, ste) -> {
                this.checkInterrupted();
                counts.addForPercents(this.calcMaxSimilarity((SourceTextEntry)ste), new StatCount((SourceTextEntry)ste));
                this.entryProcessed();
            }, MatchStatCounts::addCounts);
        }
        catch (FindMatches.StoppedException | LongProcessInterruptedException runtimeException) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).fine(String.format("Calc similarity took %.3f s (%s)", Float.valueOf((float)(endTime - startTime) / 1000.0f), doParallel ? "parallel" : "sequential"));
        return Optional.ofNullable(result);
    }

    int calcMaxSimilarity(SourceTextEntry ste) {
        String srcNoXmlTags = this.removeXmlTags(ste);
        FindMatches localFinder = this.finder.get();
        List<NearString> nears = localFinder.search(srcNoXmlTags, true, false, this::isInterrupted);
        Token[] strTokensStem = localFinder.tokenizeAll(ste.getSrcText());
        int maxSimilarity = 0;
        for (NearString near : nears) {
            Token[] candTokens = localFinder.tokenizeAll(near.source);
            int newSimilarity = FuzzyMatcher.calcSimilarity(this.distanceCalculator.get(), strTokensStem, candTokens);
            if (near.fuzzyMark) {
                newSimilarity -= 40;
            }
            if (newSimilarity <= maxSimilarity) continue;
            maxSimilarity = newSimilarity;
            if (newSimilarity < 95) continue;
            break;
        }
        return maxSimilarity;
    }

    String removeXmlTags(SourceTextEntry ste) {
        String srcNoXmlTags = ste.getSrcText();
        for (ProtectedPart pp : ste.getProtectedParts()) {
            srcNoXmlTags = srcNoXmlTags.replace(pp.getTextInSourceSegment(), pp.getReplacementMatchCalculation());
        }
        return srcNoXmlTags;
    }

    void entryProcessed() {
        ++this.treated;
        int newPercent = this.treated * 100 / this.entriesToProcess;
        if (this.percent != newPercent) {
            this.callback.showProgress(newPercent);
            this.percent = newPercent;
        }
    }
}

