/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.align;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.align.AlignFilePicker;
import org.omegat.gui.align.AlignPanelController;
import org.omegat.gui.align.Aligner;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.LanguageComboBoxRenderer;
import org.omegat.util.gui.StaticUIUtils;

public class AlignFilePickerController {
    String sourceFile;
    String targetFile;
    String sourceDefaultDir;
    String targetDefaultDir;
    String defaultSaveDir;
    List<Language> allLangs = Language.getLanguages();
    Language sourceLanguage = this.allLangs.get(0);
    Language targetLanguage = this.allLangs.get(this.allLangs.size() - 1);

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public void setSourceLanguage(Language sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public void setTargetLanguage(Language targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public void setSourceDefaultDir(String sourceDefaultDir) {
        this.sourceDefaultDir = sourceDefaultDir;
    }

    public void setTargetDefaultDir(String targetDefaultDir) {
        this.targetDefaultDir = targetDefaultDir;
    }

    public void setDefaultSaveDir(String defaultSaveDir) {
        this.defaultSaveDir = defaultSaveDir;
    }

    public void show(final Component parent) {
        final JFrame frame = new JFrame(OStrings.getString("ALIGNER_FILEPICKER"));
        frame.setDefaultCloseOperation(2);
        StaticUIUtils.setEscapeClosable(frame);
        final AlignFilePicker picker = new AlignFilePicker();
        picker.sourceLanguagePicker.setModel(new DefaultComboBoxModel<Language>(new Vector<Language>(Language.getLanguages())));
        picker.sourceLanguagePicker.setRenderer(new LanguageComboBoxRenderer());
        picker.sourceLanguagePicker.setSelectedItem(this.sourceLanguage);
        picker.sourceLanguagePicker.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (e.getItem() instanceof String) {
                    String newVal = (String)e.getItem();
                    if (Language.verifySingleLangCode(newVal)) {
                        AlignFilePickerController.this.sourceLanguage = new Language(newVal);
                    } else {
                        AlignFilePickerController.this.sourceLanguage = null;
                        JOptionPane.showMessageDialog(frame, OStrings.getString("NP_INVALID_SOURCE_LOCALE") + OStrings.getString("NP_LOCALE_SUGGESTION"), OStrings.getString("TF_ERROR"), 0);
                        picker.sourceLanguagePicker.requestFocusInWindow();
                    }
                } else if (e.getItem() instanceof Language) {
                    AlignFilePickerController.this.sourceLanguage = (Language)e.getItem();
                } else {
                    throw new IllegalArgumentException();
                }
                AlignFilePickerController.this.updatePicker(picker);
            }
        });
        picker.targetLanguagePicker.setModel(new DefaultComboBoxModel<Language>(new Vector<Language>(Language.getLanguages())));
        picker.targetLanguagePicker.setRenderer(new LanguageComboBoxRenderer());
        picker.targetLanguagePicker.setSelectedItem(this.targetLanguage);
        picker.targetLanguagePicker.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (e.getItem() instanceof String) {
                String newVal = (String)e.getItem();
                if (Language.verifySingleLangCode(newVal)) {
                    this.targetLanguage = new Language(newVal);
                } else {
                    this.targetLanguage = null;
                    JOptionPane.showMessageDialog(frame, OStrings.getString("NP_INVALID_TARGET_LOCALE") + OStrings.getString("NP_LOCALE_SUGGESTION"), OStrings.getString("TF_ERROR"), 0);
                    picker.targetLanguagePicker.requestFocusInWindow();
                }
            } else if (e.getItem() instanceof Language) {
                this.targetLanguage = (Language)e.getItem();
            } else {
                throw new IllegalArgumentException();
            }
            this.updatePicker(picker);
        });
        picker.sourceChooseFileButton.addActionListener(e -> {
            File file = AlignFilePickerController.chooseFile(frame, OStrings.getString("ALIGNER_FILEPICKER_CHOOSE_SOURCE"), StringUtil.isEmpty(this.sourceFile) ? this.sourceDefaultDir : this.sourceFile);
            if (file != null) {
                this.sourceDefaultDir = file.getParent();
                this.targetDefaultDir = this.targetDefaultDir == null ? this.sourceDefaultDir : this.targetDefaultDir;
                this.defaultSaveDir = this.defaultSaveDir == null ? this.sourceDefaultDir : this.defaultSaveDir;
                picker.sourceLanguageFileField.setText(file.getAbsolutePath());
            }
        });
        picker.targetChooseFileButton.addActionListener(e -> {
            File file = AlignFilePickerController.chooseFile(frame, OStrings.getString("ALIGNER_FILEPICKER_CHOOSE_TARGET"), StringUtil.isEmpty(this.targetFile) ? this.targetDefaultDir : this.targetFile);
            if (file != null) {
                this.targetDefaultDir = file.getParent();
                this.sourceDefaultDir = this.sourceDefaultDir == null ? this.targetDefaultDir : this.sourceDefaultDir;
                this.defaultSaveDir = this.defaultSaveDir == null ? this.targetDefaultDir : this.defaultSaveDir;
                picker.targetLanguageFileField.setText(file.getAbsolutePath());
            }
        });
        picker.sourceLanguageFileField.setText(this.sourceFile);
        picker.sourceLanguageFileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                AlignFilePickerController.this.sourceFile = picker.sourceLanguageFileField.getText();
                AlignFilePickerController.this.updatePicker(picker);
            }
        });
        picker.targetLanguageFileField.setText(this.targetFile);
        picker.targetLanguageFileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                AlignFilePickerController.this.targetFile = picker.targetLanguageFileField.getText();
                AlignFilePickerController.this.updatePicker(picker);
            }
        });
        TransferHandler transferHandler = new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    List list = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    List<File> files = AlignFilePickerController.getSupportedFiles(list);
                    if (files.isEmpty()) {
                        return false;
                    }
                    JTextComponent field = (JTextComponent)support.getComponent();
                    field.setText(files.get(0).getAbsolutePath());
                    return true;
                }
                catch (Exception e) {
                    Log.log(e);
                    return false;
                }
            }
        };
        picker.sourceLanguageFileField.setTransferHandler(transferHandler);
        picker.targetLanguageFileField.setTransferHandler(transferHandler);
        picker.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    List list = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    List<File> files = AlignFilePickerController.getSupportedFiles(list);
                    if (files.isEmpty()) {
                        return false;
                    }
                    if (files.size() == 1) {
                        JTextField insertTarget = picker.sourceLanguageFileField;
                        if (picker.sourceLanguageFileField.getDocument().getLength() != 0 && picker.targetLanguageFileField.getDocument().getLength() == 0) {
                            insertTarget = picker.targetLanguageFileField;
                        }
                        insertTarget.setText(files.get(0).getAbsolutePath());
                    } else {
                        picker.sourceLanguageFileField.setText(files.get(0).getAbsolutePath());
                        picker.targetLanguageFileField.setText(files.get(1).getAbsolutePath());
                    }
                    return true;
                }
                catch (Exception e) {
                    Log.log(e);
                    return false;
                }
            }
        });
        picker.okButton.addActionListener(e -> {
            picker.bottomPanel.remove(picker.messageTextArea);
            picker.bottomPanel.add((Component)picker.progressBar, "Center");
            picker.bottomPanel.revalidate();
            new SwingWorker<Aligner, Void>(){

                @Override
                protected Aligner doInBackground() throws Exception {
                    Aligner aligner = new Aligner(AlignFilePickerController.this.sourceFile, AlignFilePickerController.this.sourceLanguage, AlignFilePickerController.this.targetFile, AlignFilePickerController.this.targetLanguage);
                    aligner.loadFiles();
                    return aligner;
                }

                @Override
                protected void done() {
                    try {
                        Aligner aligner = (Aligner)this.get();
                        new AlignPanelController(aligner, AlignFilePickerController.this.defaultSaveDir).show(parent);
                    }
                    catch (CancellationException aligner) {
                    }
                    catch (Exception e) {
                        Log.log(e);
                        JOptionPane.showMessageDialog(frame, OStrings.getString("ALIGNER_ERROR_LOADING"), OStrings.getString("ERROR_TITLE"), 0);
                    }
                    frame.dispose();
                }
            }.execute();
        });
        picker.cancelButton.addActionListener(e -> frame.dispose());
        frame.getRootPane().setDefaultButton(picker.okButton);
        this.updatePicker(picker);
        frame.add(picker);
        frame.pack();
        frame.setLocationRelativeTo(parent);
        frame.setVisible(true);
    }

    private void updatePicker(final AlignFilePicker picker) {
        if (this.sourceFile == null || this.targetFile == null || this.sourceLanguage == null || this.targetLanguage == null) {
            picker.messageTextArea.setText(null);
            picker.okButton.setEnabled(false);
            return;
        }
        final File srcFile = new File(this.sourceFile);
        final File trgFile = new File(this.targetFile);
        if (!srcFile.isFile() || !trgFile.isFile() || srcFile.equals(trgFile)) {
            picker.messageTextArea.setText(null);
            picker.okButton.setEnabled(false);
            return;
        }
        new SwingWorker<boolean[], Void>(){

            @Override
            protected boolean[] doInBackground() throws Exception {
                FilterMaster fm = Core.getFilterMaster();
                return new boolean[]{fm.isFileSupported(srcFile, false), fm.isFileSupported(trgFile, false)};
            }

            @Override
            protected void done() {
                boolean enabled = false;
                String message = null;
                try {
                    boolean[] results = (boolean[])this.get();
                    boolean bl = enabled = results[0] && results[1];
                    if (!results[0] && results[1]) {
                        message = OStrings.getString("ALIGNER_FILEPICKER_ERROR_ONE_FILE", srcFile.getName());
                    } else if (results[0] && !results[1]) {
                        message = OStrings.getString("ALIGNER_FILEPICKER_ERROR_ONE_FILE", trgFile.getName());
                    } else if (!results[0] && !results[1]) {
                        message = OStrings.getString("ALIGNER_FILEPICKER_ERROR_BOTH_FILES");
                    }
                }
                catch (CancellationException results) {
                }
                catch (Exception e) {
                    Log.log(e);
                    message = e.getLocalizedMessage();
                }
                picker.okButton.setEnabled(enabled);
                picker.messageTextArea.setText(message);
            }
        }.execute();
    }

    private static List<File> getSupportedFiles(List<?> files) {
        ArrayList<File> result = new ArrayList<File>(files.size());
        FilterMaster fm = Core.getFilterMaster();
        for (Object o : files) {
            File file = (File)o;
            if (!fm.isFileSupported(file, true)) continue;
            result.add(file);
        }
        return result;
    }

    static File chooseFile(Component parent, String title, String dir) {
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setDialogTitle(title);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return OStrings.getString("ALIGNER_FILEPICKER_SUPPORTEDFILES");
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || Core.getFilterMaster().isFileSupported(f, true);
            }
        });
        if (chooser.showOpenDialog(parent) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Preferences.init();
        PluginUtils.loadPlugins(Collections.emptyMap());
        Core.setFilterMaster(new FilterMaster(FilterMaster.createDefaultFiltersConfig()));
        Core.setSegmenter(new Segmenter(SRX.getDefault()));
        AlignFilePickerController picker = new AlignFilePickerController();
        if (args.length == 4) {
            picker.sourceLanguage = new Language(args[0]);
            picker.sourceFile = args[1];
            picker.targetLanguage = new Language(args[2]);
            picker.targetFile = args[3];
        }
        picker.show(null);
    }
}

