/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import io.github.eb4j.stardict.StarDictDictionary;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.util.Language;
import org.omegat.util.Preferences;

public class StarDict
implements IDictionaryFactory {
    public static void loadPlugins() {
        CoreEvents.registerApplicationEventListener(new StarDictApplicationEventListener());
    }

    public static void unloadPlugins() {
    }

    @Override
    public boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".ifo");
    }

    @Override
    public IDictionary loadDict(File file) throws Exception {
        return this.loadDict(file, new Language(Locale.getDefault()));
    }

    @Override
    public IDictionary loadDict(File file, Language language) throws Exception {
        return new StarDictDict(file, language);
    }

    static class StarDictDict
    implements IDictionary {
        protected final StarDictDictionary dictionary;
        protected final Language language;

        StarDictDict(File file, Language language) throws Exception {
            this.dictionary = StarDictDictionary.loadDictionary((File)file, (int)1000, (Duration)Duration.ofMinutes(30L));
            this.language = language;
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) throws Exception {
            List result = this.dictionary.readArticles(word);
            if (result.isEmpty()) {
                result = this.dictionary.readArticles(word.toLowerCase(this.language.getLocale()));
            }
            return result.stream().filter(StarDictDict::useEntry).map(StarDictDict::convertEntry).collect(Collectors.toList());
        }

        @Override
        public List<DictionaryEntry> readArticlesPredictive(String word) {
            List result = this.dictionary.readArticlesPredictive(word);
            if (result.isEmpty()) {
                result = this.dictionary.readArticlesPredictive(word.toLowerCase(this.language.getLocale()));
            }
            return result.stream().filter(StarDictDict::useEntry).map(StarDictDict::convertEntry).collect(Collectors.toList());
        }

        private static boolean useEntry(StarDictDictionary.Entry entry) {
            StarDictDictionary.EntryType type = entry.getType();
            return type == StarDictDictionary.EntryType.MEAN || type == StarDictDictionary.EntryType.PHONETIC || type == StarDictDictionary.EntryType.HTML;
        }

        private static DictionaryEntry convertEntry(StarDictDictionary.Entry entry) {
            boolean condensed = Preferences.isPreferenceDefault("dictionary_condensed_view", false);
            StringBuilder sb = new StringBuilder();
            if (entry.getType().equals((Object)StarDictDictionary.EntryType.MEAN)) {
                String[] lines = entry.getArticle().split("\n");
                if (condensed) {
                    for (int i = 0; i < lines.length; ++i) {
                        if (i > 0) {
                            sb.append("<span class=\"paragraph-start\">&nbsp;\u00b6</span><span>");
                        } else {
                            sb.append("<span>");
                        }
                        sb.append(lines[i]).append("</span>");
                    }
                } else {
                    for (String line : lines) {
                        sb.append("<div>").append(line).append("</div>");
                    }
                }
            } else if (entry.getType().equals((Object)StarDictDictionary.EntryType.PHONETIC)) {
                sb.append("<span>(").append(entry.getArticle()).append(")</span>");
            } else if (entry.getType().equals((Object)StarDictDictionary.EntryType.HTML)) {
                sb.append(entry.getArticle());
            }
            return new DictionaryEntry(entry.getWord(), sb.toString());
        }
    }

    static class StarDictApplicationEventListener
    implements IApplicationEventListener {
        StarDictApplicationEventListener() {
        }

        @Override
        public void onApplicationStartup() {
            Core.getDictionaries().addDictionaryFactory(new StarDict());
        }

        @Override
        public void onApplicationShutdown() {
        }
    }
}

