/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.collections;

import edu.berkeley.nlp.lm.util.MurmurHash;
import java.io.Serializable;
import java.util.Arrays;

public final class LongHashSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long[] keys;
    private int size = 0;
    private static final int EMPTY_KEY = -1;
    private double maxLoadFactor = 0.5;

    public LongHashSet() {
        this(5);
    }

    public void setLoadFactor(double loadFactor) {
        this.maxLoadFactor = loadFactor;
        this.ensureCapacity(this.keys.length);
    }

    public LongHashSet(int initCapacity_) {
        int initCapacity = this.toSize(initCapacity_);
        this.keys = new long[initCapacity];
        Arrays.fill(this.keys, -1L);
    }

    public String toString() {
        return Arrays.toString(this.keys);
    }

    private int toSize(int initCapacity_) {
        return Math.max(5, (int)((double)initCapacity_ / this.maxLoadFactor) + 1);
    }

    public boolean put(long k) {
        if ((double)this.size / (double)this.keys.length > this.maxLoadFactor) {
            this.rehash();
        }
        return this.putHelp(k, this.keys);
    }

    private void rehash() {
        int length = this.keys.length * 2 + 1;
        this.rehash(length);
    }

    private void rehash(int length) {
        long[] newKeys = new long[length];
        Arrays.fill(newKeys, -1L);
        this.size = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            long curr = this.keys[i];
            if (curr == -1L) continue;
            this.putHelp(curr, newKeys);
        }
        this.keys = newKeys;
    }

    private boolean putHelp(long k, long[] keyArray) {
        assert (k != -1L);
        int pos = this.find(k, true, keyArray);
        long currKey = keyArray[pos];
        if (currKey == -1L) {
            ++this.size;
            keyArray[pos] = k;
            return true;
        }
        return false;
    }

    private static int getInitialPos(long k, long[] keyArray) {
        long hash = MurmurHash.hashOneLong(k, 47);
        if (hash < 0L) {
            hash = -hash;
        }
        int pos = (int)(hash % (long)keyArray.length);
        return pos;
    }

    public boolean get(long k) {
        int pos = this.find(k, false);
        return pos != -1;
    }

    public boolean containsKey(long k) {
        int pos = this.find(k, false);
        return pos != -1;
    }

    private int find(long k, boolean returnLastEmpty) {
        return this.find(k, returnLastEmpty, this.keys);
    }

    private int find(long k, boolean returnLastEmpty, long[] keyArray) {
        long[] localKeys = keyArray;
        int length = localKeys.length;
        int pos = LongHashSet.getInitialPos(k, localKeys);
        long curr = localKeys[pos];
        while (curr != -1L && curr != k) {
            if (++pos == length) {
                pos = 0;
            }
            curr = localKeys[pos];
        }
        return returnLastEmpty ? pos : (curr == -1L ? -1 : pos);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void ensureCapacity(int capacity) {
        int newSize = this.toSize(capacity);
        if (newSize > this.keys.length) {
            this.rehash(newSize);
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.keys, -1L);
        this.size = 0;
    }

    public void remove(long k) {
        int pos = this.find(k, false, this.keys);
        if (pos == -1) {
            return;
        }
        this.keys[pos] = -1L;
        --this.size;
    }

    public LongHashSet copy() {
        LongHashSet ret = new LongHashSet();
        ret.keys = Arrays.copyOf(this.keys, this.keys.length);
        ret.size = this.size;
        ret.maxLoadFactor = this.maxLoadFactor;
        return ret;
    }
}

