/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;
import org.omegat.core.dictionaries.DictionaryData;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.util.Language;
import org.omegat.util.Log;

public class StarDict
implements IDictionaryFactory {
    @Override
    public boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".ifo");
    }

    @Override
    public IDictionary loadDict(File file) throws Exception {
        return this.loadDict(file, new Language(Locale.getDefault()));
    }

    @Override
    public IDictionary loadDict(File ifoFile, Language language) throws Exception {
        String bitsString;
        Map<String, String> header = this.readIFO(ifoFile);
        String version = header.get("version");
        if (!"2.4.2".equals(version) && !"3.0.0".equals(version)) {
            throw new Exception("Invalid version of dictionary: " + version);
        }
        String sametypesequence = header.get("sametypesequence");
        if (!("g".equals(sametypesequence) || "m".equals(sametypesequence) || "x".equals(sametypesequence) || "h".equals(sametypesequence))) {
            throw new Exception("Invalid type of dictionary: " + sametypesequence);
        }
        int idxoffsetbits = 32;
        if ("3.0.0".equals(version) && (bitsString = header.get("idxoffsetbits")) != null) {
            idxoffsetbits = Integer.parseInt(bitsString);
        }
        if (idxoffsetbits != 32) {
            throw new Exception("StarDict dictionaries with idxoffsetbits=64 are not supported.");
        }
        String f = ifoFile.getPath();
        if (f.endsWith(".ifo")) {
            f = f.substring(0, f.length() - ".ifo".length());
        }
        String dictName = f;
        File idxFile = this.getFile(dictName, ".idx.gz", ".idx").orElseThrow(() -> new FileNotFoundException("No .idx file could be found"));
        DictionaryData<Entry> data = this.loadData(idxFile, language);
        File dictFile = this.getFile(dictName, ".dict.dz", ".dict").orElseThrow(() -> new FileNotFoundException("No .dict.dz or .dict files were found for " + dictName));
        try {
            if (dictFile.getName().endsWith(".dz")) {
                DictZipInputStream dataFile = new DictZipInputStream(new RandomAccessInputStream(new RandomAccessFile(dictFile, "r")));
                return new StarDictZipDict(dataFile, data);
            }
            RandomAccessFile dataFile = new RandomAccessFile(dictFile, "r");
            return new StarDictFileDict(dataFile, data);
        }
        catch (FileNotFoundException ex) {
            throw new FileNotFoundException("No .dict.dz or .dict files were found for " + dictName);
        }
    }

    private Map<String, String> readIFO(File ifoFile) throws Exception {
        TreeMap<String, String> result = new TreeMap<String, String>();
        try (BufferedReader rd = Files.newBufferedReader(ifoFile.toPath(), StandardCharsets.UTF_8);){
            String line;
            String first = rd.readLine();
            if (!"StarDict's dict ifo file".equals(first)) {
                throw new Exception("Invalid header of .ifo file: " + first);
            }
            while ((line = rd.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                int pos = line.indexOf(61);
                if (pos < 0) {
                    throw new Exception("Invalid format of .ifo file: " + line);
                }
                result.put(line.substring(0, pos), line.substring(pos + 1));
            }
        }
        return result;
    }

    private Optional<File> getFile(String basename, String ... suffixes) {
        return Stream.of(suffixes).map(suff -> new File(basename + suff)).filter(f -> f.isFile()).findFirst();
    }

    private DictionaryData<Entry> loadData(File idxFile, Language language) throws IOException {
        InputStream is = new FileInputStream(idxFile);
        if (idxFile.getName().endsWith(".gz")) {
            is = new GZIPInputStream(is, 8192);
        }
        DictionaryData<Entry> newData = new DictionaryData<Entry>(language);
        try (DataInputStream idx = new DataInputStream(new BufferedInputStream(is));
             ByteArrayOutputStream mem = new ByteArrayOutputStream();){
            int b;
            while ((b = idx.read()) != -1) {
                if (b == 0) {
                    String key = new String(mem.toByteArray(), 0, mem.size(), StandardCharsets.UTF_8);
                    mem.reset();
                    int bodyOffset = idx.readInt();
                    int bodyLength = idx.readInt();
                    newData.add(key, new Entry(bodyOffset, bodyLength));
                    continue;
                }
                mem.write(b);
            }
        }
        is.close();
        newData.done();
        return newData;
    }

    private static class StarDictZipDict
    extends StarDictBaseDict {
        private final DictZipInputStream dataFile;

        public StarDictZipDict(DictZipInputStream dataFile, DictionaryData<Entry> data) {
            super(data);
            this.dataFile = dataFile;
        }

        @Override
        protected String readArticle(int start, int len) {
            String result = null;
            try {
                this.dataFile.seek((long)start);
                byte[] data = new byte[len];
                this.dataFile.readFully(data);
                result = new String(data, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Log.log(e);
            }
            return result;
        }

        @Override
        public void close() throws IOException {
            this.dataFile.close();
        }
    }

    private static class StarDictFileDict
    extends StarDictBaseDict {
        private final RandomAccessFile dataFile;

        public StarDictFileDict(RandomAccessFile dataFile, DictionaryData<Entry> data) {
            super(data);
            this.dataFile = dataFile;
        }

        @Override
        protected String readArticle(int start, int len) {
            String result = null;
            try {
                byte[] data = new byte[len];
                this.dataFile.seek(start);
                int readLen = this.dataFile.read(data);
                result = new String(data, 0, readLen, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Log.log(e);
            }
            return result;
        }

        @Override
        public void close() throws IOException {
            this.dataFile.close();
        }
    }

    static abstract class StarDictBaseDict
    implements IDictionary {
        protected final DictionaryData<Entry> data;
        private final Map<Entry, String> cache = new HashMap<Entry, String>();

        StarDictBaseDict(DictionaryData<Entry> data) {
            this.data = data;
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) throws Exception {
            return this.data.lookUp(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), this.getArticle((Entry)e.getValue()))).collect(Collectors.toList());
        }

        @Override
        public List<DictionaryEntry> readArticlesPredictive(String word) {
            return this.data.lookUpPredictive(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), this.getArticle((Entry)e.getValue()))).collect(Collectors.toList());
        }

        private synchronized String getArticle(Entry entry) {
            return this.cache.computeIfAbsent(entry, e -> this.readArticle(((Entry)e).start, ((Entry)e).len).replace("\n", "<br>"));
        }

        protected abstract String readArticle(int var1, int var2);
    }

    static class Entry {
        private final int start;
        private final int len;

        Entry(int start, int len) {
            this.start = start;
            this.len = len;
        }

        public int hashCode() {
            return Objects.hash(this.len, this.start);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.len == other.len && this.start == other.start;
        }
    }
}

