/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.issues;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.DataUtils;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.issues.IIssue;
import org.omegat.gui.issues.IIssueProvider;
import org.omegat.gui.issues.IIssues;
import org.omegat.gui.issues.IssueProviders;
import org.omegat.gui.issues.IssuesPanel;
import org.omegat.gui.issues.TagIssue;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.StreamUtil;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DataTableStyling;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.ResourcesUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TableColumnSizer;

public class IssuesPanelController
implements IIssues {
    static final String ACTION_KEY_JUMP_TO_SELECTED_ISSUE = "jumpToSelectedIssue";
    static final String ACTION_KEY_FOCUS_ON_TYPES_LIST = "focusOnTypesList";
    static final String ALL_FILES_PATTERN = ".*";
    static final String NO_INSTRUCTIONS = "";
    static final double INNER_SPLIT_INITIAL_RATIO = 0.25;
    static final double OUTER_SPLIT_INITIAL_RATIO = 0.5;
    static final Icon SETTINGS_ICON = new ImageIcon(ResourcesUtil.getBundledImage("appbar.settings.active.png"));
    static final Icon SETTINGS_ICON_INACTIVE = new ImageIcon(ResourcesUtil.getBundledImage("appbar.settings.inactive.png"));
    static final Icon SETTINGS_ICON_PRESSED = new ImageIcon(ResourcesUtil.getBundledImage("appbar.settings.pressed.png"));
    static final Icon SETTINGS_ICON_INVISIBLE = new Icon(){

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return SETTINGS_ICON.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return SETTINGS_ICON.getIconHeight();
        }
    };
    final Window parent;
    JFrame frame;
    IssuesPanel panel;
    TableColumnSizer colSizer;
    String filePattern;
    String instructions;
    int mouseoverCol = -1;
    int mouseoverRow = -1;
    int selectedEntry = -1;
    List<String> selectedTypes = Collections.emptyList();
    IssueLoader loader;
    static final String ALL_TYPES = new String(OStrings.getString("ISSUES_TYPE_ALL"));

    public IssuesPanelController(Window parent) {
        this.parent = parent;
    }

    synchronized void init() {
        if (this.frame != null) {
            this.frame.setJMenuBar(this.generateMenuBar());
            return;
        }
        this.frame = new JFrame(OStrings.getString("ISSUES_WINDOW_TITLE"));
        StaticUIUtils.setEscapeClosable(this.frame);
        StaticUIUtils.setWindowIcon(this.frame);
        if (Platform.isMacOSX()) {
            OSXIntegration.enableFullScreen(this.frame);
        }
        this.panel = new IssuesPanel();
        this.frame.add(this.panel);
        this.frame.setJMenuBar(this.generateMenuBar());
        this.frame.setPreferredSize(new Dimension(600, 400));
        this.frame.pack();
        this.frame.setLocationRelativeTo(this.parent);
        this.panel.innerSplitPane.setDividerLocation(0.25);
        this.panel.outerSplitPane.setDividerLocation(0.5);
        StaticUIUtils.persistGeometry(this.frame, "issues_window", () -> Preferences.setPreference("issues_window_divider_location_bottom", this.panel.outerSplitPane.getDividerLocation()));
        try {
            int bottomDL = Integer.parseInt(Preferences.getPreference("issues_window_divider_location_bottom"));
            this.panel.outerSplitPane.setDividerLocation(bottomDL);
        }
        catch (NumberFormatException bottomDL) {
            // empty catch block
        }
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IssuesPanelController.this.reset();
            }
        });
        if (Preferences.isPreference("project_files_use_font")) {
            String fontName = Preferences.getPreference("source_font");
            int fontSize = Integer.parseInt(Preferences.getPreference("source_font_size"));
            this.setFont(new Font(fontName, 0, fontSize));
        }
        this.panel.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.viewSelectedIssueDetail();
                this.selectedEntry = this.getSelectedIssue().map(IIssue::getSegmentNumber).orElse(-1);
            }
        });
        this.panel.table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), ACTION_KEY_JUMP_TO_SELECTED_ISSUE);
        this.panel.table.getActionMap().put(ACTION_KEY_JUMP_TO_SELECTED_ISSUE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuesPanelController.this.jumpToSelectedIssue();
            }
        });
        this.panel.table.getInputMap().put(KeyStroke.getKeyStroke(9, 64), ACTION_KEY_FOCUS_ON_TYPES_LIST);
        this.panel.table.getInputMap().put(KeyStroke.getKeyStroke(9, 0), ACTION_KEY_FOCUS_ON_TYPES_LIST);
        this.panel.table.getActionMap().put(ACTION_KEY_FOCUS_ON_TYPES_LIST, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IssuesPanelController.this.panel.typeList.isVisible()) {
                    IssuesPanelController.this.panel.typeList.requestFocusInWindow();
                }
            }
        });
        this.panel.closeButton.addActionListener(e -> StaticUIUtils.closeWindowByEvent(this.frame));
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    IssuesPanelController.this.jumpToSelectedIssue();
                } else if (e.getButton() == 1 && IssuesPanelController.this.mouseoverCol == IssueColumn.ACTION_BUTTON.index) {
                    this.doPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                IssuesPanelController.this.updateRollover();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                IssuesPanelController.this.updateRollover();
            }

            private void doPopup(MouseEvent e) {
                IssuesPanelController.this.getIssueAt(e.getPoint()).ifPresent(issue -> IssuesPanelController.this.showPopupMenu(e.getComponent(), e.getPoint(), (IIssue)issue));
            }
        };
        this.panel.table.addMouseListener(adapter);
        this.panel.table.addMouseMotionListener(adapter);
        this.panel.typeList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateFilter();
                this.selectedTypes = this.getSelectedTypes();
            }
        });
        this.panel.jumpButton.addActionListener(e -> this.jumpToSelectedIssue());
        this.panel.reloadButton.addActionListener(e -> this.refreshData(this.selectedEntry, this.selectedTypes));
        this.panel.showAllButton.addActionListener(e -> this.showAll());
        this.colSizer = TableColumnSizer.autoSize(this.panel.table, IssueColumn.DESCRIPTION.index, true);
        CoreEvents.registerProjectChangeListener(e -> {
            switch (e) {
                case CLOSE: {
                    SwingUtilities.invokeLater(() -> {
                        this.filePattern = ALL_FILES_PATTERN;
                        this.instructions = NO_INSTRUCTIONS;
                        this.reset();
                        this.frame.setVisible(false);
                    });
                    break;
                }
                case MODIFIED: {
                    if (!this.frame.isVisible()) break;
                    SwingUtilities.invokeLater(() -> this.refreshData(this.selectedEntry, this.selectedTypes));
                    break;
                }
            }
        });
        CoreEvents.registerFontChangedEventListener(f -> {
            if (!Preferences.isPreference("project_files_use_font")) {
                f = new JTable().getFont();
            }
            this.setFont(f);
            this.viewSelectedIssueDetail();
        });
    }

    JMenuBar generateMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = menuBar.add(new JMenu(OStrings.getString("ISSUES_WINDOW_MENU_OPTIONS")));
        JCheckBoxMenuItem tagsItem = new JCheckBoxMenuItem(OStrings.getString("ISSUES_WINDOW_MENU_OPTIONS_TOGGLE_PROVIDER", OStrings.getString("ISSUES_TAGS_PROVIDER_NAME")));
        tagsItem.setSelected(true);
        tagsItem.setEnabled(false);
        menu.add(tagsItem);
        Set<String> disabledProviders = IssueProviders.getDisabledProviderIds();
        IssueProviders.getIssueProviders().stream().sorted(Comparator.comparing(IIssueProvider::getId)).forEach(provider -> {
            String label = StringUtil.format(OStrings.getString("ISSUES_WINDOW_MENU_OPTIONS_TOGGLE_PROVIDER"), provider.getName());
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(label);
            item.addActionListener(e -> {
                IssueProviders.setProviderEnabled(provider.getId(), item.isSelected());
                this.refreshData(this.selectedEntry, this.selectedTypes);
            });
            item.setSelected(!disabledProviders.contains(provider.getId()));
            menu.add(item);
        });
        menu.addSeparator();
        JCheckBoxMenuItem askItem = new JCheckBoxMenuItem(OStrings.getString("ISSUES_WINDOW_MENU_DONT_ASK"));
        askItem.setSelected(Preferences.isPreference("issue_providers_dont_ask"));
        askItem.addActionListener(e -> Preferences.setPreference("issue_providers_dont_ask", askItem.isSelected()));
        menu.add(askItem);
        return menuBar;
    }

    void updateRollover() {
        Point point = this.panel.table.getMousePosition();
        int oldRow = this.mouseoverRow;
        int oldCol = this.mouseoverCol;
        int newRow = point == null ? -1 : this.panel.table.rowAtPoint(point);
        int newCol = point == null ? -1 : this.panel.table.columnAtPoint(point);
        boolean doRepaint = newRow != oldRow || newCol != oldCol;
        this.mouseoverRow = newRow;
        this.mouseoverCol = newCol;
        if (doRepaint) {
            Rectangle rect = this.panel.table.getCellRect(oldRow, IssueColumn.ACTION_BUTTON.index, true);
            this.panel.table.repaint(rect);
            rect = this.panel.table.getCellRect(newRow, IssueColumn.ACTION_BUTTON.index, true);
            this.panel.table.repaint(rect);
        }
    }

    void setFont(Font font) {
        this.panel.typeList.setFont(font);
        DataTableStyling.applyFont(this.panel.table, font);
        this.panel.messageLabel.setFont(font);
    }

    void viewSelectedIssueDetail() {
        Optional<IIssue> issue = this.getSelectedIssue();
        issue.map(IIssue::getDetailComponent).ifPresent(comp -> {
            if (Preferences.isPreference("project_files_use_font")) {
                Font font = Core.getMainWindow().getApplicationFont();
                StaticUIUtils.visitHierarchy(comp, c -> c instanceof JTextComponent, c -> c.setFont(font));
            }
            this.panel.outerSplitPane.setBottomComponent((Component)comp);
        });
        this.panel.jumpButton.setEnabled(issue.isPresent());
    }

    void jumpToSelectedIssue() {
        this.getSelectedIssue().map(IIssue::getSegmentNumber).ifPresent(i -> {
            Core.getEditor().gotoEntry((int)i);
            JFrame mwf = Core.getMainWindow().getApplicationFrame();
            mwf.setState(0);
            mwf.toFront();
        });
    }

    Optional<IIssue> getIssueAt(Point p) {
        return this.getIssueAtRow(this.panel.table.rowAtPoint(p));
    }

    Optional<IIssue> getSelectedIssue() {
        return this.getIssueAtRow(this.panel.table.getSelectedRow());
    }

    Optional<IIssue> getIssueAtRow(int row) {
        if (row < 0) {
            return Optional.empty();
        }
        TableModel model = this.panel.table.getModel();
        if (!(model instanceof IssuesTableModel) || model.getRowCount() == 0) {
            return Optional.empty();
        }
        IssuesTableModel imodel = (IssuesTableModel)model;
        int realSelection = this.panel.table.getRowSorter().convertRowIndexToModel(row);
        return Optional.of(imodel.getIssueAt(realSelection));
    }

    List<String> getSelectedTypes() {
        List<String> types = this.getTypesAtRows(this.panel.typeList.getSelectedIndices());
        if (types.contains(ALL_TYPES)) {
            return Collections.singletonList(ALL_TYPES);
        }
        return types;
    }

    List<String> getTypesAtRows(int[] rows) {
        if (rows.length == 0) {
            return Collections.emptyList();
        }
        ListModel<String> model = this.panel.typeList.getModel();
        if (!(model instanceof TypeListModel)) {
            return Collections.emptyList();
        }
        TypeListModel tModel = (TypeListModel)model;
        return tModel.getTypesAt(rows);
    }

    void showPopupMenu(Component source, Point p, IIssue issue) {
        List<? extends JMenuItem> items = issue.getMenuComponents();
        if (items.isEmpty()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        items.forEach(menu::add);
        menu.show(source, p.x, p.y);
    }

    @Override
    public void showAll() {
        this.show(ALL_FILES_PATTERN, NO_INSTRUCTIONS, -1);
    }

    @Override
    public void showAll(String instructions) {
        this.show(ALL_FILES_PATTERN, instructions, -1);
    }

    @Override
    public void showForFiles(String filePattern) {
        this.show(filePattern, NO_INSTRUCTIONS, -1);
    }

    @Override
    public void showForFiles(String filePattern, String instructions) {
        this.show(filePattern, instructions, -1);
    }

    @Override
    public void showForFiles(String filePattern, int jumpToEntry) {
        this.show(filePattern, NO_INSTRUCTIONS, jumpToEntry);
    }

    private void show(String filePattern, String instructions, int jumpToEntry) {
        this.filePattern = filePattern;
        this.instructions = instructions;
        this.init();
        SwingUtilities.invokeLater(() -> this.refreshData(jumpToEntry, Collections.emptyList()));
    }

    void reset() {
        if (this.loader != null) {
            this.loader.cancel(true);
            this.loader = null;
        }
        this.frame.setTitle(OStrings.getString("ISSUES_WINDOW_TITLE"));
        this.panel.table.setModel(new DefaultTableModel());
        this.panel.typeList.setModel(new DefaultListModel());
        this.panel.outerSplitPane.setBottomComponent(this.panel.messageLabel);
        this.panel.messageLabel.setText(OStrings.getString("ISSUES_LOADING"));
        StaticUIUtils.setHierarchyEnabled(this.panel, false);
        this.panel.closeButton.setEnabled(true);
        this.panel.showAllButtonPanel.setVisible(!this.isShowingAllFiles());
        this.panel.instructionsPanel.setVisible(!this.instructions.equals(NO_INSTRUCTIONS));
        this.panel.instructionsTextArea.setText(this.instructions);
    }

    synchronized void refreshData(int jumpToEntry, List<String> jumpToTypes) {
        this.reset();
        if (!this.frame.isVisible()) {
            this.frame.setVisible(true);
        }
        this.frame.setState(0);
        this.panel.progressBar.setValue(0);
        this.panel.progressBar.setMaximum(Core.getProject().getAllEntries().size());
        this.panel.progressBar.setVisible(true);
        this.panel.progressBar.setEnabled(true);
        this.loader = new IssueLoader(jumpToEntry, jumpToTypes);
        this.loader.execute();
    }

    void updateFilter() {
        int[] selection = this.panel.typeList.getSelectedIndices();
        if (selection.length == 0) {
            return;
        }
        TypeListModel model = (TypeListModel)this.panel.typeList.getModel();
        final List<String> types = model.getTypesAt(selection);
        TableRowSorter sorter = (TableRowSorter)this.panel.table.getRowSorter();
        sorter.setRowFilter(new RowFilter<IssuesTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends IssuesTableModel, ? extends Integer> entry) {
                return types.contains(ALL_TYPES) || types.contains(entry.getStringValue(IssueColumn.TYPE.index));
            }
        });
        int totalItems = this.panel.table.getModel().getRowCount();
        if (types.contains(ALL_TYPES)) {
            this.updateTitle(totalItems);
        } else {
            this.updateTitle((int)model.getCountAt(selection), totalItems);
        }
        this.panel.table.changeSelection(0, 0, false, false);
    }

    void updateTitle(int totalItems) {
        if (this.isShowingAllFiles()) {
            this.frame.setTitle(StringUtil.format(OStrings.getString("ISSUES_WINDOW_TITLE_TEMPLATE"), totalItems));
        } else {
            String filePath = this.filePattern.replace("\\Q", NO_INSTRUCTIONS).replace("\\E", NO_INSTRUCTIONS);
            this.frame.setTitle(StringUtil.format(OStrings.getString("ISSUES_WINDOW_TITLE_FILE_TEMPLATE"), FilenameUtils.getName(filePath), totalItems));
        }
    }

    void updateTitle(int shownItems, int totalItems) {
        if (this.isShowingAllFiles()) {
            this.frame.setTitle(StringUtil.format(OStrings.getString("ISSUES_WINDOW_TITLE_FILTERED_TEMPLATE"), shownItems, totalItems));
        } else {
            String filePath = this.filePattern.replace("\\Q", NO_INSTRUCTIONS).replace("\\E", NO_INSTRUCTIONS);
            this.frame.setTitle(StringUtil.format(OStrings.getString("ISSUES_WINDOW_TITLE_FILE_FILTERED_TEMPLATE"), FilenameUtils.getName(filePath), shownItems, totalItems));
        }
    }

    boolean isShowingAllFiles() {
        return ALL_FILES_PATTERN.equals(this.filePattern);
    }

    Icon getActionMenuIcon(IIssue issue, int modelRow, int col) {
        int viewRow = this.panel.table.getRowSorter().convertRowIndexToView(modelRow);
        if (!issue.hasMenuComponents()) {
            return SETTINGS_ICON_INVISIBLE;
        }
        if (this.panel.table.getSelectedRow() == viewRow) {
            return SETTINGS_ICON_PRESSED;
        }
        if (viewRow == this.mouseoverRow && col == this.mouseoverCol) {
            return SETTINGS_ICON;
        }
        if (viewRow == this.mouseoverRow) {
            return SETTINGS_ICON_INACTIVE;
        }
        return SETTINGS_ICON_INVISIBLE;
    }

    static class TypeListModel
    extends AbstractListModel<String> {
        private final List<Map.Entry<String, Long>> types;

        TypeListModel(List<IIssue> issues) {
            this.types = this.calculateData(issues);
        }

        List<Map.Entry<String, Long>> calculateData(List<IIssue> issues) {
            Map counts = issues.stream().map(IIssue::getTypeName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            ArrayList<Map.Entry<String, Long>> result = new ArrayList<Map.Entry<String, Long>>();
            result.add(new AbstractMap.SimpleImmutableEntry<String, Long>(ALL_TYPES, Long.valueOf(issues.size())));
            counts.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(result::add);
            return result;
        }

        @Override
        public int getSize() {
            return this.types.size();
        }

        @Override
        public String getElementAt(int index) {
            Map.Entry<String, Long> entry = this.types.get(index);
            return StringUtil.format(OStrings.getString("ISSUES_TYPE_SUMMARY_TEMPLATE"), entry.getKey(), entry.getValue());
        }

        List<String> getTypesAt(int[] indicies) {
            return IntStream.of(indicies).mapToObj(this.types::get).map(Map.Entry::getKey).collect(Collectors.toList());
        }

        long getCountAt(int[] indicies) {
            return IntStream.of(indicies).mapToObj(this.types::get).mapToLong(Map.Entry::getValue).sum();
        }

        int[] indiciesOfTypes(List<String> queryTypes) {
            return queryTypes.stream().map(type -> IntStream.range(0, queryTypes.size()).filter(i -> this.types.get(i).getKey().equals(type)).findFirst()).filter(OptionalInt::isPresent).mapToInt(OptionalInt::getAsInt).toArray();
        }
    }

    class IssuesTableModel
    extends AbstractTableModel {
        private final List<IIssue> issues;

        IssuesTableModel(List<IIssue> issues) {
            this.issues = issues;
        }

        @Override
        public int getRowCount() {
            return this.issues.size();
        }

        @Override
        public int getColumnCount() {
            return IssueColumn.values().length;
        }

        @Override
        public String getColumnName(int column) {
            return IssueColumn.get(column).label;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            IIssue iss = this.issues.get(rowIndex);
            switch (IssueColumn.get(columnIndex)) {
                case SEG_NUM: {
                    return iss.getSegmentNumber();
                }
                case ICON: {
                    return iss.getIcon();
                }
                case TYPE: {
                    return iss.getTypeName();
                }
                case DESCRIPTION: {
                    return iss.getDescription();
                }
                case ACTION_BUTTON: {
                    return IssuesPanelController.this.getActionMenuIcon(iss, rowIndex, columnIndex);
                }
            }
            throw new IllegalArgumentException("Unknown column requested: " + columnIndex);
        }

        public IIssue getIssueAt(int rowIndex) {
            return this.issues.get(rowIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return IssueColumn.get(columnIndex).clazz;
        }
    }

    static enum IssueColumn {
        SEG_NUM(0, OStrings.getString("ISSUES_TABLE_COLUMN_ENTRY_NUM"), Integer.class),
        ICON(1, "", Icon.class),
        TYPE(2, OStrings.getString("ISSUES_TABLE_COLUMN_TYPE"), String.class),
        DESCRIPTION(3, OStrings.getString("ISSUES_TABLE_COLUMN_DESCRIPTION"), String.class),
        ACTION_BUTTON(4, "", Icon.class);

        private final int index;
        private final String label;
        private final Class<?> clazz;

        private IssueColumn(int index, String label, Class<?> clazz) {
            this.index = index;
            this.label = label;
            this.clazz = clazz;
        }

        static IssueColumn get(int index) {
            return IssueColumn.values()[index];
        }
    }

    class IssueLoader
    extends SwingWorker<List<IIssue>, Integer> {
        private final int jumpToEntry;
        private final List<String> jumpToTypes;
        private int progress = 0;

        IssueLoader(int jumpToEntry, List<String> jumpToTypes) {
            this.jumpToEntry = jumpToEntry;
            this.jumpToTypes = Objects.requireNonNull(jumpToTypes);
        }

        @Override
        protected List<IIssue> doInBackground() throws Exception {
            long start = System.currentTimeMillis();
            Stream<IIssue> tagErrors = Core.getTagValidation().listInvalidTags(IssuesPanelController.this.filePattern).stream().map(TagIssue::new);
            List<IIssueProvider> providers = IssueProviders.getEnabledProviders();
            Stream providerIssues = Core.getProject().getAllEntries().parallelStream().filter(StreamUtil.patternFilter(IssuesPanelController.this.filePattern, ste -> ste.getKey().file)).filter(this::progressFilter).map(this::makeEntryPair).filter(Objects::nonNull).flatMap(e -> providers.stream().flatMap(provider -> provider.getIssues((SourceTextEntry)e.getKey(), (TMXEntry)e.getValue()).stream()));
            List<IIssue> result = Stream.concat(tagErrors, providerIssues).collect(Collectors.toList());
            Logger.getLogger(IssuesPanelController.class.getName()).log(Level.FINEST, () -> String.format("Issue detection took %.3f s", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f)));
            return result;
        }

        Map.Entry<SourceTextEntry, TMXEntry> makeEntryPair(SourceTextEntry ste) {
            IProject project = Core.getProject();
            if (!project.isProjectLoaded()) {
                return null;
            }
            TMXEntry tmxEntry = project.getTranslationInfo(ste);
            if (!tmxEntry.isTranslated()) {
                return null;
            }
            if (IssuesPanelController.this.isShowingAllFiles() && DataUtils.isDuplicate(ste, tmxEntry)) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry<SourceTextEntry, TMXEntry>(ste, tmxEntry);
        }

        boolean progressFilter(SourceTextEntry ste) {
            boolean continu;
            boolean bl = continu = !this.isCancelled();
            if (continu) {
                this.publish(ste.entryNum());
            }
            return continu;
        }

        @Override
        protected void process(List<Integer> chunks) {
            if (!chunks.isEmpty()) {
                IssuesPanelController.this.panel.progressBar.setValue(this.progress += chunks.size());
            }
        }

        @Override
        protected void done() {
            int[] indicies;
            if (this.isCancelled()) {
                return;
            }
            List allIssues = Collections.emptyList();
            try {
                allIssues = (List)this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.log(e);
                JOptionPane.showMessageDialog(IssuesPanelController.this.parent, e.getMessage(), OStrings.getString("ERROR_TITLE"), 0);
                IssuesPanelController.this.frame.setVisible(false);
                return;
            }
            catch (CancellationException e) {
                return;
            }
            if (allIssues.isEmpty()) {
                IssuesPanelController.this.panel.messageLabel.setText(OStrings.getString("ISSUES_NO_ISSUES_FOUND"));
            }
            IssuesPanelController.this.panel.progressBar.setVisible(false);
            StaticUIUtils.setHierarchyEnabled(IssuesPanelController.this.panel, true);
            IssuesPanelController.this.panel.typeList.setModel(new TypeListModel(allIssues));
            IssuesPanelController.this.panel.table.setModel(new IssuesTableModel(allIssues));
            TableRowSorter sorter = (TableRowSorter)IssuesPanelController.this.panel.table.getRowSorter();
            sorter.setSortable(IssueColumn.ICON.index, false);
            sorter.toggleSortOrder(IssueColumn.SEG_NUM.index);
            IssuesPanelController.this.panel.typeList.setSelectedIndex(0);
            boolean typeListIsVisible = IssuesPanelController.this.panel.typeList.getModel().getSize() > 2;
            IssuesPanelController.this.panel.typeListScrollPanel.setVisible(typeListIsVisible);
            if (typeListIsVisible) {
                SwingUtilities.invokeLater(() -> {
                    int width = IssuesPanelController.this.panel.typeListScrollPanel.getPreferredSize().width + 10;
                    IssuesPanelController.this.panel.innerSplitPane.setDividerLocation(width);
                });
            }
            IssuesPanelController.this.colSizer.reset();
            IssuesPanelController.this.colSizer.adjustTableColumns();
            if (!this.jumpToTypes.isEmpty() && (indicies = ((TypeListModel)IssuesPanelController.this.panel.typeList.getModel()).indiciesOfTypes(this.jumpToTypes)).length > 0) {
                IssuesPanelController.this.panel.typeList.setSelectedIndices(indicies);
            }
            if (this.jumpToEntry >= 0) {
                IntStream.range(0, IssuesPanelController.this.panel.table.getRowCount()).filter(row -> (Integer)IssuesPanelController.this.panel.table.getValueAt(row, IssueColumn.SEG_NUM.index) >= this.jumpToEntry).findFirst().ifPresent(jump -> IssuesPanelController.this.panel.table.changeSelection(jump, 0, false, false));
            }
            IssuesPanelController.this.panel.table.requestFocusInWindow();
        }
    }
}

