/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.LastSegmentManager;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.gui.dialogs.ConflictDialogController;
import org.omegat.gui.editor.AlphabeticalMarkers;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.DocumentFilter3;
import org.omegat.gui.editor.EditorPopups;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorTextArea3;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.SegmentExportImport;
import org.omegat.gui.editor.SegmentHistory;
import org.omegat.gui.editor.ViewLabel;
import org.omegat.gui.editor.autocompleter.IAutoCompleter;
import org.omegat.gui.editor.mark.CalcMarkersThread;
import org.omegat.gui.editor.mark.ComesFromMTMarker;
import org.omegat.gui.editor.mark.EntryMarks;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.main.DockablePanel;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.help.Help;
import org.omegat.util.Java8Compat;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIDesignManager;
import org.omegat.util.gui.UIThreadsUtil;

public class EditorController
implements IEditor {
    private static final Logger LOGGER = Logger.getLogger(EditorController.class.getName());
    private static final double PAGE_LOAD_THRESHOLD = 0.25;
    private DockablePanel pane;
    private JScrollPane scrollPane;
    private String title;
    private boolean dockableSelected;
    protected final EditorTextArea3 editor;
    protected MarkerController markerController;
    private String introPaneTitle;
    private String emptyProjectPaneTitle;
    private JTextPane introPane;
    private JTextPane emptyProjectPane;
    protected final MainWindow mw;
    protected SegmentBuilder[] m_docSegList;
    protected int firstLoaded;
    protected int lastLoaded;
    protected Timer lazyLoadTimer = new Timer(200, null);
    protected int displayedFileIndex;
    protected int previousDisplayedFileIndex;
    protected int displayedEntryIndex;
    private SegmentHistory history = new SegmentHistory();
    protected final EditorSettings settings;
    protected Font font;
    Document3.ORIENTATION currentOrientation;
    protected boolean sourceLangIsRTL;
    protected boolean targetLangIsRTL;
    volatile IEditorFilter entriesFilter;
    private Component entriesFilterControlComponent;
    private SegmentExportImport segmentExportImport;
    private IProject.AllTranslations previousTranslations;
    private final AdjustmentListener scrollListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (EditorController.this.m_docSegList == null) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (EditorController.this.lazyLoadTimer.isRunning()) {
                return;
            }
            double pos = (double)e.getValue() / (double)EditorController.this.scrollPane.getVerticalScrollBar().getMaximum();
            if (pos <= 0.25 || pos >= 0.75) {
                EditorController.this.lazyLoadTimer.restart();
            }
        }
    };
    private final DragTargetOverlay.IDropInfo dropInfo = new DragTargetOverlay.IDropInfo(){

        @Override
        public DataFlavor getDataFlavor() {
            return DataFlavor.javaFileListFlavor;
        }

        @Override
        public int getDnDAction() {
            return 1;
        }

        @Override
        public boolean handleDroppedObject(Object dropped) {
            List files = (List)dropped;
            File firstFile = (File)files.get(0);
            if (firstFile.getName().equals("omegat.project")) {
                firstFile = firstFile.getParentFile();
            }
            if (StaticUtils.isProjectDir(firstFile)) {
                return this.handleDroppedProject(firstFile);
            }
            return this.handleDroppedFiles(files);
        }

        private boolean handleDroppedProject(final File projDir) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectUICommands.projectOpen(projDir, true);
                }
            });
            return true;
        }

        private boolean handleDroppedFiles(final List<?> files) {
            if (!Core.getProject().isProjectLoaded()) {
                return false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectUICommands.projectImportFiles(Core.getProject().getProjectProperties().getSourceRoot(), files.toArray(new File[files.size()]));
                }
            });
            return true;
        }

        @Override
        public Component getComponentToOverlay() {
            return EditorController.this.scrollPane;
        }

        @Override
        public String getOverlayMessage() {
            return Core.getProject().isProjectLoaded() ? OStrings.getString("DND_ADD_SOURCE_FILE") : OStrings.getString("DND_OPEN_PROJECT");
        }

        @Override
        public boolean canAcceptDrop() {
            return true;
        }
    };

    public EditorController(MainWindow mainWindow) {
        this.mw = mainWindow;
        this.segmentExportImport = new SegmentExportImport(this);
        this.editor = new EditorTextArea3(this);
        DragTargetOverlay.apply(this.editor, this.dropInfo);
        this.setFont(mainWindow.getApplicationFont());
        this.markerController = new MarkerController(this);
        this.createUI();
        this.settings = new EditorSettings(this);
        CoreEvents.registerProjectChangeListener(eventType -> {
            SHOW_TYPE showType;
            switch (eventType) {
                case CREATE: 
                case LOAD: {
                    this.history.clear();
                    this.removeFilter();
                    showType = !Core.getProject().getAllEntries().isEmpty() ? SHOW_TYPE.FIRST_ENTRY : SHOW_TYPE.EMPTY_PROJECT;
                    this.markerController.removeAll();
                    this.setInitialOrientation();
                    break;
                }
                case CLOSE: {
                    this.m_docSegList = null;
                    this.history.clear();
                    this.removeFilter();
                    this.markerController.removeAll();
                    showType = SHOW_TYPE.INTRO;
                    this.deactivateWithoutCommit();
                    break;
                }
                default: {
                    showType = SHOW_TYPE.NO_CHANGE;
                }
            }
            if (showType != SHOW_TYPE.NO_CHANGE) {
                this.updateState(showType);
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
                EditorController.this.updateState(SHOW_TYPE.NO_CHANGE);
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
            }
        });
        this.createAdditionalPanes();
        SwingUtilities.invokeLater(() -> {
            this.updateState(SHOW_TYPE.INTRO);
            this.pane.requestFocus();
        });
        CoreEvents.registerFontChangedEventListener(newFont -> {
            this.setFont(newFont);
            ViewLabel.fontHeight = 0;
            this.editor.revalidate();
            this.editor.repaint();
            this.emptyProjectPane.setFont(this.font);
        });
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOGGER.log(Level.SEVERE, "Uncatched exception in thread [" + t.getName() + "]", e));
        EditorPopups.init(this);
        this.lazyLoadTimer.setRepeats(false);
        this.lazyLoadTimer.addActionListener(e -> {
            JScrollBar bar = this.scrollPane.getVerticalScrollBar();
            double scrollPercent = (double)bar.getValue() / (double)bar.getMaximum();
            int unitsPerSeg = (bar.getMaximum() - bar.getMinimum()) / (this.lastLoaded - this.firstLoaded + 1);
            if (this.firstLoaded > 0 && scrollPercent <= 0.25) {
                int docSize = this.editor.getDocument().getLength();
                int visiblePos = Java8Compat.viewToModel(this.editor, this.scrollPane.getViewport().getViewPosition());
                double loadCount = (0.25 * (double)bar.getMaximum() - (double)bar.getValue()) / ((double)unitsPerSeg * 0.75);
                this.loadUp((int)Math.ceil(loadCount));
                int sizeDelta = this.editor.getDocument().getLength() - docSize;
                try {
                    this.scrollPane.getViewport().setViewPosition(Java8Compat.modelToView(this.editor, visiblePos + sizeDelta).getLocation());
                }
                catch (BadLocationException ex) {
                    Log.log(ex);
                }
            } else if (this.lastLoaded < this.m_docSegList.length - 1 && scrollPercent >= 0.75) {
                double loadCount = ((double)bar.getValue() / 0.75 - (double)bar.getMaximum()) / (double)unitsPerSeg;
                this.loadDown((int)Math.ceil(loadCount));
            }
        });
    }

    private void createUI() {
        Border viewportBorder;
        this.pane = new DockablePanel("EDITOR", " ", false);
        this.pane.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.pane.setMinimumSize(new Dimension(100, 100));
        this.pane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EditorController.this.updateTitle();
            }
        });
        this.scrollPane = new JScrollPane(this.editor);
        Border panelBorder = UIManager.getBorder("OmegaTDockablePanel.border");
        if (panelBorder != null) {
            this.scrollPane.setBorder(panelBorder);
        }
        if ((viewportBorder = UIManager.getBorder("OmegaTDockablePanelViewport.border")) != null) {
            this.scrollPane.setViewportBorder(viewportBorder);
        }
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this.scrollListener);
        this.pane.setLayout(new BorderLayout());
        this.pane.add((Component)this.scrollPane, "Center");
        this.mw.addDockable(this.pane);
        DockingDesktop desktop = UIDesignManager.getDesktop(this.pane);
        if (desktop != null) {
            desktop.addDockableSelectionListener(e -> {
                this.dockableSelected = this.pane == e.getSelectedDockable();
            });
        }
    }

    private synchronized void loadDown(int count) {
        if (this.lastLoaded < 0 || this.lastLoaded >= this.m_docSegList.length - 1) {
            return;
        }
        int loadFrom = this.lastLoaded + 1;
        int loadTo = Math.min(this.m_docSegList.length - 1, loadFrom + count - 1);
        for (int i = loadFrom; i <= loadTo; ++i) {
            SegmentBuilder builder = this.m_docSegList[i];
            this.insertStartParagraphMark(this.editor.getOmDocument(), builder);
            builder.createSegmentElement(false, Core.getProject().getTranslationInfo(builder.ste));
            builder.addSegmentSeparator();
        }
        this.lastLoaded = loadTo;
        SegmentBuilder[] loaded = Arrays.copyOfRange(this.m_docSegList, loadFrom, loadTo + 1);
        this.markerController.process(loaded);
    }

    private synchronized void loadUp(int count) {
        if (this.firstLoaded <= 0 || this.firstLoaded >= this.m_docSegList.length) {
            return;
        }
        int loadFrom = this.firstLoaded - 1;
        int loadTo = Math.max(0, loadFrom - count + 1);
        for (int i = loadFrom; i >= loadTo; --i) {
            SegmentBuilder builder = this.m_docSegList[i];
            builder.prependSegmentSeparator();
            builder.prependSegmentElement(false, Core.getProject().getTranslationInfo(builder.ste));
            this.markerController.reprocessImmediately(builder);
        }
        this.firstLoaded = loadTo;
    }

    private void updateState(SHOW_TYPE showType) {
        UIThreadsUtil.mustBeSwingThread();
        JEditorPane data = null;
        String updatedTitle = null;
        switch (showType) {
            case INTRO: {
                data = this.introPane;
                updatedTitle = this.introPaneTitle;
                break;
            }
            case EMPTY_PROJECT: {
                data = this.emptyProjectPane;
                updatedTitle = this.emptyProjectPaneTitle;
                break;
            }
            case FIRST_ENTRY: {
                this.displayedFileIndex = 0;
                this.displayedEntryIndex = 0;
                updatedTitle = StringUtil.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                data = this.editor;
                SwingUtilities.invokeLater(() -> {
                    this.loadDocument();
                    this.gotoEntry(LastSegmentManager.getLastSegmentNumber());
                    this.updateTitleCurrentFile();
                });
                break;
            }
            case NO_CHANGE: {
                updatedTitle = StringUtil.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                data = this.editor;
            }
        }
        this.updateTitle(updatedTitle);
        if (this.scrollPane.getViewport().getView() != data) {
            if (UIManager.getBoolean("OmegaTDockablePanel.isProportionalMargins")) {
                int size = data.getFont().getSize() / 2;
                data.setBorder(new EmptyBorder(size, size, size, size));
            }
            this.scrollPane.setViewportView(data);
        }
    }

    private void updateTitle() {
        this.pane.setName(StaticUIUtils.truncateToFit(this.title, this.pane, 70));
        this.pane.setToolTipText(this.title);
    }

    private void updateTitleCurrentFile() {
        this.updateTitle(StringUtil.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile()));
    }

    private void updateTitle(String title) {
        this.title = title;
        this.updateTitle();
    }

    private void setFont(Font font) {
        this.font = font;
        this.editor.setFont(font);
    }

    private void setInitialOrientation() {
        String sourceLang = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
        String targetLang = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
        this.sourceLangIsRTL = Language.isRTL(sourceLang);
        this.targetLangIsRTL = Language.isRTL(targetLang);
        this.currentOrientation = this.sourceLangIsRTL != this.targetLangIsRTL || this.sourceLangIsRTL != Language.localeIsRTL() ? Document3.ORIENTATION.DIFFER : (this.sourceLangIsRTL ? Document3.ORIENTATION.ALL_RTL : Document3.ORIENTATION.ALL_LTR);
        this.applyOrientationToEditor();
    }

    private void applyOrientationToEditor() {
        ComponentOrientation targetOrientation = null;
        switch (this.currentOrientation) {
            case ALL_LTR: {
                targetOrientation = ComponentOrientation.LEFT_TO_RIGHT;
                break;
            }
            case ALL_RTL: {
                targetOrientation = ComponentOrientation.RIGHT_TO_LEFT;
                break;
            }
            case DIFFER: {
                targetOrientation = this.targetLangIsRTL ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
            }
        }
        this.editor.setComponentOrientation(targetOrientation);
    }

    protected void toggleOrientation() {
        this.commitAndDeactivate();
        Document3.ORIENTATION newOrientation = this.currentOrientation;
        switch (this.currentOrientation) {
            case ALL_LTR: {
                newOrientation = Document3.ORIENTATION.ALL_RTL;
                break;
            }
            case ALL_RTL: {
                if (this.sourceLangIsRTL != this.targetLangIsRTL || this.sourceLangIsRTL != Language.localeIsRTL()) {
                    newOrientation = Document3.ORIENTATION.DIFFER;
                    break;
                }
                newOrientation = Document3.ORIENTATION.ALL_LTR;
                break;
            }
            case DIFFER: {
                newOrientation = Document3.ORIENTATION.ALL_LTR;
            }
        }
        LOGGER.info("Switch document orientation from " + (Object)((Object)this.currentOrientation) + " to " + (Object)((Object)newOrientation));
        this.currentOrientation = newOrientation;
        this.applyOrientationToEditor();
        this.loadDocument();
        this.activateEntry();
    }

    public Document3.ORIENTATION getOrientation() {
        return this.currentOrientation;
    }

    @Override
    public void requestFocus() {
        this.scrollPane.getViewport().getView().requestFocusInWindow();
    }

    @Override
    public SourceTextEntry getCurrentEntry() {
        SegmentBuilder builder = this.getCurrentSegmentBuilder();
        return builder == null ? null : builder.ste;
    }

    public SegmentBuilder getCurrentSegmentBuilder() {
        if (this.m_docSegList == null || this.displayedEntryIndex < 0 || this.m_docSegList.length <= this.displayedEntryIndex) {
            return null;
        }
        return this.m_docSegList[this.displayedEntryIndex];
    }

    @Override
    public String getCurrentFile() {
        IProject proj = Core.getProject();
        if (proj == null || !proj.isProjectLoaded()) {
            return null;
        }
        if (proj.getProjectFiles().isEmpty()) {
            return null;
        }
        if (this.displayedFileIndex < proj.getProjectFiles().size()) {
            return proj.getProjectFiles().get((int)this.displayedFileIndex).filePath;
        }
        return null;
    }

    @Override
    public String getCurrentTargetFile() {
        String currentSource = this.getCurrentFile();
        if (currentSource == null) {
            return null;
        }
        return Core.getProject().getTargetPathForSourceFile(currentSource);
    }

    protected void loadDocument() {
        SegmentBuilder sb;
        IProject.FileInfo file;
        UIThreadsUtil.mustBeSwingThread();
        try {
            file = Core.getProject().getProjectFiles().get(this.displayedFileIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            file = Core.getProject().getProjectFiles().get(0);
        }
        if (this.m_docSegList != null) {
            this.markerController.removeAll();
        }
        boolean hasRTL = this.sourceLangIsRTL || this.targetLangIsRTL || Language.localeIsRTL() || this.currentOrientation != Document3.ORIENTATION.ALL_LTR;
        Map<Language, ProjectTMX> otherLanguageTMs = Core.getProject().getOtherTargetLanguageTMs();
        for (Map.Entry<Language, ProjectTMX> entry : otherLanguageTMs.entrySet()) {
            hasRTL = hasRTL || Language.isRTL(entry.getKey().getLanguageCode().toLowerCase(Locale.ENGLISH));
        }
        Document3 doc = new Document3(this);
        ArrayList<SegmentBuilder> tmpSegList = new ArrayList<SegmentBuilder>(file.entries.size());
        for (SourceTextEntry ste : file.entries) {
            if (this.entriesFilter != null && !this.entriesFilter.allowed(ste)) continue;
            sb = new SegmentBuilder(this, doc, this.settings, ste, ste.entryNum(), hasRTL);
            tmpSegList.add(sb);
        }
        this.m_docSegList = tmpSegList.toArray(new SegmentBuilder[tmpSegList.size()]);
        this.displayedEntryIndex = Math.max(0, Math.min(this.m_docSegList.length - 1, this.displayedEntryIndex));
        int initialSegCount = Preferences.getPreferenceDefault("editor_initial_segment_load_count", 2000);
        this.firstLoaded = Math.max(0, this.displayedEntryIndex - initialSegCount / 2);
        this.lastLoaded = Math.min(file.entries.size() - 1, this.firstLoaded + initialSegCount - 1);
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            if (i < this.firstLoaded || i > this.lastLoaded) continue;
            sb = this.m_docSegList[i];
            this.insertStartParagraphMark(doc, sb);
            sb.createSegmentElement(false, Core.getProject().getTranslationInfo(sb.ste));
            sb.addSegmentSeparator();
        }
        doc.setDocumentFilter(new DocumentFilter3());
        Locale targetLocale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        this.editor.setLocale(targetLocale);
        this.editor.setDocument(doc);
        doc.addUndoableEditListener(this.editor.undoManager);
        this.editor.undoManager.reset();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }
        });
        this.markerController.process(this.m_docSegList);
        this.editor.repaint();
    }

    private void insertStartParagraphMark(Document3 doc, SegmentBuilder sb) {
        if (Preferences.isPreferenceDefault("mark_para_delimitation", false) && sb.getSourceTextEntry().isParagraphStart()) {
            try {
                doc.insertString(doc.getLength(), Preferences.getPreferenceDefault("mark_para_delimitation_text", "\u2014 \u00b6 \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014") + "\n\n", this.settings.getParagraphStartAttributeSet());
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public void activateEntry() {
        this.activateEntry(IEditor.CaretPosition.startOfEntry());
    }

    public void activateEntry(IEditor.CaretPosition pos) {
        UIThreadsUtil.mustBeSwingThread();
        SourceTextEntry ste = this.getCurrentEntry();
        if (ste == null) {
            return;
        }
        if (this.scrollPane.getViewport().getView() != this.editor) {
            return;
        }
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        SegmentBuilder builder = this.m_docSegList[this.displayedEntryIndex];
        if (!builder.hasBeenCreated()) {
            this.loadDocument();
            this.activateEntry(pos);
            return;
        }
        this.previousTranslations = Core.getProject().getAllTranslations(ste);
        TMXEntry currentTranslation = this.previousTranslations.getCurrentTranslation();
        builder.createSegmentElement(true, currentTranslation);
        Core.getNotes().setNoteText(currentTranslation.note);
        this.markerController.reprocessImmediately(builder);
        this.editor.undoManager.reset();
        this.history.insertNew(builder.segmentNumberInProject);
        this.setMenuEnabled();
        this.showStat();
        this.showLengthMessage();
        if (Preferences.isPreference("wf_exportCurrentSegment")) {
            this.segmentExportImport.exportCurrentSegment(ste);
        }
        int te = this.editor.getOmDocument().getTranslationEnd();
        int ts = this.editor.getOmDocument().getTranslationStart();
        if (pos.position != null) {
            pos.position = Math.max(0, pos.position);
            pos.position = Math.min(pos.position, te - ts);
        }
        if (pos.selectionStart != null && pos.selectionEnd != null) {
            pos.selectionStart = Math.max(0, pos.selectionStart);
            pos.selectionEnd = Math.min(pos.selectionEnd, te - ts);
            if (pos.selectionStart >= pos.selectionEnd) {
                pos.selectionStart = null;
                pos.selectionEnd = null;
            }
        }
        this.scrollForDisplayNearestSegments(pos);
        if (this.previousDisplayedFileIndex != this.displayedFileIndex) {
            this.previousDisplayedFileIndex = this.displayedFileIndex;
            CoreEvents.fireEntryNewFile(Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).filePath);
        }
        this.editor.autoCompleter.setVisible(false);
        this.editor.repaint();
        CoreEvents.fireEntryActivated(ste);
    }

    private void setMenuEnabled() {
        this.mw.menu.gotoHistoryBackMenuItem.setEnabled(this.history.hasPrev());
        this.mw.menu.gotoHistoryForwardMenuItem.setEnabled(this.history.hasNext());
        this.mw.menu.editMultipleDefault.setEnabled(!this.m_docSegList[this.displayedEntryIndex].isDefaultTranslation());
        this.mw.menu.editMultipleAlternate.setEnabled(this.m_docSegList[this.displayedEntryIndex].isDefaultTranslation());
    }

    void showLengthMessage() {
        Document3 doc = this.editor.getOmDocument();
        String trans = doc.extractTranslation();
        if (trans != null) {
            SourceTextEntry ste = this.m_docSegList[this.displayedEntryIndex].ste;
            String lMsg = " " + ste.getSrcText().length() + "/" + trans.length() + " ";
            this.mw.showLengthMessage(lMsg);
        }
    }

    void onTextChanged() {
        Document3 doc = this.editor.getOmDocument();
        if (doc.trustedChangesInProgress || doc.textBeingComposed) {
            return;
        }
        if (doc.isEditMode()) {
            this.m_docSegList[this.displayedEntryIndex].onActiveEntryChanged();
            SwingUtilities.invokeLater(() -> {
                this.markerController.reprocessImmediately(this.m_docSegList[this.displayedEntryIndex]);
                this.editor.autoCompleter.textDidChange();
            });
        }
    }

    private void scrollForDisplayNearestSegments(IEditor.CaretPosition pos) {
        SwingUtilities.invokeLater(() -> {
            Rectangle rect = this.getSegmentBounds(this.displayedEntryIndex);
            if (rect != null) {
                int viewportHeight = this.scrollPane.getViewport().getHeight();
                rect.y -= (viewportHeight - rect.height) / 2;
                rect.height = viewportHeight;
                this.editor.scrollRectToVisible(rect);
            }
            this.setCaretPosition(pos);
        });
    }

    private Rectangle getSegmentBounds(int index) {
        if (index < 0 || index >= this.m_docSegList.length) {
            return null;
        }
        Rectangle result = null;
        try {
            SegmentBuilder sb = this.m_docSegList[index];
            if (sb.hasBeenCreated()) {
                Rectangle start = Java8Compat.modelToView(this.editor, sb.getStartPosition());
                Rectangle end = Java8Compat.modelToView(this.editor, sb.getEndPosition());
                if (start != null && end != null) {
                    result = start.union(end);
                }
            }
        }
        catch (BadLocationException ex) {
            Log.log(ex);
        }
        return result;
    }

    public void showStat() {
        IProject project = Core.getProject();
        IProject.FileInfo fi = project.getProjectFiles().get(this.displayedFileIndex);
        int translatedInFile = 0;
        int translatedUniqueInFile = 0;
        int uniqueInFile = 0;
        for (SourceTextEntry ste : fi.entries) {
            boolean isUnique;
            boolean bl = isUnique = ste.getDuplicate() != SourceTextEntry.DUPLICATE.NEXT;
            if (isUnique) {
                ++uniqueInFile;
            }
            if (!project.getTranslationInfo(ste).isTranslated()) continue;
            ++translatedInFile;
            if (!isUnique) continue;
            ++translatedUniqueInFile;
        }
        StatisticsInfo stat = project.getStatistics();
        MainWindowUI.StatusBarMode progressMode = Preferences.getPreferenceEnumDefault("sb_progress_mode", MainWindowUI.StatusBarMode.DEFAULT);
        if (progressMode == MainWindowUI.StatusBarMode.DEFAULT) {
            StringBuilder pMsg = new StringBuilder(1024).append(" ");
            pMsg.append(translatedInFile).append("/").append(fi.entries.size()).append(" (").append(stat.numberOfTranslatedSegments).append("/").append(stat.numberOfUniqueSegments).append(", ").append(stat.numberOfSegmentsTotal).append(") ");
            this.mw.showProgressMessage(pMsg.toString());
        } else {
            NumberFormat nfPer = NumberFormat.getPercentInstance();
            nfPer.setRoundingMode(RoundingMode.DOWN);
            nfPer.setMaximumFractionDigits(1);
            String message = StringUtil.format(OStrings.getString("MW_PROGRESS_DEFAULT_PERCENTAGE"), translatedUniqueInFile == 0 ? "0%" : nfPer.format((double)translatedUniqueInFile / (double)uniqueInFile), uniqueInFile - translatedUniqueInFile, stat.numberOfTranslatedSegments == 0 ? "0%" : nfPer.format((double)stat.numberOfTranslatedSegments / (double)stat.numberOfUniqueSegments), stat.numberOfUniqueSegments - stat.numberOfTranslatedSegments, stat.numberOfSegmentsTotal);
            this.mw.showProgressMessage(message);
        }
    }

    protected boolean goToSegmentAtLocation(int location) {
        int segmentAtLocation = this.getSegmentIndexAtLocation(location);
        if (segmentAtLocation < 0) {
            return false;
        }
        if (this.displayedEntryIndex != segmentAtLocation) {
            this.commitAndDeactivate();
            this.displayedEntryIndex = segmentAtLocation;
            this.activateEntry();
            return true;
        }
        return false;
    }

    protected int getSegmentIndexAtLocation(int location) {
        if (this.m_docSegList == null) {
            return -1;
        }
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            SegmentBuilder builder = this.m_docSegList[i];
            if (!builder.hasBeenCreated() || location < builder.getStartPosition() || location > builder.getEndPosition()) continue;
            return i;
        }
        return this.m_docSegList.length - 1;
    }

    public void refreshEntries(Set<Integer> entryNumbers) {
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            if (!entryNumbers.contains(this.m_docSegList[i].ste.entryNum())) continue;
            this.m_docSegList[i].createSegmentElement(false, Core.getProject().getTranslationInfo(this.m_docSegList[i].ste));
        }
    }

    @Override
    public void commitAndDeactivate() {
        UIThreadsUtil.mustBeSwingThread();
        Document3 doc = this.editor.getOmDocument();
        if (doc == null) {
            return;
        }
        if (!doc.isEditMode()) {
            return;
        }
        String transWithControlChars = doc.extractTranslation();
        String newTrans = EditorUtils.removeDirectionCharsAroundTags(transWithControlChars, this.getCurrentEntry());
        if (newTrans != null) {
            this.commitAndDeactivate(null, newTrans);
        }
    }

    void commitAndDeactivate(ForceTranslation forceTranslation, String newTrans) {
        boolean noteChanged;
        UIThreadsUtil.mustBeSwingThread();
        Document3 doc = this.editor.getOmDocument();
        doc.stopEditMode();
        SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
        final SourceTextEntry entry = sb.ste;
        TMXEntry oldTE = Core.getProject().getTranslationInfo(entry);
        PrepareTMXEntry newen = new PrepareTMXEntry();
        newen.source = sb.ste.getSrcText();
        newen.note = Core.getNotes().getNoteText();
        if (forceTranslation != null) {
            switch (forceTranslation) {
                case UNTRANSLATED: {
                    newen.translation = null;
                    break;
                }
                case EMPTY: {
                    newen.translation = "";
                    break;
                }
                case EQUALS_TO_SOURCE: {
                    newen.translation = newen.source;
                }
            }
        } else {
            newen.translation = newTrans.isEmpty() ? (oldTE.isTranslated() && "".equals(oldTE.translation) ? "" : null) : (newTrans.equals(newen.source) ? (Preferences.isPreference("wf_allowTransEqualToSrc") ? newTrans : (oldTE.source.equals(oldTE.translation) ? oldTE.translation : null)) : newTrans);
        }
        boolean defaultTranslation = sb.isDefaultTranslation();
        boolean isNewDefaultTrans = defaultTranslation && !oldTE.defaultTranslation;
        boolean isNewAltTrans = !defaultTranslation && oldTE.defaultTranslation;
        boolean translationChanged = !Objects.equals(oldTE.translation, newen.translation);
        boolean bl = noteChanged = !StringUtil.nvl(oldTE.note, "").equals(StringUtil.nvl(newen.note, ""));
        if (!isNewAltTrans && !translationChanged && noteChanged) {
            Core.getProject().setNote(entry, oldTE, newen.note);
        } else if (isNewDefaultTrans || translationChanged || noteChanged) {
            while (true) {
                try {
                    Core.getProject().setTranslation(entry, newen, defaultTranslation, null, this.previousTranslations);
                }
                catch (IProject.OptimisticLockingFail ex) {
                    String result = new ConflictDialogController().show(ex.getOldTranslationText(), ex.getNewTranslationText(), newen.translation);
                    if (result != newen.translation) break;
                    this.previousTranslations = ex.getPrevious();
                    continue;
                }
                break;
            }
        }
        this.m_docSegList[this.displayedEntryIndex].createSegmentElement(false, Core.getProject().getTranslationInfo(this.m_docSegList[this.displayedEntryIndex].ste), defaultTranslation);
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            SegmentBuilder builder;
            if (i == this.displayedEntryIndex || !(builder = this.m_docSegList[i]).hasBeenCreated() || !builder.ste.getSrcText().equals(entry.getSrcText())) continue;
            builder.createSegmentElement(false, Core.getProject().getTranslationInfo(builder.ste), !defaultTranslation);
            this.markerController.reprocessImmediately(builder);
        }
        Core.getNotes().clear();
        this.markerController.reprocessImmediately(this.m_docSegList[this.displayedEntryIndex]);
        this.editor.undoManager.reset();
        if (entry != null && Preferences.isPreference("tagValidateOnLeave")) {
            final String file = this.getCurrentFile();
            new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() throws Exception {
                    return Core.getTagValidation().checkInvalidTags(entry);
                }

                @Override
                protected void done() {
                    try {
                        if (!((Boolean)this.get()).booleanValue()) {
                            Core.getIssues().showForFiles(Pattern.quote(file), entry.entryNum());
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOGGER.log(Level.SEVERE, "Exception when validating tags on leave", e);
                    }
                }
            }.execute();
        }
        if (Core.getProject().isTeamSyncPrepared()) {
            try {
                Core.executeExclusively(false, Core.getProject()::teamSync);
            }
            catch (InterruptedException file) {
            }
            catch (TimeoutException file) {
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void deactivateWithoutCommit() {
        UIThreadsUtil.mustBeSwingThread();
        this.segmentExportImport.exportCurrentSegment(null);
        Document3 doc = this.editor.getOmDocument();
        if (doc == null) {
            return;
        }
        doc.stopEditMode();
    }

    @Override
    public void commitAndLeave() {
        if (Core.getProject().getAllEntries().isEmpty()) {
            return;
        }
        int currentPosition = this.getCurrentPositionInEntryTranslation();
        this.commitAndDeactivate();
        this.activateEntry(new IEditor.CaretPosition(currentPosition));
    }

    private void iterateToEntry(boolean forward, Predicate<SourceTextEntry> shouldStop) {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        if (files.isEmpty()) {
            return;
        }
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        boolean looped = false;
        do {
            if (forward) {
                ++this.displayedEntryIndex;
                if (this.displayedEntryIndex < this.m_docSegList.length) continue;
                ++this.displayedFileIndex;
                this.displayedEntryIndex = 0;
                if (this.displayedFileIndex >= files.size()) {
                    this.displayedFileIndex = 0;
                    looped = true;
                }
                this.loadDocument();
                continue;
            }
            --this.displayedEntryIndex;
            if (this.displayedEntryIndex >= 0) continue;
            --this.displayedFileIndex;
            if (this.displayedFileIndex < 0) {
                this.displayedFileIndex = files.size() - 1;
                looped = true;
            }
            this.loadDocument();
            this.displayedEntryIndex = this.m_docSegList.length - 1;
        } while (!((ste = this.getCurrentEntry()) != null && shouldStop.test(ste)) && (!looped || this.displayedFileIndex != startFileIndex || !(forward && this.displayedEntryIndex >= startEntryIndex || !forward && this.displayedEntryIndex <= startEntryIndex) && this.m_docSegList.length != 0));
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    private void anyEntry(boolean forwards) {
        this.iterateToEntry(forwards, ste -> true);
    }

    @Override
    public void nextEntry() {
        this.anyEntry(true);
    }

    @Override
    public void prevEntry() {
        this.anyEntry(false);
    }

    private void nextTranslatedEntry(boolean findTranslated) {
        this.iterateToEntry(true, ste -> {
            boolean isTranslated = Core.getProject().getTranslationInfo((SourceTextEntry)ste).isTranslated();
            if (findTranslated && isTranslated) {
                return true;
            }
            if (!findTranslated && !isTranslated) {
                return true;
            }
            if (Preferences.isPreference("wf_stopOnAlternativeTranslation")) {
                HasMultipleTranslations checker = new HasMultipleTranslations(ste.getSrcText());
                Core.getProject().iterateByMultipleTranslations(checker);
                if (checker.found) {
                    return true;
                }
            }
            return false;
        });
    }

    @Override
    public void nextUntranslatedEntry() {
        this.nextTranslatedEntry(false);
    }

    @Override
    public void nextTranslatedEntry() {
        this.nextTranslatedEntry(true);
    }

    private void entryWithNote(boolean forward) {
        this.iterateToEntry(forward, ste -> Core.getProject().getTranslationInfo((SourceTextEntry)ste).hasNote());
    }

    @Override
    public void nextEntryWithNote() {
        this.entryWithNote(true);
    }

    @Override
    public void prevEntryWithNote() {
        this.entryWithNote(false);
    }

    @Override
    public void nextUniqueEntry() {
        this.iterateToEntry(true, ste -> ste.getDuplicate() != SourceTextEntry.DUPLICATE.NEXT);
    }

    @Override
    public int getCurrentEntryNumber() {
        SourceTextEntry e = this.getCurrentEntry();
        return e != null ? e.entryNum() : 0;
    }

    @Override
    public void gotoFile(int fileIndex) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (this.m_docSegList == null) {
            return;
        }
        if (fileIndex < 0 || fileIndex >= Core.getProject().getProjectFiles().size()) {
            throw new IndexOutOfBoundsException();
        }
        this.commitAndDeactivate();
        this.displayedFileIndex = fileIndex;
        this.displayedEntryIndex = 0;
        this.loadDocument();
        this.activateEntry();
    }

    @Override
    public void gotoEntry(int entryNum) {
        this.gotoEntry(entryNum, IEditor.CaretPosition.startOfEntry());
    }

    @Override
    public void gotoEntry(int entryNum, IEditor.CaretPosition pos) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (this.m_docSegList == null) {
            return;
        }
        Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        if (entryNum == 0) {
            this.displayedFileIndex = 0;
            this.displayedEntryIndex = 0;
            this.loadDocument();
        } else {
            IProject dataEngine = Core.getProject();
            block0: for (int i = 0; i < dataEngine.getProjectFiles().size(); ++i) {
                IProject.FileInfo fi = dataEngine.getProjectFiles().get(i);
                SourceTextEntry firstEntry = fi.entries.get(0);
                SourceTextEntry lastEntry = fi.entries.get(fi.entries.size() - 1);
                if (firstEntry.entryNum() > entryNum || lastEntry.entryNum() < entryNum) continue;
                if (i != this.displayedFileIndex) {
                    this.displayedFileIndex = i;
                    this.loadDocument();
                }
                for (int j = 0; j < this.m_docSegList.length; ++j) {
                    if (this.m_docSegList[j].segmentNumberInProject < entryNum) continue;
                    this.displayedEntryIndex = j;
                    break block0;
                }
                break;
            }
        }
        this.activateEntry(pos);
        this.editor.setCursor(oldCursor);
        this.updateTitleCurrentFile();
    }

    @Override
    public void gotoEntry(String srcString, EntryKey key) {
        UIThreadsUtil.mustBeSwingThread();
        List<SourceTextEntry> entries = Core.getProject().getAllEntries();
        for (int i = 0; i < entries.size(); ++i) {
            TMXEntry trans;
            SourceTextEntry ste = entries.get(i);
            if (srcString != null && !ste.getSrcText().equals(srcString) || (key != null ? !ste.getKey().equals(key) : !(trans = Core.getProject().getTranslationInfo(entries.get(i))).isTranslated() || !trans.defaultTranslation)) continue;
            this.gotoEntry(i + 1);
            break;
        }
    }

    @Override
    public void gotoEntryAfterFix(int entryNum, String fixedSource) {
        UIThreadsUtil.mustBeSwingThread();
        if (entryNum == this.getCurrentEntryNumber() || this.getCurrentEntry().getSrcText().equals(fixedSource)) {
            this.deactivateWithoutCommit();
        }
        this.gotoFile(this.displayedFileIndex);
        this.gotoEntry(entryNum);
    }

    @Override
    public void refreshViewAfterFix(List<Integer> fixedEntries) {
        boolean doCommit = fixedEntries != null && fixedEntries.contains(this.getCurrentEntryNumber());
        this.refreshView(doCommit);
    }

    @Override
    public void refreshView(boolean doCommit) {
        UIThreadsUtil.mustBeSwingThread();
        if (!doCommit) {
            this.deactivateWithoutCommit();
        }
        int currentEntry = this.getCurrentEntryNumber();
        int caretPosition = this.getCurrentPositionInEntryTranslation();
        this.gotoFile(this.displayedFileIndex);
        this.gotoEntry(currentEntry, new IEditor.CaretPosition(caretPosition));
    }

    @Override
    public void changeCase(IEditor.CHANGE_CASE_TO toWhat) {
        UIThreadsUtil.mustBeSwingThread();
        int start = this.editor.getSelectionStart();
        int end = this.editor.getSelectionEnd();
        int caretPosition = this.editor.getCaretPosition();
        int translationStart = this.editor.getOmDocument().getTranslationStart();
        int translationEnd = this.editor.getOmDocument().getTranslationEnd();
        if (end < translationStart || start > translationEnd) {
            return;
        }
        if (start < translationStart && end <= translationEnd) {
            start = translationStart;
        }
        if (end > translationEnd && start >= translationStart) {
            end = translationEnd;
        }
        try {
            if (start == end) {
                start = EditorUtils.getWordStart(this.editor, start);
                end = EditorUtils.getWordEnd(this.editor, end);
                if (start < translationStart && end <= translationEnd) {
                    start = translationStart;
                }
                if (end > translationEnd && start >= translationStart) {
                    end = translationEnd;
                }
            }
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(end);
            String selectionText = this.editor.getText(start, end - start);
            String result = EditorUtils.doChangeCase(selectionText, toWhat);
            if (selectionText.equals(result)) {
                return;
            }
            this.editor.replaceSelection(result);
            this.editor.setCaretPosition(caretPosition);
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(end);
        }
        catch (BadLocationException ble) {
            Log.log("bad location exception when changing case");
            Log.log(ble);
        }
    }

    @Override
    public void replaceEditText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        SegmentBuilder builder = this.m_docSegList[this.displayedEntryIndex];
        if (builder.hasRTL && this.targetLangIsRTL) {
            text = EditorUtils.addBidiAroundTags(EditorUtils.removeDirectionCharsAroundTags(text, builder.ste), builder.ste);
        }
        int start = this.editor.getOmDocument().getTranslationStart();
        int end = this.editor.getOmDocument().getTranslationEnd();
        CalcMarkersThread thread = this.markerController.markerThreads[this.markerController.getMarkerIndex(ComesFromMTMarker.class.getName())];
        ((ComesFromMTMarker)thread.marker).setMark(null, null);
        this.editor.select(start, end);
        this.editor.replaceSelection(text);
    }

    public void replacePartOfText(String text, int start, int end) {
        UIThreadsUtil.mustBeSwingThread();
        CalcMarkersThread thread = this.markerController.markerThreads[this.markerController.getMarkerIndex(ComesFromMTMarker.class.getName())];
        ((ComesFromMTMarker)thread.marker).setMark(null, null);
        int off = this.editor.getOmDocument().getTranslationStart();
        this.editor.select(start + off, end + off);
        this.editor.replaceSelection(text);
    }

    @Override
    public void replaceEditTextAndMark(String text) {
        this.replaceEditText(text);
        this.markAsComesFromMT(text);
    }

    private void markAsComesFromMT(String text) {
        SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
        CalcMarkersThread thread = this.markerController.markerThreads[this.markerController.getMarkerIndex(ComesFromMTMarker.class.getName())];
        ((ComesFromMTMarker)thread.marker).setMark(sb.getSourceTextEntry(), text);
        this.markerController.reprocessImmediately(sb);
    }

    @Override
    public String getCurrentTranslation() {
        UIThreadsUtil.mustBeSwingThread();
        return this.editor.getOmDocument().extractTranslation();
    }

    public int getCurrentPositionInEntryTranslation() {
        UIThreadsUtil.mustBeSwingThread();
        return this.getPositionInEntryTranslation(this.editor.getCaretPosition());
    }

    public int getPositionInEntryTranslation(int pos) {
        UIThreadsUtil.mustBeSwingThread();
        if (!this.editor.getOmDocument().isEditMode()) {
            return -1;
        }
        int beg = this.editor.getOmDocument().getTranslationStart();
        int end = this.editor.getOmDocument().getTranslationEnd();
        if (pos < beg) {
            pos = beg;
        }
        if (pos > end) {
            pos = end;
        }
        return pos - beg;
    }

    public void setCaretPosition(IEditor.CaretPosition pos) {
        UIThreadsUtil.mustBeSwingThread();
        if (!this.editor.getOmDocument().isEditMode()) {
            return;
        }
        int off = this.editor.getOmDocument().getTranslationStart();
        try {
            if (pos.position != null) {
                this.editor.setCaretPosition(off + pos.position);
            } else if (pos.selectionStart != null && pos.selectionEnd != null) {
                this.editor.select(off + pos.selectionStart, off + pos.selectionEnd);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.editor.checkAndFixCaret();
    }

    @Override
    public void insertText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.checkAndFixCaret();
        SegmentBuilder builder = this.m_docSegList[this.displayedEntryIndex];
        if (builder.hasRTL && this.targetLangIsRTL) {
            text = EditorUtils.addBidiAroundTags(EditorUtils.removeDirectionCharsAroundTags(text, builder.ste), builder.ste);
        }
        this.editor.replaceSelection(text);
    }

    @Override
    public void insertTextAndMark(String text) {
        this.insertText(text);
        this.markAsComesFromMT(text);
    }

    @Override
    public void insertTag(String tag) {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.checkAndFixCaret();
        SegmentBuilder builder = this.m_docSegList[this.displayedEntryIndex];
        if (builder.hasRTL && this.targetLangIsRTL) {
            String t = "\u200f\u200e" + tag + "\u200e" + "\u200f";
            this.editor.replaceSelection(t);
        } else {
            this.editor.replaceSelection(tag);
        }
    }

    @Override
    public void gotoHistoryBack() {
        UIThreadsUtil.mustBeSwingThread();
        int prevValue = this.history.back();
        if (prevValue != -1) {
            this.gotoEntry(prevValue);
        }
    }

    @Override
    public void gotoHistoryForward() {
        UIThreadsUtil.mustBeSwingThread();
        int nextValue = this.history.forward();
        if (nextValue != -1) {
            this.gotoEntry(nextValue);
        }
    }

    @Override
    public EditorSettings getSettings() {
        return this.settings;
    }

    @Override
    public void undo() {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.undoManager.undo();
    }

    @Override
    public void redo() {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.undoManager.redo();
    }

    @Override
    public String getSelectedText() {
        UIThreadsUtil.mustBeSwingThread();
        return this.dockableSelected ? this.editor.getSelectedText() : null;
    }

    private void createAdditionalPanes() {
        this.introPaneTitle = OStrings.getString("DOCKING_INSTANT_START_TITLE");
        try {
            String language = this.detectInstantStartLanguage();
            this.introPane = new JTextPane();
            this.introPane.setComponentOrientation(Language.isRTL(language) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
            this.introPane.setEditable(false);
            DragTargetOverlay.apply(this.introPane, this.dropInfo);
            URI uri = Help.getHelpFileURI(language, "instantStartGuideNoTOC.html");
            if (uri != null) {
                this.introPane.setPage(uri.toURL());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.emptyProjectPaneTitle = OStrings.getString("TF_INTRO_EMPTYPROJECT_FILENAME");
        this.emptyProjectPane = new JTextPane();
        this.emptyProjectPane.setEditable(false);
        this.emptyProjectPane.setText(OStrings.getString("TF_INTRO_EMPTYPROJECT"));
        this.emptyProjectPane.setFont(this.mw.getApplicationFont());
        DragTargetOverlay.apply(this.emptyProjectPane, this.dropInfo);
    }

    private String detectInstantStartLanguage() {
        String language = Locale.getDefault().getLanguage().toLowerCase(Locale.ENGLISH);
        String country = Locale.getDefault().getCountry().toUpperCase(Locale.ENGLISH);
        if (Help.getHelpFileURI(language + "_" + country, "instantStartGuideNoTOC.html") != null) {
            return language + "_" + country;
        }
        if (Help.getHelpFileURI(language, "instantStartGuideNoTOC.html") != null) {
            return language;
        }
        return "en";
    }

    @Override
    public void remarkOneMarker(String markerClassName) {
        int mi = this.markerController.getMarkerIndex(markerClassName);
        this.markerController.reprocess(this.m_docSegList, mi);
    }

    @Override
    public void markActiveEntrySource(SourceTextEntry requiredActiveEntry, List<Mark> marks, String markerClassName) {
        UIThreadsUtil.mustBeSwingThread();
        for (Mark m : marks) {
            if (m.entryPart == Mark.ENTRY_PART.SOURCE) continue;
            throw new RuntimeException("Mark must be for source only");
        }
        SourceTextEntry realActive = this.m_docSegList[this.displayedEntryIndex].ste;
        if (realActive != requiredActiveEntry) {
            return;
        }
        int mi = this.markerController.getMarkerIndex(markerClassName);
        EntryMarks ev = new EntryMarks(this.m_docSegList[this.displayedEntryIndex], this.m_docSegList[this.displayedEntryIndex].getDisplayVersion(), mi);
        ev.result = marks;
        this.markerController.queueMarksOutput(ev);
    }

    @Override
    public void registerPopupMenuConstructors(int priority, IPopupMenuConstructor constructor) {
        this.editor.registerPopupMenuConstructors(priority, constructor);
    }

    @Override
    public IEditorFilter getFilter() {
        return this.entriesFilter;
    }

    @Override
    public void setFilter(IEditorFilter filter) {
        UIThreadsUtil.mustBeSwingThread();
        if (this.entriesFilterControlComponent != null) {
            this.pane.remove(this.entriesFilterControlComponent);
        }
        this.entriesFilter = filter;
        this.entriesFilterControlComponent = filter.getControlComponent();
        this.pane.add(this.entriesFilterControlComponent, "North");
        this.pane.revalidate();
        SourceTextEntry curEntry = this.getCurrentEntry();
        Document3 doc = this.editor.getOmDocument();
        IProject project = Core.getProject();
        if (doc != null && project != null && project.getProjectFiles() != null && curEntry != null) {
            int curEntryNum = curEntry.entryNum();
            this.loadDocument();
            if (this.entriesFilter == null || this.entriesFilter.allowed(curEntry)) {
                this.gotoEntry(curEntry.entryNum());
            } else {
                for (int j = 0; j < this.m_docSegList.length; ++j) {
                    if (this.m_docSegList[j].segmentNumberInProject < curEntryNum) continue;
                    this.displayedEntryIndex = j - 1;
                    break;
                }
                this.nextEntry();
            }
        }
    }

    @Override
    public void removeFilter() {
        List<IProject.FileInfo> files;
        UIThreadsUtil.mustBeSwingThread();
        if (this.entriesFilter == null && this.entriesFilterControlComponent == null) {
            return;
        }
        this.entriesFilter = null;
        if (this.entriesFilterControlComponent != null) {
            this.pane.remove(this.entriesFilterControlComponent);
            this.pane.revalidate();
            this.entriesFilterControlComponent = null;
        }
        int curEntryNum = this.getCurrentEntryNumber();
        Document3 doc = this.editor.getOmDocument();
        IProject project = Core.getProject();
        if (doc != null && project != null && project.isProjectLoaded() && (files = project.getProjectFiles()) != null && !files.isEmpty()) {
            this.loadDocument();
            this.gotoEntry(curEntryNum);
        }
    }

    @Override
    public void setAlternateTranslationForCurrentEntry(boolean alternate) {
        SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
        if (!alternate) {
            sb.setDefaultTranslation(true);
        } else {
            sb.setDefaultTranslation(false);
        }
        this.setMenuEnabled();
    }

    @Override
    public void registerUntranslated() {
        UIThreadsUtil.mustBeSwingThread();
        this.commitAndDeactivate(ForceTranslation.UNTRANSLATED, null);
        this.activateEntry();
    }

    @Override
    public void registerEmptyTranslation() {
        UIThreadsUtil.mustBeSwingThread();
        this.commitAndDeactivate(ForceTranslation.EMPTY, null);
        this.activateEntry();
    }

    @Override
    public void registerIdenticalTranslation() {
        UIThreadsUtil.mustBeSwingThread();
        this.commitAndDeactivate(ForceTranslation.EQUALS_TO_SOURCE, null);
        this.activateEntry();
    }

    @Override
    public void windowDeactivated() {
        this.editor.autoCompleter.setVisible(false);
    }

    public AlphabeticalMarkers getAlphabeticalMarkers() {
        return new AlphabeticalMarkers(this.scrollPane){
            static final int UPPER_GAP = 5;

            @Override
            protected Map<Integer, Point> getViewableSegmentLocations() {
                LinkedHashMap<Integer, Point> map = new LinkedHashMap<Integer, Point>();
                if (EditorController.this.m_docSegList == null) {
                    return map;
                }
                JViewport viewport = EditorController.this.scrollPane.getViewport();
                int x = EditorController.this.sourceLangIsRTL ? EditorController.this.editor.getWidth() - EditorController.this.editor.getInsets().right : EditorController.this.editor.getInsets().left;
                Rectangle viewRect = viewport.getViewRect();
                viewRect.setBounds(viewRect.x, viewRect.y - 5, viewRect.width, viewRect.height + 5);
                Point viewPosition = viewport.getViewPosition();
                for (SegmentBuilder sb : EditorController.this.m_docSegList) {
                    if (!sb.hasBeenCreated()) continue;
                    try {
                        Point location = Java8Compat.modelToView(EditorController.this.editor, sb.getStartPosition()).getLocation();
                        if (!viewRect.contains(location)) continue;
                        int segmentNo = sb.segmentNumberInProject;
                        location.translate(0, -viewPosition.y);
                        location.x = x;
                        map.put(segmentNo, location);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                return map;
            }
        };
    }

    @Override
    public IAutoCompleter getAutoCompleter() {
        return this.editor.autoCompleter;
    }

    protected static class HasMultipleTranslations
    implements IProject.MultipleTranslationsIterator {
        final String sourceEntryText;
        boolean found;

        public HasMultipleTranslations(String sourceEntryText) {
            this.sourceEntryText = sourceEntryText;
        }

        @Override
        public void iterate(EntryKey source, TMXEntry trans) {
            if (this.found) {
                return;
            }
            if (this.sourceEntryText.equals(source.sourceText)) {
                this.found = true;
            }
        }
    }

    private static enum SHOW_TYPE {
        INTRO,
        EMPTY_PROJECT,
        FIRST_ENTRY,
        NO_CHANGE;

    }

    static enum ForceTranslation {
        UNTRANSLATED,
        EMPTY,
        EQUALS_TO_SOURCE;

    }
}

