/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.madlonkay.supertmxmerge.DiffController;
import org.madlonkay.supertmxmerge.gui.DiffCell;
import org.madlonkay.supertmxmerge.gui.LocStringConverter;
import org.madlonkay.supertmxmerge.gui.MapToTextConverter;
import org.madlonkay.supertmxmerge.gui.MenuFrame;
import org.madlonkay.supertmxmerge.gui.ReasonablySizedPanel;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class DiffWindow
extends JPanel {
    private final Window window;
    private JPanel buttonPanel;
    private LocStringConverter changeCountConverter;
    private JLabel changeCountLabel;
    private DiffController controller;
    private ReasonablySizedPanel diffsPanel;
    private JLabel file1Label;
    private JLabel file1TextUnits;
    private JLabel file2Label;
    private JLabel file2TextUnits;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private MapToTextConverter mapToTextConverter;
    private JButton saveAsButton;
    private JMenuItem saveAsMenuItem;
    private LocStringConverter unitCountConverter;
    private BindingGroup bindingGroup;

    public static JFrame newAsFrame(DiffController controller) {
        MenuFrame frame = new MenuFrame(LocString.get("STM_DIFF_WINDOW_TITLE"));
        frame.setContentPane(new DiffWindow(frame, controller));
        return frame;
    }

    public DiffWindow(Window window, DiffController controller) {
        this.window = window;
        this.controller = controller;
        this.initComponents();
        if (window instanceof MenuFrame) {
            this.saveAsButton.setVisible(false);
            ((MenuFrame)window).addFileMenuItem(this.saveAsMenuItem);
        }
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.initContent();
    }

    private void initContent() {
        SwingWorker<List<DiffCell>, DiffCell> worker = new SwingWorker<List<DiffCell>, DiffCell>(){

            @Override
            protected List<DiffCell> doInBackground() throws Exception {
                ArrayList<DiffCell> result = new ArrayList<DiffCell>();
                List<DiffController.DiffInfo> diffs = DiffWindow.this.controller.getDiffInfos();
                int n = 1;
                for (DiffController.DiffInfo info : diffs) {
                    DiffCell cell = new DiffCell(n, info);
                    result.add(cell);
                    this.publish(cell);
                    this.setProgress(100 * n / diffs.size());
                    ++n;
                }
                return result;
            }

            @Override
            protected void process(List<DiffCell> chunks) {
                for (DiffCell cell : chunks) {
                    DiffWindow.this.diffsPanel.add(cell);
                }
                DiffWindow.this.diffsPanel.revalidate();
            }

            @Override
            protected void done() {
                DiffWindow.this.buttonPanel.setVisible(false);
            }
        };
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    DiffWindow.this.jProgressBar1.setValue((Integer)evt.getNewValue());
                }
            }
        });
        worker.execute();
        this.file1Label.setText(this.controller.getTmx1().getName());
        this.file2Label.setText(this.controller.getTmx2().getName());
        this.file1TextUnits.setText(this.unitCountConverter.convert(this.controller.getTmx1().getSize()));
        this.file2TextUnits.setText(this.unitCountConverter.convert(this.controller.getTmx2().getSize()));
        this.file1Label.setToolTipText(MapToTextConverter.mapToHtml(this.controller.getTmx1().getMetadata()));
        this.file2Label.setToolTipText(MapToTextConverter.mapToHtml(this.controller.getTmx2().getMetadata()));
        this.saveAsButton.setEnabled(this.controller.canSaveDiff());
        GuiUtil.sizeForScreen(this);
    }

    private DiffController getController() {
        return this.controller;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.controller = this.getController();
        this.unitCountConverter = new LocStringConverter("STM_NUMBER_OF_UNITS", "STM_NUMBER_OF_UNITS_SINGULAR");
        this.changeCountConverter = new LocStringConverter("STM_NUMBER_OF_CHANGES", "STM_NUMBER_OF_CHANGES_SINGULAR");
        this.mapToTextConverter = new MapToTextConverter();
        this.saveAsMenuItem = new JMenuItem();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.file1Label = new JLabel();
        this.file2Label = new JLabel();
        this.file1TextUnits = new JLabel();
        this.file2TextUnits = new JLabel();
        this.jPanel4 = new JPanel();
        this.changeCountLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.diffsPanel = new ReasonablySizedPanel();
        this.buttonPanel = new JPanel();
        this.saveAsButton = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.saveAsMenuItem.setMnemonic('a');
        this.saveAsMenuItem.setText(LocString.get("STM_FILE_MENU_SAVEAS"));
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffWindow.this.saveAsActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 3));
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanel2.setLayout(new GridLayout(2, 2, 10, 0));
        this.file1Label.setFont(this.file1Label.getFont().deriveFont(this.file1Label.getFont().getStyle() | 1, this.file1Label.getFont().getSize() + 2));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${tmx1.name}"), (Object)this.file1Label, (Property)BeanProperty.create((String)"text"), (String)"file1Name");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.controller, (Property)ELProperty.create((String)"${tmx1.metadata}"), (Object)this.file1Label, (Property)BeanProperty.create((String)"toolTipText"), (String)"file1Metadata");
        binding.setSourceNullValue((Object)LocString.get("STM_TMX_DETAILS_UNAVAILABLE"));
        binding.setConverter((Converter)this.mapToTextConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.file1Label);
        this.file2Label.setFont(this.file2Label.getFont().deriveFont(this.file2Label.getFont().getStyle() | 1, this.file2Label.getFont().getSize() + 2));
        this.file2Label.setHorizontalAlignment(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${tmx2.name}"), (Object)this.file2Label, (Property)BeanProperty.create((String)"text"), (String)"file2Name");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${tmx2.metadata}"), (Object)this.file2Label, (Property)BeanProperty.create((String)"toolTipText"), (String)"tmx2Metadata");
        binding.setSourceNullValue((Object)LocString.get("STM_TMX_DETAILS_UNAVAILABLE"));
        binding.setConverter((Converter)this.mapToTextConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.file2Label);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${tmx1.size}"), (Object)this.file1TextUnits, (Property)BeanProperty.create((String)"text"), (String)"file1UnitCount");
        binding.setConverter((Converter)this.unitCountConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.file1TextUnits);
        this.file2TextUnits.setHorizontalAlignment(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${tmx2.size}"), (Object)this.file2TextUnits, (Property)BeanProperty.create((String)"text"), (String)"file2UnitCount");
        binding.setConverter((Converter)this.unitCountConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.file2TextUnits);
        this.jPanel3.add(this.jPanel2);
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${changeCount}"), (Object)this.changeCountLabel, (Property)BeanProperty.create((String)"text"), (String)"changeCount");
        binding.setConverter((Converter)this.changeCountConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel4.add(this.changeCountLabel);
        this.jPanel3.add(this.jPanel4);
        this.add((Component)this.jPanel3, "North");
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.diffsPanel.setLayout(new BoxLayout(this.diffsPanel, 3));
        this.jScrollPane1.setViewportView(this.diffsPanel);
        this.add((Component)this.jScrollPane1, "Center");
        this.buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.controlShadow), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.buttonPanel.setLayout(new BorderLayout());
        this.saveAsButton.setText(LocString.get("STM_SAVE_AS_BUTTON"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_ONCE, (Object)this.controller, (Property)ELProperty.create((String)"${canSaveDiff}"), (Object)this.saveAsButton, (Property)BeanProperty.create((String)"enabled"), (String)"canSaveDiff");
        this.bindingGroup.addBinding((Binding)binding);
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffWindow.this.saveAsActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.saveAsButton, "East");
        this.buttonPanel.add((Component)this.jProgressBar1, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.bindingGroup.bind();
    }

    private void saveAsActionPerformed(ActionEvent evt) {
        this.getController().saveAs();
    }
}

