/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.languagetool.rules.patterns.EquivalenceTypeLocator;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.Unifier;

public class UnifierConfiguration {
    private final Map<EquivalenceTypeLocator, PatternToken> equivalenceTypes = new ConcurrentHashMap<EquivalenceTypeLocator, PatternToken>();
    private final Map<String, List<String>> equivalenceFeatures = new ConcurrentHashMap<String, List<String>>();

    public final void setEquivalence(String feature, String type, PatternToken elem) {
        List<Object> lTypes;
        EquivalenceTypeLocator typeKey = new EquivalenceTypeLocator(feature, type);
        if (this.equivalenceTypes.containsKey(typeKey)) {
            return;
        }
        this.equivalenceTypes.put(typeKey, elem);
        if (this.equivalenceFeatures.containsKey(feature)) {
            lTypes = this.equivalenceFeatures.get(feature);
        } else {
            lTypes = new CopyOnWriteArrayList();
            this.equivalenceFeatures.put(feature, lTypes);
        }
        lTypes.add(type);
    }

    public Map<EquivalenceTypeLocator, PatternToken> getEquivalenceTypes() {
        return Collections.unmodifiableMap(this.equivalenceTypes);
    }

    public Map<String, List<String>> getEquivalenceFeatures() {
        return Collections.unmodifiableMap(this.equivalenceFeatures);
    }

    public Unifier createUnifier() {
        return new Unifier(this.getEquivalenceTypes(), this.getEquivalenceFeatures());
    }
}

