/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessInputStream
extends InputStream {
    private RandomAccessFile in;
    private int mark = 0;

    public RandomAccessInputStream(RandomAccessFile inFile) {
        this.in = inFile;
    }

    public RandomAccessInputStream(String file, String mode) throws IOException {
        this(new RandomAccessFile(file, mode));
    }

    @Override
    public final int available() throws IOException {
        return this.getLength() - this.getPos();
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
    }

    public final int getLength() throws IOException {
        return (int)this.in.length();
    }

    public final int getPos() throws IOException {
        return (int)this.in.getFilePointer();
    }

    @Override
    public final synchronized void mark(int markpos) {
        try {
            this.mark = this.getPos();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final synchronized int read() throws IOException {
        return this.in.read();
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        return this.in.read(buf, off, len);
    }

    public final void readFully(byte[] buf) throws IOException {
        this.in.readFully(buf);
    }

    @Override
    public final synchronized void reset() throws IOException {
        this.in.seek(this.mark);
    }

    public final void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    @Override
    public final long skip(long size) throws IOException {
        return this.in.skipBytes((int)size);
    }
}

