/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.io.fs.index.FSFnv1aOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class CountingOutputStream
extends FilterOutputStream {
    private long myPosition;
    private FSFnv1aOutputStream myFnv1ChecksumOutputStream;

    public CountingOutputStream(OutputStream stream, long offset) {
        super(stream);
        this.myPosition = offset >= 0L ? offset : 0L;
        this.myFnv1ChecksumOutputStream = new FSFnv1aOutputStream(SVNFileUtil.DUMMY_OUT);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.myFnv1ChecksumOutputStream.write(b, off, len);
        this.out.write(b, off, len);
        this.myPosition += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.myFnv1ChecksumOutputStream.write(b);
        this.out.write(b);
        ++this.myPosition;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.myFnv1ChecksumOutputStream.write(b);
        this.out.write(b);
        this.myPosition += (long)b.length;
    }

    public void resetChecksum() {
        this.myFnv1ChecksumOutputStream.resetChecksum();
    }

    public int finalizeChecksum() {
        return this.myFnv1ChecksumOutputStream.finalizeChecksum();
    }

    public long getPosition() {
        return this.myPosition;
    }
}

