/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import org.omegat.gui.editor.Document3;

public class ViewLabel
extends LabelView {
    protected static int fontHeight;
    boolean isResetBreakSpots = false;

    public ViewLabel(Element el) {
        super(el);
    }

    @Override
    public void paint(Graphics g, Shape a) {
        super.paint(g, a);
        if (!(this.getElement().getDocument() instanceof Document3)) {
            return;
        }
        if (fontHeight == 0) {
            FontMetrics fm = g.getFontMetrics();
            fontHeight = fm.getHeight();
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (fontHeight > 0 && axis == 1) {
            return fontHeight;
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    public float getMinimumSpan(int axis) {
        switch (axis) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return super.getMinimumSpan(axis);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public View breakView(int axis, int p0, float pos, float len) {
        if (axis == 0) {
            this.resetBreakSpots();
        }
        return super.breakView(axis, p0, pos, len);
    }

    public void resetBreakSpots() {
        this.isResetBreakSpots = true;
        this.removeUpdate(null, null, null);
        this.isResetBreakSpots = false;
    }

    @Override
    public void preferenceChanged(View child, boolean width, boolean height) {
        if (!this.isResetBreakSpots) {
            super.preferenceChanged(child, width, height);
        }
    }
}

