/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fa;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatRule;

public class PersianWordRepeatRule
extends WordRepeatRule {
    public PersianWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"\u0627\u06cc\u0646 \u06a9\u0627\u0631 <marker>\u0628\u0631\u0627\u06cc \u0628\u0631\u0627\u06cc</marker> \u062a\u0648 \u0628\u0648\u062f."), Example.fixed((String)"\u0627\u06cc\u0646 \u06a9\u0627\u0631 <marker>\u0628\u0631\u0627\u06cc</marker> \u062a\u0648 \u0628\u0648\u062f."));
    }

    public String getId() {
        return "PERSIAN_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (this.wordRepetitionOf("\u0644\u06cc", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("\u0633\u06cc", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("\u0644\u06a9", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("\u0631\u06cc\u0632", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("\u062c\u0632", tokens, position)) {
            return true;
        }
        return this.wordRepetitionOf("\u06a9\u0644", tokens, position);
    }

    private boolean wordRepetitionOf(String word, AnalyzedTokenReadings[] tokens, int position) {
        return position > 0 && tokens[position - 1].getToken().equals(word) && tokens[position].getToken().equals(word);
    }
}

