/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Color;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public final class Styles {
    private static final Logger LOGGER = Logger.getLogger(EditorColor.class.getName());

    private Styles() {
    }

    public static AttributeSet createAttributeSet(Color foregroundColor, Color backgroundColor, Boolean bold, Boolean italic) {
        SimpleAttributeSet r = new SimpleAttributeSet();
        if (foregroundColor != null) {
            StyleConstants.setForeground(r, foregroundColor);
        }
        if (backgroundColor != null) {
            StyleConstants.setBackground(r, backgroundColor);
        }
        if (bold != null) {
            StyleConstants.setBold(r, bold);
        }
        if (italic != null) {
            StyleConstants.setItalic(r, italic);
        }
        return r;
    }

    public static AttributeSet createAttributeSet(Color foregroundColor, Color backgroundColor, Boolean bold, Boolean italic, Boolean strikethrough, Boolean underline) {
        MutableAttributeSet r = (MutableAttributeSet)Styles.createAttributeSet(foregroundColor, backgroundColor, bold, italic);
        if (strikethrough != null) {
            StyleConstants.setStrikeThrough(r, strikethrough);
        }
        if (underline != null) {
            StyleConstants.setUnderline(r, underline);
        }
        return r;
    }

    public static enum EditorColor {
        COLOR_BACKGROUND(UIManager.getColor("TextPane.background")),
        COLOR_FOREGROUND(UIManager.getColor("TextPane.foreground")),
        COLOR_ACTIVE_SOURCE("#c0ffc0"),
        COLOR_ACTIVE_SOURCE_FG((Color)null),
        COLOR_ACTIVE_TARGET((Color)null),
        COLOR_ACTIVE_TARGET_FG((Color)null),
        COLOR_SEGMENT_MARKER_FG((Color)null),
        COLOR_SEGMENT_MARKER_BG((Color)null),
        COLOR_SOURCE("#c0ffc0"),
        COLOR_SOURCE_FG((Color)null),
        COLOR_NOTED("#c0ffff"),
        COLOR_NOTED_FG((Color)null),
        COLOR_UNTRANSLATED("#c0c0ff"),
        COLOR_UNTRANSLATED_FG((Color)null),
        COLOR_TRANSLATED("#ffff99"),
        COLOR_TRANSLATED_FG((Color)null),
        COLOR_NON_UNIQUE("#808080"),
        COLOR_NON_UNIQUE_BG((Color)null),
        COLOR_MOD_INFO((Color)null),
        COLOR_MOD_INFO_FG((Color)null),
        COLOR_PLACEHOLDER("#969696"),
        COLOR_REMOVETEXT_TARGET("#ff0000"),
        COLOR_NBSP("#c8c8c8"),
        COLOR_WHITESPACE("#808080"),
        COLOR_BIDIMARKERS("#c80000"),
        COLOR_PARAGRAPH_START("#aeaeae"),
        COLOR_MARK_COMES_FROM_TM("#fa8072"),
        COLOR_MARK_COMES_FROM_TM_XICE("#af76df"),
        COLOR_MARK_COMES_FROM_TM_X100PC("#ff9408"),
        COLOR_MARK_COMES_FROM_TM_XAUTO("#ffd596"),
        COLOR_MARK_COMES_FROM_TM_XENFORCED("#ffccff"),
        COLOR_REPLACE("#0000ff"),
        COLOR_LANGUAGE_TOOLS("#0000ff"),
        COLOR_TRANSTIPS("#0000ff"),
        COLOR_SPELLCHECK("#ff0000"),
        COLOR_TERMINOLOGY(Color.ORANGE),
        COLOR_MATCHES_CHANGED("#0000ff"),
        COLOR_MATCHES_UNCHANGED("#00ff00"),
        COLOR_MATCHES_DEL_ACTIVE((Color)null),
        COLOR_MATCHES_DEL_INACTIVE((Color)null),
        COLOR_MATCHES_INS_ACTIVE("#0000ff"),
        COLOR_MATCHES_INS_INACTIVE("#808080"),
        COLOR_HYPERLINK("#0000ff"),
        COLOR_NOTIFICATION_MIN("#fff2d4"),
        COLOR_NOTIFICATION_MAX("#ff9900"),
        COLOR_ALIGNER_ACCEPTED("#15bb45"),
        COLOR_ALIGNER_NEEDSREVIEW(Color.RED),
        COLOR_ALIGNER_HIGHLIGHT(Color.YELLOW),
        COLOR_ALIGNER_TABLE_ROW_HIGHLIGHT("#c8c8c8");

        private static final String DEFAULT_COLOR = "__DEFAULT__";
        private Color color;
        private Color defaultColor;

        private EditorColor(Color defaultColor) {
            this.color = defaultColor;
            this.defaultColor = defaultColor;
            String prefColor = Preferences.getPreferenceDefault(this.name(), null);
            if (prefColor != null && !DEFAULT_COLOR.equals(prefColor)) {
                try {
                    this.color = Color.decode(prefColor);
                }
                catch (NumberFormatException e) {
                    Log.logDebug(LOGGER, "Cannot set custom color for {0}, default to {1}.", this.name(), prefColor);
                }
            }
        }

        private EditorColor(String defaultColor) {
            this(Color.decode(defaultColor));
        }

        public String toHex() {
            return String.format("#%02x%02x%02x", this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        }

        public Color getColor() {
            return this.color;
        }

        public Color getDefault() {
            return this.defaultColor;
        }

        public String getDisplayName() {
            try {
                return OStrings.getString(this.name());
            }
            catch (MissingResourceException ex) {
                Log.log(ex);
                return this.name();
            }
        }

        public void setColor(Color newColor) {
            if (newColor == null || newColor.equals(this.defaultColor)) {
                this.color = this.defaultColor;
                Preferences.setPreference(this.name(), DEFAULT_COLOR);
            } else {
                this.color = newColor;
                Preferences.setPreference(this.name(), this.toHex());
            }
        }
    }
}

