/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.gui.main.IMainMenu;
import org.omegat.gui.main.MainMenuIcons;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowMenuHandler;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.RecentProjects;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.Styles;
import org.openide.awt.Mnemonics;

public class MainWindowMenu
implements ActionListener,
MenuListener,
IMainMenu {
    private static final Logger LOGGER = Logger.getLogger(MainWindowMenu.class.getName());
    protected final MainWindow mainWindow;
    protected final MainWindowMenuHandler mainWindowMenuHandler;
    JMenuItem cycleSwitchCaseMenuItem;
    JMenuItem editFindInProjectMenuItem;
    JMenuItem editReplaceInProjectMenuItem;
    JMenuItem editInsertSourceMenuItem;
    JMenuItem editInsertTranslationMenuItem;
    JMenu editMenu;
    JMenuItem editOverwriteSourceMenuItem;
    JMenuItem editOverwriteTranslationMenuItem;
    JMenuItem editOverwriteMachineTranslationMenuItem;
    JMenuItem editRedoMenuItem;
    JMenu selectFuzzySubMenu;
    JMenuItem editSelectFuzzyPrevMenuItem;
    JMenuItem editSelectFuzzyNextMenuItem;
    JMenuItem editSelectFuzzy1MenuItem;
    JMenuItem editSelectFuzzy2MenuItem;
    JMenuItem editSelectFuzzy3MenuItem;
    JMenuItem editSelectFuzzy4MenuItem;
    JMenuItem editSelectFuzzy5MenuItem;
    JMenu insertCharsSubMenu;
    JMenuItem insertCharsLRM;
    JMenuItem insertCharsRLM;
    JMenuItem insertCharsLRE;
    JMenuItem insertCharsRLE;
    JMenuItem insertCharsPDF;
    public JMenuItem editMultipleDefault;
    public JMenuItem editMultipleAlternate;
    JMenuItem editUndoMenuItem;
    JMenuItem editTagPainterMenuItem;
    JMenuItem editTagNextMissedMenuItem;
    JMenuItem editExportSelectionMenuItem;
    JMenuItem editCreateGlossaryEntryMenuItem;
    JMenuItem editSearchDictionaryMenuItem;
    JMenuItem editRegisterUntranslatedMenuItem;
    JMenuItem editRegisterEmptyMenuItem;
    JMenuItem editRegisterIdenticalMenuItem;
    public JMenuItem gotoHistoryBackMenuItem;
    public JMenuItem gotoHistoryForwardMenuItem;
    JMenu gotoMenu;
    JMenuItem gotoNextSegmentMenuItem;
    JMenuItem gotoNextUntranslatedMenuItem;
    JMenuItem gotoNextTranslatedMenuItem;
    JMenuItem gotoPreviousSegmentMenuItem;
    JMenuItem gotoSegmentMenuItem;
    JMenuItem gotoNextNoteMenuItem;
    JMenuItem gotoPreviousNoteMenuItem;
    JMenuItem gotoMatchSourceSegment;
    JMenuItem gotoNextUniqueMenuItem;
    JMenuItem helpAboutMenuItem;
    JMenuItem helpContentsMenuItem;
    JMenuItem helpLastChangesMenuItem;
    JMenuItem helpLogMenuItem;
    JMenuItem helpUpdateCheckMenuItem;
    JMenu helpMenu;
    JMenuItem lowerCaseMenuItem;
    JMenuBar mainMenu;
    JMenu optionsMenu;
    JMenuItem viewRestoreGUIMenuItem;
    JMenuItem optionsAccessConfigDirMenuItem;
    JMenuItem optionsSentsegMenuItem;
    JMenuItem optionsSetupFileFiltersMenuItem;
    JMenu optionsMachineTranslateMenu;
    JMenu optionsGlossaryMenu;
    JMenu optionsDictionaryMenu;
    JMenuItem optionsDictionaryFuzzyMatchingCheckBoxMenuItem;
    JMenu optionsAutoCompleteMenu;
    JMenuItem optionsAutoCompleteShowAutomaticallyItem;
    JMenuItem optionsAutoCompleteHistoryCompletionMenuItem;
    JMenuItem optionsAutoCompleteHistoryPredictionMenuItem;
    JMenuItem optionsWorkflowMenuItem;
    JCheckBoxMenuItem optionsMTAutoFetchCheckboxMenuItem;
    JMenuItem optionsPreferencesMenuItem;
    JMenuItem projectCloseMenuItem;
    JMenuItem projectCommitSourceFiles;
    JMenuItem projectCommitTargetFiles;
    JMenuItem projectCompileMenuItem;
    JMenuItem projectSingleCompileMenuItem;
    JMenuItem projectMedOpenMenuItem;
    JMenuItem projectMedCreateMenuItem;
    JMenuItem projectEditMenuItem;
    JMenuItem projectExitMenuItem;
    JMenuItem projectImportMenuItem;
    JMenu projectMenu;
    JMenuItem projectNewMenuItem;
    JMenuItem projectTeamNewMenuItem;
    JMenuItem projectOpenMenuItem;
    JMenu projectOpenRecentMenuItem;
    JMenuItem projectClearRecentMenuItem;
    JMenuItem projectReloadMenuItem;
    JMenuItem projectSaveMenuItem;
    JMenuItem projectWikiImportMenuItem;
    JMenu projectAccessProjectFilesMenu;
    JMenuItem projectAccessRootMenuItem;
    JMenuItem projectAccessDictionaryMenuItem;
    JMenuItem projectAccessGlossaryMenuItem;
    JMenuItem projectAccessSourceMenuItem;
    JMenuItem projectAccessTargetMenuItem;
    JMenuItem projectAccessTMMenuItem;
    JMenuItem projectAccessCurrentSourceDocumentMenuItem;
    JMenuItem projectAccessCurrentTargetDocumentMenuItem;
    JMenuItem projectAccessWriteableGlossaryMenuItem;
    JMenuItem sentenceCaseMenuItem;
    JMenu switchCaseSubMenu;
    JMenuItem titleCaseMenuItem;
    JMenu toolsMenu;
    JMenuItem toolsCheckIssuesMenuItem;
    JMenuItem toolsCheckIssuesCurrentFileMenuItem;
    JMenuItem toolsShowStatisticsStandardMenuItem;
    JMenuItem toolsShowStatisticsMatchesMenuItem;
    JMenuItem toolsShowStatisticsMatchesPerFileMenuItem;
    JMenuItem toolsAlignFilesMenuItem;
    JMenuItem upperCaseMenuItem;
    JCheckBoxMenuItem viewDisplaySegmentSourceCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkNonUniqueSegmentsCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkNotedSegmentsCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkNBSPCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkWhitespaceCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkBidiCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkAutoPopulatedCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkGlossaryMatchesCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkLanguageCheckerCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkFontFallbackCheckBoxMenuItem;
    JMenu viewModificationInfoMenu;
    JRadioButtonMenuItem viewDisplayModificationInfoNoneRadioButtonMenuItem;
    JRadioButtonMenuItem viewDisplayModificationInfoSelectedRadioButtonMenuItem;
    JRadioButtonMenuItem viewDisplayModificationInfoAllRadioButtonMenuItem;
    JMenuItem viewFileListMenuItem;
    JCheckBoxMenuItem viewMarkTranslatedSegmentsCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkUntranslatedSegmentsCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkParagraphStartCheckBoxMenuItem;
    JMenu viewMenu;

    public MainWindowMenu(MainWindow mainWindow, MainWindowMenuHandler mainWindowMenuHandler) {
        this.mainWindow = mainWindow;
        this.mainWindowMenuHandler = mainWindowMenuHandler;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String action = evt.getActionCommand();
        Log.logInfoRB("LOG_MENU_CLICK", action);
        this.invokeAction(action, evt.getModifiers());
    }

    @Override
    public void invokeAction(String action, int modifiers) {
        Object[] objectArray;
        String methodName = action + "ActionPerformed";
        Method method = null;
        try {
            method = this.mainWindowMenuHandler.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            try {
                method = this.mainWindowMenuHandler.getClass().getMethod(methodName, Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                throw new IncompatibleClassChangeError("Error invoke method handler for main menu: there is no method " + methodName);
            }
        }
        if (method.getParameterTypes().length == 0) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = modifiers;
        }
        Object[] args = objectArray;
        try {
            method.invoke((Object)this.mainWindowMenuHandler, args);
        }
        catch (IllegalAccessException ex) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.SEVERE, "Error execute method", ex);
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
    }

    @Override
    public void menuSelected(MenuEvent evt) {
        JMenu menu = (JMenu)evt.getSource();
        String action = menu.getActionCommand();
        Log.logInfoRB("LOG_MENU_CLICK", action);
        String methodName = action + "MenuSelected";
        Method method = null;
        try {
            method = this.mainWindowMenuHandler.getClass().getMethod(methodName, JMenu.class);
        }
        catch (NoSuchMethodException ex) {
            return;
        }
        try {
            method.invoke((Object)this.mainWindowMenuHandler, menu);
        }
        catch (IllegalAccessException ex) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.SEVERE, "Error execute method", ex);
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    JMenuBar initComponents() {
        this.mainMenu = new JMenuBar();
        this.projectMenu = this.createMenu("TF_MENU_FILE");
        this.mainMenu.add(this.projectMenu);
        this.editMenu = this.createMenu("TF_MENU_EDIT");
        this.mainMenu.add(this.editMenu);
        this.gotoMenu = this.createMenu("MW_GOTOMENU");
        this.mainMenu.add(this.gotoMenu);
        this.viewMenu = this.createMenu("MW_VIEW_MENU");
        this.mainMenu.add(this.viewMenu);
        this.toolsMenu = this.createMenu("TF_MENU_TOOLS");
        this.mainMenu.add(this.toolsMenu);
        this.optionsMenu = this.createMenu("MW_OPTIONSMENU");
        this.mainMenu.add(this.optionsMenu);
        this.helpMenu = this.createMenu("TF_MENU_HELP");
        this.mainMenu.add(this.helpMenu);
        this.projectNewMenuItem = this.createMenuItem("TF_MENU_FILE_CREATE");
        this.projectMenu.add(this.projectNewMenuItem);
        this.projectTeamNewMenuItem = this.createMenuItem("TF_MENU_FILE_TEAM_CREATE");
        this.projectMenu.add(this.projectTeamNewMenuItem);
        this.projectOpenMenuItem = this.createMenuItem("TF_MENU_FILE_OPEN");
        this.projectMenu.add(this.projectOpenMenuItem);
        this.projectOpenRecentMenuItem = this.createMenu("TF_MENU_FILE_OPEN_RECENT");
        this.projectMenu.add(this.projectOpenRecentMenuItem);
        this.projectOpenRecentMenuItem.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                MainWindowMenu.this.populateRecentProjects();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.projectClearRecentMenuItem = this.createMenuItem("TF_MENU_FILE_CLEAR_RECENT");
        this.projectImportMenuItem = this.createMenuItem("TF_MENU_FILE_IMPORT");
        this.projectMenu.add(this.projectImportMenuItem);
        this.projectWikiImportMenuItem = this.createMenuItem("TF_MENU_WIKI_IMPORT");
        this.projectMenu.add(this.projectWikiImportMenuItem);
        this.projectReloadMenuItem = this.createMenuItem("TF_MENU_PROJECT_RELOAD");
        this.projectMenu.add(this.projectReloadMenuItem);
        this.projectCloseMenuItem = this.createMenuItem("TF_MENU_FILE_CLOSE");
        this.projectMenu.add(this.projectCloseMenuItem);
        this.projectMenu.addSeparator();
        this.projectSaveMenuItem = this.createMenuItem("TF_MENU_FILE_SAVE");
        this.projectMenu.add(this.projectSaveMenuItem);
        this.projectMenu.addSeparator();
        this.projectCommitSourceFiles = this.createMenuItem("TF_MENU_FILE_COMMIT");
        this.projectMenu.add(this.projectCommitSourceFiles);
        this.projectCommitTargetFiles = this.createMenuItem("TF_MENU_FILE_TARGET");
        this.projectMenu.add(this.projectCommitTargetFiles);
        this.projectMenu.addSeparator();
        this.projectCompileMenuItem = this.createMenuItem("TF_MENU_FILE_COMPILE");
        this.projectMenu.add(this.projectCompileMenuItem);
        this.projectSingleCompileMenuItem = this.createMenuItem("TF_MENU_FILE_SINGLE_COMPILE");
        this.projectMenu.add(this.projectSingleCompileMenuItem);
        this.projectMenu.addSeparator();
        this.projectMedOpenMenuItem = this.createMenuItem("TF_MENU_FILE_MED_OPEN");
        this.projectMenu.add(this.projectMedOpenMenuItem);
        this.projectMedCreateMenuItem = this.createMenuItem("TF_MENU_FILE_MED_CREATE");
        this.projectMenu.add(this.projectMedCreateMenuItem);
        this.projectMenu.addSeparator();
        this.projectEditMenuItem = this.createMenuItem("MW_PROJECTMENU_EDIT");
        this.projectMenu.add(this.projectEditMenuItem);
        this.viewFileListMenuItem = this.createMenuItem("TF_MENU_FILE_PROJWIN");
        this.projectMenu.add(this.viewFileListMenuItem);
        this.projectAccessProjectFilesMenu = this.createMenu("TF_MENU_FILE_ACCESS_PROJECT_FILES");
        this.projectMenu.add(this.projectAccessProjectFilesMenu);
        this.projectAccessRootMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_ROOT");
        this.projectAccessProjectFilesMenu.add(this.projectAccessRootMenuItem);
        this.projectAccessDictionaryMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_DICTIONARY");
        this.projectAccessProjectFilesMenu.add(this.projectAccessDictionaryMenuItem);
        this.projectAccessGlossaryMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_GLOSSARY");
        this.projectAccessProjectFilesMenu.add(this.projectAccessGlossaryMenuItem);
        this.projectAccessSourceMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_SOURCE");
        this.projectAccessProjectFilesMenu.add(this.projectAccessSourceMenuItem);
        this.projectAccessTargetMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_TARGET");
        this.projectAccessProjectFilesMenu.add(this.projectAccessTargetMenuItem);
        this.projectAccessTMMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_TM");
        this.projectAccessProjectFilesMenu.add(this.projectAccessTMMenuItem);
        this.projectAccessProjectFilesMenu.addSeparator();
        this.projectAccessCurrentSourceDocumentMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_CURRENT_SOURCE_DOCUMENT");
        this.projectAccessProjectFilesMenu.add(this.projectAccessCurrentSourceDocumentMenuItem);
        this.projectAccessCurrentTargetDocumentMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_CURRENT_TARGET_DOCUMENT");
        this.projectAccessProjectFilesMenu.add(this.projectAccessCurrentTargetDocumentMenuItem);
        this.projectAccessWriteableGlossaryMenuItem = this.createMenuItem("TF_MENU_FILE_ACCESS_WRITEABLE_GLOSSARY");
        this.projectAccessProjectFilesMenu.add(this.projectAccessWriteableGlossaryMenuItem);
        this.projectAccessProjectFilesMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (Core.getProject().isProjectLoaded()) {
                    String sourcePath = Core.getEditor().getCurrentFile();
                    MainWindowMenu.this.projectAccessCurrentSourceDocumentMenuItem.setEnabled(!StringUtil.isEmpty(sourcePath) && new File(Core.getProject().getProjectProperties().getSourceRoot(), sourcePath).isFile());
                    String targetPath = Core.getEditor().getCurrentTargetFile();
                    MainWindowMenu.this.projectAccessCurrentTargetDocumentMenuItem.setEnabled(!StringUtil.isEmpty(targetPath) && new File(Core.getProject().getProjectProperties().getTargetRoot(), targetPath).isFile());
                    String glossaryPath = Core.getProject().getProjectProperties().getWriteableGlossary();
                    MainWindowMenu.this.projectAccessWriteableGlossaryMenuItem.setEnabled(!StringUtil.isEmpty(glossaryPath) && new File(glossaryPath).isFile());
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.projectExitMenuItem = this.createMenuItem("TF_MENU_FILE_QUIT");
        if (!Platform.isMacOSX()) {
            this.projectMenu.addSeparator();
            this.projectMenu.add(this.projectExitMenuItem);
        }
        this.editUndoMenuItem = this.createMenuItem("TF_MENU_EDIT_UNDO");
        this.editMenu.add(this.editUndoMenuItem);
        this.editRedoMenuItem = this.createMenuItem("TF_MENU_EDIT_REDO");
        this.editMenu.add(this.editRedoMenuItem);
        this.editMenu.addSeparator();
        this.editOverwriteTranslationMenuItem = this.createMenuItem("TF_MENU_EDIT_RECYCLE");
        this.editMenu.add(this.editOverwriteTranslationMenuItem);
        this.editInsertTranslationMenuItem = this.createMenuItem("TF_MENU_EDIT_INSERT");
        this.editMenu.add(this.editInsertTranslationMenuItem);
        this.editMenu.addSeparator();
        this.editOverwriteMachineTranslationMenuItem = this.createMenuItem("TF_MENU_EDIT_OVERWRITE_MACHITE_TRANSLATION");
        this.editMenu.add(this.editOverwriteMachineTranslationMenuItem);
        this.editMenu.addSeparator();
        this.editOverwriteSourceMenuItem = this.createMenuItem("TF_MENU_EDIT_SOURCE_OVERWRITE");
        this.editMenu.add(this.editOverwriteSourceMenuItem);
        this.editInsertSourceMenuItem = this.createMenuItem("TF_MENU_EDIT_SOURCE_INSERT");
        this.editMenu.add(this.editInsertSourceMenuItem);
        this.editMenu.addSeparator();
        this.editTagPainterMenuItem = this.createMenuItem("TF_MENU_EDIT_TAGPAINT");
        this.editMenu.add(this.editTagPainterMenuItem);
        this.editTagNextMissedMenuItem = this.createMenuItem("TF_MENU_EDIT_TAG_NEXT_MISSED");
        this.editMenu.add(this.editTagNextMissedMenuItem);
        this.editMenu.addSeparator();
        this.editExportSelectionMenuItem = this.createMenuItem("TF_MENU_EDIT_EXPORT_SELECTION");
        this.editMenu.add(this.editExportSelectionMenuItem);
        this.editCreateGlossaryEntryMenuItem = this.createMenuItem("TF_MENU_EDIT_CREATE_GLOSSARY_ENTRY");
        this.editMenu.add(this.editCreateGlossaryEntryMenuItem);
        this.editMenu.addSeparator();
        this.editFindInProjectMenuItem = this.createMenuItem("TF_MENU_EDIT_FIND");
        this.editMenu.add(this.editFindInProjectMenuItem);
        this.editReplaceInProjectMenuItem = this.createMenuItem("TF_MENU_EDIT_REPLACE");
        this.editMenu.add(this.editReplaceInProjectMenuItem);
        this.editMenu.addSeparator();
        this.editSearchDictionaryMenuItem = this.createMenuItem("TF_MENU_EDIT_SEARCH_DICTIONARY");
        this.editMenu.add(this.editSearchDictionaryMenuItem);
        this.editMenu.addSeparator();
        this.switchCaseSubMenu = this.createMenu("TF_EDIT_MENU_SWITCH_CASE");
        this.editMenu.add(this.switchCaseSubMenu);
        this.selectFuzzySubMenu = this.createMenu("TF_MENU_EDIT_COMPARE");
        this.editMenu.add(this.selectFuzzySubMenu);
        this.editSelectFuzzyPrevMenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_PREV");
        this.selectFuzzySubMenu.add(this.editSelectFuzzyPrevMenuItem);
        this.editSelectFuzzyNextMenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_NEXT");
        this.selectFuzzySubMenu.add(this.editSelectFuzzyNextMenuItem);
        this.selectFuzzySubMenu.addSeparator();
        this.editSelectFuzzy1MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_1");
        this.selectFuzzySubMenu.add(this.editSelectFuzzy1MenuItem);
        this.editSelectFuzzy2MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_2");
        this.selectFuzzySubMenu.add(this.editSelectFuzzy2MenuItem);
        this.editSelectFuzzy3MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_3");
        this.selectFuzzySubMenu.add(this.editSelectFuzzy3MenuItem);
        this.editSelectFuzzy4MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_4");
        this.selectFuzzySubMenu.add(this.editSelectFuzzy4MenuItem);
        this.editSelectFuzzy5MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_5");
        this.selectFuzzySubMenu.add(this.editSelectFuzzy5MenuItem);
        this.insertCharsSubMenu = this.createMenu("TF_MENU_EDIT_INSERT_CHARS");
        this.editMenu.add(this.insertCharsSubMenu);
        this.insertCharsLRM = this.createMenuItem("TF_MENU_EDIT_INSERT_CHARS_LRM");
        this.insertCharsSubMenu.add(this.insertCharsLRM);
        this.insertCharsRLM = this.createMenuItem("TF_MENU_EDIT_INSERT_CHARS_RLM");
        this.insertCharsSubMenu.add(this.insertCharsRLM);
        this.insertCharsSubMenu.addSeparator();
        this.insertCharsLRE = this.createMenuItem("TF_MENU_EDIT_INSERT_CHARS_LRE");
        this.insertCharsSubMenu.add(this.insertCharsLRE);
        this.insertCharsRLE = this.createMenuItem("TF_MENU_EDIT_INSERT_CHARS_RLE");
        this.insertCharsSubMenu.add(this.insertCharsRLE);
        this.insertCharsPDF = this.createMenuItem("TF_MENU_EDIT_INSERT_CHARS_PDF");
        this.insertCharsSubMenu.add(this.insertCharsPDF);
        this.editMenu.addSeparator();
        this.editMultipleDefault = this.createMenuItem("MULT_MENU_DEFAULT");
        this.editMenu.add(this.editMultipleDefault);
        this.editMultipleAlternate = this.createMenuItem("MULT_MENU_MULTIPLE");
        this.editMenu.add(this.editMultipleAlternate);
        this.editMenu.addSeparator();
        this.editRegisterUntranslatedMenuItem = this.createMenuItem("TF_MENU_EDIT_UNTRANSLATED_TRANSLATION");
        this.editMenu.add(this.editRegisterUntranslatedMenuItem);
        this.editRegisterEmptyMenuItem = this.createMenuItem("TF_MENU_EDIT_EMPTY_TRANSLATION");
        this.editMenu.add(this.editRegisterEmptyMenuItem);
        this.editRegisterIdenticalMenuItem = this.createMenuItem("TF_MENU_EDIT_IDENTICAL_TRANSLATION");
        this.editMenu.add(this.editRegisterIdenticalMenuItem);
        this.lowerCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_LOWER");
        this.switchCaseSubMenu.add(this.lowerCaseMenuItem);
        this.upperCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_UPPER");
        this.switchCaseSubMenu.add(this.upperCaseMenuItem);
        this.titleCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_TITLE");
        this.switchCaseSubMenu.add(this.titleCaseMenuItem);
        this.sentenceCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_SENTENCE");
        this.switchCaseSubMenu.add(this.sentenceCaseMenuItem);
        this.switchCaseSubMenu.addSeparator();
        this.cycleSwitchCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_CYCLE");
        this.switchCaseSubMenu.add(this.cycleSwitchCaseMenuItem);
        this.gotoNextUntranslatedMenuItem = this.createMenuItem("TF_MENU_EDIT_UNTRANS");
        this.gotoMenu.add(this.gotoNextUntranslatedMenuItem);
        this.gotoNextTranslatedMenuItem = this.createMenuItem("TF_MENU_EDIT_TRANS");
        this.gotoMenu.add(this.gotoNextTranslatedMenuItem);
        this.gotoNextSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_NEXT");
        this.gotoMenu.add(this.gotoNextSegmentMenuItem);
        this.gotoPreviousSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_PREV");
        this.gotoMenu.add(this.gotoPreviousSegmentMenuItem);
        this.gotoSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_GOTO");
        this.gotoMenu.add(this.gotoSegmentMenuItem);
        this.gotoNextNoteMenuItem = this.createMenuItem("TF_MENU_EDIT_NEXT_NOTE");
        this.gotoMenu.add(this.gotoNextNoteMenuItem);
        this.gotoPreviousNoteMenuItem = this.createMenuItem("TF_MENU_EDIT_PREV_NOTE");
        this.gotoMenu.add(this.gotoPreviousNoteMenuItem);
        this.gotoNextUniqueMenuItem = this.createMenuItem("TF_MENU_GOTO_NEXT_UNIQUE");
        this.gotoMenu.add(this.gotoNextUniqueMenuItem);
        this.gotoMatchSourceSegment = this.createMenuItem("TF_MENU_GOTO_SELECTED_MATCH_SOURCE");
        this.gotoMenu.add(this.gotoMatchSourceSegment);
        this.gotoMenu.addSeparator();
        this.gotoHistoryForwardMenuItem = this.createMenuItem("TF_MENU_GOTO_FORWARD_IN_HISTORY");
        this.gotoMenu.add(this.gotoHistoryForwardMenuItem);
        this.gotoHistoryBackMenuItem = this.createMenuItem("TF_MENU_GOTO_BACK_IN_HISTORY");
        this.gotoMenu.add(this.gotoHistoryBackMenuItem);
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_MARK_TRANSLATED");
        this.viewMenu.add(this.viewMarkTranslatedSegmentsCheckBoxMenuItem);
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_MARK_UNTRANSLATED");
        this.viewMenu.add(this.viewMarkUntranslatedSegmentsCheckBoxMenuItem);
        this.viewMarkParagraphStartCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_MARK_PARAGRAPH");
        this.viewMenu.add(this.viewMarkParagraphStartCheckBoxMenuItem);
        this.viewDisplaySegmentSourceCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_DISPLAY_SEGMENT_SOURCES");
        this.viewMenu.add(this.viewDisplaySegmentSourceCheckBoxMenuItem);
        this.viewMarkNonUniqueSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_NON_UNIQUE_SEGMENTS");
        this.viewMenu.add(this.viewMarkNonUniqueSegmentsCheckBoxMenuItem);
        this.viewMarkNotedSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_NOTED_SEGMENTS");
        this.viewMenu.add(this.viewMarkNotedSegmentsCheckBoxMenuItem);
        this.viewMarkNBSPCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_NBSP");
        this.viewMenu.add(this.viewMarkNBSPCheckBoxMenuItem);
        this.viewMarkWhitespaceCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_WHITESPACE");
        this.viewMenu.add(this.viewMarkWhitespaceCheckBoxMenuItem);
        this.viewMarkBidiCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_BIDI");
        this.viewMenu.add(this.viewMarkBidiCheckBoxMenuItem);
        this.viewMarkAutoPopulatedCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_AUTOPOPULATED");
        this.viewMenu.add(this.viewMarkAutoPopulatedCheckBoxMenuItem);
        this.viewMarkGlossaryMatchesCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_GLOSSARY_MARK");
        this.viewMenu.add(this.viewMarkGlossaryMatchesCheckBoxMenuItem);
        this.viewMarkLanguageCheckerCheckBoxMenuItem = this.createCheckboxMenuItem("LT_OPTIONS_MENU_ENABLED");
        this.viewMenu.add(this.viewMarkLanguageCheckerCheckBoxMenuItem);
        this.viewMarkFontFallbackCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_FONT_FALLBACK");
        this.viewMenu.add(this.viewMarkFontFallbackCheckBoxMenuItem);
        this.viewModificationInfoMenu = this.createMenu("MW_VIEW_MENU_MODIFICATION_INFO");
        this.viewMenu.add(this.viewModificationInfoMenu);
        ButtonGroup viewModificationInfoMenuBG = new ButtonGroup();
        this.viewDisplayModificationInfoNoneRadioButtonMenuItem = this.createRadioButtonMenuItem("MW_VIEW_MENU_MODIFICATION_INFO_NONE", viewModificationInfoMenuBG);
        this.viewModificationInfoMenu.add(this.viewDisplayModificationInfoNoneRadioButtonMenuItem);
        this.viewDisplayModificationInfoSelectedRadioButtonMenuItem = this.createRadioButtonMenuItem("MW_VIEW_MENU_MODIFICATION_INFO_SELECTED", viewModificationInfoMenuBG);
        this.viewModificationInfoMenu.add(this.viewDisplayModificationInfoSelectedRadioButtonMenuItem);
        this.viewDisplayModificationInfoAllRadioButtonMenuItem = this.createRadioButtonMenuItem("MW_VIEW_MENU_MODIFICATION_INFO_ALL", viewModificationInfoMenuBG);
        this.viewModificationInfoMenu.add(this.viewDisplayModificationInfoAllRadioButtonMenuItem);
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_TRANSLATED.getColor()));
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_UNTRANSLATED.getColor()));
        this.viewMarkParagraphStartCheckBoxMenuItem.setIcon(MainMenuIcons.newTextIcon(Styles.EditorColor.COLOR_PARAGRAPH_START.getColor(), '\u00b6'));
        this.viewDisplaySegmentSourceCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_SOURCE.getColor()));
        this.viewMarkNonUniqueSegmentsCheckBoxMenuItem.setIcon(MainMenuIcons.newTextIcon(Styles.EditorColor.COLOR_NON_UNIQUE.getColor(), 'M'));
        this.viewMarkNotedSegmentsCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_NOTED.getColor()));
        this.viewMarkNBSPCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_NBSP.getColor()));
        this.viewMarkWhitespaceCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_WHITESPACE.getColor()));
        this.viewMarkBidiCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_BIDIMARKERS.getColor()));
        this.viewModificationInfoMenu.setIcon(MainMenuIcons.newBlankIcon());
        this.viewMarkAutoPopulatedCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_XAUTO.getColor()));
        this.viewMarkGlossaryMatchesCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_TRANSTIPS.getColor()));
        this.viewMarkLanguageCheckerCheckBoxMenuItem.setIcon(MainMenuIcons.newColorIcon(Styles.EditorColor.COLOR_LANGUAGE_TOOLS.getColor()));
        this.viewMarkFontFallbackCheckBoxMenuItem.setIcon(MainMenuIcons.newTextIcon(UIManager.getColor("Label.foreground"), new Font("Serif", 2, 16), 'F'));
        this.viewMenu.addSeparator();
        this.viewRestoreGUIMenuItem = this.createMenuItem("MW_OPTIONSMENU_RESTORE_GUI");
        this.viewMenu.add(this.viewRestoreGUIMenuItem);
        this.toolsCheckIssuesMenuItem = this.createMenuItem("TF_MENU_TOOLS_CHECK_ISSUES");
        this.toolsMenu.add(this.toolsCheckIssuesMenuItem);
        this.toolsCheckIssuesCurrentFileMenuItem = this.createMenuItem("TF_MENU_TOOLS_CHECK_ISSUES_CURRENT_FILE");
        this.toolsMenu.add(this.toolsCheckIssuesCurrentFileMenuItem);
        this.toolsShowStatisticsStandardMenuItem = this.createMenuItem("TF_MENU_TOOLS_STATISTICS_STANDARD");
        this.toolsMenu.add(this.toolsShowStatisticsStandardMenuItem);
        this.toolsShowStatisticsMatchesMenuItem = this.createMenuItem("TF_MENU_TOOLS_STATISTICS_MATCHES");
        this.toolsMenu.add(this.toolsShowStatisticsMatchesMenuItem);
        this.toolsShowStatisticsMatchesPerFileMenuItem = this.createMenuItem("TF_MENU_TOOLS_STATISTICS_MATCHES_PER_FILE");
        this.toolsMenu.add(this.toolsShowStatisticsMatchesPerFileMenuItem);
        this.toolsMenu.addSeparator();
        this.toolsAlignFilesMenuItem = this.createMenuItem("TF_MENU_TOOLS_ALIGN_FILES");
        this.toolsMenu.add(this.toolsAlignFilesMenuItem);
        this.optionsPreferencesMenuItem = this.createMenuItem("MW_OPTIONSMENU_PREFERENCES");
        if (!Platform.isMacOSX()) {
            this.optionsMenu.add(this.optionsPreferencesMenuItem);
            this.optionsMenu.addSeparator();
        }
        this.optionsMachineTranslateMenu = this.createMenu("TF_OPTIONSMENU_MACHINETRANSLATE");
        this.optionsMenu.add(this.optionsMachineTranslateMenu);
        this.optionsMTAutoFetchCheckboxMenuItem = this.createCheckboxMenuItem("MT_AUTO_FETCH");
        this.optionsMachineTranslateMenu.add(this.optionsMTAutoFetchCheckboxMenuItem);
        this.optionsMachineTranslateMenu.addSeparator();
        this.optionsGlossaryMenu = this.createMenu("TF_OPTIONSMENU_GLOSSARY");
        this.optionsMenu.add(this.optionsGlossaryMenu);
        this.optionsGlossaryMenu.addSeparator();
        this.optionsDictionaryMenu = this.createMenu("TF_OPTIONSMENU_DICTIONARY");
        this.optionsMenu.add(this.optionsDictionaryMenu);
        this.optionsDictionaryFuzzyMatchingCheckBoxMenuItem = this.createCheckboxMenuItem("TF_OPTIONSMENU_DICTIONARY_FUZZY");
        this.optionsDictionaryMenu.add(this.optionsDictionaryFuzzyMatchingCheckBoxMenuItem);
        this.optionsAutoCompleteMenu = this.createMenu("MW_OPTIONSMENU_AUTOCOMPLETE");
        this.optionsMenu.add(this.optionsAutoCompleteMenu);
        this.optionsAutoCompleteShowAutomaticallyItem = this.createCheckboxMenuItem("MW_OPTIONSMENU_AUTOCOMPLETE_SHOW_AUTOMATICALLY");
        this.optionsAutoCompleteMenu.add(this.optionsAutoCompleteShowAutomaticallyItem);
        this.optionsAutoCompleteHistoryCompletionMenuItem = this.createCheckboxMenuItem("MW_OPTIONSMENU_AUTOCOMPLETE_HISTORY_COMPLETION");
        this.optionsAutoCompleteMenu.add(this.optionsAutoCompleteHistoryCompletionMenuItem);
        this.optionsAutoCompleteHistoryPredictionMenuItem = this.createCheckboxMenuItem("MW_OPTIONSMENU_AUTOCOMPLETE_HISTORY_PREDICTION");
        this.optionsAutoCompleteMenu.add(this.optionsAutoCompleteHistoryPredictionMenuItem);
        this.optionsMenu.addSeparator();
        this.optionsSetupFileFiltersMenuItem = this.createMenuItem("TF_MENU_DISPLAY_FILTERS");
        this.optionsMenu.add(this.optionsSetupFileFiltersMenuItem);
        this.optionsSentsegMenuItem = this.createMenuItem("MW_OPTIONSMENU_SENTSEG");
        this.optionsMenu.add(this.optionsSentsegMenuItem);
        this.optionsWorkflowMenuItem = this.createMenuItem("MW_OPTIONSMENU_WORKFLOW");
        this.optionsMenu.add(this.optionsWorkflowMenuItem);
        this.optionsMenu.addSeparator();
        this.optionsAccessConfigDirMenuItem = this.createMenuItem("MW_OPTIONSMENU_ACCESS_CONFIG_DIR");
        this.optionsMenu.add(this.optionsAccessConfigDirMenuItem);
        this.optionsMenu.addSeparator();
        this.helpContentsMenuItem = this.createMenuItem("TF_MENU_HELP_CONTENTS");
        this.helpMenu.add(this.helpContentsMenuItem);
        this.helpAboutMenuItem = this.createMenuItem("TF_MENU_HELP_ABOUT");
        this.helpMenu.add(this.helpAboutMenuItem);
        this.helpLastChangesMenuItem = this.createMenuItem("TF_MENU_HELP_LAST_CHANGES");
        this.helpMenu.add(this.helpLastChangesMenuItem);
        this.helpLogMenuItem = this.createMenuItem("TF_MENU_HELP_LOG");
        this.helpMenu.add(this.helpLogMenuItem);
        this.helpUpdateCheckMenuItem = this.createMenuItem("TF_MENU_HELP_CHECK_FOR_UPDATES");
        this.helpMenu.add(this.helpUpdateCheckMenuItem);
        this.setActionCommands();
        PropertiesShortcuts.getMainMenuShortcuts().bindKeyStrokes(this.mainMenu);
        final String key = "findInProjectReuseLastWindow";
        KeyStroke stroke = PropertiesShortcuts.getMainMenuShortcuts().getKeyStroke(key);
        this.mainWindow.getRootPane().getInputMap(2).put(stroke, key);
        this.mainWindow.getRootPane().getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.logInfoRB("LOG_MENU_CLICK", key);
                MainWindowMenu.this.mainWindowMenuHandler.findInProjectReuseLastWindow();
            }
        });
        if (Platform.isMacOSX()) {
            this.initMacSpecific();
        }
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
                MainWindowMenu.this.updateCheckboxesOnStart();
                MainWindowMenu.this.onProjectStatusChanged(false);
            }

            @Override
            public void onApplicationShutdown() {
            }
        });
        CoreEvents.registerProjectChangeListener(e -> this.onProjectStatusChanged(Core.getProject().isProjectLoaded()));
        Preferences.addPropertyChangeListener(e -> {
            JMenuItem item;
            if (e.getNewValue() instanceof Boolean && (item = this.getItemForPreference(e.getPropertyName())) != null) {
                item.setSelected((Boolean)e.getNewValue());
            }
        });
        return this.mainMenu;
    }

    private JMenuItem getItemForPreference(String preference) {
        switch (preference) {
            case "ac_show_suggestions_automatically": {
                return this.optionsAutoCompleteShowAutomaticallyItem;
            }
            case "allow_history_completer": {
                return this.optionsAutoCompleteHistoryCompletionMenuItem;
            }
            case "history_completer_prediction_enabled": {
                return this.optionsAutoCompleteHistoryPredictionMenuItem;
            }
            case "mt_auto_fetch": {
                return this.optionsMTAutoFetchCheckboxMenuItem;
            }
            case "dictionary_fuzzy_matching": {
                return this.optionsDictionaryFuzzyMatchingCheckBoxMenuItem;
            }
        }
        return null;
    }

    private void updateCheckboxesOnStart() {
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkTranslated());
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkUntranslated());
        this.viewMarkParagraphStartCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkParagraphDelimitations());
        this.viewDisplaySegmentSourceCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isDisplaySegmentSources());
        this.viewMarkNonUniqueSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkNonUniqueSegments());
        this.viewMarkNotedSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkNotedSegments());
        this.viewMarkNBSPCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkNBSP());
        this.viewMarkWhitespaceCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkWhitespace());
        this.viewMarkBidiCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkBidi());
        this.viewMarkAutoPopulatedCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkAutoPopulated());
        this.viewMarkGlossaryMatchesCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkGlossaryMatches());
        this.viewMarkLanguageCheckerCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkLanguageChecker());
        this.viewMarkFontFallbackCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isDoFontFallback());
        this.viewDisplayModificationInfoNoneRadioButtonMenuItem.setSelected("none".equals(Core.getEditor().getSettings().getDisplayModificationInfo()));
        this.viewDisplayModificationInfoSelectedRadioButtonMenuItem.setSelected("selected".equals(Core.getEditor().getSettings().getDisplayModificationInfo()));
        this.viewDisplayModificationInfoAllRadioButtonMenuItem.setSelected("all".equals(Core.getEditor().getSettings().getDisplayModificationInfo()));
        this.optionsAutoCompleteShowAutomaticallyItem.setSelected(Preferences.isPreferenceDefault("ac_show_suggestions_automatically", true));
        this.optionsAutoCompleteHistoryCompletionMenuItem.setSelected(Preferences.isPreference("allow_history_completer"));
        this.optionsAutoCompleteHistoryPredictionMenuItem.setSelected(Preferences.isPreference("history_completer_prediction_enabled"));
        this.optionsMTAutoFetchCheckboxMenuItem.setSelected(Preferences.isPreferenceDefault("mt_auto_fetch", true));
        this.optionsDictionaryFuzzyMatchingCheckBoxMenuItem.setSelected(Preferences.isPreferenceDefault("dictionary_fuzzy_matching", true));
    }

    private void initMacSpecific() {
        try {
            OSXIntegration.setQuitHandler(e -> this.mainWindowMenuHandler.projectExitMenuItemActionPerformed());
            OSXIntegration.setAboutHandler(e -> this.mainWindowMenuHandler.helpAboutMenuItemActionPerformed());
            OSXIntegration.setPreferencesHandler(e -> this.mainWindowMenuHandler.optionsPreferencesMenuItemActionPerformed());
        }
        catch (NoClassDefFoundError e2) {
            Log.log(e2);
        }
    }

    private void populateRecentProjects() {
        this.projectOpenRecentMenuItem.removeAll();
        List<String> items = RecentProjects.getRecentProjects();
        for (String project : items) {
            JMenuItem recentProjectMenuItem = new JMenuItem(project);
            File projectFile = new File(project);
            recentProjectMenuItem.addActionListener(event -> ProjectUICommands.projectOpen(projectFile, true));
            recentProjectMenuItem.setEnabled(projectFile.isDirectory() && projectFile.canRead());
            this.projectOpenRecentMenuItem.add(recentProjectMenuItem);
        }
        this.projectOpenRecentMenuItem.addSeparator();
        this.projectOpenRecentMenuItem.add(this.projectClearRecentMenuItem);
        this.projectClearRecentMenuItem.setEnabled(!items.isEmpty());
    }

    private JMenu createMenu(String titleKey) {
        JMenu result = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)result, (String)OStrings.getString(titleKey));
        result.addMenuListener(this);
        return result;
    }

    private JMenuItem createMenuItem(String titleKey) {
        JMenuItem result = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)result, (String)OStrings.getString(titleKey));
        result.addActionListener(this);
        return result;
    }

    private JCheckBoxMenuItem createCheckboxMenuItem(String titleKey) {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)result, (String)OStrings.getString(titleKey));
        result.addActionListener(this);
        return result;
    }

    private JRadioButtonMenuItem createRadioButtonMenuItem(String titleKey, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem result = new JRadioButtonMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)result, (String)OStrings.getString(titleKey));
        result.addActionListener(this);
        buttonGroup.add(result);
        return result;
    }

    protected void setActionCommands() {
        try {
            for (Field f : this.getClass().getDeclaredFields()) {
                if (!JMenuItem.class.isAssignableFrom(f.getType())) continue;
                JMenuItem menuItem = (JMenuItem)f.get(this);
                menuItem.setActionCommand(f.getName());
            }
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private void onProjectStatusChanged(boolean isProjectOpened) {
        JMenuItem[] itemsToSwitchOff = new JMenuItem[]{this.projectNewMenuItem, this.projectTeamNewMenuItem, this.projectOpenMenuItem, this.projectMedOpenMenuItem};
        JMenuItem[] itemsToSwitchOn = new JMenuItem[]{this.projectImportMenuItem, this.projectWikiImportMenuItem, this.projectReloadMenuItem, this.projectCloseMenuItem, this.projectSaveMenuItem, this.projectEditMenuItem, this.projectCompileMenuItem, this.projectSingleCompileMenuItem, this.projectAccessProjectFilesMenu, this.projectMedCreateMenuItem, this.editMenu, this.editFindInProjectMenuItem, this.editReplaceInProjectMenuItem, this.editInsertSourceMenuItem, this.editInsertTranslationMenuItem, this.editTagPainterMenuItem, this.editOverwriteSourceMenuItem, this.editOverwriteTranslationMenuItem, this.editRedoMenuItem, this.editSelectFuzzy1MenuItem, this.editSelectFuzzy2MenuItem, this.editSelectFuzzy3MenuItem, this.editSelectFuzzy4MenuItem, this.editSelectFuzzy5MenuItem, this.editUndoMenuItem, this.switchCaseSubMenu, this.editOverwriteMachineTranslationMenuItem, this.editRegisterUntranslatedMenuItem, this.editRegisterEmptyMenuItem, this.editRegisterIdenticalMenuItem, this.gotoMenu, this.gotoNextSegmentMenuItem, this.gotoNextUntranslatedMenuItem, this.gotoPreviousSegmentMenuItem, this.gotoSegmentMenuItem, this.gotoNextNoteMenuItem, this.gotoPreviousNoteMenuItem, this.gotoMatchSourceSegment, this.viewFileListMenuItem, this.toolsCheckIssuesMenuItem, this.toolsCheckIssuesCurrentFileMenuItem, this.toolsShowStatisticsStandardMenuItem, this.toolsShowStatisticsMatchesMenuItem, this.toolsShowStatisticsMatchesPerFileMenuItem};
        for (JMenuItem item : itemsToSwitchOff) {
            item.setEnabled(!isProjectOpened);
        }
        for (JMenuItem item : itemsToSwitchOn) {
            item.setEnabled(isProjectOpened);
        }
        if (Core.getParams().containsKey("no-team")) {
            this.projectTeamNewMenuItem.setEnabled(false);
        }
        if (isProjectOpened && Core.getProject().isRemoteProject() && Core.getProject().getProjectProperties().getSourceDir().isUnderRoot()) {
            this.projectCommitSourceFiles.setEnabled(true);
        } else {
            this.projectCommitSourceFiles.setEnabled(false);
        }
        if (isProjectOpened && Core.getProject().isRemoteProject() && Core.getProject().getProjectProperties().getTargetDir().isUnderRoot()) {
            this.projectCommitTargetFiles.setEnabled(true);
        } else {
            this.projectCommitTargetFiles.setEnabled(false);
        }
    }

    @Override
    public JMenu getMachineTranslationMenu() {
        return this.optionsMachineTranslateMenu;
    }

    @Override
    public JMenu getOptionsMenu() {
        return this.optionsMenu;
    }

    @Override
    public JMenu getToolsMenu() {
        return this.toolsMenu;
    }

    @Override
    public JMenu getGlossaryMenu() {
        return this.optionsGlossaryMenu;
    }

    @Override
    public JMenu getProjectMenu() {
        return this.projectMenu;
    }

    @Override
    public JMenu getAutoCompletionMenu() {
        return this.optionsAutoCompleteMenu;
    }
}

