/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

public class DockGroup {
    private DockGroup parent;
    private String name;

    public DockGroup(String name) {
        this.name = name;
    }

    public DockGroup(String name, DockGroup parent) {
        this.name = name;
        this.parent = parent;
    }

    public DockGroup getParent() {
        return this.parent;
    }

    public void setParent(DockGroup parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof DockGroup && ((DockGroup)o).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isAncestorOf(DockGroup g) {
        if (this.equals(g)) {
            return true;
        }
        DockGroup parent = g.parent;
        while (parent != null) {
            if (this.equals(parent)) {
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    public boolean isCompatibleGroup(DockGroup g) {
        if (g == null) {
            return false;
        }
        if (this.equals(g)) {
            return true;
        }
        if (this.isAncestorOf(g)) {
            return true;
        }
        if (g.isAncestorOf(this)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isCompatibleGroup(g.parent);
        }
        return false;
    }

    public static boolean areGroupsCompatible(DockGroup g1, DockGroup g2) {
        if (g1 == null) {
            return g2 == null;
        }
        if (g2 == null) {
            return g1 == null;
        }
        return g1.isCompatibleGroup(g2);
    }
}

