/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.align;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.omegat.gui.align.EditingPanel;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class EditingPanelController {
    private final String text;
    private String result;

    public EditingPanelController(String text) {
        this.text = text;
    }

    public String show(Window parent) {
        final JDialog dialog = new JDialog(parent, OStrings.getString("ALIGNER_DIALOG_EDITOR"), Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditingPanelController.this.doCancel(dialog);
            }
        });
        StaticUIUtils.setEscapeClosable(dialog);
        final EditingPanel panel = new EditingPanel();
        panel.editorPane.setText(this.text);
        StaticUIUtils.makeCaretAlwaysVisible(panel.editorPane);
        panel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditingPanelController.this.result = panel.editorPane.getText();
                dialog.dispose();
            }
        });
        panel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditingPanelController.this.doCancel(dialog);
            }
        });
        panel.editorPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    panel.okButton.doClick();
                }
            }
        });
        dialog.add(panel);
        dialog.getRootPane().setDefaultButton(panel.okButton);
        dialog.setMinimumSize(new Dimension(450, 200));
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.result;
    }

    private void doCancel(JDialog dialog) {
        this.result = this.text;
        dialog.dispose();
    }
}

