/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.html;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

class CssIdCompletionItem
implements CompletionProposal {
    private final ElementHandle element;
    private final ParserResult parserInfo;
    private final int astOffset;
    private final String name;
    private static ImageIcon cssIcon = null;

    public CssIdCompletionItem(String name, ParserResult info, int astOffset) {
        this.parserInfo = info;
        this.name = name;
        this.astOffset = astOffset;
        this.element = null;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public Set<Modifier> getModifiers() {
        EnumSet<Modifier> modifiers;
        if (this.getElement() == null || this.getElement().getModifiers().isEmpty()) {
            modifiers = Collections.EMPTY_SET;
        } else {
            modifiers = EnumSet.noneOf(Modifier.class);
            modifiers.addAll(this.getElement().getModifiers());
        }
        if (modifiers.contains(Modifier.PRIVATE) && (modifiers.contains(Modifier.PUBLIC) || modifiers.contains(Modifier.PROTECTED))) {
            modifiers.remove(Modifier.PUBLIC);
            modifiers.remove(Modifier.PROTECTED);
        }
        return modifiers;
    }

    public int getAnchorOffset() {
        return this.parserInfo.getSnapshot().getOriginalOffset(this.astOffset);
    }

    public ImageIcon getIcon() {
        if (cssIcon == null) {
            cssIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/jquery/resources/style_sheet_16.png"));
        }
        return cssIcon;
    }

    public String getName() {
        return this.name;
    }

    public String getInsertPrefix() {
        return this.getName();
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.reset();
        formatter.appendText(this.getName());
        return formatter.getText();
    }

    public ElementKind getKind() {
        return ElementKind.RULE;
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return null;
    }

    public String getSortText() {
        StringBuilder sb = new StringBuilder();
        if (this.element != null) {
            FileObject sourceFo = this.parserInfo.getSnapshot().getSource().getFileObject();
            FileObject elementFo = this.element.getFileObject();
            if (elementFo != null && sourceFo != null && sourceFo.equals(elementFo)) {
                sb.append("1");
            } else if (OffsetRange.NONE.equals((Object)this.element.getOffsetRange(this.parserInfo))) {
                sb.append("8");
            } else {
                sb.append("9");
            }
        }
        sb.append(this.getName());
        return sb.toString();
    }

    protected boolean isDeprecated() {
        return this.element.getModifiers().contains(Modifier.DEPRECATED);
    }

    protected void formatName(HtmlFormatter formatter) {
        if (this.isDeprecated()) {
            formatter.deprecated(true);
            formatter.appendText(this.getName());
            formatter.deprecated(false);
        } else {
            formatter.appendText(this.getName());
        }
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        int order = 100;
        return order;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public final String getFileNameURL() {
        ElementHandle elem = this.getElement();
        if (elem == null) {
            return null;
        }
        FileObject fo = elem.getFileObject();
        if (fo != null) {
            return fo.getNameExt();
        }
        return this.getName();
    }
}

