/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PSR12Hint;
import org.openide.filesystems.FileObject;

public class PSR12FilesHint
extends PSR12Hint {
    private static final String HINT_ID = "PSR12.Hint.Files";
    private static final Logger LOGGER = Logger.getLogger(PSR12FilesHint.class.getName());

    @Override
    protected PSR12Hint.CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
        FilesVisitor filesVisitor = new FilesVisitor(this, fileObject, baseDocument);
        try {
            int lastPosition = baseDocument.getLength();
            int lineStart = LineDocumentUtils.getLineStart((LineDocument)baseDocument, (int)lastPosition);
            if (!this.endsWithSingleLF(baseDocument)) {
                filesVisitor.createHint(new OffsetRange(lineStart, lastPosition), Bundle.PSR12FilesTerminatedWithSingleLFHint());
            }
            if (!PSR12FilesHint.isLF(baseDocument)) {
                int lineEnd = LineDocumentUtils.getLineEnd((LineDocument)baseDocument, (int)0);
                filesVisitor.createHint(new OffsetRange(0, lineEnd), Bundle.PSR12FilesLFOnlyHint());
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, "Cannot get the line position. document length: {0}, invalid offset: {1}", new Object[]{baseDocument.getLength(), ex.offsetRequested()});
        }
        return filesVisitor;
    }

    private boolean endsWithSingleLF(BaseDocument document) {
        int docLength = document.getLength();
        try {
            char[] chars;
            String lastChar;
            if (docLength == 1 ? (lastChar = document.getText(docLength - 1, 1)).equals("\n") && PSR12FilesHint.isLF(document) : docLength > 1 && (chars = document.getChars(docLength - 2, 2))[1] == '\n' && chars[0] != '\n' && chars[0] != '\r') {
                return true;
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, "Cannot get the text. document length: {0}, invalid offset: {1}", new Object[]{document.getLength(), ex.offsetRequested()});
        }
        return false;
    }

    private static boolean isLF(BaseDocument document) {
        String lineEnding;
        Object lineSeparator = document.getProperty((Object)"__EndOfLine__");
        return lineSeparator instanceof String && (lineEnding = (String)lineSeparator).equals("\n");
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.PSR12FilesHintDescription();
    }

    public String getDisplayName() {
        return Bundle.PSR12FilesHintDisplayName();
    }

    private static final class FilesVisitor
    extends PSR12Hint.CheckVisitor {
        public FilesVisitor(PSR12Hint psr12hint, FileObject fileObject, BaseDocument baseDocument) {
            super(psr12hint, fileObject, baseDocument);
        }

        @Override
        protected void createHint(OffsetRange offsetRange, String message) {
            super.createHint(offsetRange, message);
        }

        @Override
        protected boolean needScan() {
            return false;
        }
    }
}

