/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.nodes.array.GetLengthHelperNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=GetLengthHelperNode.class)
final class GetLengthHelperNodeGen
extends GetLengthHelperNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private ArrayLengthNode.ArrayLengthReadNode getArrayLengthInt_arrayLengthReadNode_;
    @Node.Child
    private ArrayLengthNode.ArrayLengthReadNode getArrayLength_arrayLengthReadNode_;
    @Node.Child
    private PropertyNode getLengthDynamicObject_getLengthPropertyNode_;
    @Node.Child
    private GetLengthForeign0Data getLengthForeign0_cache;
    @Node.Child
    private ImportValueNode getLengthForeign1_importValueNode_;

    private GetLengthHelperNodeGen(JSContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop
    public Object execute(Object arg0Value, boolean arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 7) != 0 && JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((state & 1) != 0 && arg1Value) {
                    try {
                        return this.getArrayLengthInt(arg0Value_, arg1Value, this.getArrayLengthInt_arrayLengthReadNode_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFE;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state & 2) != 0 && arg1Value) {
                    return this.getArrayLength(arg0Value_, arg1Value, this.getArrayLength_arrayLengthReadNode_);
                }
                if ((state & 4) != 0 && !arg1Value) {
                    return this.getLengthDynamicObject(arg0Value_, arg1Value, this.getLengthDynamicObject_getLengthPropertyNode_);
                }
            }
            if ((state & 0x18) != 0) {
                if ((state & 8) != 0) {
                    GetLengthForeign0Data s4_ = this.getLengthForeign0_cache;
                    while (s4_ != null) {
                        if (s4_.interop_.accepts(arg0Value) && !JSGuards.isDynamicObject(arg0Value)) {
                            return this.getLengthForeign(arg0Value, arg1Value, s4_.interop_, s4_.importValueNode_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state & 0x10) != 0 && !JSGuards.isDynamicObject(arg0Value)) {
                    return this.getLengthForeign1Boundary(state, arg0Value, arg1Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object getLengthForeign1Boundary(int state, Object arg0Value, boolean arg1Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary getLengthForeign1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
            Double d = this.getLengthForeign(arg0Value, arg1Value, getLengthForeign1_interop__, this.getLengthForeign1_importValueNode_);
            return d;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object executeAndSpecialize(Object arg0Value, boolean arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0 && arg1Value) {
                    this.getArrayLengthInt_arrayLengthReadNode_ = (ArrayLengthNode.ArrayLengthReadNode)super.insert((Node)ArrayLengthNode.ArrayLengthReadNode.create());
                    this.state_ = state |= 1;
                    try {
                        lock.unlock();
                        hasLock = false;
                        Integer n = this.getArrayLengthInt(arg0Value_, arg1Value, this.getArrayLengthInt_arrayLengthReadNode_);
                        return n;
                    }
                    catch (UnexpectedResultException ex) {
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFE;
                        }
                        finally {
                            lock.unlock();
                        }
                        Object object = ex.getResult();
                        if (hasLock) {
                            lock.unlock();
                        }
                        return object;
                    }
                }
                if (arg1Value) {
                    this.getArrayLength_arrayLengthReadNode_ = (ArrayLengthNode.ArrayLengthReadNode)super.insert((Node)ArrayLengthNode.ArrayLengthReadNode.create());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Double ex = this.getArrayLength(arg0Value_, arg1Value, this.getArrayLength_arrayLengthReadNode_);
                    return ex;
                }
                if (!arg1Value) {
                    this.getLengthDynamicObject_getLengthPropertyNode_ = (PropertyNode)super.insert((Node)this.createLengthProperty());
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Double ex = this.getLengthDynamicObject(arg0Value_, arg1Value, this.getLengthDynamicObject_getLengthPropertyNode_);
                    return ex;
                }
            }
            if ((exclude & 2) == 0) {
                int count4_ = 0;
                GetLengthForeign0Data s4_ = this.getLengthForeign0_cache;
                if ((state & 8) != 0) {
                    while (s4_ != null && (!s4_.interop_.accepts(arg0Value) || JSGuards.isDynamicObject(arg0Value))) {
                        s4_ = s4_.next_;
                        ++count4_;
                    }
                }
                if (s4_ == null && !JSGuards.isDynamicObject(arg0Value) && count4_ < 3) {
                    s4_ = (GetLengthForeign0Data)super.insert((Node)new GetLengthForeign0Data(this.getLengthForeign0_cache));
                    s4_.interop_ = (InteropLibrary)s4_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    s4_.importValueNode_ = s4_.insertAccessor(ImportValueNode.create());
                    this.getLengthForeign0_cache = s4_;
                    this.state_ = state |= 8;
                }
                if (s4_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Double d = this.getLengthForeign(arg0Value, arg1Value, s4_.interop_, s4_.importValueNode_);
                    return d;
                }
            }
            InteropLibrary getLengthForeign1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                if (!JSGuards.isDynamicObject(arg0Value)) {
                    getLengthForeign1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    this.getLengthForeign1_importValueNode_ = (ImportValueNode)super.insert((Node)ImportValueNode.create());
                    this.exclude_ = exclude |= 2;
                    this.getLengthForeign0_cache = null;
                    state &= 0xFFFFFFF7;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.getLengthForeign(arg0Value, arg1Value, getLengthForeign1_interop__, this.getLengthForeign1_importValueNode_);
                    return d;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        GetLengthForeign0Data s4_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s4_ = this.getLengthForeign0_cache) == null || s4_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "getArrayLengthInt";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.getArrayLengthInt_arrayLengthReadNode_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "getArrayLength";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.getArrayLength_arrayLengthReadNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "getLengthDynamicObject";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.getLengthDynamicObject_getLengthPropertyNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "getLengthForeign";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            GetLengthForeign0Data s4_ = this.getLengthForeign0_cache;
            while (s4_ != null) {
                cached.add(Arrays.asList(new Node[]{s4_.interop_, s4_.importValueNode_}));
                s4_ = s4_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "getLengthForeign";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.getLengthForeign1_importValueNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static GetLengthHelperNode create(JSContext context) {
        return new GetLengthHelperNodeGen(context);
    }

    @GeneratedBy(value=GetLengthHelperNode.class)
    private static final class GetLengthForeign0Data
    extends Node {
        @Node.Child
        GetLengthForeign0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        ImportValueNode importValueNode_;

        GetLengthForeign0Data(GetLengthForeign0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

