/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.ui.push.PushBranchesStep;
import org.netbeans.modules.git.ui.push.PushMapping;
import org.netbeans.modules.git.ui.push.UpdateBranchReferencesStep;
import org.netbeans.modules.git.ui.repository.remote.SelectUriStep;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

class PushWizard
implements ChangeListener {
    private final Map<String, GitRemoteConfig> remotes;
    private PanelsIterator wizardIterator;
    private WizardDescriptor wizardDescriptor;
    private final File repository;

    public PushWizard(File repository, Map<String, GitRemoteConfig> remotes) {
        this.repository = repository;
        this.remotes = remotes;
    }

    boolean show() {
        boolean finnished;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(PushWizard.class, (String)"LBL_PushWizard.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        this.setErrorMessage(this.wizardIterator.selectUriStep.getErrorMessage());
        dialog.setVisible(true);
        dialog.toFront();
        Object value = this.wizardDescriptor.getValue();
        boolean bl = finnished = value == WizardDescriptor.FINISH_OPTION;
        if (!(finnished || value != WizardDescriptor.CLOSED_OPTION && value != WizardDescriptor.CANCEL_OPTION)) {
            this.wizardIterator.selectUriStep.cancelBackgroundTasks();
        }
        return finnished;
    }

    private void setErrorMessage(AbstractWizardPanel.Message msg) {
        if (this.wizardDescriptor != null) {
            if (msg == null) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
            } else if (msg.isInfo()) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)msg.getMessage());
            } else {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)msg.getMessage());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        AbstractWizardPanel step = (AbstractWizardPanel)e.getSource();
        this.setErrorMessage(step.getErrorMessage());
    }

    String getPushUri() {
        return this.wizardIterator.selectUriStep.getSelectedUri();
    }

    Collection<PushMapping> getPushMappings() {
        return this.wizardIterator.pushBranchesStep.getSelectedMappings();
    }

    List<String> getFetchRefSpecs() {
        return this.wizardIterator.updateBranchReferencesStep.getSelectedRefSpecs();
    }

    String getRemoteName() {
        return this.wizardIterator.selectUriStep.getRemoteName();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor> {
        private SelectUriStep selectUriStep;
        private PushBranchesStep pushBranchesStep;
        private UpdateBranchReferencesStep updateBranchReferencesStep;

        private PanelsIterator() {
        }

        protected WizardDescriptor.Panel<WizardDescriptor>[] initializePanels() {
            this.selectUriStep = new SelectUriStep(PushWizard.this.repository, PushWizard.this.remotes, SelectUriStep.Mode.PUSH);
            this.selectUriStep.addChangeListener(PushWizard.this);
            this.pushBranchesStep = new PushBranchesStep(PushWizard.this.repository);
            this.pushBranchesStep.addChangeListener(PushWizard.this);
            this.updateBranchReferencesStep = new UpdateBranchReferencesStep(PushWizard.this.repository);
            this.updateBranchReferencesStep.addChangeListener(PushWizard.this);
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{this.selectUriStep, this.pushBranchesStep, this.updateBranchReferencesStep};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; ++i) {
                Component c = panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panels;
        }

        public synchronized void nextPanel() {
            if (this.current() == this.selectUriStep) {
                Map<String, GitBranch> remoteBranches = this.selectUriStep.getRemoteBranches();
                Map<String, String> remoteTags = this.selectUriStep.getRemoteTags();
                if (remoteBranches != null) {
                    this.pushBranchesStep.fillRemoteBranches(this.selectUriStep.getSelectedRemote(), remoteBranches, remoteTags == null ? Collections.emptyMap() : remoteTags);
                }
                this.pushBranchesStep.setAsLastPanel(!this.selectUriStep.isConfiguredRemoteSelected() && this.selectUriStep.getRemoteName() == null);
                this.selectUriStep.storeURI();
            } else if (this.current() == this.pushBranchesStep) {
                Collection<PushMapping> mappings = this.pushBranchesStep.getSelectedMappings();
                LinkedHashMap<String, String> remoteBranches = new LinkedHashMap<String, String>(mappings.size());
                for (PushMapping mapping : mappings) {
                    if (mapping.isDeletion() || !(mapping instanceof PushMapping.PushBranchMapping)) continue;
                    PushMapping.PushBranchMapping pushMapping = (PushMapping.PushBranchMapping)mapping;
                    remoteBranches.put(pushMapping.getRemoteRepositoryBranchName(), pushMapping.getLocalRepositoryBranchHeadId());
                }
                this.updateBranchReferencesStep.setRemote(this.selectUriStep.getSelectedRemote());
                this.updateBranchReferencesStep.fillRemoteBranches(remoteBranches);
            }
            super.nextPanel();
        }

        public boolean hasNext() {
            return this.current() == this.pushBranchesStep ? this.selectUriStep.isConfiguredRemoteSelected() || this.selectUriStep.getRemoteName() != null : super.hasNext();
        }
    }
}

