/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.ValueItem;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.spi.editor.completion.CompletionItem;

public class FxIdCompleter
implements Completer,
Completer.Factory {
    private CompletionContext ctx;
    private ElementHandle<TypeElement> controllerType;
    private static final String ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/fxid-value.gif";

    public FxIdCompleter() {
    }

    FxIdCompleter(CompletionContext ctx, ElementHandle<TypeElement> controllerType) {
        this.ctx = ctx;
        this.controllerType = controllerType;
    }

    public List<CompletionItem> complete() {
        FxInstance inst = (FxInstance)this.ctx.getElementParent();
        TypeElement instType = (TypeElement)inst.getJavaType().resolve(this.ctx.getCompilationInfo());
        TypeElement ct = (TypeElement)this.controllerType.resolve(this.ctx.getCompilationInfo());
        if (ct == null) {
            return null;
        }
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        for (VariableElement v : ElementFilter.fieldsIn(this.ctx.getCompilationInfo().getElements().getAllMembers(ct))) {
            if (!FxClassUtils.isFxmlAccessible(v)) continue;
            String sn = v.getSimpleName().toString();
            if (this.ctx.getModel().getInstance(sn) != null || !this.ctx.getCompilationInfo().getTypes().isAssignable(instType.asType(), v.asType())) continue;
            ValueItem vi = new ValueItem(this.ctx, v.getSimpleName().toString(), ICON_RESOURCE);
            vi.setAttribute(this.ctx.getType() == CompletionContext.Type.PROPERTY_VALUE);
            items.add(vi);
        }
        return items;
    }

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        if (ctx.getType() != CompletionContext.Type.PROPERTY_VALUE || ctx.getElementParent().getKind() != FxNode.Kind.Instance) {
            return null;
        }
        String propName = ctx.getPropertyName();
        String prefix = ctx.findFxmlNsPrefix();
        if (prefix == null || !(prefix + ":id").equals(propName)) {
            return null;
        }
        ElementHandle<TypeElement> controllerType = ctx.getModel().getControllerType();
        if (controllerType != null) {
            return new FxIdCompleter(ctx, controllerType);
        }
        return null;
    }
}

