/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractInterceptedElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ClassModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.openide.util.NbBundle;

public class DeclaredIBindingsAnalyzer
extends AbstractInterceptedElementAnalyzer
implements ClassModelAnalyzer.ClassAnalyzer {
    @Override
    public void analyze(TypeElement element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        Set<AnnotationMirror> interceptorBindings = this.getInterceptorBindings(element, model);
        HashMap<Element, AnnotationMirror> iBindings = new HashMap<Element, AnnotationMirror>();
        if (!interceptorBindings.isEmpty()) {
            result.requireCdiEnabled(element, model);
        }
        for (AnnotationMirror annotationMirror : interceptorBindings) {
            Element iBinding = annotationMirror.getAnnotationType().asElement();
            AnnotationMirror found = (AnnotationMirror)iBindings.get(iBinding);
            if (found != null && !this.isSame(found, annotationMirror, model.getCompilationController())) {
                result.addError((Element)element, model, NbBundle.getMessage(DeclaredIBindingsAnalyzer.class, (String)"ERR_InvalidDuplicateIBindings", (Object)((TypeElement)iBinding).getQualifiedName().toString()));
                break;
            }
            iBindings.put(iBinding, annotationMirror);
        }
    }

    private boolean isSame(AnnotationMirror first, AnnotationMirror second, CompilationController controller) {
        Element secondElement;
        Element firstElement = first.getAnnotationType().asElement();
        if (!firstElement.equals(secondElement = second.getAnnotationType().asElement())) {
            return false;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> firstValues = first.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> secondValues = second.getElementValues();
        if (firstValues.size() != secondValues.size()) {
            return false;
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : firstValues.entrySet()) {
            AnnotationValue secondValue = secondValues.get(entry.getKey());
            AnnotationValue firstValue = entry.getValue();
            if (this.isSame(firstValue, secondValue, controller)) continue;
            return false;
        }
        return true;
    }

    private boolean isSame(AnnotationValue first, AnnotationValue second, CompilationController controller) {
        Object firstValue = first.getValue();
        Object secondValue = second.getValue();
        if (firstValue == null) {
            return secondValue == null;
        }
        if (firstValue instanceof TypeMirror) {
            TypeMirror firstMirror = (TypeMirror)firstValue;
            if (secondValue instanceof TypeMirror) {
                return controller.getTypes().isSameType(firstMirror, (TypeMirror)secondValue);
            }
            return false;
        }
        if (firstValue instanceof AnnotationMirror) {
            if (secondValue instanceof AnnotationMirror) {
                return this.isSame((AnnotationMirror)firstValue, (AnnotationMirror)((Object)second), controller);
            }
            return false;
        }
        if (firstValue instanceof List) {
            if (secondValue instanceof List) {
                List firstList = (List)firstValue;
                List secondList = (List)secondValue;
                if (firstList.size() != secondList.size()) {
                    return false;
                }
                for (int i = 0; i < firstList.size(); ++i) {
                    Object firstObject = firstList.get(i);
                    Object secondObject = secondList.get(i);
                    assert (firstObject instanceof AnnotationValue);
                    assert (secondObject instanceof AnnotationValue);
                    if (this.isSame((AnnotationValue)firstObject, (AnnotationValue)secondObject, controller)) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return firstValue.equals(secondValue);
    }
}

