/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.graalsdk.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Language;
import org.netbeans.libs.graalsdk.impl.GraalContext;
import org.netbeans.libs.graalsdk.impl.GraalEngineFactory;
import org.netbeans.spi.scripting.EngineProvider;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.util.Lookup;

public final class GraalEnginesProvider
implements EngineProvider {
    private Throwable disable;
    private ClassLoader currentAllLoader;
    private ClassLoader languagesLoader;

    public List<ScriptEngineFactory> factories() {
        return this.factories(null);
    }

    public List<ScriptEngineFactory> factories(ScriptEngineManager m) {
        ArrayList<ScriptEngineFactory> arr = new ArrayList<ScriptEngineFactory>();
        try {
            if (this.disable == null) {
                this.enumerateLanguages(arr, m == null ? null : m.getBindings());
            }
        }
        catch (IllegalStateException | LinkageError err) {
            this.disable = err;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader createGraalDependentClassLoader() {
        ClassLoader created;
        boolean added;
        ClassLoader allLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        GraalEnginesProvider graalEnginesProvider = this;
        synchronized (graalEnginesProvider) {
            if (this.languagesLoader != null && this.currentAllLoader == allLoader) {
                return this.languagesLoader;
            }
            this.languagesLoader = null;
        }
        ArrayList modules = new ArrayList(Lookup.getDefault().lookupAll(ModuleInfo.class));
        ModuleInfo thisModule = Modules.getDefault().ownerOf(this.getClass());
        LinkedHashMap<String, ModuleInfo> dependentsOfSDK = new LinkedHashMap<String, ModuleInfo>();
        if (thisModule == null) {
            return allLoader;
        }
        dependentsOfSDK.put(thisModule.getCodeName(), thisModule);
        do {
            added = false;
            Iterator it = modules.iterator();
            block9: while (it.hasNext()) {
                ModuleInfo m = (ModuleInfo)it.next();
                if (!m.isEnabled()) continue;
                for (Dependency d : m.getDependencies()) {
                    if (d.getType() != 1 || !dependentsOfSDK.keySet().contains(d.getName())) continue;
                    dependentsOfSDK.put(m.getCodeName(), m);
                    it.remove();
                    added = true;
                    continue block9;
                }
            }
        } while (!added);
        try {
            BiFunction<String, ClassLoader, Boolean> decideDelegation = (n, c) -> c != null;
            Class<?> pcl = Class.forName("org.netbeans.ProxyClassLoader", true, allLoader);
            Constructor<?> ctor = pcl.getConstructor(ClassLoader[].class, Boolean.TYPE, BiFunction.class);
            ClassLoader[] delegates = new ClassLoader[dependentsOfSDK.size()];
            int index = delegates.length - 1;
            for (ModuleInfo mi : dependentsOfSDK.values()) {
                delegates[index--] = mi.getClassLoader();
            }
            created = (ClassLoader)ctor.newInstance(delegates, true, decideDelegation);
        }
        catch (ReflectiveOperationException ex) {
            created = allLoader;
        }
        GraalEnginesProvider graalEnginesProvider2 = this;
        synchronized (graalEnginesProvider2) {
            if ((this.currentAllLoader == null || this.currentAllLoader == allLoader) && this.languagesLoader == null) {
                this.languagesLoader = created;
            }
        }
        return created;
    }

    private void enumerateLanguages(List<ScriptEngineFactory> arr, Bindings globals) {
        ClassLoader langLoader = this.createGraalDependentClassLoader();
        GraalContext ctx = new GraalContext(globals, langLoader);
        String specVersion = System.getProperty("java.specification.version");
        String vmVersion = System.getProperty("java.vm.version");
        if ("1.8".equals(specVersion) && vmVersion.contains("jvmci-")) {
            return;
        }
        GraalContext.executeWithClassLoader(() -> {
            try (Engine engine = Engine.newBuilder().build();){
                for (Map.Entry<String, Language> entry : engine.getLanguages().entrySet()) {
                    arr.add(new GraalEngineFactory(ctx, entry.getKey(), entry.getValue()));
                }
            }
            return null;
        }, langLoader);
    }
}

