/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.config.WildflyConnectionFactory;
import org.netbeans.modules.javaee.wildfly.nodes.Util;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyAsyncChildren;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyConnectionFactoryNode;
import org.netbeans.modules.javaee.wildfly.nodes.actions.Refreshable;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class WildflyConnectionFactoriesChildren
extends WildflyAsyncChildren
implements Refreshable {
    private static final Logger LOGGER = Logger.getLogger(WildflyConnectionFactoriesChildren.class.getName());
    private final Lookup lookup;

    public WildflyConnectionFactoriesChildren(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void updateKeys() {
        this.setKeys(new Object[]{"wait_node"});
        this.getExecutorService().submit(new WildflyConnectionFactoriesNodeUpdater(), 0);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof WildflyConnectionFactoryNode) {
            return new Node[]{(WildflyConnectionFactoryNode)((Object)key)};
        }
        if (key instanceof String && key.equals("wait_node")) {
            return new Node[]{Util.createWaitNode()};
        }
        return null;
    }

    class WildflyConnectionFactoriesNodeUpdater
    implements Runnable {
        List<WildflyConnectionFactoryNode> keys = new ArrayList<WildflyConnectionFactoryNode>();

        WildflyConnectionFactoriesNodeUpdater() {
        }

        @Override
        public void run() {
            try {
                WildflyDeploymentManager dm = (WildflyDeploymentManager)WildflyConnectionFactoriesChildren.this.lookup.lookup(WildflyDeploymentManager.class);
                for (WildflyConnectionFactory connectionFactory : dm.getClient().listConnectionFactories()) {
                    this.keys.add(new WildflyConnectionFactoryNode(connectionFactory, WildflyConnectionFactoriesChildren.this.lookup));
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            WildflyConnectionFactoriesChildren.this.setKeys(this.keys);
        }
    }
}

