/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermStream;

public abstract class LineFilter {
    public abstract void processLine(String var1, LineSink var2);

    protected final String hyperlink(String clientData, String text) {
        StringBuilder buf = new StringBuilder();
        buf.append('\u001b');
        buf.append("]10;");
        buf.append(clientData);
        buf.append(";");
        buf.append(text);
        buf.append('\u0007');
        return buf.toString();
    }

    public static void pushInto(LineFilter lf, Term term, int delayMillis) {
        LineProcessorBridge lpb = new LineProcessorBridge(lf, delayMillis);
        term.pushStream(lpb);
    }

    private static class LineProcessorBridge
    extends TermStream
    implements LineSink,
    ActionListener {
        private final LineFilter lineProcessor;
        private final Timer timer;
        private final char[] eol = new char[]{'\n', '\r'};
        private StringBuilder buf = new StringBuilder();
        private boolean ignoreNextCR;
        private boolean fullLine;

        public LineProcessorBridge(LineFilter lineProcessor, int delay) {
            if (delay == 0) {
                this.timer = null;
            } else {
                this.timer = new Timer(delay, this);
                this.timer.setRepeats(false);
            }
            this.lineProcessor = lineProcessor;
        }

        @Override
        public void flush() {
            this.toDTE.flush();
        }

        @Override
        public void putChar(char c) {
            this.processChar(c);
        }

        @Override
        public void putChars(char[] buf, int offset, int count) {
            for (int bx = 0; bx < count; ++bx) {
                this.processChar(buf[offset + bx]);
            }
        }

        @Override
        public void sendChar(char c) {
            this.toDCE.sendChar(c);
        }

        @Override
        public void sendChars(char[] c, int offset, int count) {
            this.toDCE.sendChars(c, offset, count);
        }

        private void processChar(char c) {
            if (c == '\n') {
                if (this.ignoreNextCR) {
                    this.ignoreNextCR = false;
                } else {
                    this.doProcessLine(this.buf.toString(), true);
                }
            } else if (c == '\r') {
                this.ignoreNextCR = true;
                this.doProcessLine(this.buf.toString(), true);
            } else {
                this.ignoreNextCR = false;
                this.buf.append(c);
                if (this.timer != null) {
                    this.timer.restart();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.doProcessLine(this.buf.toString(), false);
        }

        private void doProcessLine(String line, boolean fullLine) {
            this.fullLine = fullLine;
            this.lineProcessor.processLine(line, this);
            this.buf = new StringBuilder();
        }

        @Override
        public void forwardLine(String line) {
            this.toDTE.putChars(line.toCharArray(), 0, line.length());
            if (this.fullLine) {
                this.toDTE.putChars(this.eol, 0, this.eol.length);
            }
        }
    }

    protected static interface LineSink {
        public void forwardLine(String var1);
    }
}

